/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.icommerce.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;

public class BeanCopierUtils {
    private static final Map<String, BeanCopier> BEAN_COPIERS = new ConcurrentHashMap<String, BeanCopier>();

    public static void copy(Object srcObj, Object destObj) {
        String key = BeanCopierUtils.genKey(srcObj.getClass(), destObj.getClass());
        BeanCopier copier = null;
        if (!BEAN_COPIERS.containsKey(key)) {
            copier = BeanCopier.create(srcObj.getClass(), destObj.getClass(), (boolean)false);
            BEAN_COPIERS.put(key, copier);
        } else {
            copier = BEAN_COPIERS.get(key);
        }
        copier.copy(srcObj, destObj, null);
    }

    public static <T> List<T> copyList(List<?> sourceList, Class<T> targetClass) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
        for (Object o : sourceList) {
            Object t = null;
            try {
                t = targetClass.newInstance();
                BeanCopierUtils.copy(o, t);
                resultList.add(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    private static String genKey(Class<?> srcClazz, Class<?> destClazz) {
        return srcClazz.getName() + destClazz.getName();
    }
}

