/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.icommerce.utils.tree;

import com.dtyunxi.icommerce.utils.tree.TreeNode;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeUtil {
    static Logger logger = LoggerFactory.getLogger(TreeUtil.class);

    public static void buildTree(List<? extends TreeNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        LinkedList<? extends TreeNode> allNodes = new LinkedList<TreeNode>(nodes);
        int index = 0;
        int n = allNodes.size();
        while (index < allNodes.size()) {
            TreeNode node = allNodes.get(index);
            logger.debug(" TargetNode (id:{},curIndex:{},nodes left:{})", new Object[]{node.getId(), index, allNodes.size()});
            TreeUtil.findChildren(node, allNodes);
            if (n != allNodes.size()) {
                n = allNodes.size();
                index = 0;
                continue;
            }
            ++index;
        }
        nodes.clear();
        nodes.addAll(allNodes);
    }

    private static void findChildren(TreeNode node, LinkedList allNodes) {
        int index = 0;
        logger.debug("start finding Children of node {}", (Object)node.getId());
        while (index < allNodes.size()) {
            TreeNode child = (TreeNode)allNodes.get(index);
            if (child.getParentId() != null && child.getParentId().equals(node.getId())) {
                node.addChild(child);
                allNodes.remove(child);
                logger.debug(" child  of node {}, founded id:{},nodes left:{} ", new Object[]{node.getId(), child.getId(), allNodes.size()});
                continue;
            }
            ++index;
        }
        node.getChildren().forEach(item -> TreeUtil.findChildren(item, allNodes));
        logger.debug("Founded  {} Children of node {}", (Object)node.getChildren().size(), (Object)node.getId());
    }
}

