/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.module.admin.api.IAccess;
import com.dtyunxi.yundt.module.admin.bo.reqeust.AccessCondition;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.bo.Access;
import com.dtyunxi.yundt.module.domain.bo.Role;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AccessImpl
implements IAccess {
    @Resource
    private IAccessApi accessApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IUserApi userApi;

    public Long create(Access access) {
        return null;
    }

    public void modify(Access access) {
    }

    public void remove(Long accessId) {
    }

    public PageInfo<Access> query(AccessCondition accessCondition) {
        return null;
    }

    public Access getById(Long accessId) {
        return null;
    }

    public void authRoleWithAccess(Long roleId, List<Access> accesss) {
        RoleAccessDto roleAccess = this.getRoleAccessDto(accesss);
        roleAccess.setRoleId(roleId);
        ArrayList roleAccessList = Lists.newArrayList((Object[])new RoleAccessDto[]{roleAccess});
        this.accessApi.addRoleResources(this.context.instanceId(), (List)roleAccessList);
    }

    public Role queryAccessByRole(Long roleId) {
        RestResponse accessRestResponse = this.accessQueryApi.queryRoleById(roleId, "");
        if (!ExceptionCode.SUCCESS.getCode().equals(accessRestResponse.getResultCode())) {
            throw new BizException(accessRestResponse.getResultCode(), accessRestResponse.getResultMsg());
        }
        Role role = this.convert2Role((RoleAccessDto)accessRestResponse.getData());
        RoleDto roleDto = (RoleDto)this.accessQueryApi.queryRoleByRoleId(role.getId()).getData();
        if (roleDto != null) {
            role.setCode(roleDto.getCode());
            role.setName(roleDto.getName());
            role.setDescription(roleDto.getDescription());
            role.setStatus(roleDto.getStatus());
        }
        return role;
    }

    private Role convert2Role(RoleAccessDto roleAccessDto) {
        Role role = new Role();
        role.setId(roleAccessDto.getRoleId());
        ArrayList<Access> accessList = new ArrayList<Access>();
        Access access = null;
        for (AccessDto accessDto : roleAccessDto.getAccessSet()) {
            access = new Access();
            BeanUtils.copyProperties((Object)accessDto, (Object)access);
            accessList.add(access);
        }
        role.setAccessList(accessList);
        return role;
    }

    private RoleAccessDto getRoleAccessDto(List<Access> accessList) {
        HashSet accessSet = Sets.newHashSet();
        for (Access access : accessList) {
            AccessDto accessDto = new AccessDto();
            BeanUtils.copyProperties((Object)access, (Object)accessDto);
            accessSet.add(accessDto);
        }
        RoleAccessDto roleAccessDto = new RoleAccessDto();
        roleAccessDto.setAccessSet((Set)accessSet);
        return roleAccessDto;
    }

    public void authRoles(Long userId, List<Long> roleIds) {
        Long instanceId = this.context.instanceId();
        this.accessApi.addUserRoles(instanceId, userId, roleIds);
    }
}

