/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.module.admin.api.IAuthorize;
import com.dtyunxi.yundt.module.admin.bo.Resource;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.bo.Access;
import com.dtyunxi.yundt.module.domain.bo.Role;
import com.dtyunxi.yundt.module.domain.bo.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Valid
public class AuthorizeImpl
implements IAuthorize {
    @Autowired
    private IAccessApi accessApi;
    @Autowired
    private IAccessQueryApi accessQueryApi;
    @Autowired
    private IContext context;
    @Autowired
    private IUserApi userApi;

    public void authRoles(Long userId, @NotEmpty List<Long> roleIds) {
        this.accessApi.giveUserRoles(this.context.instanceId(), userId, roleIds);
    }

    public void authRoles(User user, @NotEmpty List<Role> roles) {
        List<Long> roleIds = this.getRoleIdList(roles);
        this.authRoles(user.getId(), roleIds);
    }

    private List<Long> getRoleIdList(@NotEmpty List<Role> roles) {
        List<Long> roleIdList = roles.stream().map(role -> role.getId()).collect(Collectors.toList());
        return roleIdList;
    }

    public void authRoles(List<User> users, @NotEmpty List<Role> roles) {
        List<Long> roleIds = this.getRoleIdList(roles);
        for (User user : users) {
            this.authRoles(user.getId(), roleIds);
        }
    }

    public void authRoleWithAccess(Role role, @NotEmpty List<Access> accesss) {
        RoleAccessDto roleAccess = this.getRoleAccessDto(accesss);
        roleAccess.setRoleId(role.getId());
        ArrayList roleAccessList = Lists.newArrayList((Object[])new RoleAccessDto[]{roleAccess});
        this.accessApi.giveRoleResources(this.context.instanceId(), (List)roleAccessList);
    }

    private RoleAccessDto getRoleAccessDto(List<Access> accessList) {
        HashSet accessSet = Sets.newHashSet();
        for (Access access : accessList) {
            AccessDto accessDto = this.convert2RoleAccessDto(access);
            accessSet.add(accessDto);
        }
        RoleAccessDto roleAccessDto = new RoleAccessDto();
        roleAccessDto.setAccessSet((Set)accessSet);
        return roleAccessDto;
    }

    private AccessDto convert2RoleAccessDto(Access access) {
        AccessDto accessDto = new AccessDto();
        return accessDto;
    }

    public void deauthRoles(Long userId, List<Long> roleIds) {
        Long[] roleIdArr = (Long[])roleIds.stream().toArray(Long[]::new);
        this.userApi.removeUserRoles(userId, roleIdArr);
    }

    public void deauthRoles(User user, List<Role> roles) {
        List<Long> roleIds = this.getRoleIdList(roles);
        this.deauthRoles(user.getId(), roleIds);
    }

    public boolean hasRoles(Long userId, List<Role> roles) {
        Set<RoleDto> roleSet = this.getRoleSet(userId);
        if (CollectionUtils.isEmpty(roleSet)) {
            return false;
        }
        List<Long> roleIdList = this.getRoleIdList(roles);
        List allRoleIdList = roleSet.stream().map(roleDto -> roleDto.getId()).collect(Collectors.toList());
        boolean has = allRoleIdList.containsAll(roleIdList);
        return has;
    }

    public boolean hasAccess(Long userId, List<Access> access) {
        Set<AccessDto> accessSet = this.getAccessSet(userId);
        if (CollectionUtils.isEmpty(accessSet)) {
            return false;
        }
        List<Long> accessIds = this.getAccessIdList(access);
        List allAccessIds = accessSet.stream().map(accessDto -> accessDto.getId()).collect(Collectors.toList());
        boolean has = allAccessIds.containsAll(accessIds);
        return has;
    }

    private List<Long> getAccessIdList(List<Access> accessList) {
        List<Long> accessIdList = accessList.stream().map(access -> access.getId()).collect(Collectors.toList());
        return accessIdList;
    }

    private Set<AccessDto> getAccessSet(Long userId) {
        UserAccessVo userAccessVo = (UserAccessVo)this.accessQueryApi.queryUserAccess(this.context.instanceId(), userId, "").getData();
        if (null == userAccessVo) {
            return null;
        }
        return userAccessVo.getAccessSet();
    }

    private Set<RoleDto> getRoleSet(Long userId) {
        UserAccessVo userAccessVo = (UserAccessVo)this.accessQueryApi.queryUserAccess(this.context.instanceId(), userId, "").getData();
        if (null == userAccessVo) {
            return null;
        }
        return userAccessVo.getRoleSet();
    }

    public boolean hasPermission(Long userId, Resource resource, Integer permissions) {
        boolean hasPermission = false;
        UserAccessVo userAccessVo = (UserAccessVo)this.accessQueryApi.queryUserAccess(this.context.instanceId(), userId, "").getData();
        if (null == userAccessVo || CollectionUtils.isEmpty((Collection)userAccessVo.getAccessSet())) {
            return hasPermission;
        }
        for (AccessDto accessDto : userAccessVo.getAccessSet()) {
            if (!accessDto.getResourceId().equals(resource.getId()) || !permissions.equals(accessDto.getPermissions() & permissions)) continue;
            hasPermission = true;
            break;
        }
        return hasPermission;
    }

    public void deauthRoleWithAccess(Role role, List<Access> accesss) {
        RoleAccessDto roleAccess = this.getRoleAccessDto(accesss);
        roleAccess.setRoleId(role.getId());
        ArrayList roleAccessList = Lists.newArrayList((Object[])new RoleAccessDto[]{roleAccess});
        this.accessApi.removeRoleResources(role.getId(), (List)roleAccessList);
    }
}

