/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ChannelPageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSettingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IChannelQueryApi;
import com.dtyunxi.yundt.module.admin.api.IBasicSettingService;
import com.dtyunxi.yundt.module.admin.api.enums.AdminModuleExceptionCode;
import com.dtyunxi.yundt.module.admin.api.enums.BasicSetupEnum;
import com.dtyunxi.yundt.module.admin.biz.adapter.BasicSetupDtoAdapter;
import com.dtyunxi.yundt.module.admin.dto.request.StoreSettingReqDto;
import com.dtyunxi.yundt.module.admin.dto.request.SystemSettingReqDto;
import com.dtyunxi.yundt.module.admin.dto.response.BasicSettingRespDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BasicSettingServiceImpl
implements IBasicSettingService {
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private IDictApi dictApi;
    @Resource
    private IChannelQueryApi channelQueryApi;

    @Transactional
    public void addSystemSetting(SystemSettingReqDto systemSettingReqDto) {
        this.validateSystemSetting(systemSettingReqDto);
        BasicSettingRespDto basicSettingRespDto = this.querySettingByGroupCode(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType());
        SystemSettingReqDto temp = basicSettingRespDto.getSystemSettingReqDto();
        if (null != basicSettingRespDto && null != temp) {
            this.handleSystemSettingUpdate(systemSettingReqDto, temp);
        } else {
            this.handleSystemSettingAdd(systemSettingReqDto);
        }
    }

    public BasicSettingRespDto querySettingByGroupCode(String groupCode) {
        StringBuffer buffer;
        BasicSettingRespDto basicSettingRespDto = new BasicSettingRespDto();
        RestResponse dictDtos = this.dictQueryApi.queryByGroupCode(ComConstants.TENANT, groupCode);
        if (null == dictDtos || CollectionUtils.isEmpty((Collection)((Collection)dictDtos.getData()))) {
            return basicSettingRespDto;
        }
        Map<String, DictDto> dictDtoMap = ((List)dictDtos.getData()).stream().collect(Collectors.toMap(DictDto::getCode, dictDto -> dictDto));
        if (BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType().equals(groupCode)) {
            buffer = new StringBuffer();
            buffer.append("{");
            BasicSetupDtoAdapter.systemSettingDtoMap.keySet().forEach(key -> buffer.append(BasicSetupDtoAdapter.systemSettingDtoMap.get(key)).append(":").append(((DictDto)dictDtoMap.get(key)).getValue()).append(","));
            buffer.deleteCharAt(buffer.length() - 1).append("}");
            basicSettingRespDto.setSystemSettingReqDto((SystemSettingReqDto)JSONObject.parseObject((String)buffer.toString(), SystemSettingReqDto.class));
        }
        if (BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType().equals(groupCode)) {
            buffer = new StringBuffer();
            buffer.append("{");
            BasicSetupDtoAdapter.storeSettingDtoMap.keySet().forEach(key -> buffer.append(BasicSetupDtoAdapter.storeSettingDtoMap.get(key)).append(":").append(((DictDto)dictDtoMap.get(key)).getValue()).append(","));
            buffer.deleteCharAt(buffer.length() - 1).append("}");
            basicSettingRespDto.setStoreSettingReqDto((StoreSettingReqDto)JSONObject.parseObject((String)buffer.toString(), StoreSettingReqDto.class));
        }
        if (BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType().equals(groupCode)) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            BasicSetupDtoAdapter.orderSettingDtoMap.keySet().forEach(key -> builder.append(BasicSetupDtoAdapter.orderSettingDtoMap.get(key)).append(":").append(((DictDto)dictDtoMap.get(key)).getValue()).append(","));
            builder.deleteCharAt(builder.length() - 1).append("}");
            basicSettingRespDto.setOrderSettingReqDto((OrderSettingReqDto)JSONObject.parseObject((String)builder.toString(), OrderSettingReqDto.class));
        }
        return basicSettingRespDto;
    }

    @Transactional
    public void addStoreSetting(StoreSettingReqDto storeSettingReqDto) {
        this.validateStoreSetting(storeSettingReqDto);
        BasicSettingRespDto basicSettingRespDto = this.querySettingByGroupCode(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType());
        StoreSettingReqDto temp = basicSettingRespDto.getStoreSettingReqDto();
        if (null != storeSettingReqDto && null != temp) {
            this.handleStoreSettingUpdate(storeSettingReqDto, temp);
        } else {
            this.handleStoreSettingAdd(storeSettingReqDto);
        }
    }

    @Transactional
    public void addOrderSetting(OrderSettingReqDto orderSettingReqDto) {
        OrderSettingReqDto oriOrderSettingReqDto = this.querySettingByGroupCode(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType()).getOrderSettingReqDto();
        this.handleOrderSettingSave(orderSettingReqDto, oriOrderSettingReqDto);
    }

    private void validateStoreSetting(StoreSettingReqDto dto) {
        if (null != dto.getStoreDistanceDto() && new BigDecimal(100).compareTo(dto.getStoreDistanceDto().getValue()) < 0) {
            throw new BizException(AdminModuleExceptionCode.STORE_DISTANCE_EXCEPTION.getMsg());
        }
        if (null != dto.getStoreDeliveryThresholdDto() && new BigDecimal(100).compareTo(dto.getStoreDeliveryThresholdDto().getValue()) < 0) {
            throw new BizException(AdminModuleExceptionCode.STORE_DELIVERY_THRESHOLD_EXCEPTION.getMsg());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getStoreDeliveryEfficiencyDto())) {
            dto.getStoreDeliveryEfficiencyDto().stream().forEach(bean -> {
                if (BigDecimal.ZERO.compareTo(bean.getScore()) > 0) {
                    throw new BizException(AdminModuleExceptionCode.STORE_DELIVERY_EFFICIENCY_SCORE_EXCEPTION.getMsg());
                }
            });
        }
    }

    private void handleStoreSettingUpdate(StoreSettingReqDto currentStoreSettingReqDto, StoreSettingReqDto originalStoreSettingReqDto) {
        if (0 != CompareToBuilder.reflectionCompare((Object)currentStoreSettingReqDto.getStoreRejectDto(), (Object)originalStoreSettingReqDto.getStoreRejectDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.REJECT_ORDER_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreRejectDto()), BasicSetupEnum.StoreCreditEnum.REJECT_ORDER_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentStoreSettingReqDto.getStoreUnDeliverDto(), (Object)originalStoreSettingReqDto.getStoreUnDeliverDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.UNABLE_DELIVER_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreUnDeliverDto()), BasicSetupEnum.StoreCreditEnum.UNABLE_DELIVER_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentStoreSettingReqDto.getStoreNotDeliverTimeoutDto(), (Object)originalStoreSettingReqDto.getStoreNotDeliverTimeoutDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.NOT_DELIVER_TIMEOUT_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreNotDeliverTimeoutDto()), BasicSetupEnum.StoreCreditEnum.NOT_DELIVER_TIMEOUT_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentStoreSettingReqDto.getStoreRestoreCreditDto(), (Object)originalStoreSettingReqDto.getStoreRestoreCreditDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.RESTORE_CREDIT_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreRestoreCreditDto()), BasicSetupEnum.StoreCreditEnum.RESTORE_CREDIT_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentStoreSettingReqDto.getStoreDistanceDto(), (Object)originalStoreSettingReqDto.getStoreDistanceDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreDistanceEnum.DISTANCE_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreDistanceDto()), BasicSetupEnum.StoreDistanceEnum.DISTANCE_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentStoreSettingReqDto.getStoreDeliveryThresholdDto(), (Object)originalStoreSettingReqDto.getStoreDeliveryThresholdDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreDeliveryThresholdEnum.STORE_DELIVERY_THRESHOLD_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreDeliveryThresholdDto()), BasicSetupEnum.StoreDeliveryThresholdEnum.STORE_DELIVERY_THRESHOLD_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreDeliveryEfficiencyDto()), (Object)JSON.toJSONString((Object)originalStoreSettingReqDto.getStoreDeliveryEfficiencyDto()))) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreDeliveryEfficiencyEnum.STORE_DELIVERY_EFFICIENCY_SETTING.getType(), JSON.toJSONString((Object)currentStoreSettingReqDto.getStoreDeliveryEfficiencyDto()), BasicSetupEnum.StoreDeliveryEfficiencyEnum.STORE_DELIVERY_EFFICIENCY_SETTING.getDesc());
        }
    }

    private void handleStoreSettingAdd(StoreSettingReqDto storeSettingReqDto) {
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.REJECT_ORDER_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreRejectDto()), BasicSetupEnum.StoreCreditEnum.REJECT_ORDER_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.UNABLE_DELIVER_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreUnDeliverDto()), BasicSetupEnum.StoreCreditEnum.UNABLE_DELIVER_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.NOT_DELIVER_TIMEOUT_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreNotDeliverTimeoutDto()), BasicSetupEnum.StoreCreditEnum.NOT_DELIVER_TIMEOUT_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreCreditEnum.RESTORE_CREDIT_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreRestoreCreditDto()), BasicSetupEnum.StoreCreditEnum.RESTORE_CREDIT_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreDistanceEnum.DISTANCE_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreDistanceDto()), BasicSetupEnum.StoreDistanceEnum.DISTANCE_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreDeliveryThresholdEnum.STORE_DELIVERY_THRESHOLD_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreDeliveryThresholdDto()), BasicSetupEnum.StoreDeliveryThresholdEnum.STORE_DELIVERY_THRESHOLD_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.STORE_SETTING.getType(), BasicSetupEnum.StoreDeliveryEfficiencyEnum.STORE_DELIVERY_EFFICIENCY_SETTING.getType(), JSON.toJSONString((Object)storeSettingReqDto.getStoreDeliveryEfficiencyDto()), BasicSetupEnum.StoreDeliveryEfficiencyEnum.STORE_DELIVERY_EFFICIENCY_SETTING.getDesc());
    }

    private void handleOrderSettingSave(OrderSettingReqDto orderSettingReqDto, OrderSettingReqDto oriOrderSettingReqDto) {
        if (null == oriOrderSettingReqDto || null == oriOrderSettingReqDto.getDeliveryAutoSplitSettingDto()) {
            this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType(), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_SPLIT_SETTING.getType(), JSON.toJSONString((Object)orderSettingReqDto.getDeliveryAutoSplitSettingDto()), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_SPLIT_SETTING.getDesc());
        } else {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType(), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_SPLIT_SETTING.getType(), JSON.toJSONString((Object)orderSettingReqDto.getDeliveryAutoSplitSettingDto()), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_SPLIT_SETTING.getDesc());
        }
        if (null == oriOrderSettingReqDto || null == oriOrderSettingReqDto.getDeliveryAutoMergeSettingDto()) {
            this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType(), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_MERGE_SETTING.getType(), JSON.toJSONString((Object)orderSettingReqDto.getDeliveryAutoMergeSettingDto()), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_MERGE_SETTING.getDesc());
        } else {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType(), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_MERGE_SETTING.getType(), JSON.toJSONString((Object)orderSettingReqDto.getDeliveryAutoSplitSettingDto()), BasicSetupEnum.OrderSettingEnum.DELIVERY_AUTO_MERGE_SETTING.getDesc());
        }
        if (null == oriOrderSettingReqDto || null == oriOrderSettingReqDto.getDeliveryAutoMergeSettingDto()) {
            this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType(), BasicSetupEnum.OrderSettingEnum.DELIVERY_SETTING.getType(), JSON.toJSONString((Object)orderSettingReqDto.getDeliverySettingDto()), BasicSetupEnum.OrderSettingEnum.DELIVERY_SETTING.getDesc());
        } else {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.ORDER_SETTING.getType(), BasicSetupEnum.OrderSettingEnum.DELIVERY_SETTING.getType(), JSON.toJSONString((Object)orderSettingReqDto.getDeliverySettingDto()), BasicSetupEnum.OrderSettingEnum.DELIVERY_SETTING.getDesc());
        }
    }

    private void handleSystemSettingAdd(SystemSettingReqDto systemSettingReqDto) {
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.DirectSalesPerformanceEnum.PERFORMANCE_DIVIDED_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getPerformanceDividedDto()), BasicSetupEnum.DirectSalesPerformanceEnum.PERFORMANCE_DIVIDED_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.DirectSalesPerformanceEnum.DELIVERY_PERFORMANCE_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getDeliveryPerformanceDto()), BasicSetupEnum.DirectSalesPerformanceEnum.DELIVERY_PERFORMANCE_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.DirectSalesPerformanceEnum.UN_DELIVERY_PERFORMANCE_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getUnDeliveryPerformanceDto()), BasicSetupEnum.DirectSalesPerformanceEnum.UN_DELIVERY_PERFORMANCE_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventorySharingEnum.INVENTORY_SHARE_STRATEGY_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getInventoryShareStrategyDto()), BasicSetupEnum.InventorySharingEnum.INVENTORY_SHARE_STRATEGY_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventorySharingEnum.STORE_INVENTORY_SHARING_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getStoreInventorySharingDto()), BasicSetupEnum.InventorySharingEnum.STORE_INVENTORY_SHARING_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventorySharingEnum.STORE_SAFETY_INVENTORY_NUM_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getStoreSafetyInventoryNumDto()), BasicSetupEnum.InventorySharingEnum.STORE_SAFETY_INVENTORY_NUM_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.FranchiseeFinanceEnum.FINANCIAL_DIVIDED_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getFinancialDividedDto()), BasicSetupEnum.FranchiseeFinanceEnum.FINANCIAL_DIVIDED_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.FranchiseeFinanceEnum.DELIVERY_FINANCIAL_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getFinancialDeliveryDto()), BasicSetupEnum.FranchiseeFinanceEnum.DELIVERY_FINANCIAL_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.SmsReminderEnum.SMS_REMINDER_DURATION_SETTING.getType(), JSON.toJSONString((Object)systemSettingReqDto.getSmsReminderDto()), BasicSetupEnum.SmsReminderEnum.SMS_REMINDER_DURATION_SETTING.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventoryBaseEnum.INVENTORY_BASE.getType(), JSON.toJSONString((Object)systemSettingReqDto.getInventoryBaseDto()), BasicSetupEnum.InventoryBaseEnum.INVENTORY_BASE.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.StoreSafetyInventoryStrategyEnum.STORE_SAFETY_INVENTORY_STRATEGYE.getType(), JSON.toJSONString((Object)systemSettingReqDto.getStoreSafetyInventoryStrategyDto()), BasicSetupEnum.StoreSafetyInventoryStrategyEnum.STORE_SAFETY_INVENTORY_STRATEGYE.getDesc());
        this.addSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventoryCalculateEnum.INVENTORY_CALCULATE.getType(), JSON.toJSONString((Object)systemSettingReqDto.getInventoryCalculateDto()), BasicSetupEnum.InventoryCalculateEnum.INVENTORY_CALCULATE.getDesc());
    }

    private void handleSystemSettingUpdate(SystemSettingReqDto currentSystemSettingReqDto, SystemSettingReqDto originalSystemSettingReqDto) {
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getPerformanceDividedDto(), (Object)originalSystemSettingReqDto.getPerformanceDividedDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.DirectSalesPerformanceEnum.PERFORMANCE_DIVIDED_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getPerformanceDividedDto()), BasicSetupEnum.DirectSalesPerformanceEnum.PERFORMANCE_DIVIDED_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getDeliveryPerformanceDto(), (Object)originalSystemSettingReqDto.getDeliveryPerformanceDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.DirectSalesPerformanceEnum.DELIVERY_PERFORMANCE_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getDeliveryPerformanceDto()), BasicSetupEnum.DirectSalesPerformanceEnum.DELIVERY_PERFORMANCE_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getUnDeliveryPerformanceDto(), (Object)originalSystemSettingReqDto.getUnDeliveryPerformanceDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.DirectSalesPerformanceEnum.UN_DELIVERY_PERFORMANCE_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getUnDeliveryPerformanceDto()), BasicSetupEnum.DirectSalesPerformanceEnum.UN_DELIVERY_PERFORMANCE_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getInventoryShareStrategyDto(), (Object)originalSystemSettingReqDto.getInventoryShareStrategyDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventorySharingEnum.INVENTORY_SHARE_STRATEGY_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getInventoryShareStrategyDto()), BasicSetupEnum.InventorySharingEnum.INVENTORY_SHARE_STRATEGY_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getStoreInventorySharingDto(), (Object)originalSystemSettingReqDto.getStoreInventorySharingDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventorySharingEnum.STORE_INVENTORY_SHARING_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getStoreInventorySharingDto()), BasicSetupEnum.InventorySharingEnum.STORE_INVENTORY_SHARING_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getStoreSafetyInventoryNumDto(), (Object)originalSystemSettingReqDto.getStoreSafetyInventoryNumDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventorySharingEnum.STORE_SAFETY_INVENTORY_NUM_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getStoreSafetyInventoryNumDto()), BasicSetupEnum.InventorySharingEnum.STORE_SAFETY_INVENTORY_NUM_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getFinancialDividedDto(), (Object)originalSystemSettingReqDto.getFinancialDividedDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.FranchiseeFinanceEnum.FINANCIAL_DIVIDED_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getFinancialDividedDto()), BasicSetupEnum.FranchiseeFinanceEnum.FINANCIAL_DIVIDED_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getFinancialDeliveryDto(), (Object)originalSystemSettingReqDto.getFinancialDeliveryDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.FranchiseeFinanceEnum.DELIVERY_FINANCIAL_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getFinancialDeliveryDto()), BasicSetupEnum.FranchiseeFinanceEnum.DELIVERY_FINANCIAL_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getSmsReminderDto(), (Object)originalSystemSettingReqDto.getSmsReminderDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.SmsReminderEnum.SMS_REMINDER_DURATION_SETTING.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getSmsReminderDto()), BasicSetupEnum.SmsReminderEnum.SMS_REMINDER_DURATION_SETTING.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getInventoryBaseDto(), (Object)originalSystemSettingReqDto.getInventoryBaseDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventoryBaseEnum.INVENTORY_BASE.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getInventoryBaseDto()), BasicSetupEnum.InventoryBaseEnum.INVENTORY_BASE.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getStoreSafetyInventoryStrategyDto(), (Object)originalSystemSettingReqDto.getStoreSafetyInventoryStrategyDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.StoreSafetyInventoryStrategyEnum.STORE_SAFETY_INVENTORY_STRATEGYE.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getStoreSafetyInventoryStrategyDto()), BasicSetupEnum.StoreSafetyInventoryStrategyEnum.STORE_SAFETY_INVENTORY_STRATEGYE.getDesc());
        }
        if (0 != CompareToBuilder.reflectionCompare((Object)currentSystemSettingReqDto.getInventoryCalculateDto(), (Object)originalSystemSettingReqDto.getInventoryCalculateDto())) {
            this.updateSetting(BasicSetupEnum.BasicSetupTypeEnum.SYSTEM_SETTING.getType(), BasicSetupEnum.InventoryCalculateEnum.INVENTORY_CALCULATE.getType(), JSON.toJSONString((Object)currentSystemSettingReqDto.getInventoryCalculateDto()), BasicSetupEnum.InventoryCalculateEnum.INVENTORY_CALCULATE.getDesc());
        }
    }

    private void addSetting(String groupCode, String code, String value, String statement) {
        DictDto dictDto = new DictDto();
        dictDto.setGroupCode(groupCode);
        dictDto.setCode(code);
        dictDto.setValue(value);
        dictDto.setStatement(statement);
        dictDto.setTenantId(ComConstants.TENANT);
        dictDto.setStatus(Integer.valueOf(1));
        this.dictApi.saveDict(dictDto);
    }

    private void updateSetting(String groupCode, String code, String value, String statement) {
        DictDto dictDto = new DictDto();
        dictDto.setGroupCode(groupCode);
        dictDto.setCode(code);
        dictDto.setValue(value);
        dictDto.setStatement(statement);
        dictDto.setTenantId(ComConstants.TENANT);
        dictDto.setStatus(Integer.valueOf(1));
        this.dictApi.modifyDict(dictDto);
    }

    private void validateSystemSetting(SystemSettingReqDto dto) {
        if (null != dto.getPerformanceDividedDto()) {
            if (BigDecimal.ZERO.compareTo(dto.getPerformanceDividedDto().getDeliveryChannelShare()) > 0 && new BigDecimal(100).compareTo(dto.getPerformanceDividedDto().getDeliveryChannelShare()) < 0) {
                throw new BizException(AdminModuleExceptionCode.DELIVERY_CHANNEL_SHARE_RANGE_OUT_EXCEPTION.getMsg());
            }
            if (BigDecimal.ZERO.compareTo(dto.getPerformanceDividedDto().getSaleChannelShare()) > 0 && new BigDecimal(100).compareTo(dto.getPerformanceDividedDto().getSaleChannelShare()) < 0) {
                throw new BizException(AdminModuleExceptionCode.SALE_CHANNEL_SHARE_RANGE_OUT_EXCEPTION.getMsg());
            }
            if (null != dto.getPerformanceDividedDto().getDeliveryChannelShare() && null != dto.getPerformanceDividedDto().getSaleChannelShare() && new BigDecimal(100).compareTo(dto.getPerformanceDividedDto().getDeliveryChannelShare().add(dto.getPerformanceDividedDto().getSaleChannelShare())) != 0) {
                throw new BizException(AdminModuleExceptionCode.PERFORMANCE_DIVIDED_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getDeliveryPerformanceDto()) {
            if (BigDecimal.ZERO.compareTo(dto.getDeliveryPerformanceDto().getRejectionAmount()) > 0) {
                throw new BizException(AdminModuleExceptionCode.REJECTION_AMOUNT_EXCEPTION.getMsg());
            }
            if (BigDecimal.ZERO.compareTo(dto.getDeliveryPerformanceDto().getUnDeliveryAmount()) > 0) {
                throw new BizException(AdminModuleExceptionCode.UNDELIVERY_AMOUNT_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getUnDeliveryPerformanceDto() && null != dto.getUnDeliveryPerformanceDto().getType() && "3".equals(dto.getUnDeliveryPerformanceDto().getType()) && null != dto.getUnDeliveryPerformanceDto().getProportion() && BigDecimal.ZERO.compareTo(dto.getUnDeliveryPerformanceDto().getProportion()) > 0) {
            throw new BizException(AdminModuleExceptionCode.UNDELIVERY_PERFORMANCE_EXCEPTION.getMsg());
        }
        if (null != dto.getStoreInventorySharingDto()) {
            if (BigDecimal.ZERO.compareTo(dto.getStoreInventorySharingDto().getOMSChannel()) > 0 && new BigDecimal(100).compareTo(dto.getStoreInventorySharingDto().getOMSChannel()) < 0) {
                throw new BizException(AdminModuleExceptionCode.STORE_INVENTORY_SHARING_OMS_EXCEPTION.getMsg());
            }
            if (BigDecimal.ZERO.compareTo(dto.getStoreInventorySharingDto().getAppletChannel()) > 0 && new BigDecimal(100).compareTo(dto.getStoreInventorySharingDto().getAppletChannel()) < 0) {
                throw new BizException(AdminModuleExceptionCode.STORE_INVENTORY_SHARING_APPLET_EXCEPTION.getMsg());
            }
            if (null != dto.getStoreInventorySharingDto().getOMSChannel() && null != dto.getStoreInventorySharingDto().getAppletChannel() && new BigDecimal(100).compareTo(dto.getStoreInventorySharingDto().getOMSChannel().add(dto.getStoreInventorySharingDto().getAppletChannel())) < 0) {
                throw new BizException(AdminModuleExceptionCode.STORE_INVENTORY_SHARING_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getStoreSafetyInventoryNumDto() && dto.getStoreSafetyInventoryNumDto().getNum() < 0) {
            throw new BizException(AdminModuleExceptionCode.STORE_SAFETY_INVENTORY_NUM_EXCEPTION.getMsg());
        }
        if (null != dto.getFinancialDividedDto()) {
            if (BigDecimal.ZERO.compareTo(dto.getFinancialDividedDto().getSaleShare()) > 0 && new BigDecimal(100).compareTo(dto.getFinancialDividedDto().getSaleShare()) < 0) {
                throw new BizException(AdminModuleExceptionCode.FINANCIAL_DIVIDED_SALE_EXCEPTION.getMsg());
            }
            if (BigDecimal.ZERO.compareTo(dto.getFinancialDividedDto().getDeliveryShare()) > 0 && new BigDecimal(100).compareTo(dto.getFinancialDividedDto().getDeliveryShare()) < 0) {
                throw new BizException(AdminModuleExceptionCode.FINANCIAL_DIVIDED_DELIVERY_EXCEPTION.getMsg());
            }
            if (null != dto.getFinancialDividedDto().getSaleShare() && null != dto.getFinancialDividedDto().getDeliveryShare() && new BigDecimal(100).compareTo(dto.getFinancialDividedDto().getSaleShare().add(dto.getFinancialDividedDto().getDeliveryShare())) != 0) {
                throw new BizException(AdminModuleExceptionCode.FINANCIAL_DIVIDED_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getFinancialDeliveryDto()) {
            if (BigDecimal.ZERO.compareTo(dto.getFinancialDeliveryDto().getRejectAmount()) > 0) {
                throw new BizException(AdminModuleExceptionCode.FINANCIAL_DELIVERY_REJECT_AMOUNT_EXCEPTION.getMsg());
            }
            if (BigDecimal.ZERO.compareTo(dto.getFinancialDeliveryDto().getUnDeliverAmount()) > 0) {
                throw new BizException(AdminModuleExceptionCode.FINANCIAL_DELIVERY_UNDELIVER_AMOUNT_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getSmsReminderDto()) {
            if (null == dto.getSmsReminderDto().getStatus()) {
                throw new BizException(AdminModuleExceptionCode.SMS_REMINDER_STATUS_EXCEPTION.getMsg());
            }
            if (dto.getSmsReminderDto().getRoutingFailedTime() < 0) {
                throw new BizException(AdminModuleExceptionCode.SMS_REMINDER_ROUTING_FAILED_EXCEPTION.getMsg());
            }
            if (dto.getSmsReminderDto().getRoutingStoreTime() < 0) {
                throw new BizException(AdminModuleExceptionCode.SMS_REMINDER_ROUTING_STORE_EXCEPTION.getMsg());
            }
            if (dto.getSmsReminderDto().getStoreReceivingTime() < 0) {
                throw new BizException(AdminModuleExceptionCode.SMS_REMINDER_STORE_RECEIVING_EXCEPTION.getMsg());
            }
            if (dto.getSmsReminderDto().getOfflineToStoreTime() < 0) {
                throw new BizException(AdminModuleExceptionCode.SMS_REMINDER_OFFLINE_TO_STORE_EXCEPTION.getMsg());
            }
            if (dto.getSmsReminderDto().getCancelOrderTime() < 0) {
                throw new BizException(AdminModuleExceptionCode.SMS_REMINDER_CANCEL_ORDER_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getInventoryBaseDto()) {
            if (null == dto.getInventoryBaseDto().getBatchStatus()) {
                throw new BizException(AdminModuleExceptionCode.BATCH_STATUS_EXCEPTION.getMsg());
            }
            if (dto.getInventoryBaseDto().getOutBoundRule() == null) {
                throw new BizException(AdminModuleExceptionCode.OUTBOUND_RULE_EXCEPTION.getMsg());
            }
            if (null == dto.getInventoryBaseDto().getInventoryAdequate() || dto.getInventoryBaseDto().getInventoryAdequate().doubleValue() < 0.0) {
                throw new BizException(AdminModuleExceptionCode.INVENTORY_ADEQUATE_RULE_EXCEPTION.getMsg());
            }
            if (null == dto.getInventoryBaseDto().getInventoryTight() || dto.getInventoryBaseDto().getInventoryTight().doubleValue() < 0.0) {
                throw new BizException(AdminModuleExceptionCode.INVENTORY_TIGHT_RULE_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getStoreSafetyInventoryStrategyDto()) {
            if (null == dto.getStoreSafetyInventoryStrategyDto().getSafetyInventorOverNum() || dto.getStoreSafetyInventoryStrategyDto().getSafetyInventorOverNum() < 0) {
                throw new BizException(AdminModuleExceptionCode.SAFETY_INVENTOROVER_NUM_EXCEPTION.getMsg());
            }
            if (null == dto.getStoreSafetyInventoryStrategyDto().getSingleChannelInventorOverNum() || dto.getStoreSafetyInventoryStrategyDto().getSingleChannelInventorOverNum() < 0) {
                throw new BizException(AdminModuleExceptionCode.SINGLE_CHANNEL_INVENTOROVER_NUM_EXCEPTION.getMsg());
            }
            if (StringUtils.isBlank((CharSequence)dto.getStoreSafetyInventoryStrategyDto().getSingleChannelCode()) || this.exitChannelByCode(dto)) {
                throw new BizException(AdminModuleExceptionCode.SINGLE_CHANNEL_CODE_EXCEPTION.getMsg());
            }
        }
        if (null != dto.getInventoryCalculateDto() && (null == dto.getStoreSafetyInventoryStrategyDto().getSafetyInventorOverNum() || dto.getStoreSafetyInventoryStrategyDto().getSafetyInventorOverNum() < 0)) {
            throw new BizException(AdminModuleExceptionCode.INVENTORY_CALCULATE_EXCEPTION.getMsg());
        }
    }

    private boolean exitChannelByCode(SystemSettingReqDto dto) {
        ChannelPageReqDto condition = new ChannelPageReqDto();
        condition.setCode(dto.getStoreSafetyInventoryStrategyDto().getSingleChannelCode());
        RestResponse restResponse = this.channelQueryApi.queryByCode(dto.getStoreSafetyInventoryStrategyDto().getSingleChannelCode());
        return null == restResponse.getData();
    }
}

