/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.AppInstanceUserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.admin.api.IAccess;
import com.dtyunxi.yundt.module.admin.api.IOperator;
import com.dtyunxi.yundt.module.admin.api.IRole;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.bo.Role;
import com.dtyunxi.yundt.module.domain.bo.User;
import com.dtyunxi.yundt.module.domain.constant.UserConstant;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.dtyunxi.yundt.module.shop.api.IMerchant;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperatorImpl
implements IOperator {
    private static final Logger logger = LoggerFactory.getLogger(OperatorImpl.class);
    @Resource
    private IUserApi userApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Autowired
    private IAccess accessImpl;
    @Autowired
    private IRole roleImpl;
    @Autowired
    private ISecurityApi securityApi;
    @Autowired
    private IMerchant merchantImpl;
    @Resource
    private IApplicationQueryApi applicationQueryApi;

    public Long create(User user) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        UserDto userDto = (UserDto)ConvertUtil.convert((Object)user, UserDto.class);
        userDto.setInstanceId(instanceId);
        userDto.setTenantId(tenantId);
        String userName = this.context.userName();
        userDto.setCreatePerson(userName);
        userDto.setRegisterType(Integer.valueOf(4));
        userDto.setUserType(Integer.valueOf(1));
        RestResponse restResponse = this.userApi.addUser(instanceId, userDto);
        Long userId = (Long)restResponse.getData();
        if (!ExceptionCode.SUCCESS.getCode().equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        Integer roleType = this.roleImpl.validRoleType();
        this.addMgmtRole(roleIds, roleType);
        if (CollectionUtils.isNotEmpty((Collection)user.getRoleSet())) {
            for (Role role : user.getRoleSet()) {
                roleIds.add(role.getId());
            }
        }
        this.accessImpl.authRoles(userId, roleIds);
        if (UserConstant.MERCHANT.equals(roleType)) {
            Long sellerId = this.merchantImpl.getSellerIdByContext();
            UserDto exam = new UserDto();
            exam.setExtension(sellerId.toString());
            this.userApi.update(userId, exam);
        }
        return userId;
    }

    private void addMgmtRole(List<Long> roleIds, Integer roleType) {
        RoleDto roleData;
        if (UserConstant.OPERATOR.equals(roleType)) {
            RoleDto roleData2 = (RoleDto)this.accessQueryApi.queryRoleByCodeOrName(this.context.instanceId(), "platMgmtChild", null).getData();
            if (roleData2 != null) {
                roleIds.add(roleData2.getId());
            }
        } else if (UserConstant.MERCHANT.equals(roleType) && (roleData = (RoleDto)this.accessQueryApi.queryRoleByCodeOrName(this.context.instanceId(), "merchantChild", null).getData()) != null) {
            roleIds.add(roleData.getId());
        }
    }

    public void modify(User user) {
        UserDto userDto = (UserDto)ConvertUtil.convert((Object)user, UserDto.class);
        userDto.setTenantId(this.context.tenantId());
        if (StringUtils.isNotBlank((String)userDto.getPassword())) {
            this.securityApi.resetPasswordByAdmin(user.getId(), userDto.getPassword());
            userDto.setPassword(null);
        }
        this.userApi.updatePasswordPermittedWithSalt(user.getId(), userDto);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)user.getRoleSet())) {
            for (Role role : user.getRoleSet()) {
                roleIds.add(role.getId());
            }
            this.accessImpl.authRoles(user.getId(), roleIds);
        }
    }

    public void remove(Long userId) {
        RestResponseHelper.checkOrThrow((RestResponse)this.userApi.delete(userId));
    }

    public void updateStatus(Long userId, Integer status) {
        UserDto userDto = new UserDto();
        userDto.setStatus(status);
        this.userApi.update(userId, userDto);
    }

    public PageInfo<User> query(User exam, Integer pageNum, Integer pageSize) {
        PageInfo result = new PageInfo();
        result.setPageNum(pageNum.intValue());
        result.setPageSize(pageSize.intValue());
        PageInfo pageInfo = null;
        if (CollectionUtils.isNotEmpty((Collection)exam.getRoleSet())) {
            Role role = this.roleImpl.getById(((Role)exam.getRoleSet().stream().findFirst().get()).getId());
            pageInfo = (PageInfo)this.userQueryApi.queryByRoleCode(role.getCode(), "{}", "{}", pageNum, pageSize).getData();
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                RoleDto roleDto = (RoleDto)ConvertUtil.convert((Object)role, RoleDto.class);
                HashSet<RoleDto> roleSet = new HashSet<RoleDto>();
                roleSet.add(roleDto);
                for (UserDto userDto2 : pageInfo.getList()) {
                    userDto2.setRoleSet(roleSet);
                }
            }
        } else {
            List<SqlFilter> sqlFilterList = this.getSqlFilters(exam);
            HashMap param = Maps.newHashMap();
            param.put("instanceId", this.context.instanceId());
            param.put("tenantId", this.context.tenantId());
            param.put("reses", new String[]{"role"});
            param.put("filters", sqlFilterList);
            String filter = ObjectHelper.bean2Json((Object)param);
            pageInfo = (PageInfo)this.userQueryApi.queryByPage(filter, pageNum, pageSize).getData();
        }
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return result;
        }
        List userList = pageInfo.getList().stream().map(userDto -> {
            User user = (User)ConvertUtil.convert((Object)userDto, User.class);
            user.setPassword(null);
            if (CollectionUtils.isNotEmpty((Collection)userDto.getRoleSet())) {
                HashSet roleSet = new HashSet();
                CubeBeanUtils.copyCollection(roleSet, (Collection)userDto.getRoleSet(), Role.class);
                user.setRoleSet(roleSet);
            }
            return user;
        }).collect(Collectors.toList());
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        result.setList(userList);
        return result;
    }

    private List<SqlFilter> getSqlFilters(User user) {
        ArrayList filterList = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)user.getUserName())) {
            filterList.add(SqlFilter.like((String)"userName", (Object)user.getUserName()));
        }
        if (null != user.getNickName()) {
            filterList.add(SqlFilter.eq((String)"nickName", (Object)user.getNickName()));
        }
        if (StringUtils.isNotBlank((String)user.getPhone())) {
            filterList.add(SqlFilter.like((String)"phone", (Object)user.getPhone()));
        }
        if (null != user.getStatus()) {
            filterList.add(SqlFilter.eq((String)"status", (Object)user.getStatus()));
        }
        filterList.add(SqlFilter.in((String)"user_type", (Object)StringUtils.join((Object[])new Integer[]{1, 2}, (String)",")));
        return filterList;
    }

    public List<MenuQueryResDto> queryMenuTree(Long userId) {
        Long instanceId = this.context.instanceId();
        logger.debug("\u4e0a\u4e0b\u6587\u4e2d\u7684instanceId\u4e3a\uff1a{}", (Object)instanceId);
        AppInstanceUserQueryReqDto queryParam = new AppInstanceUserQueryReqDto();
        queryParam.setUserId(userId);
        queryParam.setRes((List)Lists.newArrayList((Object[])new String[]{"menus"}));
        AppInstanceQueryResDto appInstanceDto = (AppInstanceQueryResDto)RestResponseHelper.extractData((RestResponse)this.applicationQueryApi.queryUserResources(queryParam));
        List menuList = appInstanceDto.getMenuList();
        return menuList;
    }

    @Nullable
    public User getById(Long userId) {
        UserVo userVo = (UserVo)this.userQueryApi.queryByIdAndResource(userId, new String[]{"role"}, "{}").getData();
        if (null == userVo) {
            return null;
        }
        User user = (User)ConvertUtil.convert((Object)userVo, User.class);
        return user;
    }
}

