/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IApplicationApi;
import com.dtyunxi.yundt.cube.center.user.api.IResourceApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.module.admin.api.IResource;
import com.dtyunxi.yundt.module.admin.bo.Button;
import com.dtyunxi.yundt.module.admin.bo.Menu;
import com.dtyunxi.yundt.module.admin.bo.Resource;
import com.dtyunxi.yundt.module.admin.bo.constant.AdminConstant;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceImpl
implements IResource {
    @Autowired
    private IResourceApi resourceApi;
    @Autowired
    private IApplicationQueryApi applicationQueryApi;
    @Autowired
    private IApplicationApi applicationApi;
    @Autowired
    private IContext context;

    public <T extends Resource> void create(T t) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Long applicationId = this.context.applicationId();
        Optional.ofNullable(applicationId).orElseThrow(() -> new BizException("\u5b9e\u4f8b\u4e0d\u5b58\u5728"));
        RestResponse createResp = null;
        if (AdminConstant.RESOURCE_TYPE_BUTTON.equals(t.getResourceType())) {
            ButtonDto buttonDto = (ButtonDto)ConvertUtil.convert((Object)((Button)t), ButtonDto.class);
            buttonDto.setInstanceId(instanceId);
            buttonDto.setTenantId(tenantId);
            createResp = this.applicationApi.appBindButton(applicationId, buttonDto.getMenuId(), (List)Lists.newArrayList((Object[])new ButtonDto[]{buttonDto}));
        } else {
            MenuDto menuDto = (MenuDto)ConvertUtil.convert((Object)((Menu)t), MenuDto.class);
            menuDto.setInstanceId(instanceId);
            menuDto.setTenantId(tenantId);
            createResp = this.applicationApi.appBindMenu(applicationId, menuDto);
        }
        if (!ExceptionCode.SUCCESS.getCode().equals(createResp.getResultCode())) {
            throw new BizException(createResp.getResultCode(), createResp.getResultMsg());
        }
    }

    @Nullable
    public List<Menu> queryMenuTree() {
        AppInstanceDto appInstance = this.getInsResById(this.context.instanceId());
        if (null == appInstance || null == appInstance.getMenus()) {
            return null;
        }
        Menu menu = (Menu)ConvertUtil.convert((Object)appInstance.getMenus(), Menu.class);
        return Lists.newArrayList((Object[])new Menu[]{menu});
    }

    @Nullable
    private AppInstanceDto getInsResById(Long instanceId) {
        String[] res = new String[]{"menus", "buttons"};
        AppInstanceDto appInstance = (AppInstanceDto)this.applicationQueryApi.queryInsByIdAndResources(this.context.instanceId(), res, "").getData();
        return appInstance;
    }

    @Nullable
    public <T extends Resource> T getById(Long resourceId) {
        return null;
    }

    public <T extends Resource> void modify(T t) {
        if (AdminConstant.RESOURCE_TYPE_BUTTON.equals(t.getResourceType())) {
            ButtonDto buttonDto = (ButtonDto)ConvertUtil.convert((Object)((Button)t), ButtonDto.class);
            this.resourceApi.modifyButton(buttonDto.getId(), buttonDto);
        } else {
            MenuDto menuDto = (MenuDto)ConvertUtil.convert((Object)((Menu)t), MenuDto.class);
            this.resourceApi.modifyMenu(menuDto.getId(), menuDto);
        }
    }

    public void modifySort(Long originMenuId, Integer originSortNo, Long targetMenuId, Integer targetSortNo) {
        MenuDto menuDto = new MenuDto();
        menuDto.setId(originMenuId);
        menuDto.setSortNo(targetSortNo);
        this.resourceApi.modifyMenu(menuDto.getId(), menuDto);
        menuDto.setId(targetMenuId);
        menuDto.setSortNo(originSortNo);
        this.resourceApi.modifyMenu(menuDto.getId(), menuDto);
    }

    public void removeButton(Long resourceId) {
        RestResponseHelper.checkOrThrow((RestResponse)this.resourceApi.removeButton(this.context.instanceId(), resourceId));
    }

    public void removeMenu(Long resourceId) {
        RestResponseHelper.checkOrThrow((RestResponse)this.resourceApi.remove(this.context.instanceId(), resourceId));
    }
}

