/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.admin.api.IRole;
import com.dtyunxi.yundt.module.admin.bo.constant.AdminConstant;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.bo.Role;
import com.dtyunxi.yundt.module.domain.constant.UserConstant;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RoleImpl
implements IRole {
    @Resource
    private IAccessApi accessApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IContext context;

    public Long create(Role role) {
        Long instanceId = this.context.instanceId();
        RoleDto roleDto = this.convert2roleDto(role);
        roleDto.setInstanceId(instanceId);
        roleDto.setTenantId(this.context.tenantId());
        String userName = this.context.userName();
        roleDto.setCreatePerson(userName);
        roleDto.setStatus(AdminConstant.STATUS_ENABLE);
        if (roleDto.getCode() == null) {
            roleDto.setCode(MD5Util.getMd5ByString((String)(instanceId + "" + System.currentTimeMillis())));
        }
        RestResponse restResponse = this.accessApi.createRole(instanceId, roleDto);
        if (!ExceptionCode.SUCCESS.getCode().equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return ((RoleDto)restResponse.getData()).getId();
    }

    private RoleDto convert2roleDto(Role role) {
        RoleDto roleDto = new RoleDto();
        BeanUtils.copyProperties((Object)role, (Object)roleDto);
        return roleDto;
    }

    public void modify(Role role) {
        RoleDto roleDto = this.convert2roleDto(role);
        this.accessApi.updateRole(roleDto.getId(), roleDto);
    }

    public void remove(Long roleId) {
        RestResponseHelper.checkOrThrow((RestResponse)this.accessApi.deleteRole((List)Lists.newArrayList((Object[])new Long[]{roleId})));
    }

    public void enable(Long roleId) {
        this.updateRoleStatus(roleId, AdminConstant.STATUS_ENABLE);
    }

    @Nullable
    private RoleDto queryRoleDtoById(Long roleId) {
        RoleDto roleParam = new RoleDto();
        roleParam.setId(roleId);
        roleParam.setInstanceId(this.context.instanceId());
        roleParam.setTenantId(this.context.tenantId());
        PageInfo pageInfo = (PageInfo)this.accessQueryApi.queryPageRole(JSON.toJSONString((Object)roleParam), "", Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        return (RoleDto)pageInfo.getList().get(0);
    }

    public void disable(Long roleId) {
        this.updateRoleStatus(roleId, AdminConstant.STATUS_DISABLE);
    }

    private void updateRoleStatus(Long roleId, Integer status) {
        RoleDto roleDto = this.queryRoleDtoById(roleId);
        Optional.ofNullable(roleDto).ifPresent(role -> {
            roleDto.setStatus(status);
            this.accessApi.updateRole(roleId, roleDto);
        });
    }

    public PageInfo<Role> query(@Nullable Role role, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        PageInfo result = new PageInfo();
        result.setPageNum(pageNum.intValue());
        result.setPageSize(pageSize.intValue());
        String filter = null;
        if (null != role) {
            RoleDto roleParam = this.convert2roleDto(role);
            roleParam.setInstanceId(this.context.instanceId());
            roleParam.setTenantId(this.context.tenantId());
            filter = JSON.toJSONString((Object)roleParam);
        }
        if (CollectionUtils.isEmpty((Collection)(pageInfo = (PageInfo)this.accessQueryApi.queryPageRole(filter, "", pageNum, pageSize).getData()).getList())) {
            return result;
        }
        List roleList = pageInfo.getList().stream().map(this::convert2Role).collect(Collectors.toList());
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        result.setList(roleList);
        return result;
    }

    private Role convert2Role(RoleDto roleDto) {
        Role role = new Role();
        BeanUtils.copyProperties((Object)roleDto, (Object)role);
        return role;
    }

    public Role getById(Long roleId) {
        RoleDto roleDto = this.queryRoleDtoById(roleId);
        if (null == roleDto) {
            return null;
        }
        Role role = this.convert2Role(roleDto);
        return role;
    }

    public List<Role> queryRoleByContext() {
        ArrayList roleList = null;
        Long userId = this.context.userId();
        UserVo userVo = (UserVo)this.userQueryApi.queryByIdAndResource(userId, new String[]{"role"}, "{}").getData();
        if (userVo != null && CollectionUtils.isNotEmpty((Collection)userVo.getRoleSet())) {
            roleList = new ArrayList();
            CubeBeanUtils.copyCollection(roleList, (Collection)userVo.getRoleSet(), Role.class);
        }
        return roleList;
    }

    public Integer validRoleType() {
        List<Role> roleList = this.queryRoleByContext();
        if (CollectionUtils.isNotEmpty(roleList)) {
            for (Role role : roleList) {
                if ("platMgmt".equals(role.getCode()) || "platMgmtChild".equals(role.getCode())) {
                    return UserConstant.OPERATOR;
                }
                if (!"merchant".equals(role.getCode()) && !"merchantChild".equals(role.getCode())) continue;
                return UserConstant.MERCHANT;
            }
        }
        return UserConstant.CONSUME;
    }
}

