/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.rest;

import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.module.bitem.api.IBitemShelfService;
import com.dtyunxi.yundt.module.bitem.api.IBitemShelfV2Service;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemOnShelfReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemOnShelfTobReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ShopItemReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ShopItemRespDto;
import com.dtyunxi.yundt.module.bitem.api.enums.BitemEventCodeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u5546\u54c1\u7ba1\u7406\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/bitem"})
public class BItemServiceRest {
    @Autowired
    private IBitemShelfService bitemShelfService;
    @Resource
    private IBitemShelfV2Service bitemShelfV2Service;

    @ApiOperation(value="\u6279\u91cf\u4e0a\u67b6\u5546\u54c1", notes="\u5546\u54c1\u6279\u91cf\u4e0a\u67b6")
    @PutMapping(value={"/onSale"})
    RestResponse<Void> onShelf(@Valid @RequestBody List<ItemOnShelfReqDto> itemOnShelfReqDtos) {
        this.bitemShelfV2Service.itemBrandAuthCheck(itemOnShelfReqDtos);
        ServiceEvent serviceEvent = new ServiceEvent(BitemEventCodeEnum.ON_SHELF.getCode(), BitemEventCodeEnum.ON_SHELF.getName(), itemOnShelfReqDtos);
        this.bitemShelfService.onShelf(serviceEvent);
        return new RestResponse();
    }

    @PostMapping(value={"/checkShopSkuScope"})
    @ApiOperation(value="\u5927B(\u7ecf\u9500\u5546)\u68c0\u67e5sku\u662f\u5426\u53ef\u4ee5\u5728\u5e97\u94fa\u4e0a\u67b6\u552e\u5356", notes="\u68c0\u67e5sku\u662f\u5426\u53ef\u4ee5\u5728\u5e97\u94fa\u4e0a\u67b6\u552e\u5356")
    public RestResponse<ShopItemRespDto> checkShopSkuScope(@RequestBody ShopItemReqDto shopItemReqDto) {
        return new RestResponse((Object)this.bitemShelfService.newCheckShopSkuScope(shopItemReqDto));
    }

    @ApiOperation(value="\u6279\u91cf\u4e0a\u67b6\u5546\u54c1(B\u7aef\u4e13\u7528)", notes="\u6279\u91cf\u4e0a\u67b6\u5546\u54c1(B\u7aef\u4e13\u7528)")
    @PutMapping(value={"/batch/on-shelf"})
    RestResponse<Void> batchOnShelfItem(@Valid @RequestBody List<ItemOnShelfTobReqDto> itemOnShelfReqDtos) {
        this.bitemShelfService.batchOnShelfItem(itemOnShelfReqDtos);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1\u6388\u6743\u8868\u7684\u5916\u56f4\u5546\u54c1\u7f16\u7801", notes="\u4fee\u6539\u5546\u54c1\u6388\u6743\u8868\u7684\u5916\u56f4\u5546\u54c1\u7f16\u7801")
    @PutMapping(value={"/modifyItemAuth"})
    RestResponse<Void> modifyItemAuth(@RequestBody ItemAuthReqDto modifyReqDto) {
        this.bitemShelfService.modifyItemAuth(modifyReqDto);
        return new RestResponse();
    }
}

