/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRespExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityOverlapRuleQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.ICouponTemplate;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.CouponTemplateTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.BlackItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityAuthItemReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.AuthActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.PageEditActivityReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ActivityListQueryRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponInfoRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CustomerNotAuthItemResp;
import com.dtyunxi.yundt.module.marketing.api.dto.response.GroupInfoRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ItemForActivityInfoRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.module.marketing.api.enums.OverlapSourceEnum;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.enums.QueryActivityStatusEnum;
import com.dtyunxi.yundt.module.marketing.biz.enums.QueryCouponTpStatusEnum;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.marketing.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements IActivityService {
    private static Logger logger = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IActivityApi activityApi;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IContext context;
    @Resource
    private IActivityExtQueryApi activityExtQueryApi;
    @Resource
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private ICouponTemplate couponTemplate;
    @Resource
    private IActivityOverlapRuleQueryApi activityOverlapRuleQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Autowired
    private IItemAuthQueryApi itemAuthQueryApi;

    public ItemForActivityInfoRespDto queryActivityByItemId(long itemId, boolean validStatus) {
        List activities = (List)this.activityQueryApi.inverseQuery(itemId, 0L, validStatus).getData();
        ItemForActivityInfoRespDto result = new ItemForActivityInfoRespDto();
        for (ActivityRespExtDto activity : activities) {
            PromotionInfoRespDto info;
            CouponInfoRespDto temp;
            if (null != activity.getCouponInfo()) {
                temp = new CouponInfoRespDto((ActivityRespDto)activity);
                CouponTemplateExtRespDto couponTemplateResDto = (CouponTemplateExtRespDto)activity.getCouponInfo().get(0);
                temp.setAmount(couponTemplateResDto.getAmount().toString());
                temp.setCouponCategory(couponTemplateResDto.getCouponCategory().intValue());
                temp.setCouponRange(couponTemplateResDto.getCouponRange());
                temp.setCouponValue(couponTemplateResDto.getCouponValue().toString());
                info = temp;
                result.addCouponPromotions((CouponInfoRespDto)info);
            }
            if (null != activity.getCrowdOrdering()) {
                temp = new GroupInfoRespDto((ActivityRespDto)activity);
                temp.setActivityGroupRespDtos(activity.getCrowdOrdering());
                info = temp;
                result.addActivityGroupPromotions((GroupInfoRespDto)info);
            } else {
                info = new PromotionInfoRespDto((ActivityRespDto)activity);
                result.addNormalPromotions(info);
            }
            for (ConditionTemplate conditionTemplate : ActivityFactory.getActivityTemplate(info.getActivityType())) {
            }
        }
        result.setSystemTime(System.currentTimeMillis());
        return result;
    }

    public PageInfo<ActivityListRespDto> queryByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        ActivityExtDto activityExtDto = new ActivityExtDto();
        activityExtDto.setInstanceId(this.context.instanceId());
        activityExtDto.setTenantId(this.context.tenantId());
        if (StringUtils.isNotBlank((String)activityQueryReqDto.getActivityStatus())) {
            if ("ENABLE_OVERLAP".equals(activityQueryReqDto.getActivityStatus())) {
                activityExtDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.NEW.getKey(), ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
                activityExtDto.setAuditStatusEnums((List)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.WAIT_AUDIT.getKey(), AuditStatusEnum.NEW.getKey(), AuditStatusEnum.AUDIT_PASS.getKey()}));
            } else {
                QueryActivityStatusEnum statusEnum = QueryActivityStatusEnum.getByStatus(activityQueryReqDto.getActivityStatus());
                if (null != statusEnum) {
                    activityExtDto.setAuditStatusEnum(AuditStatusEnum.valueOf((String)statusEnum.getAdutitStatus()));
                    activityExtDto.setActivityStatusEnum(ActivityStatusEnum.valueOf((String)statusEnum.getActivityStatus()));
                }
            }
        }
        if (null != activityQueryReqDto.getActivityType()) {
            activityExtDto.setActivityTemplateId(Long.valueOf(activityQueryReqDto.getActivityType().getId()));
        } else {
            ArrayList activityTemplateIds = OverlapSourceEnum.TIME_DISCOUNT.getCode().equals(activityQueryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : (OverlapSourceEnum.EXCHANGE.getCode().equals(activityQueryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}));
            activityExtDto.setActivityTemplateIds((List)activityTemplateIds);
        }
        activityExtDto.setThirdPartyCode(activityQueryReqDto.getThirdPartyCode());
        activityExtDto.setBeginTimeStart(activityQueryReqDto.getActivityTimeStart());
        activityExtDto.setBeginTimeEnd(activityQueryReqDto.getActivityTimeEnd());
        activityExtDto.setActivityName(activityQueryReqDto.getActivityName());
        activityExtDto.setActivityCode(activityQueryReqDto.getActivityCode());
        activityExtDto.setEndTimeStart(activityQueryReqDto.getEndTimeStart());
        activityExtDto.setEndTimeEnd(activityQueryReqDto.getEndTimeEnd());
        activityExtDto.setShopId(activityQueryReqDto.getShopId());
        if (Objects.nonNull(activityQueryReqDto.getOutActivityId())) {
            activityExtDto.setOutActivityIds((List)Lists.newArrayList((Iterable)activityQueryReqDto.getOutActivityId()));
        }
        Long currentUserOrgId = this.getCurrentUserOrgId(this.context.userId());
        activityExtDto.setOrganizationId(currentUserOrgId);
        PageInfo pageInfo = (PageInfo)this.activityExtQueryApi.queryActivityPage(activityExtDto, pageNum, pageSize).getData();
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            pageInfo.getList().forEach(activity -> {
                if (activity.getActivityTemplateId().equals(ActivityType.COUPON_TOB_ACTIVITY.getId())) {
                    activity.setActivityStatus(QueryCouponTpStatusEnum.getStatus(activity.getCouponTemplateStatus(), activity.getAuditStatus()));
                } else {
                    activity.setActivityStatus(QueryActivityStatusEnum.getStatus(activity.getActivityStatus(), activity.getAuditStatus()));
                }
            });
        }
        return pageInfo;
    }

    public PageInfo<ActivityListQueryRespDto> queryActivityByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo activityPageInfo = new PageInfo(ListUtil.empty());
        PageInfo<ActivityListRespDto> pageInfo = this.queryByPage(activityQueryReqDto, pageNum, pageSize);
        if (Objects.isNull(pageInfo) || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return activityPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)activityPageInfo, pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List activityList = pageInfo.getList();
        List activityQueryList = activityList.stream().map(item -> {
            ActivityListQueryRespDto activityListQueryRespDto = new ActivityListQueryRespDto();
            BeanUtils.copyProperties((Object)item, (Object)activityListQueryRespDto);
            return activityListQueryRespDto;
        }).collect(Collectors.toList());
        activityPageInfo.setList(activityQueryList);
        Set shopIds = activityList.stream().map(ActivityRespDto::getShopId).collect(Collectors.toSet());
        if (CollUtil.isEmpty(shopIds)) {
            return activityPageInfo;
        }
        RestResponse shopListResponse = this.shopQueryApi.queryByIds(shopIds);
        if (Objects.isNull(shopListResponse) || CollUtil.isEmpty((Collection)((Collection)shopListResponse.getData()))) {
            return activityPageInfo;
        }
        Map shopMap = ((List)shopListResponse.getData()).stream().collect(Collectors.toMap(ShopDto::getId, Function.identity(), (o1, o2) -> o2));
        activityPageInfo.getList().forEach(item -> {
            if (Objects.nonNull(item.getShopId()) && shopMap.containsKey(item.getShopId())) {
                item.setShopName(((ShopDto)shopMap.get(item.getShopId())).getName());
            }
        });
        return activityPageInfo;
    }

    public void finish(Long id) {
        ActivityRespDto activityRespDto = this.checkActivity(id);
        if (ActivityStatusEnum.FINISH.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u6d3b\u52a8\u5df2\u7ed3\u675f\uff01");
        }
        if (ActivityStatusEnum.READY.getKey().equals(activityRespDto.getActivityStatus())) {
            RestResponseHelper.checkOrThrow((RestResponse)this.activityApi.finishActivityForReady(id.longValue()));
            return;
        }
        if (!ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u672a\u5f00\u59cb\u7684\u6d3b\u52a8\u4e0d\u80fd\u7ed3\u675f\uff01");
        }
        RestResponseHelper.checkOrThrow((RestResponse)this.activityApi.finishById(id.longValue()));
    }

    private ActivityRespDto checkActivity(Long activityId) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(activityId.longValue()).getData();
        if (activityRespDto == null) {
            throw new BizException("\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        return activityRespDto;
    }

    public void delete(Long id) {
        ActivityRespDto activityRespDto = this.checkActivity(id);
        if (!ActivityStatusEnum.NEW.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u53ef\u5220\u9664\uff01");
        }
        RestResponseHelper.checkOrThrow((RestResponse)this.activityApi.deleteById(id.longValue()));
    }

    public PageInfo<ActivityRespDto> queryActivityPage(ActivityDto queryDto, Integer pageNum, Integer pageSize) {
        queryDto.setAuditStatusEnum(AuditStatusEnum.AUDIT_PASS);
        queryDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
        return (PageInfo)this.activityQueryApi.queryActivityPage(queryDto, pageNum, pageSize).getData();
    }

    public ItemForActivityInfoRespDto queryActivityByItemId(Long itemId) {
        ItemForActivityInfoRespDto itemForActivityInfo = new ItemForActivityInfoRespDto();
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setPreheatStartTime(new Date());
        queryReqDto.setItemId(itemId);
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return itemForActivityInfo;
        }
        Map<Integer, List<ItemActivityInfoRespDto>> group = itemActivityTagDtos.stream().map(this::convertToItemActivityInfoRespDto).filter(activityInfo -> activityInfo.getId() != null && activityInfo.getDimension() != null).collect(Collectors.groupingBy(ItemActivityInfoRespDto::getDimension));
        for (Integer dimension : group.keySet()) {
            List<ItemActivityInfoRespDto> activityInfoRespDtos = group.get(dimension);
            if (ActivityDimensionEnum.COUPON.getKey().equals(dimension)) {
                List<ItemActivityInfoRespDto> couponActivityList = this.getCouponActivityInfoRespDtos(activityInfoRespDtos);
                itemForActivityInfo.setCouponActivityInfo(couponActivityList);
                continue;
            }
            if (ActivityDimensionEnum.ITEM.getKey().equals(dimension)) {
                itemForActivityInfo.setItemActivityInfo(activityInfoRespDtos);
                continue;
            }
            if (!ActivityDimensionEnum.ORDER.getKey().equals(dimension)) continue;
            itemForActivityInfo.setOrderActivityInfo(activityInfoRespDtos);
        }
        itemForActivityInfo.setSystemTime(System.currentTimeMillis());
        return itemForActivityInfo;
    }

    private List<ItemActivityInfoRespDto> getCouponActivityInfoRespDtos(List<ItemActivityInfoRespDto> activityInfoRespDtos) {
        List activityIds = activityInfoRespDtos.stream().map(BaseActivityTobDto::getId).collect(Collectors.toList());
        List templates = this.couponTemplate.queryByActivityIds(activityIds);
        Map<Long, CouponTemplateTobDto> templateMap = templates.stream().collect(Collectors.toMap(CouponTemplateTobDto::getActivityId, e -> e, (e1, e2) -> e1));
        ArrayList activityList = Lists.newArrayList();
        activityInfoRespDtos.forEach(activityInfoDto -> {
            if (templateMap.containsKey(activityInfoDto.getId())) {
                CouponTemplateTobDto couponTemplateTobDto = (CouponTemplateTobDto)templateMap.get(activityInfoDto.getId());
                couponTemplateTobDto.setTag(activityInfoDto.getTag());
                activityInfoDto.setCouponTemplate(couponTemplateTobDto);
                activityList.add(activityInfoDto);
            }
        });
        return activityList;
    }

    private ItemActivityInfoRespDto convertToItemActivityInfoRespDto(ItemActivityTagDto itemActivityTagDto) {
        ItemActivityInfoRespDto activityInfo = new ItemActivityInfoRespDto();
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(itemActivityTagDto.getActivityId().longValue()).getData();
            CubeBeanUtils.copyProperties((Object)activityInfo, (Object)activityRespDto, (String[])new String[0]);
            if (null == activityRespDto.getPreheatStartTime()) {
                activityInfo.setPreheatStartTime(activityRespDto.getBeginTime());
            }
            activityInfo.setDimension(activityRespDto.getActivityTemplate().getDimension());
            activityInfo.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activityInfo;
    }

    public void audit(Long id, ActivityAuditReqDto activityAuditReqDto) {
        activityAuditReqDto.setAuditPerson(this.context.userId());
        activityAuditReqDto.setTenantId(this.context.tenantId());
        activityAuditReqDto.setInstanceId(this.context.instanceId());
        activityAuditReqDto.setParentAuditPerson(activityAuditReqDto.getAuditPerson());
        this.activityApi.auditById(id.longValue(), activityAuditReqDto);
        if (AuditStatusEnum.AUDIT_PASS.getKey().equals(activityAuditReqDto.getAuditStatus())) {
            this.activityApi.enableById(id.longValue());
        }
    }

    public ActivityListRespDto queryActivity(PageEditActivityReqDto pageEditActivityReqDto) {
        ActivityListRespDto activityListRespDto = new ActivityListRespDto();
        ActivityQueryReqDto activityQueryReqDto = new ActivityQueryReqDto();
        activityQueryReqDto.setActivityType(pageEditActivityReqDto.getActivityType());
        Date today = DateUtil.getToday();
        Date tomorrow = DateUtil.addDays((Date)today, (int)1);
        Date tomorrowEnd = DateUtil.getDayEnd((Date)tomorrow);
        Date lastSevenDay = DateUtil.addDays((Date)today, (int)7);
        Date lastSevenDayEnd = DateUtil.getDayEnd((Date)lastSevenDay);
        if ("TODAY_ACTIVITY".equals(pageEditActivityReqDto.getPageEditActivityType())) {
            activityQueryReqDto.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        } else if ("TOMORROW_ACTIVITY".equals(pageEditActivityReqDto.getPageEditActivityType())) {
            activityQueryReqDto.setActivityStatus(ActivityStatusEnum.READY.getKey());
            activityQueryReqDto.setActivityTimeStart(tomorrow);
            activityQueryReqDto.setActivityTimeEnd(tomorrowEnd);
        } else if ("LAST_SEVEN_DAY_ACTIVITY".equals(pageEditActivityReqDto.getPageEditActivityType())) {
            activityQueryReqDto.setActivityStatus(ActivityStatusEnum.READY.getKey());
            activityQueryReqDto.setActivityTimeStart(tomorrow);
            activityQueryReqDto.setActivityTimeEnd(lastSevenDayEnd);
        }
        PageInfo<ActivityListRespDto> pageInfo = this.queryByPage(activityQueryReqDto, 1, 100);
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            List activityListRespDtos = pageInfo.getList();
            List activitySortList = activityListRespDtos.stream().sorted(Comparator.comparing(ActivityRespDto::getBeginTime)).collect(Collectors.toList());
            activityListRespDto = (ActivityListRespDto)activitySortList.get(0);
        }
        return activityListRespDto;
    }

    public List<ItemShelfQueryRespDto> queryAllItem(Long shopId, List<Long> brandIds, List<Long> dirIds, List<BlackItemSkuDto> blackItems) {
        return this.queryOnShelfItemList(shopId, brandIds, dirIds, null, blackItems);
    }

    public List<ApplicableActivityItemDto> queryAllItemByCondition(Long shopId, List<Long> brandIds, List<Long> dirIds, Integer selectType, ActivityType activityType) {
        if (selectType == 0) {
            brandIds = null;
            dirIds = null;
        }
        List<Object> itemShelfQueryRespDtos = this.queryOnShelfItemList(shopId, brandIds, dirIds, activityType, null);
        if (selectType == 0) {
            itemShelfQueryRespDtos = itemShelfQueryRespDtos.stream().filter(e -> Objects.equals(SubTypeEnum.PRODUCT.getType(), e.getSubType())).collect(Collectors.toList());
        }
        List<ApplicableActivityItemDto> applicableActivityItemDtos = this.createApplicableActivityItems(itemShelfQueryRespDtos);
        return applicableActivityItemDtos;
    }

    public List<ApplicableActivityItemDto> queryAllItemByCondition(Long shopId, List<Long> brandIds, List<Long> dirIds, Integer selectType, List<BlackItemSkuDto> blackItems) {
        if (selectType == 0) {
            brandIds = null;
            dirIds = null;
        }
        List<Object> itemShelfQueryRespDtos = this.queryOnShelfItemList(shopId, brandIds, dirIds, null, blackItems);
        if (selectType == 0) {
            itemShelfQueryRespDtos = itemShelfQueryRespDtos.stream().filter(e -> Objects.equals(SubTypeEnum.PRODUCT.getType(), e.getSubType())).collect(Collectors.toList());
        }
        List<ApplicableActivityItemDto> applicableActivityItemDtos = this.createApplicableActivityItems(itemShelfQueryRespDtos);
        return applicableActivityItemDtos;
    }

    private List<ApplicableActivityItemDto> createApplicableActivityItems(List<ItemShelfQueryRespDto> itemShelfQueryRespDtos) {
        ArrayList<ApplicableActivityItemDto> applicableActivityItemDtos = new ArrayList<ApplicableActivityItemDto>();
        if (CollectionUtils.isNotEmpty(itemShelfQueryRespDtos)) {
            for (ItemShelfQueryRespDto itemShelfRespDto : itemShelfQueryRespDtos) {
                List skuList = itemShelfRespDto.getSkuList();
                if (!CollectionUtils.isNotEmpty((Collection)skuList)) continue;
                for (ItemShelfSkuRespDto skuRespDto : skuList) {
                    ApplicableActivityItemDto itemDto = new ApplicableActivityItemDto();
                    itemDto.setItemId(itemShelfRespDto.getItemId());
                    itemDto.setItemName(itemShelfRespDto.getItemName());
                    itemDto.setShopId(itemShelfRespDto.getShopId());
                    itemDto.setSkuId(skuRespDto.getId());
                    itemDto.setSkuDesc(skuRespDto.getName());
                    itemDto.setSellPrice(skuRespDto.getPrice());
                    applicableActivityItemDtos.add(itemDto);
                }
            }
        }
        return applicableActivityItemDtos;
    }

    private List<ItemShelfQueryRespDto> queryOnShelfItemList(Long shopId, List<Long> brandIds, List<Long> dirIds, ActivityType activityType, List<BlackItemSkuDto> blackItems) {
        PageInfo pageInfo;
        if (CollectionUtils.isNotEmpty(dirIds)) {
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            directoryReqDto.setIds(dirIds);
            RestResponse response = this.directoryQueryApi.queryLinkAndChildDirIdListByDirId(directoryReqDto);
            dirIds = (List)RestResponseHelper.extractData((RestResponse)response);
        }
        ArrayList itemShelfQueryRespDtos = Lists.newArrayList();
        ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setItemStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        queryReqDto.setShopId(shopId);
        queryReqDto.setBrandIds(brandIds);
        queryReqDto.setDirIds(dirIds);
        if (!ActivityType.EXCHANGE_ACTIVITY.equals((Object)activityType)) {
            queryReqDto.setSubType(Integer.valueOf(1));
        }
        if (CollectionUtils.isNotEmpty(blackItems)) {
            List outSkuIds = blackItems.stream().map(BlackItemSkuDto::getSkuId).collect(Collectors.toList());
            queryReqDto.setOutSkuIds(outSkuIds);
        }
        int pageNum = 1;
        int pageSize = 1000;
        do {
            RestResponse response;
            if (PageInfoUtil.isNotEmpty(pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)(response = this.itemQueryApi.queryShelfItemByPage(queryReqDto, Integer.valueOf(pageNum), Integer.valueOf(pageSize)))))) {
                itemShelfQueryRespDtos.addAll(pageInfo.getList());
            }
            ++pageNum;
        } while (PageInfoUtil.isNotEmpty(pageInfo));
        return itemShelfQueryRespDtos;
    }

    private <T> Boolean isNotEmpty(PageInfo<T> pageInfo) {
        return null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }

    public Integer queryActivityStockType() {
        RestResponse response = this.itemActivityStockApi.queryActivityStockType(null);
        return (Integer)RestResponseHelper.extractData((RestResponse)response);
    }

    public Long getCurrentUserOrgId(Long userId) {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
    }

    public BigDecimal queryItemDealerRetailPrice(Long shopId, Long itemId, Long skuId) {
        ArrayList<ItemSkuPriceConditionQueryReqDto> shopConditionList = new ArrayList<ItemSkuPriceConditionQueryReqDto>();
        ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
        ItemSkuPriceConditionQueryReqDto skuPriceConditionReqDto = new ItemSkuPriceConditionQueryReqDto();
        skuPriceConditionReqDto.setSkuId(skuId);
        skuPriceConditionReqDto.setShopId(shopId);
        shopConditionList.add(skuPriceConditionReqDto);
        itemSkuPriceQueryReqDto.setShopConditionList(shopConditionList);
        RestResponse listRestResponse = this.basePriceItemQueryApi.querySkuPrice(itemSkuPriceQueryReqDto);
        List skuPriceQueryRespList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isNotEmpty((Collection)skuPriceQueryRespList)) {
            return ((ItemSkuPriceQueryRespDto)skuPriceQueryRespList.get(0)).getDealerRetailPrice();
        }
        return null;
    }

    public List<CustomerNotAuthItemResp> checkCustomerAuthItemStatus(ActivityAuthItemReqDto activityAuthItemReqDto) {
        if (CollectionUtils.isEmpty((Collection)activityAuthItemReqDto.getActivityCustomers()) || CollectionUtils.isEmpty((Collection)activityAuthItemReqDto.getActivityItems())) {
            logger.info("[\u5ba2\u6237\u6388\u6743\u5546\u54c1\u72b6\u6001]\uff0c\u6821\u9a8c\u53c2\u6570\u9519\u8bef");
            return Lists.newArrayList();
        }
        ArrayList skuIds = Lists.newArrayList();
        HashMap activityItemDtoMap = Maps.newHashMap();
        activityAuthItemReqDto.getActivityItems().stream().forEach(activityItem -> {
            skuIds.add(activityItem.getSkuId());
            activityItemDtoMap.put(activityItem.getSkuId() + "_" + activityItem.getWebActivityItemType(), activityItem);
        });
        List customerIds = activityAuthItemReqDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
        itemAuthReqDto.setTargetIdList(customerIds);
        itemAuthReqDto.setBusinessIdList((List)skuIds);
        itemAuthReqDto.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
        itemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.CUSTOMER.getCode());
        List itemAuthRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.queryByTargetIds(itemAuthReqDto));
        Map<Long, List<ItemAuthRespDto>> customerAuthItemGroup = itemAuthRespDtos.stream().collect(Collectors.groupingBy(ItemAuthRespDto::getTargetId));
        HashMap customerNotAuthItemMap = Maps.newHashMap();
        for (AuthActivityItemDto authActivityItemDto : activityAuthItemReqDto.getActivityItems()) {
            for (Long customerId : customerIds) {
                String key;
                AuthActivityItemDto applicableActivityItemDto;
                Long skuId = authActivityItemDto.getSkuId();
                List authSkuIds = customerAuthItemGroup.getOrDefault(customerId, Lists.newArrayList()).stream().map(ItemAuthRespDto::getBusinessId).collect(Collectors.toList());
                if (authSkuIds.contains(skuId) || (applicableActivityItemDto = (AuthActivityItemDto)activityItemDtoMap.get(key = skuId + "_" + authActivityItemDto.getWebActivityItemType())) == null) continue;
                List applicableActivityItemDtos1 = customerNotAuthItemMap.getOrDefault(customerId, new ArrayList());
                applicableActivityItemDtos1.add(applicableActivityItemDto);
                customerNotAuthItemMap.put(customerId, applicableActivityItemDtos1);
            }
        }
        ArrayList list = Lists.newArrayList();
        if (!customerNotAuthItemMap.isEmpty()) {
            Set customerIdSet = customerNotAuthItemMap.keySet();
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(new ArrayList(customerIdSet)));
            Map<Long, CustomerRespDto> customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, e -> e, (e1, e2) -> e1));
            for (Map.Entry entry : customerNotAuthItemMap.entrySet()) {
                Long customerId = (Long)entry.getKey();
                CustomerRespDto customerRespDto = customerRespDtoMap.get(customerId);
                for (AuthActivityItemDto applicableActivityItemDto : (List)entry.getValue()) {
                    CustomerNotAuthItemResp customerNotAuthItemResp = new CustomerNotAuthItemResp();
                    customerNotAuthItemResp.setItemCode(applicableActivityItemDto.getItemCode());
                    customerNotAuthItemResp.setItemName(applicableActivityItemDto.getItemName());
                    customerNotAuthItemResp.setSubType(applicableActivityItemDto.getSubType());
                    customerNotAuthItemResp.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)applicableActivityItemDto.getSubType()));
                    customerNotAuthItemResp.setCustomerId(customerId);
                    customerNotAuthItemResp.setWebActivityItemType(applicableActivityItemDto.getWebActivityItemType());
                    if (customerRespDto != null) {
                        customerNotAuthItemResp.setCustomerCode(customerRespDto.getCode());
                        customerNotAuthItemResp.setCustomerName(customerRespDto.getName());
                        customerNotAuthItemResp.setCustomerTypeId(customerRespDto.getCustomerTypeId());
                        customerNotAuthItemResp.setCustomerTypeName(customerRespDto.getCustomerTypeName());
                        customerNotAuthItemResp.setRegionCodeList(customerRespDto.getRegionCodeList());
                        customerNotAuthItemResp.setRegionNames(customerRespDto.getRegionNames());
                    }
                    list.add(customerNotAuthItemResp);
                }
            }
        }
        return list;
    }

    public static void main(String[] args) {
        List applicableActivityItemDtos = JSON.parseArray((String)"[\n    {\n      \n      \"skuId\": 1,\n      \"itemName\":\"\u5546\u54c1\u540d\u79f0\",\n      \"itemCode\": \"A001\",\n      \"webActivityItemType\": \"1\",\n      \"subType\": \"1\"\n    },{\n      \n      \"skuId\": 1,\n      \"itemName\":\"\u5546\u54c1\u540d\u79f02\",\n      \"itemCode\": \"A002\",\n      \"webActivityItemType\": \"2\",\n      \"subType\": \"2\"\n    }\n  ]", AuthActivityItemDto.class);
        HashMap activityItemDtoMap = Maps.newHashMap();
        ArrayList skuIds = Lists.newArrayList();
        applicableActivityItemDtos.stream().forEach(activityItem -> {
            skuIds.add(activityItem.getSkuId());
            activityItemDtoMap.put(activityItem.getSkuId() + "_" + activityItem.getWebActivityItemType(), activityItem);
        });
        List itemAuthRespDtos = JSON.parseArray((String)"[\n    {\n      \"businessId\": \"22\",\n      \"businessType\": \"SKU\",\n      \"createPerson\": \"\",\n      \"createTime\": \"2021-12-15 02:01:40\",\n      \"extFields\": {},\n      \"extension\": \"\",\n      \"id\": \"1294125686543668175\",\n      \"instanceId\": \"1254039287584232622\",\n      \"status\": 1,\n      \"targetId\": \"1294124580341089941\",\n      \"targetType\": 1,\n      \"tenantId\": 1,\n      \"updatePerson\": \"\",\n      \"updateTime\": \"2022-09-02 15:13:25\"\n    }\n  ]", ItemAuthRespDto.class);
        Map<Long, List<ItemAuthRespDto>> customerAuthItemGroup = itemAuthRespDtos.stream().collect(Collectors.groupingBy(ItemAuthRespDto::getTargetId));
        ArrayList customerIds = Lists.newArrayList((Object[])new Long[]{1294124580341089941L});
        HashMap customerNotAuthItemMap = Maps.newHashMap();
        for (AuthActivityItemDto authActivityItemDto : applicableActivityItemDtos) {
            Long skuId = authActivityItemDto.getSkuId();
            for (Long customerId : customerIds) {
                String key;
                AuthActivityItemDto applicableActivityItemDto;
                List authSkuIds = customerAuthItemGroup.getOrDefault(customerId, Lists.newArrayList()).stream().map(ItemAuthRespDto::getBusinessId).collect(Collectors.toList());
                if (authSkuIds.contains(skuId) || (applicableActivityItemDto = (AuthActivityItemDto)activityItemDtoMap.get(key = skuId + "_" + authActivityItemDto.getWebActivityItemType())) == null) continue;
                List applicableActivityItemDtos1 = customerNotAuthItemMap.getOrDefault(customerId, new ArrayList());
                applicableActivityItemDtos1.add(applicableActivityItemDto);
                customerNotAuthItemMap.put(customerId, applicableActivityItemDtos1);
            }
        }
        System.out.println(JSON.toJSONString((Object)customerNotAuthItemMap));
        ArrayList list = Lists.newArrayList();
        if (!customerNotAuthItemMap.isEmpty()) {
            HashMap customerRespDtoMap = Maps.newHashMap();
            for (Map.Entry entry : customerNotAuthItemMap.entrySet()) {
                Long customerId;
                customerId = (Long)entry.getKey();
                CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(customerId);
                for (AuthActivityItemDto applicableActivityItemDto : (List)entry.getValue()) {
                    CustomerNotAuthItemResp customerNotAuthItemResp = new CustomerNotAuthItemResp();
                    customerNotAuthItemResp.setItemCode(applicableActivityItemDto.getItemCode());
                    customerNotAuthItemResp.setItemName(applicableActivityItemDto.getItemName());
                    customerNotAuthItemResp.setSubType(applicableActivityItemDto.getSubType());
                    customerNotAuthItemResp.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)applicableActivityItemDto.getSubType()));
                    customerNotAuthItemResp.setCustomerId(customerId);
                    customerNotAuthItemResp.setWebActivityItemType(applicableActivityItemDto.getWebActivityItemType());
                    if (customerRespDto != null) {
                        customerNotAuthItemResp.setCustomerCode(customerRespDto.getCode());
                        customerNotAuthItemResp.setCustomerName(customerRespDto.getName());
                        customerNotAuthItemResp.setCustomerTypeId(customerRespDto.getCustomerTypeId());
                        customerNotAuthItemResp.setCustomerTypeName(customerRespDto.getCustomerTypeName());
                        customerNotAuthItemResp.setRegionCodeList(customerRespDto.getRegionCodeList());
                    }
                    list.add(customerNotAuthItemResp);
                }
            }
        }
        System.out.println(JSON.toJSONString((Object)list));
    }
}

