/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.IExchangeBalanceAccountApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceStatementReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ManualAdjustReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceStatementRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeStatementChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.query.IExchangeBalanceStatementQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.IExchangeActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.CustomerSingleItemPageReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.GExchange;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CustomerSingleItemRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ExchangeListQueryRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.SupportSingleItemConflictRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.condition.exchange.ExchangeItemsCondition;
import com.dtyunxi.yundt.module.marketing.biz.enums.QueryActivityStatusEnum;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExchangeActivityImpl
extends AbstractActivityService
implements IExchangeActivity {
    private static Logger logger = LoggerFactory.getLogger(ExchangeActivityImpl.class);
    @Autowired
    private IContext context;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private IConditionQueryApi conditionQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private IActivityExtApi activityExtApi;
    @Autowired
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Autowired
    private IActivityExtQueryApi activityExtQueryApi;
    @Autowired
    private IItemActivityStockApi itemActivityStockApi;
    @Autowired
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Autowired
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IExchangeBalanceAccountApi exchangeBalanceAccountApi;
    @Autowired
    private IExchangeBalanceStatementQueryApi exchangeBalanceStatementQueryApi;

    public Long add(ExchangeActivityDto activityReqDto) {
        if (!ActivityType.EXCHANGE_ACTIVITY.equals((Object)activityReqDto.getActivityType())) {
            throw new BizException("\u6d3b\u52a8\u7c7b\u578b\u975e\u6362\u8d2d!");
        }
        this.updateTag(activityReqDto);
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("HG"));
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            List activityItems = this.activityService.queryAllItemByCondition(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getSelectType(), activityReqDto.getActivityType());
            activityReqDto.setActivityItems(activityItems);
        }
        Long activityId = this.addActivity(activityReqDto);
        RestResponseHelper.extractData((RestResponse)this.activityExtApi.saveSingleItemByActivity(activityId));
        return activityId;
    }

    public List<SupportSingleItemConflictRespDto> checkSupportSingleItemConflict(ExchangeActivityDto activityReqDto) {
        return Lists.newArrayList();
    }

    public PageInfo<CustomerSingleItemRespDto> queryCustomerSingleItemPage(CustomerSingleItemPageReqDto customerSingleItemPageReqDto) {
        if (customerSingleItemPageReqDto.getCustomerId() == null) {
            return new PageInfo();
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(customerSingleItemPageReqDto.getCustomerId()));
        if (customerRespDto == null) {
            logger.info("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)customerSingleItemPageReqDto.getCustomerId());
            return new PageInfo();
        }
        SupportSingleItemDto supportSingleItemDto = new SupportSingleItemDto();
        supportSingleItemDto.setItemName(customerSingleItemPageReqDto.getItemName());
        supportSingleItemDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.NEW.getKey(), ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
        supportSingleItemDto.setCustomerRespDtos((List)Lists.newArrayList((Object[])new CustomerRespDto[]{customerRespDto}));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryCustomerSingleItemPage(supportSingleItemDto));
        PageInfo resultPageInfo = new PageInfo();
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            BeanUtils.copyProperties((Object)pageInfo, (Object)resultPageInfo, (String[])new String[]{"list"});
            HashSet skuIds = Sets.newHashSet();
            HashSet itemIds = Sets.newHashSet();
            HashSet activityIds = Sets.newHashSet();
            ArrayList customerSingleItemRespDtos = Lists.newArrayList();
            for (NotSupportSingleItemDto singleItemDto : pageInfo.getList()) {
                skuIds.add(singleItemDto.getSkuId());
                itemIds.add(singleItemDto.getItemId());
                activityIds.add(singleItemDto.getActivityId());
                CustomerSingleItemRespDto customerSingleItemRespDto = new CustomerSingleItemRespDto();
                BeanUtils.copyProperties((Object)singleItemDto, (Object)customerSingleItemRespDto);
                customerSingleItemRespDto.setCustomerId(customerRespDto.getId());
                customerSingleItemRespDto.setCustomerCode(customerRespDto.getCode());
                customerSingleItemRespDto.setCustomerName(customerRespDto.getName());
                customerSingleItemRespDtos.add(customerSingleItemRespDto);
            }
            Map<Object, Object> activityRespDtoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)activityIds)) {
                List activityRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds(new ArrayList(activityIds)));
                activityRespDtoMap = activityRespDtos.stream().collect(Collectors.toMap(ActivityRespDto::getId, e -> e, (e1, e2) -> e1));
            }
            Map<Object, Object> itemRespDtoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemIds)) {
                ItemReqDto itemReqDto = new ItemReqDto();
                itemReqDto.setItemIds(new ArrayList(itemIds));
                itemReqDto.setBizType(Integer.valueOf(2));
                PageInfo itemPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByPage(JSON.toJSONString((Object)itemReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
                if (itemPageInfo != null && CollectionUtils.isNotEmpty((Collection)itemPageInfo.getList())) {
                    itemRespDtoMap = itemPageInfo.getList().stream().collect(Collectors.toMap(ItemRespDto::getId, e -> e, (e1, e2) -> e1));
                }
            }
            Map<Object, Object> skuRespDtoHashMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)skuIds)) {
                List itemSkuExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuExtBySkuId(new ArrayList(skuIds)));
                skuRespDtoHashMap = Optional.ofNullable(itemSkuExtRespDtos).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
            }
            for (CustomerSingleItemRespDto conflictRespDto : customerSingleItemRespDtos) {
                ActivityRespDto activityRespDto;
                ItemSkuExtRespDto itemSkuRespDto;
                ItemRespDto itemRespDto = (ItemRespDto)itemRespDtoMap.get(conflictRespDto.getItemId());
                if (itemRespDto != null) {
                    conflictRespDto.setItemCode(itemRespDto.getCode());
                    conflictRespDto.setItemName(itemRespDto.getName());
                    if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemMediasList())) {
                        conflictRespDto.setImgPath(((ItemMediasRespDto)itemRespDto.getItemMediasList().get(0)).getPath1());
                    }
                    conflictRespDto.setSubType(itemRespDto.getSubType());
                    conflictRespDto.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemRespDto.getSubType()));
                    conflictRespDto.setDirIds(itemRespDto.getDirIdList());
                    conflictRespDto.setDirNames(itemRespDto.getDirNameList());
                }
                if ((itemSkuRespDto = (ItemSkuExtRespDto)skuRespDtoHashMap.get(conflictRespDto.getSkuId())) != null) {
                    conflictRespDto.setSkuDesc(itemSkuRespDto.getAttr());
                }
                if ((activityRespDto = (ActivityRespDto)activityRespDtoMap.get(conflictRespDto.getActivityId())) == null) continue;
                conflictRespDto.setActivityCode(activityRespDto.getActivityCode());
                conflictRespDto.setActivityName(activityRespDto.getActivityName());
                conflictRespDto.setActivityStatus(activityRespDto.getActivityStatus());
                conflictRespDto.setActivityStatusName(QueryActivityStatusEnum.getDesc(activityRespDto.getActivityStatus(), activityRespDto.getAuditStatus()));
                conflictRespDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
                conflictRespDto.setActivityTypeName("\u6362\u8d2d\u6d3b\u52a8");
            }
            resultPageInfo.setList((List)customerSingleItemRespDtos);
        }
        return resultPageInfo;
    }

    public void modify(ExchangeActivityDto activityReqDto) {
        Assert.notNull((Object)activityReqDto.getId(), (String)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)activityReqDto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.updateTag(activityReqDto);
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            List activityItems = this.activityService.queryAllItemByCondition(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getSelectType(), activityReqDto.getActivityType());
            activityReqDto.setActivityItems(activityItems);
        }
        this.addActivity(activityReqDto);
    }

    public ExchangeActivityDto getDetail(Long id) {
        List activityResp;
        RestResponse shopBaseDtoRestResponse;
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
        CubeBeanUtils.copyProperties((Object)exchangeActivityDto, (Object)activityRespDto, (String[])new String[0]);
        Long shopId = exchangeActivityDto.getShopId();
        if (Objects.nonNull(shopId) && Objects.nonNull(shopBaseDtoRestResponse = this.shopQueryApi.queryBaseById(shopId)) && Objects.nonNull(shopBaseDtoRestResponse.getData())) {
            exchangeActivityDto.setShopName(((ShopBaseDto)shopBaseDtoRestResponse.getData()).getName());
        }
        exchangeActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(exchangeActivityDto.getActivityType());
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), exchangeActivityDto));
        if (AuditStatusEnum.AUDIT_REFUSE.getKey().equals(activityRespDto.getAuditStatus()) && CollectionUtils.isNotEmpty((Collection)(activityResp = (List)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.queryAuditData(id.longValue()))))) {
            exchangeActivityDto.setActivityAudit((ActivityRespDto)activityResp.stream().findFirst().get());
        }
        this.assembleCustomerInfo(exchangeActivityDto, activityRespDto);
        return exchangeActivityDto;
    }

    private void assembleCustomerInfo(ExchangeActivityDto exchangeActivityDto, ActivityRespDto activityRespDto) {
        if (CollectionUtils.isNotEmpty((Collection)activityRespDto.getUserIds())) {
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setIdList(new ArrayList(activityRespDto.getUserIds()));
            PageInfo customers = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            if (null != customers && CollectionUtils.isNotEmpty((Collection)customers.getList())) {
                List activityCustomerDtos = customers.getList().stream().map(bean -> {
                    ActivityCustomerDto activityCustomerDto = new ActivityCustomerDto();
                    activityCustomerDto.setCustomerId(bean.getId());
                    activityCustomerDto.setCustomerCode(bean.getCode());
                    activityCustomerDto.setCustomerName(bean.getName());
                    activityCustomerDto.setRegion(bean.getRegion());
                    activityCustomerDto.setType(bean.getType());
                    activityCustomerDto.setCustomerTypeName(bean.getCustomerTypeName());
                    activityCustomerDto.setRegionNames(bean.getRegionNames());
                    activityCustomerDto.setStatusName(bean.getStatusName());
                    return activityCustomerDto;
                }).collect(Collectors.toList());
                exchangeActivityDto.setActivityCustomers(activityCustomerDtos);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activityRespDto.getCustomerTypeIds())) {
            exchangeActivityDto.setCustomerTypeIds((List)JSON.parseObject((String)activityRespDto.getCustomerTypeIds(), (TypeReference)new TypeReference<ArrayList<Long>>(){}, (Feature[])new Feature[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)activityRespDto.getCustomerAreaCodes())) {
            exchangeActivityDto.setCustomerAreaCodes((List)JSON.parseObject((String)activityRespDto.getCustomerAreaCodes(), (TypeReference)new TypeReference<ArrayList<String>>(){}, (Feature[])new Feature[0]));
        }
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        ExchangeActivityDto activityDto = (ExchangeActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (activityDto.getSelectType() == 1) {
            activityDto.getActivityItems().stream().forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setActivityStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setSkuDesc(itemDto.getSkuDesc());
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                if (CollectionUtils.isNotEmpty((Collection)itemDto.getSkus())) {
                    activityItemReqDto.setSkuId(((PromotionActivitySkuDto)itemDto.getSkus().get(0)).getSkuId());
                }
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        ExchangeActivityDto activityDto = (ExchangeActivityDto)activityReqDto;
        if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityCustomers())) {
            List<Long> customerIds = activityDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            return customerIds;
        }
        return null;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getCustomerTypes(T activityReqDto) {
        ExchangeActivityDto activityDto = (ExchangeActivityDto)activityReqDto;
        return activityDto.getCustomerTypeIds();
    }

    @Override
    protected <T extends BaseActivityTobDto> List<String> getCustomerAreaCodes(T activityReqDto) {
        ExchangeActivityDto activityDto = (ExchangeActivityDto)activityReqDto;
        return activityDto.getCustomerAreaCodes();
    }

    public PageInfo<ExchangeListQueryRespDto> queryActivityByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo activityPageInfo = new PageInfo(ListUtil.empty());
        PageInfo pageInfo = this.activityService.queryByPage(activityQueryReqDto, pageNum, pageSize);
        if (Objects.isNull(pageInfo) || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return activityPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)activityPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List activityList = pageInfo.getList();
        List activityQueryList = activityList.stream().map(item -> {
            ExchangeListQueryRespDto activityListQueryRespDto = new ExchangeListQueryRespDto();
            BeanUtils.copyProperties((Object)item, (Object)activityListQueryRespDto);
            return activityListQueryRespDto;
        }).collect(Collectors.toList());
        activityPageInfo.setList(activityQueryList);
        Set shopIds = activityList.stream().map(ActivityRespDto::getShopId).collect(Collectors.toSet());
        if (CollUtil.isEmpty(shopIds)) {
            return activityPageInfo;
        }
        RestResponse shopListResponse = this.shopQueryApi.queryByIds(shopIds);
        if (Objects.isNull(shopListResponse) || CollUtil.isEmpty((Collection)((Collection)shopListResponse.getData()))) {
            return activityPageInfo;
        }
        Map shopMap = ((List)shopListResponse.getData()).stream().collect(Collectors.toMap(ShopDto::getId, Function.identity(), (o1, o2) -> o2));
        List activityIds = activityPageInfo.getList().stream().map(ActivityRespDto::getId).distinct().collect(Collectors.toList());
        List conditionRespDtoList = this.conditionQueryApi.queryConditions(activityIds, 1196944771412880296L);
        Map<Long, List<ConditionRespDto>> activityMap = conditionRespDtoList.stream().collect(Collectors.groupingBy(ConditionRespDto::getActivityId));
        activityPageInfo.getList().forEach(item -> {
            List conditionList;
            if (Objects.nonNull(item.getShopId()) && shopMap.containsKey(item.getShopId())) {
                item.setShopName(((ShopDto)shopMap.get(item.getShopId())).getName());
            }
            if (CollectionUtils.isNotEmpty((Collection)(conditionList = (List)activityMap.get(item.getId())))) {
                ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
                this.parse((ConditionRespDto)conditionList.get(0), exchangeActivityDto);
                item.setExchangeActivityDtos(exchangeActivityDto);
            }
        });
        return activityPageInfo;
    }

    public RestResponse<Void> manualAdjust(ManualAdjustReqDto manualAdjustReqDto) {
        return this.exchangeBalanceAccountApi.manualAdjust(manualAdjustReqDto);
    }

    public RestResponse<PageInfo<ExchangeBalanceStatementRespDto>> queryStatementByPage(ExchangeBalanceStatementReqDto exchangeBalanceStatementReqDto) {
        exchangeBalanceStatementReqDto.setNeedDiscountUnit(true);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.exchangeBalanceStatementQueryApi.queryByPage(exchangeBalanceStatementReqDto));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (ExchangeBalanceStatementRespDto statementRespDto : pageInfo.getList()) {
                statementRespDto.setChangeTypeName(ExchangeStatementChangeTypeEnum.getDescByType((Integer)statementRespDto.getChangeType()));
            }
        }
        return new RestResponse((Object)pageInfo);
    }

    public <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        exchangeActivityDto.setPromotionMethod(exchangeRule.getPromotionMethod());
        exchangeActivityDto.setPromotionCondition(exchangeRule.getPromotionCondition());
        exchangeActivityDto.setThresholdType(exchangeRule.getThresholdType());
        exchangeActivityDto.setPromotionType(exchangeRule.getPromotionType());
        ArrayList exchangeRuleContents = new ArrayList();
        exchangeRule.getExcRuleContents().stream().forEach(contents -> {
            ExchangeRuleContent exchangeRuleContent = new ExchangeRuleContent();
            CubeBeanUtils.copyProperties((Object)exchangeRuleContent, (Object)contents, (String[])new String[0]);
            List exchangeItems = BeanCopierUtils.copyList((List)contents.getExchangeItems(), GExchange.class);
            exchangeRuleContent.setExchangeItems(exchangeItems);
            exchangeRuleContents.add(exchangeRuleContent);
        });
        exchangeActivityDto.setPromotionContents(exchangeRuleContents);
    }

    private void validate(ExchangeActivityDto activityReqDto) {
        List<Object> itemIds = Lists.newArrayList();
        ArrayList activityItemIds = Lists.newArrayList();
        if (activityReqDto.getSelectType() == 1) {
            itemIds = activityReqDto.getActivityItems().stream().map(PromotionActivityItemDto::getItemId).collect(Collectors.toList());
        } else if (activityReqDto.getSelectType() == 2) {
            ItemShelfQueryReqDto dto1 = new ItemShelfQueryReqDto();
            dto1.setBrandIds(activityReqDto.getBrandIds());
            dto1.setInstanceId(this.context.instanceId());
            dto1.setTenantId(this.context.tenantId());
            PageInfo brandItemPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryShelfItemByPage(dto1, Integer.valueOf(1), Integer.valueOf(1000)));
            if (CollectionUtils.isNotEmpty((Collection)brandItemPageInfo.getList())) {
                itemIds.addAll(brandItemPageInfo.getList().stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList()));
            }
            ItemShelfQueryReqDto dto2 = new ItemShelfQueryReqDto();
            dto2.setDirIds(activityReqDto.getDirIds());
            dto2.setInstanceId(this.context.instanceId());
            dto2.setTenantId(this.context.tenantId());
            PageInfo dirItemPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryShelfItemByPage(dto2, Integer.valueOf(1), Integer.valueOf(1000)));
            if (CollectionUtils.isNotEmpty((Collection)dirItemPageInfo.getList())) {
                itemIds.addAll(dirItemPageInfo.getList().stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList()));
            }
        }
        ActivityQueryReqDto activityQueryReqDto = new ActivityQueryReqDto();
        activityQueryReqDto.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        activityQueryReqDto.setActivityType(ActivityType.EXCHANGE_ACTIVITY);
        PageInfo pageInfo = this.activityService.queryByPage(activityQueryReqDto, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && activityReqDto.getSelectType() == 0) {
            throw new BizException("\u540c\u4e00\u4e2a\u65f6\u95f4\u6bb5\u5185\u540c\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u53c2\u52a0\u4e00\u4e2a\u6362\u8d2d\u6d3b\u52a8");
        }
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List list = pageInfo.getList();
            list.forEach(e -> {
                if (!(activityReqDto.getBeginTime().compareTo(e.getBeginTime()) == -1 && activityReqDto.getEndTime().compareTo(e.getBeginTime()) == -1 || activityReqDto.getBeginTime().compareTo(e.getEndTime()) == 1 && activityReqDto.getEndTime().compareTo(e.getEndTime()) == 1)) {
                    if (e.getSelectType() == 0) {
                        throw new BizException("\u540c\u4e00\u4e2a\u65f6\u95f4\u6bb5\u5185\u540c\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u53c2\u52a0\u4e00\u4e2a\u6362\u8d2d\u6d3b\u52a8");
                    }
                    ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
                    new ExchangeItemsCondition().parseCondition(e.getConditionDtos(), exchangeActivityDto);
                    if (e.getSelectType() == 1) {
                        activityItemIds.addAll(exchangeActivityDto.getActivityItems().stream().map(PromotionActivityItemDto::getItemId).collect(Collectors.toList()));
                    } else if (e.getSelectType() == 2) {
                        ItemShelfQueryReqDto dto1 = new ItemShelfQueryReqDto();
                        dto1.setBrandIds(exchangeActivityDto.getBrandIds());
                        dto1.setInstanceId(this.context.instanceId());
                        dto1.setTenantId(this.context.tenantId());
                        PageInfo brandItemPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryShelfItemByPage(dto1, Integer.valueOf(1), Integer.valueOf(1000)));
                        ItemShelfQueryReqDto dto2 = new ItemShelfQueryReqDto();
                        dto2.setDirIds(exchangeActivityDto.getDirIds());
                        dto2.setInstanceId(this.context.instanceId());
                        dto2.setTenantId(this.context.tenantId());
                        PageInfo dirItemPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryShelfItemByPage(dto2, Integer.valueOf(1), Integer.valueOf(1000)));
                        if (CollectionUtils.isNotEmpty((Collection)brandItemPageInfo.getList())) {
                            activityItemIds.addAll(brandItemPageInfo.getList().stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList()));
                        }
                        if (CollectionUtils.isNotEmpty((Collection)dirItemPageInfo.getList())) {
                            activityItemIds.addAll(dirItemPageInfo.getList().stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList()));
                        }
                    }
                }
            });
        }
        logger.info("\u68c0\u9a8c\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)itemIds);
        logger.info("\u68c0\u9a8c\u6240\u6709\u6d3b\u52a8\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)activityItemIds);
        for (Long activityItemId : activityItemIds) {
            for (Long l : itemIds) {
                if (!activityItemId.equals(l)) continue;
                throw new BizException("\u540c\u4e00\u4e2a\u65f6\u95f4\u6bb5\u5185\u540c\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u53c2\u52a0\u4e00\u4e2a\u6362\u8d2d\u6d3b\u52a8");
            }
        }
    }

    public void updateTag(ExchangeActivityDto activityReqDto) {
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u6807\u7b7e\u66ff\u6362:{},{}", (Object)activityReqDto.getTagType(), (Object)activityReqDto.getTag());
        if (activityReqDto.getTagType() == 0) {
            Integer promotionCondition = activityReqDto.getPromotionCondition();
            if (CollectionUtils.isNotEmpty((Collection)activityReqDto.getPromotionContents())) {
                BigDecimal threshold = ((ExchangeRuleContent)activityReqDto.getPromotionContents().get(0)).getThreshold();
                if (promotionCondition == 1 || promotionCondition == 3) {
                    activityReqDto.setTag("\u6ee1" + threshold + "\u6362\u8d2d");
                } else {
                    activityReqDto.setTag("\u6bcf" + threshold + "\u6362\u8d2d");
                }
            }
        }
    }

    private static /* synthetic */ ActivityRespDto lambda$checkSupportSingleItemConflict$1(ActivityRespDto e1, ActivityRespDto e2) {
        return e1;
    }

    private static /* synthetic */ ActivityRespDto lambda$checkSupportSingleItemConflict$0(ActivityRespDto e) {
        return e;
    }
}

