/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.fullreduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecActItem;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.BlackItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.module.marketing.api.enums.SelectTypeEnum;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullDecItemsCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(FullDecItemsCondition.class);

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880283L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.FULL_REDUCTION_ACTIVITY.equals((Object)type) || ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)type) || ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        List blackActivityItemDtos;
        List promotionActivityItemDtos;
        ConditionReqDto condition = this.getConditionReqDto();
        HashMap conditionParam = Maps.newHashMap();
        if (ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_PRESENT_TOB_ACTIVITY.equals((Object)t.getActivityType())) {
            ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
            promotionActivityItemDtos = returnGiftActivityDto.getActivityItems();
            blackActivityItemDtos = returnGiftActivityDto.getBlackItems();
            conditionParam.put("ItemFullDecCondition.type", returnGiftActivityDto.getSelectType());
        } else {
            FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
            promotionActivityItemDtos = fullReductionActivityDto.getActivityItems();
            blackActivityItemDtos = fullReductionActivityDto.getBlackItems();
            conditionParam.put("ItemFullDecCondition.type", fullReductionActivityDto.getSelectType());
        }
        List fullDecActItems = promotionActivityItemDtos.stream().map(itemDto -> {
            FullDecActItem fullDecActItem = new FullDecActItem();
            fullDecActItem.setItemId(itemDto.getItemId());
            fullDecActItem.setItemCode(itemDto.getItemCode());
            fullDecActItem.setItemName(itemDto.getItemName());
            fullDecActItem.setPrice(itemDto.getSellPrice());
            fullDecActItem.setShopId(itemDto.getShopId());
            fullDecActItem.setSkuId(itemDto.getSkuId());
            return fullDecActItem;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)blackActivityItemDtos)) {
            List blackItems = blackActivityItemDtos.stream().map(itemDto -> {
                ItemSkuDto itemSkuDto = new ItemSkuDto();
                itemSkuDto.setItemId(itemDto.getItemId());
                itemSkuDto.setShopId(itemDto.getShopId());
                itemSkuDto.setSkuId(itemDto.getSkuId());
                return itemSkuDto;
            }).collect(Collectors.toList());
            conditionParam.put("ItemFullDecCondition.blackItems", blackItems);
        }
        conditionParam.put("ItemFullDecCondition.items", fullDecActItems);
        conditionParam.put("ItemFullDecCondition.sellerIds", Lists.newArrayList());
        conditionParam.put("ItemFullDecCondition.brandIds", t.getBrandIds());
        conditionParam.put("ItemFullDecCondition.dirIds", t.getDirIds());
        logger.info("\u6ee1\u51cf\u6ee1\u6298\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        Integer selectType = jsonObject.getInteger("ItemFullDecCondition.type");
        IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
        if (SelectTypeEnum.ALL.getCode().equals(selectType) || SelectTypeEnum.CATEGORY.getCode().equals(selectType)) {
            List brandIds = JSON.parseArray((String)jsonObject.getString("ItemFullDecCondition.brandIds"), Long.class);
            List dirIds = JSON.parseArray((String)jsonObject.getString("ItemFullDecCondition.dirIds"), Long.class);
            List blackItems = JSON.parseArray((String)jsonObject.getString("ItemFullDecCondition.blackItems"), ItemSkuDto.class);
            ArrayList<BlackItemSkuDto> blackActivityItems = new ArrayList<BlackItemSkuDto>();
            if (CollectionUtils.isNotEmpty((Collection)blackItems)) {
                for (ItemSkuDto blackItem : blackItems) {
                    ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(blackItem.getShopId(), blackItem.getItemId(), ItemBusTypeEnum.ORDINARY.getType());
                    BlackItemSkuDto blackItemSkuDto = new BlackItemSkuDto();
                    blackItemSkuDto.setItemId(blackItem.getItemId());
                    blackItemSkuDto.setItemCode(itemDetail.getItemCode());
                    blackItemSkuDto.setItemName(itemDetail.getItemName());
                    blackItemSkuDto.setShopId(blackItem.getShopId());
                    blackItemSkuDto.setSkuId(blackItem.getSkuId());
                    itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(blackItem.getSkuId())).findFirst().ifPresent(itemSku -> {
                        if (null != itemSku.getAttrMap()) {
                            String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                            blackItemSkuDto.setSkuDesc(skuName);
                            blackItemSkuDto.setAttr(skuName);
                        }
                    });
                    blackActivityItems.add(blackItemSkuDto);
                }
            }
            if (ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_PRESENT_TOB_ACTIVITY.equals((Object)t.getActivityType())) {
                ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
                returnGiftActivityDto.setBrandIds(brandIds);
                returnGiftActivityDto.setDirIds(dirIds);
                returnGiftActivityDto.setBlackItems(blackActivityItems);
            } else {
                FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
                fullReductionActivityDto.setBrandIds(brandIds);
                fullReductionActivityDto.setDirIds(dirIds);
                fullReductionActivityDto.setDirIds(dirIds);
                fullReductionActivityDto.setBlackItems(blackActivityItems);
            }
            return;
        }
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean(IActivityItemQueryApi.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(conditionRespDto.getActivityId());
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<String, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activityItem -> activityItem.getShopId() + activityItem.getItemId().toString() + activityItem.getSkuId()));
        ArrayList groupActivityItemDtos = Lists.newArrayList();
        group.forEach((shopItemKey, itemDtos) -> {
            Long itemId = ((ActivityItemRespDto)itemDtos.get(0)).getItemId();
            Long shopId = ((ActivityItemRespDto)itemDtos.get(0)).getShopId();
            ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(shopId, itemId, ItemBusTypeEnum.ORDINARY.getType());
            if (null == itemDetail) {
                return;
            }
            ApplicableActivityItemDto applicableActivityItemDto = new ApplicableActivityItemDto();
            applicableActivityItemDto.setItemId(itemId);
            applicableActivityItemDto.setItemCode(itemDetail.getItemCode());
            applicableActivityItemDto.setItemName(itemDetail.getItemName());
            applicableActivityItemDto.setShopId(shopId);
            applicableActivityItemDto.setSkuId(((ActivityItemRespDto)itemDtos.get(0)).getSkuId());
            applicableActivityItemDto.setSubType(itemDetail.getSubType());
            if (null != shopId) {
                ShopBaseDto shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(shopId).getData();
                applicableActivityItemDto.setShopName(shopDto == null ? null : shopDto.getName());
            }
            Long totalStock = 0L;
            ArrayList skus = Lists.newArrayList();
            BigDecimal minPrice = BigDecimal.ZERO;
            for (ActivityItemRespDto skuDto : itemDtos) {
                PromotionActivitySkuDto sku = new PromotionActivitySkuDto();
                sku.setActivityStock(skuDto.getOriginalStock());
                applicableActivityItemDto.setActivityStock(skuDto.getOriginalStock());
                applicableActivityItemDto.setRemainingStock(skuDto.getActivityStock());
                sku.setPromotionPrice(skuDto.getActivityPrice());
                sku.setItemId(skuDto.getItemId());
                sku.setSkuId(skuDto.getSkuId());
                itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(skuDto.getSkuId())).findFirst().ifPresent(itemSku -> {
                    if (null != itemSku.getAttrMap()) {
                        String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                        sku.setSkuName(skuName);
                        applicableActivityItemDto.setSkuDesc(skuName);
                        applicableActivityItemDto.setAttr(skuName);
                    }
                });
                BigDecimal price = itemService.queryItemPrice(shopId, skuDto.getItemId(), skuDto.getSkuId());
                if (null != price && price.compareTo(minPrice) == -1) {
                    minPrice = price;
                }
                sku.setSellPrice(price);
                Long stock = itemService.queryVirStorage(shopId, null, skuDto.getSkuId());
                sku.setStock(stock);
                totalStock = totalStock + stock;
                skus.add(sku);
            }
            applicableActivityItemDto.setSkus((List)skus);
            applicableActivityItemDto.setTotalStock(totalStock);
            applicableActivityItemDto.setSellPrice(minPrice);
            groupActivityItemDtos.add(applicableActivityItemDto);
            if (ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_PRESENT_TOB_ACTIVITY.equals((Object)t.getActivityType())) {
                ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
                returnGiftActivityDto.setActivityItems(groupActivityItemDtos);
            } else {
                FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
                fullReductionActivityDto.setActivityItems(groupActivityItemDtos);
            }
        });
    }
}

