/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.fullreduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecContent;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecRule;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.FullDecRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.module.marketing.biz.enums.DiscountRule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullReduceCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(FullReduceCondition.class);

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        FullDecRule fullDecRule = (FullDecRule)JSON.parseObject((String)jsonObject.getString("FullReduceCondition.rule"), FullDecRule.class);
        fullReductionActivityDto.setPromotionMethod(fullDecRule.getPromotionMethod());
        fullReductionActivityDto.setPromotionCondition(fullDecRule.getPromotionCondition());
        fullReductionActivityDto.setPromotionType(fullDecRule.getPromotionType());
        List fullDecRuleContents = BeanCopierUtils.copyList((List)fullDecRule.getPromotionContents(), FullDecRuleContent.class);
        fullReductionActivityDto.setPromotionContents(fullDecRuleContents);
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880284L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.FULL_REDUCTION_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
        ConditionReqDto condition = this.getConditionReqDto();
        if (CollectionUtils.isEmpty((Collection)fullReductionActivityDto.getPromotionContents())) {
            throw new BizException("\u4fc3\u9500\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!DiscountRule.STAIR.getType().equals(fullReductionActivityDto.getPromotionCondition())) {
            if (fullReductionActivityDto.getPromotionContents().size() > 1) {
                throw new BizException("\u5f53\u524d\u4fc3\u9500\u6761\u4ef6\u53ea\u5141\u8bb8\u586b\u5199\u4e00\u6761\u89c4\u5219");
            }
        } else if (fullReductionActivityDto.getPromotionContents().size() > 5) {
            throw new BizException("\u5f53\u524d\u4fc3\u9500\u6761\u4ef6\u6700\u591a\u4e0d\u8d85\u8fc75\u6761\u89c4\u5219");
        }
        FullDecRule rule = new FullDecRule();
        rule.setPromotionCondition(fullReductionActivityDto.getPromotionCondition());
        rule.setPromotionMethod(fullReductionActivityDto.getPromotionMethod());
        rule.setPromotionType(fullReductionActivityDto.getPromotionType());
        ArrayList decContentList = Lists.newArrayList();
        fullReductionActivityDto.getPromotionContents().forEach(fullDecRule -> {
            FullDecContent decContent = new FullDecContent();
            decContent.setPostage(fullDecRule.getPostage());
            decContent.setThreshold(fullDecRule.getThreshold());
            decContent.setUnit(fullDecRule.getUnit());
            decContent.setDiscount(fullDecRule.getDiscount());
            decContent.setLogic(fullDecRule.getLogic());
            decContentList.add(decContent);
        });
        rule.setPromotionContents((List)decContentList);
        HashMap conditionParam = Maps.newHashMap();
        conditionParam.put("FullReduceCondition.rule", rule);
        logger.info("\u9650\u65f6\u6298\u6263\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }
}

