/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.exchange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.GExchange;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.module.marketing.biz.enums.DiscountRule;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(ExchangeCondition.class);

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        exchangeActivityDto.setPromotionMethod(exchangeRule.getPromotionMethod());
        exchangeActivityDto.setPromotionCondition(exchangeRule.getPromotionCondition());
        exchangeActivityDto.setThresholdType(exchangeRule.getThresholdType());
        exchangeActivityDto.setPromotionType(exchangeRule.getPromotionType());
        ArrayList exchangeRuleContents = new ArrayList();
        exchangeRule.getExcRuleContents().stream().forEach(contents -> {
            ExchangeRuleContent exchangeRuleContent = new ExchangeRuleContent();
            CubeBeanUtils.copyProperties((Object)exchangeRuleContent, (Object)contents, (String[])new String[0]);
            List exchangeItems = BeanCopierUtils.copyList((List)contents.getExchangeItems(), GExchange.class);
            IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
            Long shopId = null;
            if (CollectionUtils.isNotEmpty((Collection)exchangeItems)) {
                shopId = ((GExchange)exchangeItems.get(0)).getShopId();
            }
            ShopBaseDto shopDto = null;
            if (null != shopId) {
                shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(((GExchange)exchangeItems.get(0)).getShopId()).getData();
            }
            IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
            IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
            for (GExchange gItem : exchangeItems) {
                List skuList = (List)itemQueryApi.queryItemSkuByItemId(gItem.getItemId()).getData();
                for (ItemSkuRespDto sku : skuList) {
                    if (!sku.getId().equals(gItem.getSkuId())) continue;
                    ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)RestResponseHelper.extractData((RestResponse)itemQueryApi.queryItemDetail(gItem.getItemId(), "sku", null));
                    if (Objects.nonNull(itemDetailRespDto.getItem())) {
                        ItemRespDto itemDto = itemDetailRespDto.getItem();
                        List itemSkuList = itemDetailRespDto.getItemSkuList();
                        ItemSkuRespDto itemSku = (ItemSkuRespDto)itemSkuList.stream().findFirst().get();
                        gItem.setBrand(itemDto.getBrand());
                        gItem.setSkuCode(itemSku.getCode());
                        gItem.setAttr(itemSku.getAttr());
                        gItem.setItemCode(itemDto.getCode());
                        gItem.setDirName(itemDto.getDirName());
                        gItem.setSubType(itemDto.getSubType());
                    }
                    BigDecimal price = itemService.queryItemPrice(shopId, gItem.getItemId(), gItem.getSkuId());
                    gItem.setSellPrice(price);
                    gItem.setRetailPrice(price);
                    Long stock = itemService.queryVirStorage(shopId, gItem.getItemId(), gItem.getSkuId());
                    gItem.setStock(stock);
                    break;
                }
                gItem.setShopName(shopDto == null ? null : shopDto.getName());
            }
            exchangeRuleContent.setExchangeItems(exchangeItems);
            exchangeRuleContents.add(exchangeRuleContent);
        });
        exchangeActivityDto.setPromotionContents(exchangeRuleContents);
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880296L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.EXCHANGE_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        ConditionReqDto condition = this.getConditionReqDto();
        if (CollectionUtils.isEmpty((Collection)exchangeActivityDto.getPromotionContents())) {
            throw new BizException("\u4fc3\u9500\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!DiscountRule.STAIR.getType().equals(exchangeActivityDto.getPromotionCondition())) {
            if (exchangeActivityDto.getPromotionContents().size() > 1) {
                throw new BizException("\u5f53\u524d\u4fc3\u9500\u6761\u4ef6\u53ea\u5141\u8bb8\u586b\u5199\u4e00\u6761\u89c4\u5219");
            }
        } else if (exchangeActivityDto.getPromotionContents().size() > 5) {
            throw new BizException("\u5f53\u524d\u4fc3\u9500\u6761\u4ef6\u6700\u591a\u4e0d\u8d85\u8fc75\u6761\u89c4\u5219");
        }
        ExchangeRule rule = new ExchangeRule();
        rule.setPromotionCondition(exchangeActivityDto.getPromotionCondition());
        rule.setPromotionMethod(exchangeActivityDto.getPromotionMethod());
        rule.setPromotionType(exchangeActivityDto.getPromotionType());
        rule.setThresholdType(exchangeActivityDto.getThresholdType());
        ArrayList ruleContentDtoList = new ArrayList();
        exchangeActivityDto.getPromotionContents().forEach(exchangeRule -> {
            ExcRuleContentDto ruleContentDto = new ExcRuleContentDto();
            ruleContentDto.setThresholdType(exchangeRule.getThresholdType());
            ruleContentDto.setThreshold(exchangeRule.getThreshold());
            ruleContentDto.setUnit(exchangeRule.getUnit());
            ruleContentDto.setDiscountUnit(exchangeRule.getDiscountUnit());
            ruleContentDto.setDiscountScale(exchangeRule.getDiscountScale());
            ruleContentDto.setDiscount(exchangeRule.getDiscount());
            ruleContentDto.setOrderScale(exchangeRule.getOrderScale());
            ruleContentDto.setIsOrderScale(exchangeRule.getIsOrderScale());
            if (CollectionUtils.isNotEmpty((Collection)exchangeRule.getExchangeItems())) {
                ArrayList exchangeItems = new ArrayList();
                exchangeRule.getExchangeItems().forEach(eItem -> {
                    ExcItemDto excItemDto = new ExcItemDto();
                    excItemDto.setItemId(eItem.getItemId());
                    excItemDto.setItemName(eItem.getItemName());
                    excItemDto.setShopName(eItem.getShopName());
                    excItemDto.setShopId(eItem.getShopId());
                    excItemDto.setSkuId(eItem.getSkuId());
                    excItemDto.setExchangePrice(eItem.getExchangePrice());
                    excItemDto.setSupportSingleBuy(eItem.getSupportSingleBuy());
                    exchangeItems.add(excItemDto);
                });
                ruleContentDto.setExchangeItems(exchangeItems);
            }
            ruleContentDtoList.add(ruleContentDto);
        });
        rule.setExcRuleContents(ruleContentDtoList);
        HashMap conditionParam = Maps.newHashMap();
        conditionParam.put("ExchangeCondition.rule", rule);
        logger.info("\u52a0\u4ef7\u8d2d\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }
}

