/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.ITimeDiscountActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.timediscount.TimeDiscountActivityDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeDiscountActivityImpl
extends AbstractActivityService
implements ITimeDiscountActivity {
    @Resource
    private IContext context;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IBitemService itemService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IActivityService activityService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;

    public Long add(TimeDiscountActivityDto activityReqDto) {
        this.validate(activityReqDto);
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            this.assembleAllItems(activityReqDto);
        }
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("TD"));
        return this.addActivity(activityReqDto);
    }

    public void modify(TimeDiscountActivityDto activityReqDto) {
        Assert.notNull((Object)activityReqDto.getId(), (String)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)activityReqDto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(activityReqDto);
        if (activityReqDto.getSelectType() == 0 || activityReqDto.getSelectType() == 2) {
            this.assembleAllItems(activityReqDto);
        }
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("TD"));
        this.addActivity(activityReqDto);
    }

    private void assembleAllItems(TimeDiscountActivityDto activityReqDto) {
        if (activityReqDto.getSelectType() == 0) {
            activityReqDto.setBrandIds(null);
            activityReqDto.setDirIds(null);
        }
        IActivityService activityService = (IActivityService)SpringBeanUtil.getBean(IActivityService.class);
        List items = activityService.queryAllItem(activityReqDto.getShopId(), activityReqDto.getBrandIds(), activityReqDto.getDirIds(), activityReqDto.getBlackItems());
        ArrayList<ApplicableActivityItemDto> applicableActivityItemDtos = new ArrayList<ApplicableActivityItemDto>();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            if (activityReqDto.getSelectType() == 0) {
                items = items.stream().filter(e -> Objects.equals(SubTypeEnum.PRODUCT.getType(), e.getSubType())).collect(Collectors.toList());
            }
            for (ItemShelfQueryRespDto itemShelfRespDto : items) {
                List skuList = itemShelfRespDto.getSkuList();
                if (!CollectionUtils.isNotEmpty((Collection)skuList)) continue;
                for (ItemShelfSkuRespDto skuRespDto : skuList) {
                    ApplicableActivityItemDto itemDto = new ApplicableActivityItemDto();
                    itemDto.setItemId(itemShelfRespDto.getItemId());
                    itemDto.setItemName(itemShelfRespDto.getItemName());
                    itemDto.setShopId(itemShelfRespDto.getShopId());
                    itemDto.setSkuId(skuRespDto.getId());
                    itemDto.setSkuDesc(skuRespDto.getName());
                    itemDto.setSellPrice(skuRespDto.getPrice());
                    if (2 == activityReqDto.getPromotionMethod()) {
                        itemDto.setDiscount(activityReqDto.getPromotionValue());
                        if (null != activityReqDto.getPromotionValue() && null != itemDto.getSellPrice()) {
                            itemDto.setActivityPrice(itemDto.getSellPrice().multiply(activityReqDto.getPromotionValue()).divide(new BigDecimal(10)));
                        }
                    } else {
                        itemDto.setActivityPrice(activityReqDto.getPromotionValue());
                    }
                    applicableActivityItemDtos.add(itemDto);
                }
            }
        }
        activityReqDto.setActivityItems(applicableActivityItemDtos);
    }

    private void validate(TimeDiscountActivityDto activityReqDto) {
        if (activityReqDto.getSelectType() == 1 && CollectionUtils.isEmpty((Collection)activityReqDto.getActivityItems())) {
            throw new BizException("\u9002\u7528\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty((Collection)activityReqDto.getActivityItems())) {
            activityReqDto.getActivityItems().forEach(itemDto -> {
                if (null == itemDto.getShopId()) {
                    throw new BizException("\u5546\u54c1\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                itemDto.getSkus().forEach(sku -> {
                    if (activityReqDto.getPromotionMethod() == 1) {
                        if (null == sku.getPromotionPrice()) {
                            throw new BizException("\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (sku.getPromotionPrice().compareTo(BigDecimal.ZERO) == -1) {
                            throw new BizException("\u5546\u54c1\u4fc3\u9500\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e0");
                        }
                        if (null != sku.getPromotionPrice() && null != sku.getRetailPrice() && sku.getRetailPrice().compareTo(sku.getPromotionPrice()) == -1) {
                            throw new BizException("\u4fc3\u9500\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u5546\u54c1\u81ea\u5b9a\u4e49\u5efa\u8bae\u96f6\u552e\u4ef7");
                        }
                    } else if (activityReqDto.getPromotionMethod() == 2 && null == sku.getDiscount()) {
                        throw new BizException("\u5546\u54c1\u6298\u6263\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            });
        }
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        TimeDiscountActivityDto activityDto = (TimeDiscountActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (1 == activityDto.getSelectType()) {
            if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityItems())) {
                activityDto.getActivityItems().stream().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
                    ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                    activityItemReqDto.setItemId(skuDto.getItemId());
                    activityItemReqDto.setItemName(itemDto.getItemName());
                    activityItemReqDto.setSkuId(skuDto.getSkuId());
                    activityItemReqDto.setInstanceId(this.context.instanceId());
                    activityItemReqDto.setTenantId(this.context.tenantId());
                    activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                    activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                    activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                    activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                    activityItemReqDto.setActivityStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                    activityItemReqDto.setSkuDesc(itemDto.getSkuDesc());
                    activityItemReqDto.setActivityPrice(null != skuDto.getPromotionPrice() ? skuDto.getPromotionPrice() : BigDecimal.ZERO);
                    if (2 == activityDto.getPromotionMethod() && Objects.nonNull(skuDto.getRetailPrice())) {
                        activityItemReqDto.setActivityPrice(skuDto.getRetailPrice().multiply(skuDto.getDiscount()).divide(new BigDecimal(10)));
                    }
                    activityItemReqDto.setShopId(itemDto.getShopId());
                    activityItemReqDtos.add(activityItemReqDto);
                }));
            }
        } else if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityItems())) {
            for (ApplicableActivityItemDto itemDto2 : activityDto.getActivityItems()) {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setItemId(itemDto2.getItemId());
                activityItemReqDto.setItemName(itemDto2.getItemName());
                activityItemReqDto.setSkuId(itemDto2.getSkuId());
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setRemainingStock(Long.valueOf(-1L));
                activityItemReqDto.setOriginalStock(Long.valueOf(-1L));
                activityItemReqDto.setActivityStock(Long.valueOf(-1L));
                activityItemReqDto.setSkuDesc(itemDto2.getSkuDesc());
                activityItemReqDto.setActivityPrice(null != itemDto2.getActivityPrice() ? itemDto2.getActivityPrice() : BigDecimal.ZERO);
                activityItemReqDto.setShopId(itemDto2.getShopId());
                activityItemReqDtos.add(activityItemReqDto);
            }
        }
        return activityItemReqDtos;
    }

    public TimeDiscountActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        TimeDiscountActivityDto timeDiscountActivityDto = new TimeDiscountActivityDto();
        CubeBeanUtils.copyProperties((Object)timeDiscountActivityDto, (Object)activityRespDto, (String[])new String[0]);
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.TIME_DISCOUNT_TOB_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), timeDiscountActivityDto));
        timeDiscountActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        return timeDiscountActivityDto;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        TimeDiscountActivityDto activityDto = (TimeDiscountActivityDto)activityReqDto;
        if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityCustomers())) {
            List<Long> customerIds = activityDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            return customerIds;
        }
        return null;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getCustomerTypes(T activityReqDto) {
        TimeDiscountActivityDto activityDto = (TimeDiscountActivityDto)activityReqDto;
        return activityDto.getCustomerTypeIds();
    }

    @Override
    protected <T extends BaseActivityTobDto> List<String> getCustomerAreaCodes(T activityReqDto) {
        TimeDiscountActivityDto activityDto = (TimeDiscountActivityDto)activityReqDto;
        return activityDto.getCustomerAreaCodes();
    }
}

