/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl.serializa;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.module.marketing.api.IDeserializationDynamicDate;
import com.dtyunxi.yundt.module.marketing.api.common.CouponTemplateTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.CouponUseTimeTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.DynamicDate;
import com.dtyunxi.yundt.module.marketing.biz.enums.CouponUseTimeEnum;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class DeserializationToday
implements IDeserializationDynamicDate {
    private static final Integer AFTER_DAY = 1;

    public Integer getSupportAfterDay() {
        return AFTER_DAY;
    }

    public void deserialization(CouponTemplateTobDto couponTemplateTobDto, DynamicDate dynamicDate) {
        if (dynamicDate == null) {
            return;
        }
        if (dynamicDate.getAfterDate() != AFTER_DAY) {
            return;
        }
        CouponUseTimeTobDto dto = new CouponUseTimeTobDto();
        dto.setType(CouponUseTimeEnum.TODAY.getKey());
        dto.setValue((Object)dynamicDate.getDay());
        couponTemplateTobDto.setCouponUseTimeReqDto(dto);
        couponTemplateTobDto.setCouponUseBeginTime(DateUtil.getDayBegin());
        Date endTime = DateUtil.getEndOfDay((Date)couponTemplateTobDto.getCouponUseBeginTime());
        if (dynamicDate.getDay() > 1) {
            endTime = DateUtil.addDays((Date)endTime, (int)(dynamicDate.getDay() - 1));
        }
        couponTemplateTobDto.setCouponUseEndTime(endTime);
    }
}

