/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.SelectTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.bitem.api.constants.ItemConstant;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemQueryReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IXCXActivity;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.ActivityItemSearchParamDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.FullDecRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.GItem;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.response.XCXActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.XCXActivityItemRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.XCXActivityRuleAndItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.XCXFullActivityRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XCXActivityImpl
implements IXCXActivity {
    @Autowired
    private IContext context;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Autowired
    private IActivityItemQueryApi activityItemQueryApi;

    public RestResponse<XCXFullActivityRespDto> queryActivityDetail(Long id, String activityType) {
        XCXFullActivityRespDto xcxFullReductionActivityRespDto = new XCXFullActivityRespDto();
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        StringBuilder descStr = new StringBuilder();
        ArrayList<String> descList = new ArrayList<String>();
        switch (activityType) {
            case "FULL_PRESENT_TOB_ACTIVITY": {
                ReturnGiftActivityDto returnGiftActivityDto = new ReturnGiftActivityDto();
                CubeBeanUtils.copyProperties((Object)returnGiftActivityDto, (Object)activityRespDto, (String[])new String[0]);
                xcxFullReductionActivityRespDto.setActivityStatus(activityRespDto.getActivityStatus());
                this.buildTemplate(activityRespDto, returnGiftActivityDto);
                HashSet<Long> itemIds = new HashSet<Long>();
                for (ReturnGiftRuleContent promotionContent : returnGiftActivityDto.getPromotionContents()) {
                    StringBuilder desc = this.buildFullGiftRuleDesc(returnGiftActivityDto, promotionContent);
                    descList.add(desc.toString());
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)descStr.toString())) {
                        descStr.append(",");
                    }
                    descStr.append((CharSequence)desc);
                    itemIds.addAll(this.buildFullGiftRuleItemIds(promotionContent));
                }
                Map<Long, List<ItemRespDto>> groupForItems = this.buildItemGroup(itemIds);
                List<XCXActivityRuleAndItemDto> activityRuleAndItems = this.buildGiftList(returnGiftActivityDto, groupForItems);
                xcxFullReductionActivityRespDto.setActivityRuleAndItems(activityRuleAndItems);
                break;
            }
            case "OVERALL_REDUCTION_TOB_ACTIVITY": 
            case "FULL_DISCOUNT_TOB_ACTIVITY": {
                FullReductionActivityDto fullReductionActivityDto = new FullReductionActivityDto();
                CubeBeanUtils.copyProperties((Object)fullReductionActivityDto, (Object)activityRespDto, (String[])new String[0]);
                ActivityType byType = ActivityType.getByType((Long)activityRespDto.getActivityTemplateId());
                List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(byType);
                templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), fullReductionActivityDto));
                if (CollectionUtils.isEmpty((Collection)fullReductionActivityDto.getPromotionContents())) break;
                for (FullDecRuleContent promotionContent : fullReductionActivityDto.getPromotionContents()) {
                    StringBuilder desc = new StringBuilder();
                    desc.append(fullReductionActivityDto.getPromotionCondition() != null && fullReductionActivityDto.getPromotionCondition() == 1 ? "\u6ee1" : "\u6bcf\u6ee1").append(promotionContent.getThreshold()).append(promotionContent.getUnit() == 1 ? "\u5143" : "\u4ef6").append(fullReductionActivityDto.getPromotionType() == 1 ? "\u51cf" : "").append(promotionContent.getDiscount()).append(fullReductionActivityDto.getPromotionType() == 1 ? "\u5143" : "\u6298");
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)descStr.toString())) {
                        descStr.append(",");
                    }
                    descStr.append(desc.toString());
                    descList.add(desc.toString());
                }
                break;
            }
            case "EXCHANGE_ACTIVITY": {
                ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
                CubeBeanUtils.copyProperties((Object)exchangeActivityDto, (Object)activityRespDto, (String[])new String[0]);
                ActivityType byType1 = ActivityType.getByType((Long)activityRespDto.getActivityTemplateId());
                List<ConditionTemplate> templateList1 = ActivityFactory.getActivityTemplate(byType1);
                templateList1.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), exchangeActivityDto));
                if (CollectionUtils.isEmpty((Collection)exchangeActivityDto.getPromotionContents())) break;
                for (ExchangeRuleContent exchangeRuleContent : exchangeActivityDto.getPromotionContents()) {
                    StringBuilder desc = new StringBuilder();
                    if (exchangeActivityDto.getPromotionCondition() == 1) {
                        desc.append("\u6ee1");
                    } else if (exchangeActivityDto.getPromotionCondition() == 2) {
                        desc.append("\u6bcf\u6ee1");
                    }
                    desc.append(exchangeRuleContent.getThreshold()).append(exchangeRuleContent.getUnit() == 1 ? "\u5143" : "\u4ef6");
                    desc.append("\uff0c\u53ef");
                    desc.append(exchangeActivityDto.getThresholdType() == 0 ? "\u514d\u8d39" : "\u4f18\u60e0");
                    desc.append("\u6362\u8d2d\u5546\u54c1");
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)descStr.toString())) {
                        descStr.append(",");
                    }
                    descStr.append(desc.toString());
                    descList.add(desc.toString());
                }
                break;
            }
            case "COMBINATION_ACTIVITY": {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + activityType);
            }
        }
        xcxFullReductionActivityRespDto.setActivityName(activityRespDto.getActivityName());
        xcxFullReductionActivityRespDto.setBeginTime(activityRespDto.getBeginTime());
        xcxFullReductionActivityRespDto.setEndTime(activityRespDto.getEndTime());
        long l = activityRespDto.getEndTime().getTime() - System.currentTimeMillis();
        xcxFullReductionActivityRespDto.setCountdown(Math.max(l, 0L));
        xcxFullReductionActivityRespDto.setId(activityRespDto.getId());
        xcxFullReductionActivityRespDto.setItemsConditionDec(SelectTypeEnum.toName((String)(activityRespDto.getSelectType() + "")));
        xcxFullReductionActivityRespDto.setFullRuleDecList(descList);
        xcxFullReductionActivityRespDto.setFullRuleDec(descStr.toString());
        xcxFullReductionActivityRespDto.setSelectType(activityRespDto.getSelectType());
        xcxFullReductionActivityRespDto.setPromotionMethod(activityRespDto.getPromotionMethod());
        return new RestResponse((Object)xcxFullReductionActivityRespDto);
    }

    public RestResponse<PageInfo<XCXActivityItemRespDto>> pageActivityItems(ActivityItemSearchParamDto activityItemSearchParamDto, Integer pageNum, Integer pageSize) {
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(activityItemSearchParamDto.getActivityId());
        RestResponse listRestResponse = this.activityItemQueryApi.queryAll(activityItemQueryReqDto);
        List activityItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        List itemIds = activityItemRespDtos.stream().map(ActivityItemRespDto::getItemId).collect(Collectors.toList());
        ItemQueryReqDto itemQueryReqDto = new ItemQueryReqDto();
        BeanUtils.copyProperties((Object)activityItemSearchParamDto, (Object)itemQueryReqDto);
        itemQueryReqDto.setType(ItemConstant.ORDINARY_ITEM);
        itemQueryReqDto.setItemIds(itemIds);
        if (StringUtils.isNotEmpty((String)activityItemSearchParamDto.getKeyword())) {
            itemQueryReqDto.setKeyword("%" + itemQueryReqDto.getKeyword() + "%");
        }
        itemQueryReqDto.setInstanceId(this.context.instanceId());
        itemQueryReqDto.setTenantId(this.context.tenantId());
        String filter = JSON.toJSONString((Object)itemQueryReqDto);
        RestResponse restResponse = this.itemQueryApi.queryByKeyword(filter, pageNum, pageSize);
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        ArrayList list = new ArrayList();
        for (ItemRespDto itemRespDto : itemSearchRespDto.getPageInfo().getList()) {
        }
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)itemSearchRespDto.getPageInfo(), (Object)pageInfo);
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    private List<XCXActivityRuleAndItemDto> buildGiftList(ReturnGiftActivityDto returnGiftActivityDto, Map<Long, List<ItemRespDto>> groupForItems) {
        ArrayList<XCXActivityRuleAndItemDto> list = new ArrayList<XCXActivityRuleAndItemDto>();
        for (ReturnGiftRuleContent promotionContent : returnGiftActivityDto.getPromotionContents()) {
            StringBuilder stringBuilder = this.buildFullGiftRuleDesc(returnGiftActivityDto, promotionContent);
            XCXActivityRuleAndItemDto xcx = new XCXActivityRuleAndItemDto();
            xcx.setActivityRule(stringBuilder.append("\uff08\u9001\u5b8c\u5373\u6b62\uff09").toString());
            ArrayList<XCXActivityItemDto> XCXActivityItemDtolist = new ArrayList<XCXActivityItemDto>();
            if (promotionContent.getSelfItem().booleanValue()) {
                Long sendNum = promotionContent.getGiftNum();
                XCXActivityItemDto xcxActivityItemDtoSelf = new XCXActivityItemDto();
                xcxActivityItemDtoSelf.setNum(sendNum);
                xcxActivityItemDtoSelf.setSkuName("\u672c\u54c1");
                xcxActivityItemDtoSelf.setSelfItem(1);
                XCXActivityItemDtolist.add(xcxActivityItemDtoSelf);
            }
            if (!CollectionUtils.isEmpty((Collection)promotionContent.getGiftItems())) {
                for (GItem giftItem : promotionContent.getGiftItems()) {
                    XCXActivityItemDto xcxActivityItemDto = new XCXActivityItemDto();
                    List<ItemRespDto> itemRespDtos = groupForItems.get(giftItem.getItemId());
                    ItemRespDto itemRespDto = CollectionUtils.isNotEmpty(itemRespDtos) ? itemRespDtos.get(0) : null;
                    ItemMediasRespDto itemMediasRespDto = itemRespDto != null && CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemMediasList()) ? (ItemMediasRespDto)itemRespDto.getItemMediasList().get(0) : null;
                    xcxActivityItemDto.setSelfItem(2);
                    xcxActivityItemDto.setImgPath(itemMediasRespDto == null ? "" : itemMediasRespDto.getPath1());
                    xcxActivityItemDto.setItemId(giftItem.getItemId());
                    xcxActivityItemDto.setItemName(giftItem.getItemName());
                    xcxActivityItemDto.setNum(giftItem.getNum());
                    xcxActivityItemDto.setSkuId(giftItem.getSkuId());
                    xcxActivityItemDto.setSkuName(giftItem.getSkuName());
                    xcxActivityItemDto.setSellPrice(giftItem.getSellPrice());
                    xcxActivityItemDto.setStock(giftItem.getStock());
                    XCXActivityItemDtolist.add(xcxActivityItemDto);
                }
            }
            xcx.setActivityItemDto(XCXActivityItemDtolist);
            list.add(xcx);
        }
        return list;
    }

    private void buildTemplate(ActivityRespDto activityRespDto, ReturnGiftActivityDto returnGiftActivityDto) {
        returnGiftActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        List<ConditionTemplate> templateListReturnGiftActivityDto = ActivityFactory.getActivityTemplate(returnGiftActivityDto.getActivityType());
        templateListReturnGiftActivityDto.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), returnGiftActivityDto));
    }

    private Map<Long, List<ItemRespDto>> buildItemGroup(Set<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return new HashMap<Long, List<ItemRespDto>>(0);
        }
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        itemSearchQueryReqDto.setItemIds(new ArrayList<Long>(itemIds));
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        itemSearchQueryReqDto.setSearch(Boolean.valueOf(false));
        itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemIds.size())));
        if (itemSearchRespDto == null) {
            return new HashMap<Long, List<ItemRespDto>>();
        }
        return itemSearchRespDto.getPageInfo().getList().stream().collect(Collectors.groupingBy(ItemRespDto::getItemId, Collectors.toList()));
    }

    private StringBuilder buildFullGiftRuleDesc(ReturnGiftActivityDto returnGiftActivityDto, ReturnGiftRuleContent promotionContent) {
        StringBuilder filterDesc = new StringBuilder();
        filterDesc.append(returnGiftActivityDto.getPromotionCondition() != null && returnGiftActivityDto.getPromotionCondition() == 1 ? "\u6ee1" : "\u6bcf\u6ee1").append(promotionContent.getThreshold()).append(promotionContent.getUnit() == 1 ? "\u5143" : "\u4ef6").append(returnGiftActivityDto.getPromotionType() == 3 ? "\u8d60" : "");
        if (promotionContent.getSelfItem().booleanValue()) {
            filterDesc.append(promotionContent.getGiftNum().intValue()).append("\u672c\u54c1");
        }
        if (!CollectionUtils.isEmpty((Collection)promotionContent.getGiftItems())) {
            long totalNum = promotionContent.getGiftItems().stream().mapToLong(item -> item.getNum() == null ? 0L : item.getNum()).sum();
            filterDesc.append(promotionContent.getSelfItem() != false ? "," : "").append((int)totalNum).append("\u8d60\u54c1");
        }
        return filterDesc;
    }

    private List<Long> buildFullGiftRuleItemIds(ReturnGiftRuleContent promotionContent) {
        return promotionContent.getGiftItems().stream().map(GItem::getItemId).collect(Collectors.toList());
    }
}

