/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.exchange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ExchangeItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.coupon.CouponItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ExchangeItemCondition
extends AbstractBaseTemplate {
    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        if (t instanceof CouponTemplateDetailRespDto) {
            CouponTemplateDetailRespDto coupon = (CouponTemplateDetailRespDto)t;
            JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
            List items = JSON.parseArray((String)jsonObject.getString("ExchangeItemCondition.items"), ExchangeItemDto.class);
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                ArrayList couponItemSkuDtos = Lists.newArrayList();
                items.forEach(exchangeItemDto -> {
                    CouponItemSkuDto couponItemSkuDto = new CouponItemSkuDto();
                    CubeBeanUtils.copyProperties((Object)couponItemSkuDto, (Object)exchangeItemDto, (String[])new String[0]);
                    couponItemSkuDtos.add(couponItemSkuDto);
                });
                Map<String, List<CouponItemSkuDto>> group = couponItemSkuDtos.stream().collect(Collectors.groupingBy(sku -> sku.getItemId().toString() + sku.getShopId()));
                ArrayList couponItemDtos = Lists.newArrayList();
                group.values().forEach(skus -> {
                    CouponItemDto couponItemDto = new CouponItemDto();
                    Long itemId = ((CouponItemSkuDto)skus.get(0)).getItemId();
                    Long shopId = ((CouponItemSkuDto)skus.get(0)).getShopId();
                    ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(shopId, itemId, ItemBusTypeEnum.ORDINARY.getType());
                    if (null == itemDetail) {
                        return;
                    }
                    if (null != shopId) {
                        ShopBaseDto shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(shopId).getData();
                        couponItemDto.setShopName(shopDto == null ? null : shopDto.getName());
                    }
                    Long totalStock = 0L;
                    for (CouponItemSkuDto sku : skus) {
                        itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(sku.getSkuId())).findFirst().ifPresent(itemSku -> {
                            if (null != itemSku.getAttrMap()) {
                                String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                                sku.setSkuName(skuName);
                            }
                        });
                        BigDecimal price = itemService.queryItemPrice(shopId, sku.getItemId(), sku.getSkuId());
                        sku.setSellPrice(price);
                        Long stock = itemService.queryVirStorage(shopId, null, sku.getSkuId());
                        sku.setStock(stock);
                        totalStock = totalStock + stock;
                    }
                    couponItemDto.setItemId(itemId);
                    couponItemDto.setShopId(shopId);
                    couponItemDto.setSkus(skus);
                    couponItemDto.setItemCode(itemDetail.getItemCode());
                    couponItemDto.setItemName(itemDetail.getItemName());
                    couponItemDto.setTotalStock(totalStock);
                    couponItemDtos.add(couponItemDto);
                });
                coupon.setExchangeItems((List)couponItemDtos);
            }
        }
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880290L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.COUPON_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        return null;
    }
}

