/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.returngift;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.GiftItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ReturnGiftContent;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ReturnGiftRule;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.GItem;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.returngift.ReturnGiftRuleContent;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.module.marketing.biz.enums.DiscountRule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnGiftCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(ReturnGiftCondition.class);

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ReturnGiftRule returnGiftRule = (ReturnGiftRule)JSON.parseObject((String)jsonObject.getString("ReturnGiftCondition.rule"), ReturnGiftRule.class);
        returnGiftActivityDto.setPromotionMethod(returnGiftRule.getPromotionMethod());
        returnGiftActivityDto.setPromotionCondition(returnGiftRule.getPromotionCondition());
        returnGiftActivityDto.setPromotionType(returnGiftRule.getPromotionType());
        ArrayList returnGiftContents = new ArrayList();
        returnGiftRule.getPromotionContents().stream().forEach(contents -> {
            ReturnGiftRuleContent returnGiftContent = new ReturnGiftRuleContent();
            CubeBeanUtils.copyProperties((Object)returnGiftContent, (Object)contents, (String[])new String[0]);
            List giftItems = BeanCopierUtils.copyList((List)contents.getGiftItems(), GItem.class);
            IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
            Long shopId = null;
            if (CollectionUtils.isNotEmpty((Collection)giftItems)) {
                shopId = ((GItem)giftItems.get(0)).getShopId();
            }
            ShopBaseDto shopDto = null;
            if (null != shopId) {
                shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(((GItem)giftItems.get(0)).getShopId()).getData();
            }
            IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
            IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
            for (GItem gItem : giftItems) {
                ItemChangeApplyDetailDto itemDetail;
                List skuList = (List)itemQueryApi.queryItemSkuByItemId(gItem.getItemId()).getData();
                for (ItemSkuRespDto sku : skuList) {
                    if (!sku.getId().equals(gItem.getSkuId())) continue;
                    BigDecimal price = itemService.queryItemPrice(shopId, gItem.getItemId(), gItem.getSkuId());
                    gItem.setSellPrice(price);
                    gItem.setRetailPrice(price);
                    gItem.setAttr(gItem.getSkuName());
                    Long stock = itemService.queryVirStorage(shopId, gItem.getItemId(), gItem.getSkuId());
                    gItem.setStock(stock);
                    break;
                }
                if ((itemDetail = itemService.getDetailByItemId(shopId, gItem.getItemId(), ItemBusTypeEnum.ORDINARY.getType())) != null) {
                    gItem.setSubType(itemDetail.getSubType());
                }
                gItem.setShopName(shopDto == null ? null : shopDto.getName());
            }
            returnGiftContent.setGiftItems(giftItems);
            returnGiftContents.add(returnGiftContent);
        });
        returnGiftActivityDto.setPromotionContents(returnGiftContents);
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880258L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)type) || ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
        ConditionReqDto condition = this.getConditionReqDto();
        if (CollectionUtils.isEmpty((Collection)returnGiftActivityDto.getPromotionContents())) {
            throw new BizException("\u4fc3\u9500\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!DiscountRule.STAIR.getType().equals(returnGiftActivityDto.getPromotionCondition())) {
            if (returnGiftActivityDto.getPromotionContents().size() > 1) {
                throw new BizException("\u5f53\u524d\u4fc3\u9500\u6761\u4ef6\u53ea\u5141\u8bb8\u586b\u5199\u4e00\u6761\u89c4\u5219");
            }
        } else if (returnGiftActivityDto.getPromotionContents().size() > 5) {
            throw new BizException("\u5f53\u524d\u4fc3\u9500\u6761\u4ef6\u6700\u591a\u4e0d\u8d85\u8fc75\u6761\u89c4\u5219");
        }
        ReturnGiftRule rule = new ReturnGiftRule();
        rule.setPromotionCondition(returnGiftActivityDto.getPromotionCondition());
        rule.setPromotionMethod(returnGiftActivityDto.getPromotionMethod());
        rule.setPromotionType(returnGiftActivityDto.getPromotionType());
        rule.setPresentType(returnGiftActivityDto.getPresentType());
        ArrayList decContentList = Lists.newArrayList();
        returnGiftActivityDto.getPromotionContents().forEach(returnGiftRule -> {
            ReturnGiftContent decContent = new ReturnGiftContent();
            decContent.setPostage(returnGiftRule.getPostage());
            decContent.setThreshold(returnGiftRule.getThreshold());
            decContent.setUnit(returnGiftRule.getUnit());
            decContent.setPoints(returnGiftRule.getPoints());
            decContent.setSelfItem(returnGiftRule.getSelfItem());
            decContent.setGiftNum(returnGiftRule.getGiftNum());
            decContent.setGiftItem(returnGiftRule.getGiftItem());
            decContent.setTotalGiftNum(returnGiftRule.getTotalGiftNum());
            decContent.setLogic(returnGiftRule.getLogic());
            if (null != returnGiftRule.getGiftItems()) {
                ArrayList giftItems = new ArrayList();
                returnGiftRule.getGiftItems().forEach(gItem -> {
                    GiftItem giftItem = new GiftItem();
                    giftItem.setItemCode(gItem.getItemCode());
                    giftItem.setNum(gItem.getNum());
                    giftItem.setItemName(gItem.getItemName());
                    giftItem.setShopId(gItem.getShopId());
                    giftItem.setItemId(gItem.getItemId());
                    giftItem.setSkuId(gItem.getSkuId());
                    giftItem.setSkuName(gItem.getSkuName());
                    giftItem.setTotalGiftNum(gItem.getTotalGiftNum());
                    giftItem.setPrice(gItem.getRetailPrice());
                    giftItems.add(giftItem);
                });
                decContent.setGiftItems(giftItems);
            }
            decContentList.add(decContent);
        });
        rule.setPromotionContents((List)decContentList);
        HashMap conditionParam = Maps.newHashMap();
        conditionParam.put("ReturnGiftCondition.rule", rule);
        logger.info("\u9650\u65f6\u6298\u6263\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }
}

