/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BaseRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaSubTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfSearchDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemOnShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRelRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfWholeCasePurchaseEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemSkuInfoDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemStorageQueryDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.StorageBranchQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemActivityPriceRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemBaseInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemDetailInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.ItemForActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.biz.price.PriceRuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IXCXActivity;
import com.dtyunxi.yundt.module.marketing.api.dto.response.XCXFullActivityRespDto;
import com.dtyunxi.yundt.module.marketing.api.enums.SelectTypeEnum;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IShoppingCart;
import com.dtyunxi.yundt.module.trade.api.ItemService;
import com.dtyunxi.yundt.module.trade.api.dto.request.CartItemBatchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ImportItemFailMsgRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ImportItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ShoppingCartItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.TrolleyQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.activity.TradeExchangeActivityReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderItemImportReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.CommonImportRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ImportItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ItemInfoImportRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.activity.TradeExchangeActivityRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemSkuListRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeTobEnum;
import com.dtyunxi.yundt.module.trade.biz.IPriceService;
import com.dtyunxi.yundt.module.trade.biz.export.AbstractDataExport;
import com.dtyunxi.yundt.module.trade.biz.export.BatchImportOrderTemplateExport;
import com.dtyunxi.yundt.module.trade.biz.util.DeliveryRuleUtils;
import com.dtyunxi.yundt.module.trade.biz.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.module.trade.biz.util.NumberFormatUtils;
import com.dtyunxi.yundt.module.trade.biz.vo.BatchExportOrderVo;
import com.dtyunxi.yundt.module.trade.biz.vo.BatchImportOrderVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.constants.LimitMinModeEnum;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemServiceImpl
implements ItemService {
    private static final Logger logger = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Resource
    private IShopQueryApi iShopQueryApi;
    @Resource
    private IItemQueryApi iItemQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IOrderService orderService;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;
    @Resource
    private IPriceService priceService;
    @Resource
    private IBitemService bitemService;
    @Resource
    private IShoppingCart shoppingCart;
    @Autowired
    private IXCXActivity ixcxActivity;
    @Autowired
    private IActivityExtQueryApi activityExtQueryApi;
    @Autowired
    private IItemExtQueryApi itemExtQueryApi;
    @Autowired
    private ICustomerQueryApi customerApi;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private IControlInventoryQueryApi controlInventoryQueryApi;
    @Resource
    private ICustomerExtQueryApi customerQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ItemService itemService;
    @Autowired
    private DeliveryRuleUtils deliveryRuleUtils;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Autowired
    private PriceRuleHelper priceRuleHelper;

    public PageInfo<ItemSkuListRespDto> pageItemSkuList(ItemSkuListQueryReqDto itemSkuListQueryReqDto, Integer pageNum, Integer pageSize) {
        ItemOnShelfSearchDto itemOnShelfSearchDto = new ItemOnShelfSearchDto();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getDirId()) {
            ids.add(itemSkuListQueryReqDto.getDirId());
        }
        ArrayList<Long> backDirIds = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getBackDirId()) {
            backDirIds.add(itemSkuListQueryReqDto.getBackDirId());
        }
        itemOnShelfSearchDto.setOutSkuIds(itemSkuListQueryReqDto.getOutSkuIds());
        itemOnShelfSearchDto.setDirIds(ids);
        itemOnShelfSearchDto.setBackDirIds(backDirIds);
        itemOnShelfSearchDto.setInstanceId(this.context.instanceId());
        itemOnShelfSearchDto.setPageNum(pageNum);
        itemOnShelfSearchDto.setPageSize(pageSize);
        itemOnShelfSearchDto.setSearchValue(itemSkuListQueryReqDto.getKeyword());
        itemOnShelfSearchDto.setTenantId(this.context.tenantId());
        itemOnShelfSearchDto.setShopId(itemSkuListQueryReqDto.getShopId());
        List sellIds = this.orderService.getSellIds();
        itemOnShelfSearchDto.setSellerIds(sellIds);
        if (null != itemSkuListQueryReqDto.getBusType()) {
            itemOnShelfSearchDto.setBusType(itemSkuListQueryReqDto.getBusType());
        } else {
            itemOnShelfSearchDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        logger.info("itemOnShelfSearchDto>>>{}", (Object)JSON.toJSONString((Object)itemOnShelfSearchDto));
        RestResponse pageInfoRestResponse = this.iItemQueryApi.findItemOnSelf(JSON.toJSONString((Object)itemOnShelfSearchDto), pageNum, pageSize);
        PageInfo itemOnShelfRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.isNull(itemOnShelfRespDtoPageInfo) || CollectionUtils.isEmpty((Collection)itemOnShelfRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        ArrayList itemSkuListRespDtos = Lists.newArrayList();
        HashSet<Long> unitIds = new HashSet<Long>(itemOnShelfRespDtoPageInfo.getList().size());
        List<Long> shopIds = itemOnShelfRespDtoPageInfo.getList().stream().map(ItemOnShelfRespDto::getShopId).collect(Collectors.toList());
        Map<Long, List<ShopDto>> group = this.getShopIdMap(shopIds);
        for (ItemOnShelfRespDto itemOnShelfRespDto : itemOnShelfRespDtoPageInfo.getList()) {
            ItemSkuListRespDto itemSkuListRespDto = new ItemSkuListRespDto();
            BeanUtils.copyProperties((Object)itemOnShelfRespDto, (Object)itemSkuListRespDto);
            itemSkuListRespDto.setId(null);
            itemSkuListRespDto.setItemNum(Long.valueOf(Objects.nonNull(itemSkuListRespDto.getWholesaleLimitMin()) ? itemSkuListRespDto.getWholesaleLimitMin() : 1L));
            Map skuAttr = (Map)ObjectHelper.Json2Bean((String)itemSkuListRespDto.getAttr(), Map.class);
            if (null != skuAttr) {
                String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                itemSkuListRespDto.setSkuName(skuDesc);
            } else {
                itemSkuListRespDto.setSkuName("");
            }
            List<ShopDto> shopDtos = group.get(itemOnShelfRespDto.getShopId());
            itemSkuListRespDto.setShopName(CollectionUtils.isEmpty(shopDtos) ? "" : shopDtos.get(0).getName());
            if (StringUtils.isNotEmpty((String)itemSkuListRespDto.getUnit())) {
                Long aLong = null;
                try {
                    aLong = Long.valueOf(itemSkuListRespDto.getUnit());
                    unitIds.add(aLong);
                }
                catch (Exception e) {
                    logger.error("\u8f6c\u5316\u5546\u54c1\u5355\u4f4d\u5931\u8d25:{}, \u5931\u8d25\u539f\u56e0: {}", (Object)itemSkuListRespDto, (Object)e);
                }
            }
            itemSkuListRespDtos.add(itemSkuListRespDto);
        }
        this.priceService.replacePrice(itemSkuListRespDtos, itemSkuListQueryReqDto.getCustomerId());
        if (CollectionUtils.isNotEmpty(unitIds)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
            Map<Long, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(UnitRespDto::getId, UnitRespDto::getName, (e1, e2) -> e1));
            for (ItemSkuListRespDto itemSkuInfo : itemSkuListRespDtos) {
                if (!StringUtils.isNotEmpty((String)itemSkuInfo.getUnit())) continue;
                try {
                    String unitName = unitNameMap.get(Long.valueOf(itemSkuInfo.getUnit()));
                    itemSkuInfo.setUnitName(unitName);
                }
                catch (Exception e) {
                    logger.error("\u8f6c\u5316\u5546\u54c1sku\u5355\u4f4d\u5931\u8d25:{}, \u5931\u8d25\u539f\u56e0: {}", (Object)itemSkuInfo, (Object)e);
                }
            }
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)itemOnShelfRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        result.setList((List)itemSkuListRespDtos);
        return result;
    }

    private Map<Long, List<ShopDto>> getShopIdMap(List<Long> shopIds) {
        Map<Long, List<Object>> group = new HashMap<Long, List<ShopDto>>();
        try {
            RestResponse listRestResponse = this.iShopQueryApi.queryByIds(new HashSet<Long>(shopIds));
            group = ((List)listRestResponse.getData()).stream().collect(Collectors.groupingBy(ShopDto::getId, Collectors.toList()));
        }
        catch (Exception e) {
            logger.error("\u8f6c\u5316\u5931\u8d25\u83b7\u53d6\u95e8\u5e97\u6570\u636e\u5931\u8d25:{}, \u5931\u8d25\u539f\u56e0: {}", (Object)StringUtils.join(shopIds, (String)","), (Object)e);
        }
        return group;
    }

    public PageInfo<ItemSkuListRespDto> getSkuList(ItemSkuListQueryReqDto itemSkuListQueryReqDto, Integer pageNum, Integer pageSize) {
        Map<String, BigDecimal> costRetailPriceMap;
        ItemOnShelfSearchDto itemOnShelfSearchDto = new ItemOnShelfSearchDto();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getDirId()) {
            ids.add(itemSkuListQueryReqDto.getDirId());
        }
        ArrayList<Long> backDirIds = new ArrayList<Long>();
        if (null != itemSkuListQueryReqDto.getBackDirId()) {
            backDirIds.add(itemSkuListQueryReqDto.getBackDirId());
        }
        itemOnShelfSearchDto.setOutSkuIds(itemSkuListQueryReqDto.getOutSkuIds());
        itemOnShelfSearchDto.setDirIds(ids);
        itemOnShelfSearchDto.setSkuCode(itemSkuListQueryReqDto.getSkuCode());
        itemOnShelfSearchDto.setBackDirIds(backDirIds);
        itemOnShelfSearchDto.setInstanceId(this.context.instanceId());
        itemOnShelfSearchDto.setPageNum(pageNum);
        itemOnShelfSearchDto.setPageSize(pageSize);
        itemOnShelfSearchDto.setSearchValue(itemSkuListQueryReqDto.getKeyword());
        itemOnShelfSearchDto.setTenantId(this.context.tenantId());
        itemOnShelfSearchDto.setShopId(itemSkuListQueryReqDto.getShopId());
        itemOnShelfSearchDto.setBrandId(itemSkuListQueryReqDto.getBrandId());
        itemOnShelfSearchDto.setSubType(itemSkuListQueryReqDto.getSubType());
        if (null != itemSkuListQueryReqDto.getBusType()) {
            itemOnShelfSearchDto.setBusType(itemSkuListQueryReqDto.getBusType());
        } else {
            itemOnShelfSearchDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        Integer busType = itemOnShelfSearchDto.getBusType();
        RestResponse pageInfoRestResponse = this.iItemQueryApi.findItemOnSelf(JSON.toJSONString((Object)itemOnShelfSearchDto), pageNum, pageSize);
        PageInfo itemOnShelfRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.isNull(itemOnShelfRespDtoPageInfo) || CollectionUtils.isEmpty((Collection)itemOnShelfRespDtoPageInfo.getList())) {
            return new PageInfo();
        }
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        ArrayList<ItemSkuPriceConditionQueryReqDto> shopConditionList = new ArrayList<ItemSkuPriceConditionQueryReqDto>();
        for (ItemOnShelfRespDto itemRespDto : itemOnShelfRespDtoPageInfo.getList()) {
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(itemRespDto.getSkuId());
            itemStorageQueryDto.setShopId(itemRespDto.getShopId());
            itemStorageQueryDto.setCargoCode(itemRespDto.getCargoCode());
            itemStorageList.add(itemStorageQueryDto);
            ItemSkuPriceConditionQueryReqDto skuPriceConditionReqDto = new ItemSkuPriceConditionQueryReqDto();
            skuPriceConditionReqDto.setSkuId(itemRespDto.getSkuId());
            skuPriceConditionReqDto.setShopId(itemRespDto.getShopId());
            shopConditionList.add(skuPriceConditionReqDto);
        }
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
        ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
        itemSkuPriceQueryReqDto.setShopConditionList(shopConditionList);
        RestResponse listRestResponse = this.basePriceItemQueryApi.queryRetailSkuPrice(itemSkuPriceQueryReqDto);
        List skuPriceQueryRespList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<String, BigDecimal> finalCostRetailPriceMap = costRetailPriceMap = skuPriceQueryRespList.stream().filter(Objects::nonNull).filter(e -> e.getCostRetailPrice() != null).collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId(), ItemSkuPriceQueryRespDto::getCostRetailPrice, (o1, o2) -> o1));
        List itemSkuListRespDtos = itemOnShelfRespDtoPageInfo.getList().stream().map(bean -> {
            ItemSkuListRespDto itemSkuListRespDto = new ItemSkuListRespDto();
            BeanUtils.copyProperties((Object)bean, (Object)itemSkuListRespDto);
            itemSkuListRespDto.setId(null);
            itemSkuListRespDto.setItemNum(Long.valueOf(Objects.nonNull(itemSkuListRespDto.getWholesaleLimitMin()) ? itemSkuListRespDto.getWholesaleLimitMin() : 1L));
            Map skuAttr = (Map)ObjectHelper.Json2Bean((String)itemSkuListRespDto.getAttr(), Map.class);
            if (null != skuAttr) {
                String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                itemSkuListRespDto.setSkuName(skuDesc);
            } else {
                itemSkuListRespDto.setSkuName("");
            }
            Long balance = (Long)avaNumMap.get(bean.getShopId() + "_" + bean.getSkuId() + "_" + bean.getCargoCode());
            itemSkuListRespDto.setBalance(Long.valueOf(balance != null && balance > 0L ? balance : 0L));
            BigDecimal retailPrice = (BigDecimal)finalCostRetailPriceMap.get(bean.getShopId() + "_" + bean.getSkuId());
            if (Objects.nonNull(retailPrice)) {
                itemSkuListRespDto.setRetailPrice(retailPrice);
            }
            itemSkuListRespDto.setStock(itemSkuListRespDto.getBalance());
            itemSkuListRespDto.setSubType(bean.getItemSubType());
            itemSkuListRespDto.setBusType(busType);
            return itemSkuListRespDto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)itemOnShelfRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        result.setList(itemSkuListRespDtos);
        return result;
    }

    public PageInfo<ItemInfoRespDto> queryItemPageDepth(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5546\u54c1\u641c\u7d22\u5165\u53c2\uff1a{},\u5f53\u524d\u9875\uff1a{}, \u9875\u6570\u5927\u5c0f\uff1a{}", new Object[]{itemDepthReqDto, pageNum, pageSize});
        PageInfo itemInfoRespDtoPageInfo = this.bitemService.queryItemPageDepth(itemDepthReqDto, pageNum, pageSize);
        List list = itemInfoRespDtoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return itemInfoRespDtoPageInfo;
        }
        List<Long> shopIds = list.stream().filter(item -> Objects.nonNull(item.getShopId())).map(ItemInfoRespDto::getShopId).collect(Collectors.toList());
        this.setShoppingCartInfo(list, shopIds);
        this.bitemService.setItemPolicyPriceInfo(list);
        this.setStockSortAndItemActivity(itemDepthReqDto, (PageInfo<ItemInfoRespDto>)itemInfoRespDtoPageInfo);
        this.setActivityTypeName((PageInfo<ItemInfoRespDto>)itemInfoRespDtoPageInfo);
        this.setItemToInventory(itemDepthReqDto, list);
        this.bitemService.setItemPolicyPriceInfo(list);
        this.setStockSortAndItemActivity(itemDepthReqDto, (PageInfo<ItemInfoRespDto>)itemInfoRespDtoPageInfo);
        return itemInfoRespDtoPageInfo;
    }

    private void setActivityTypeName(PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo) {
        HashSet activityIds = Sets.newHashSet();
        for (ItemInfoRespDto itemInfoRespDto : itemInfoRespDtoPageInfo.getList()) {
            if (CollectionUtils.isEmpty((Collection)itemInfoRespDto.getTags())) continue;
            for (ItemActivityTagDto tag : itemInfoRespDto.getTags()) {
                activityIds.add(tag.getActivityId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)activityIds)) {
            return;
        }
        List activityRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds(new ArrayList(activityIds)));
        if (CollectionUtils.isNotEmpty((Collection)activityRespDtos)) {
            Map<Long, ActivityRespDto> activityRespDtoMap = activityRespDtos.stream().collect(Collectors.toMap(ActivityRespDto::getId, e -> e, (e1, e2) -> e1));
            for (ItemInfoRespDto itemInfoRespDto : itemInfoRespDtoPageInfo.getList()) {
                if (CollectionUtils.isEmpty((Collection)itemInfoRespDto.getTags())) continue;
                HashSet activityTypeNameSet = Sets.newHashSet();
                for (ItemActivityTagDto tag : itemInfoRespDto.getTags()) {
                    ActivityRespDto activityRespDto;
                    ActivityTypeTobEnum activityTypeTobEnum;
                    if (!activityRespDtoMap.containsKey(tag.getActivityId()) || (activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)(activityRespDto = activityRespDtoMap.get(tag.getActivityId())).getActivityTemplateId())) == null) continue;
                    activityTypeNameSet.add(activityTypeTobEnum.getTradeDesc());
                }
                itemInfoRespDto.setActivityTypeNameList(new ArrayList(activityTypeNameSet));
                activityTypeNameSet = null;
            }
        }
    }

    private void setStockSortAndItemActivity(ItemDepthQueryReqDto itemDepthReqDto, PageInfo<ItemInfoRespDto> itemPageInfo) {
        boolean activitySearch = false;
        if (null != itemDepthReqDto.getActivityId() || null != itemDepthReqDto.getCouponTpId()) {
            activitySearch = true;
        }
        this.bitemService.setItemActivityInfo(itemPageInfo.getList(), Boolean.valueOf(activitySearch), Boolean.valueOf(true), itemDepthReqDto.getCustomerIdList());
        ArrayList inStockList = new ArrayList();
        ArrayList outStockList = new ArrayList();
        itemPageInfo.getList().forEach(item -> {
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)item.getItemSkuList().get(0);
            if (item.isItemSkuSellState()) {
                if (Objects.nonNull(itemSkuRespDto) && itemSkuRespDto.getBalance() > 0L) {
                    inStockList.add(item);
                } else {
                    outStockList.add(item);
                }
            } else {
                outStockList.add(item);
            }
            if (CollectionUtils.isNotEmpty((Collection)item.getTags())) {
                item.setTagNum(Integer.valueOf(item.getTags().size()));
            } else {
                item.setTagNum(Integer.valueOf(0));
            }
        });
        List newInStockList = inStockList.stream().sorted(Comparator.comparing(ItemInfoRespDto::getTagNum, Comparator.reverseOrder())).collect(Collectors.toList());
        newInStockList.addAll(outStockList);
        itemPageInfo.setList(newInStockList);
    }

    public PageInfo<ItemInfoRespDto> queryExchangeItemPageDepth(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        if (itemDepthReqDto.getActivityId() == null) {
            throw new BizException("\u6362\u8d2d\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActivityRespDto activityRespDto = (ActivityRespDto)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryExchangeActivityDetailById(itemDepthReqDto.getActivityId()));
        logger.info("\u6362\u8d2d\u5546\u54c1\u5217\u8868\uff0c\u6362\u8d2d\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)activityRespDto);
        if (!SelectTypeEnum.ALL.getCode().equals(activityRespDto.getSelectType()) && CollectionUtils.isEmpty((Collection)activityRespDto.getActivityItemRespDtos())) {
            return new PageInfo();
        }
        ArrayList list = Lists.newArrayList();
        HashMap exchangeItemMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)activityRespDto.getActivityItemRespDtos())) {
            for (ActivityItemRespDto activityItemRespDto : activityRespDto.getActivityItemRespDtos()) {
                list.add(activityItemRespDto.getItemId());
                exchangeItemMap.put(activityItemRespDto.getItemId(), activityItemRespDto);
            }
        }
        itemDepthReqDto.setItemIds(StringUtils.join((Collection)list, (String)","));
        itemDepthReqDto.setActivityId(null);
        logger.info("\u6362\u8d2d\u5546\u54c1\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemDepthReqDto));
        PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo = this.queryItemPageDepth(itemDepthReqDto, pageNum, pageSize);
        if (itemInfoRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)itemInfoRespDtoPageInfo.getList())) {
            for (ItemInfoRespDto itemInfoRespDto : itemInfoRespDtoPageInfo.getList()) {
                itemInfoRespDto.setIfExchange(Integer.valueOf(1));
                if (!exchangeItemMap.containsKey(itemInfoRespDto.getItemId())) continue;
                ActivityItemRespDto itemRespDto = (ActivityItemRespDto)exchangeItemMap.get(itemInfoRespDto.getItemId());
                itemInfoRespDto.setExchangePrice(Optional.ofNullable(itemRespDto.getActivityPrice()).orElse(itemInfoRespDto.getSellPrice()));
            }
        }
        return itemInfoRespDtoPageInfo;
    }

    public List<TradeExchangeActivityRespDto> queryExchangeItemByActivityIds(TradeExchangeActivityReqDto tradeExchangeActivityReqDto) {
        if (CollectionUtils.isEmpty((Collection)tradeExchangeActivityReqDto.getActivityIds()) || tradeExchangeActivityReqDto.getShopId() == null) {
            throw new BizException("\u6d3b\u52a8id\u6216\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List activityRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryExchangeActivityDetailByIds(tradeExchangeActivityReqDto.getActivityIds()));
        logger.info("\u6279\u91cf\u6362\u8d2d\u5546\u54c1\u5217\u8868\uff0c\u6362\u8d2d\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)activityRespDtos);
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)activityRespDtos)) {
            HashSet itemIdSet = Sets.newHashSet();
            HashMap exchangeItemMap = Maps.newHashMap();
            for (ActivityRespDto activityRespDto : activityRespDtos) {
                if (!CollectionUtils.isNotEmpty((Collection)activityRespDto.getActivityItemRespDtos())) continue;
                for (ActivityItemRespDto activityItemRespDto : activityRespDto.getActivityItemRespDtos()) {
                    itemIdSet.add(activityItemRespDto.getItemId());
                    exchangeItemMap.put(activityItemRespDto.getItemId() + "#" + activityRespDto.getId(), activityItemRespDto);
                }
            }
            ItemDepthQueryReqDto itemDepthReqDto = new ItemDepthQueryReqDto();
            itemDepthReqDto.setItemIds(StringUtils.join((Collection)itemIdSet, (String)","));
            itemDepthReqDto.setShopId(tradeExchangeActivityReqDto.getShopId());
            logger.info("\u6362\u8d2d\u5546\u54c1\u5217\u8868\u5165\u53c2\uff1a{}", (Object)itemDepthReqDto);
            PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo = this.queryItemPageDepth(itemDepthReqDto, 1, itemIdSet.size());
            if (itemInfoRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)itemInfoRespDtoPageInfo.getList())) {
                Map<Long, ItemInfoRespDto> itemInfoRespDtoMap = itemInfoRespDtoPageInfo.getList().stream().collect(Collectors.toMap(ItemInfoRespDto::getItemId, e -> e, (e1, e2) -> e1));
                for (ActivityRespDto activityRespDto : activityRespDtos) {
                    TradeExchangeActivityRespDto tradeExchangeActivityRespDto = new TradeExchangeActivityRespDto();
                    tradeExchangeActivityRespDto.setActivityId(activityRespDto.getId());
                    tradeExchangeActivityRespDto.setActivityName(activityRespDto.getActivityName());
                    tradeExchangeActivityRespDto.setTag(activityRespDto.getTag());
                    ArrayList itemInfoList = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)activityRespDto.getActivityItemRespDtos())) {
                        for (ActivityItemRespDto activityItemRespDto : activityRespDto.getActivityItemRespDtos()) {
                            if (!itemInfoRespDtoMap.containsKey(activityItemRespDto.getItemId())) continue;
                            ItemInfoRespDto itemInfoRespDto = new ItemInfoRespDto();
                            CubeBeanUtils.copyProperties((Object)itemInfoRespDto, (Object)itemInfoRespDtoMap.get(activityItemRespDto.getItemId()), (String[])new String[0]);
                            itemInfoRespDto.setIfExchange(Integer.valueOf(1));
                            itemInfoRespDto.setExchangePrice(Optional.ofNullable(activityItemRespDto.getActivityPrice()).orElse(itemInfoRespDto.getSellPrice()));
                            itemInfoList.add(itemInfoRespDto);
                        }
                    }
                    tradeExchangeActivityRespDto.setItemInfoRespDtos((List)itemInfoList);
                    list.add(tradeExchangeActivityRespDto);
                }
            }
        }
        return list;
    }

    private Map<String, ShoppingCartItemRespDto> getShoppingCartInfo(List<Long> shopIds) {
        TrolleyQueryReqDto trolleyQueryReqDto = new TrolleyQueryReqDto();
        ShoppingCartRespDto shoppingCartRespDto = this.shoppingCart.queryUserItemList(trolleyQueryReqDto);
        if (Objects.isNull(shoppingCartRespDto)) {
            return MapUtil.empty();
        }
        List normalCartItemList = shoppingCartRespDto.getNormalCartItemList();
        if (CollUtil.isEmpty((Collection)normalCartItemList)) {
            return MapUtil.empty();
        }
        if (CollUtil.isNotEmpty(shopIds)) {
            HashSet<Long> shopIdSet = new HashSet<Long>(shopIds);
            normalCartItemList = normalCartItemList.stream().filter(item -> shopIdSet.contains(item.getShopId())).collect(Collectors.toList());
        }
        Map<String, ShoppingCartItemRespDto> skuMap = normalCartItemList.stream().collect(Collectors.toMap(sku -> sku.getShopId() + "-" + sku.getSkuId(), Function.identity(), (o1, o2) -> o2));
        return skuMap;
    }

    private void setShoppingCartInfo(List<ItemInfoRespDto> list, List<Long> shopIds) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        Map<String, ShoppingCartItemRespDto> skuMap = this.getShoppingCartInfo(shopIds);
        if (CollUtil.isEmpty(skuMap)) {
            return;
        }
        for (ItemInfoRespDto item : list) {
            Long shopId = item.getShopId();
            List itemSkuList = item.getItemSkuList();
            if (Objects.isNull(shopId) || CollUtil.isEmpty((Collection)itemSkuList)) continue;
            itemSkuList.forEach(skuInfo -> {
                Long skuId = skuInfo.getId();
                String key = shopId + "-" + skuId;
                if (skuMap.containsKey(key)) {
                    skuInfo.setShoppingCartItemNum(((ShoppingCartItemRespDto)skuMap.get(key)).getItemNum());
                    skuInfo.setShoppingCartItemId(((ShoppingCartItemRespDto)skuMap.get(key)).getId());
                } else {
                    skuInfo.setShoppingCartItemNum(Integer.valueOf(0));
                }
            });
        }
    }

    public String getMinimumAreaCode(Long customerId) {
        CustomerExtDetailRespDto customerExtDetailRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(customerId));
        logger.info("\u6839\u636e\u5ba2\u6237id:{}\u83b7\u53d6\u5ba2\u6237\u533a\u57df\u6570\u636e:{}", (Object)customerId, (Object)JSON.toJSONString((Object)customerExtDetailRespDto));
        List<String> areaCodeList = customerExtDetailRespDto.getRegionCodeList().stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            CustomerAreaSubTreeReqDto customerAreaSubTreeReqDto = new CustomerAreaSubTreeReqDto();
            customerAreaSubTreeReqDto.setOrgInfoId(customerExtDetailRespDto.getMerchantId());
            customerAreaSubTreeReqDto.setCode((String)areaCodeList.get(0));
            CustomerAreaTreeRespDto customerAreaTreeRespDto = (CustomerAreaTreeRespDto)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryForSubTree(customerAreaSubTreeReqDto));
            if (Objects.isNull(customerAreaSubTreeReqDto)) {
                logger.info("\u83b7\u53d6\u5ba2\u6237\u533a\u57df\u5b50\u6811\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                return "";
            }
            return this.getMinimumAreaCode(customerAreaTreeRespDto, areaCodeList);
        }
        return "";
    }

    public String getMinimumAreaCode(CustomerAreaTreeRespDto customerAreaTreeRespDto, List<String> areaCodeList) {
        if (Objects.isNull(customerAreaTreeRespDto)) {
            return "";
        }
        if (CollectionUtils.isNotEmpty((Collection)customerAreaTreeRespDto.getChildren())) {
            CustomerAreaTreeRespDto customerAreaTreeResp = customerAreaTreeRespDto.getChildren().stream().filter(children -> areaCodeList.contains(children.getCode())).findFirst().orElse(new CustomerAreaTreeRespDto());
            return this.getMinimumAreaCode(customerAreaTreeResp, areaCodeList);
        }
        return customerAreaTreeRespDto.getCode();
    }

    public ItemDetailInfoRespDto queryItemDetail(Long id, Long shopId, Integer busType, Long customerId) {
        Long inventory;
        Map<Long, Long> itemIdToInventoryMap;
        ItemDetailInfoRespDto itemDetailInfoRespDto = this.bitemService.queryItemDetail(id, shopId, busType, customerId);
        if (Objects.isNull(itemDetailInfoRespDto)) {
            return null;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerApi.queryById(customerId));
        boolean sellerDelivery = this.deliveryRuleUtils.isSellerDelivery(customerRespDto);
        ItemBaseInfoRespDto itemBaseInfo = itemDetailInfoRespDto.getItemBaseInfo();
        itemBaseInfo.setDeliveryType(sellerDelivery ? OrderDeliveryTypeEnum.SELLER.getType() : OrderDeliveryTypeEnum.FACTORY.getType());
        if (null != customerId && !(itemIdToInventoryMap = this.checkControlRule(Collections.singletonList(id), customerId)).isEmpty() && null != (inventory = itemIdToInventoryMap.get(id))) {
            long balance = ((ItemSkuInfoRespDto)itemBaseInfo.getItemSkuList().get(0)).getBalance() - inventory;
            balance = balance < 0L ? 0L : balance;
            ((ItemSkuInfoRespDto)itemBaseInfo.getItemSkuList().get(0)).setBalance(Long.valueOf(balance));
        }
        if (Objects.isNull(itemBaseInfo)) {
            return itemDetailInfoRespDto;
        }
        this.setSimpleLimitMinPurchaseNum(itemBaseInfo, customerRespDto);
        this.setActivityAttachInfo(itemDetailInfoRespDto.getActivityInfoRespDto());
        List itemSkuList = itemBaseInfo.getItemSkuList();
        if (CollUtil.isEmpty((Collection)itemSkuList)) {
            return itemDetailInfoRespDto;
        }
        Map<String, ShoppingCartItemRespDto> skuMap = this.getShoppingCartInfo(ListUtil.toList((Object[])new Long[]{shopId}));
        if (CollUtil.isEmpty(skuMap)) {
            return itemDetailInfoRespDto;
        }
        for (ItemSkuInfoRespDto itemSkuInfoRespDto : itemSkuList) {
            String key = shopId + "-" + itemSkuInfoRespDto.getId();
            if (skuMap.containsKey(key)) {
                itemSkuInfoRespDto.setShoppingCartItemNum(skuMap.get(key).getItemNum());
                itemSkuInfoRespDto.setShoppingCartItemId(skuMap.get(key).getId());
                continue;
            }
            itemSkuInfoRespDto.setShoppingCartItemNum(Integer.valueOf(0));
        }
        SupportSingleItemDto supportSingleItemDto = new SupportSingleItemDto();
        supportSingleItemDto.setItemIds((List)Lists.newArrayList((Object[])new Long[]{id}));
        supportSingleItemDto.setShopIds((List)Lists.newArrayList((Object[])new Long[]{shopId}));
        supportSingleItemDto.setCustomerRespDtos((List)Lists.newArrayList((Object[])new CustomerRespDto[]{customerRespDto}));
        List notSupportSingleItem = this.bitemService.getNotSupportSingleItem(supportSingleItemDto);
        itemDetailInfoRespDto.setSupportSingleBuy(Integer.valueOf(CollectionUtils.isEmpty((Collection)notSupportSingleItem) ? 0 : 1));
        return itemDetailInfoRespDto;
    }

    public Map<Long, Long> checkControlRule(List<Long> itemIdList, Long customerId) {
        logger.info("\u8fdb\u5165\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\uff0citemId={},customerId={}", (Object)JSON.toJSONString(itemIdList), (Object)customerId);
        List<Long> customerIdList = Collections.singletonList(customerId);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryListByCustomerIds(customerIdList));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u5ba2\u6237{}\u4e0d\u5b58\u5728", (Object)customerId);
            return new HashMap<Long, Long>();
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        CustomerControlInventoryReqDto reqDto = new CustomerControlInventoryReqDto();
        reqDto.setCustomerId(customerId);
        reqDto.setItemIdList(itemIdList);
        reqDto.setOrgId(customerRespDto.getMerchantId());
        List areaCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(areaCodeList);
            List parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
                reqDto.setCustomerAreaCodeList(parentAreaCodeList);
            }
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u89c4\u5219\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        List controlInventoryItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlInventoryQueryApi.queryRuleByCustomerNew(reqDto));
        if (CollectionUtils.isEmpty((Collection)controlInventoryItemRespDtos)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u4fe1\u606f");
            return new HashMap<Long, Long>();
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u89c4\u5219\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)controlInventoryItemRespDtos));
        HashMap<Long, Long> controlInventoryItemMap = new HashMap<Long, Long>();
        Map<Long, List<ControlInventoryItemRespDto>> itemControlMap = controlInventoryItemRespDtos.stream().collect(Collectors.groupingBy(ControlInventoryItemRespDto::getItemId));
        for (Long itemId : itemControlMap.keySet()) {
            List itemRuleList = itemControlMap.get(itemId).stream().sorted(Comparator.comparing(BaseRuleRespDto::getRuleSort)).collect(Collectors.toList());
            ControlInventoryItemRespDto controlInventoryItemRespDto = (ControlInventoryItemRespDto)itemRuleList.get(0);
            Integer floorInventoryCount = controlInventoryItemRespDto.getFloorInventoryCount();
            Long inventory = 0L;
            if (null != floorInventoryCount) {
                inventory = (long)floorInventoryCount;
            }
            controlInventoryItemMap.put(itemId, inventory);
        }
        logger.info("\u7ba1\u63a7\u5546\u54c1key\u4e3aid, value\u4e3a\u5b89\u5168\u5e93\u5b58:{}", (Object)JSON.toJSONString(controlInventoryItemMap));
        return controlInventoryItemMap;
    }

    private void setActivityAttachInfo(ItemForActivityInfoRespDto itemForActivityInfo) {
        if (Objects.isNull(itemForActivityInfo)) {
            return;
        }
        List orderActivityInfoList = itemForActivityInfo.getOrderActivityInfo();
        if (CollUtil.isNotEmpty((Collection)orderActivityInfoList)) {
            orderActivityInfoList.forEach(itemActivityInfo -> {
                String activityType;
                Long activityId = itemActivityInfo.getId();
                XCXFullActivityRespDto xcxFullActivityRespDto = (XCXFullActivityRespDto)RestResponseHelper.extractData((RestResponse)this.ixcxActivity.queryActivityDetail(activityId, activityType = itemActivityInfo.getActivityType().name()));
                if (Objects.nonNull(xcxFullActivityRespDto)) {
                    Integer selectType = xcxFullActivityRespDto.getSelectType();
                    Integer promotionMethod = xcxFullActivityRespDto.getPromotionMethod();
                    List fullRuleDecList = xcxFullActivityRespDto.getFullRuleDecList();
                    itemActivityInfo.setPromotionMethod(promotionMethod);
                    itemActivityInfo.setSelectType(selectType);
                    itemActivityInfo.setFullRuleDec(fullRuleDecList);
                }
            });
        }
    }

    public PageInfo<ItemSkuInfoDto> queryItemPageForNear(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        PageInfo itemSkuInfoDtoPageInfo = this.bitemService.queryItemPageForNear(itemDepthReqDto, pageNum, pageSize);
        List list = itemSkuInfoDtoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return itemSkuInfoDtoPageInfo;
        }
        this.setActivityTypeNameForNear(list);
        List<Long> shopIds = list.stream().filter(item -> Objects.nonNull(item.getShopId())).map(ItemSkuInfoDto::getShopId).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        if (CollUtil.isEmpty(shopIds)) {
            return itemSkuInfoDtoPageInfo;
        }
        Map<String, ShoppingCartItemRespDto> skuMap = this.getShoppingCartInfo(shopIds);
        if (CollUtil.isEmpty(skuMap)) {
            return itemSkuInfoDtoPageInfo;
        }
        List<Long> itemIds = list.stream().map(ItemSkuInfoDto::getItemId).collect(Collectors.toList());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerApi.queryCustomerRespDto(Collections.singletonList(itemDepthReqDto.getShopId())));
        Map<Object, Object> itemIdToInventoryMap = new HashMap();
        Integer ifWholeCase = null;
        Integer deliveryType = null;
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
            if (null != customerRespDto.getId()) {
                itemIdToInventoryMap = this.checkControlRule(itemIds, customerRespDto.getId());
            }
            ifWholeCase = customerRespDto.getIfWholeCasePurchase();
            deliveryType = customerRespDto.getDeliverMethod();
        }
        for (ItemSkuInfoDto itemSkuInfoDto : list) {
            Long inventory;
            String key = itemSkuInfoDto.getShopId() + "-" + itemSkuInfoDto.getSkuId();
            if (skuMap.containsKey(key)) {
                itemSkuInfoDto.setShoppingCartItemNum(skuMap.get(key).getItemNum());
                itemSkuInfoDto.setShoppingCartItemId(skuMap.get(key).getId());
            } else {
                itemSkuInfoDto.setShoppingCartItemNum(Integer.valueOf(0));
            }
            if (!itemIdToInventoryMap.isEmpty() && null != (inventory = (Long)itemIdToInventoryMap.get(itemSkuInfoDto.getItemId()))) {
                long balance = itemSkuInfoDto.getBalance() - inventory;
                balance = balance < 0L ? 0L : balance;
                itemSkuInfoDto.setBalance(Long.valueOf(balance));
            }
            itemSkuInfoDto.setDeliveryType(deliveryType);
            this.setLimitMinPurchaseNum(itemSkuInfoDto, ifWholeCase);
        }
        try {
            this.bitemService.setSkuPolicyPriceInfo(itemSkuInfoDtoPageInfo.getList(), itemDepthReqDto.getCustomerIdList());
        }
        catch (Exception e) {
            logger.error("[\u4ef7\u683c\u67e5\u8be2] >>> \u67e5\u4ef7\u5931\u8d25", (Throwable)e);
        }
        return itemSkuInfoDtoPageInfo;
    }

    private void setSimpleLimitMinPurchaseNum(ItemBaseInfoRespDto itemBaseInfo, CustomerRespDto customerRespDto) {
        String ifWholeCasePurchaseRemark;
        logger.info("\u5546\u54c1\u8be6\u60c5\u8bbe\u7f6e\u6574\u7bb1\u8d77\u8ba2");
        if (customerRespDto != null && customerRespDto.getIfWholeCasePurchase() != null) {
            itemBaseInfo.setIfWholeCasePurchase(customerRespDto.getIfWholeCasePurchase());
        }
        if (CollectionUtils.isEmpty((Collection)itemBaseInfo.getItemSkuList())) {
            ifWholeCasePurchaseRemark = "\u5546\u54c1Sku\u94fe\u8868\u4e3a\u7a7a\uff0c\u8d77\u8ba2\u91cf\u9ed8\u8ba4\u4e3a1";
        } else {
            ItemSkuInfoRespDto itemSkuInfoDto = (ItemSkuInfoRespDto)itemBaseInfo.getItemSkuList().get(0);
            if (IfWholeCasePurchaseEnum.YES.getCode().equals(itemBaseInfo.getIfWholeCasePurchase())) {
                if (itemSkuInfoDto.getMinPackage() != null) {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u3002\u53d6\u6700\u5c0f\u5305\u88c5\u6570";
                    itemBaseInfo.setLimitMinPurchaseNum(itemSkuInfoDto.getMinPackage());
                } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(itemSkuInfoDto.getLimitMinMode())) {
                    itemBaseInfo.setLimitMinPurchaseNum(itemSkuInfoDto.getLimitMin());
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
                } else {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u500d\u6570\u63a7\u5236\u60c5\u51b5\u4e0b\u9ed8\u8ba4\u4e3a1";
                }
            } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(itemSkuInfoDto.getLimitMinMode())) {
                itemBaseInfo.setLimitMinPurchaseNum(itemSkuInfoDto.getLimitMin());
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf\u6a21\u5f0f\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
            } else if (LimitMinModeEnum.MULTIPLE.getCode().equals(itemSkuInfoDto.getLimitMinMode())) {
                if (itemSkuInfoDto.getMinPackage() != null && itemSkuInfoDto.getLimitMin() != null) {
                    itemBaseInfo.setLimitMinPurchaseNum(Integer.valueOf(itemSkuInfoDto.getLimitMin() * itemSkuInfoDto.getMinPackage()));
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u65f6\u8ba1\u7b97\u51fa\u76f8\u4e58\u7684\u8d77\u8ba2\u91cf";
                } else {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236\uff0c\u4f46\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u4e0b\u9ed8\u8ba4\u4e3a1";
                }
            } else {
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u4e3a1";
            }
        }
        if (MapUtils.isNotEmpty((Map)itemBaseInfo.getExtFields())) {
            itemBaseInfo.getExtFields().put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
            itemBaseInfo.setExtFields(map);
        }
    }

    private void setLimitMinPurchaseNum(ItemSkuInfoDto itemSkuInfoDto, Integer ifWholeCase) {
        String ifWholeCasePurchaseRemark;
        if (ifWholeCase != null) {
            itemSkuInfoDto.setIfWholeCasePurchase(ifWholeCase);
        }
        if (IfWholeCasePurchaseEnum.YES.getCode().equals(ifWholeCase)) {
            if (itemSkuInfoDto.getMinPackage() != null) {
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u3002\u53d6\u6700\u5c0f\u5305\u88c5\u6570";
                itemSkuInfoDto.setLimitMinPurchaseNum(itemSkuInfoDto.getMinPackage());
            } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(itemSkuInfoDto.getLimitMinMode())) {
                itemSkuInfoDto.setLimitMinPurchaseNum(itemSkuInfoDto.getLimitMin());
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
            } else {
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u500d\u6570\u63a7\u5236\u60c5\u51b5\u4e0b\u9ed8\u8ba4\u4e3a1";
            }
        } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(itemSkuInfoDto.getLimitMinMode())) {
            itemSkuInfoDto.setLimitMinPurchaseNum(itemSkuInfoDto.getLimitMin());
            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf\u6a21\u5f0f\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
        } else if (LimitMinModeEnum.MULTIPLE.getCode().equals(itemSkuInfoDto.getLimitMinMode())) {
            if (itemSkuInfoDto.getMinPackage() != null && itemSkuInfoDto.getLimitMin() != null) {
                itemSkuInfoDto.setLimitMinPurchaseNum(Integer.valueOf(itemSkuInfoDto.getLimitMin() * itemSkuInfoDto.getMinPackage()));
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u65f6\u8ba1\u7b97\u51fa\u76f8\u4e58\u7684\u8d77\u8ba2\u91cf";
            } else {
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236\uff0c\u4f46\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u4e0b\u9ed8\u8ba4\u4e3a1";
            }
        } else {
            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u4e3a1";
        }
        if (MapUtils.isNotEmpty((Map)itemSkuInfoDto.getExtFields())) {
            itemSkuInfoDto.getExtFields().put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
            itemSkuInfoDto.setExtFields(map);
        }
    }

    private void setActivityTypeNameForNear(List<ItemSkuInfoDto> list) {
        List activityRespDtos;
        HashSet activityIds = Sets.newHashSet();
        list.stream().forEach(e -> {
            if (CollectionUtils.isNotEmpty((Collection)e.getTags())) {
                for (ItemActivityTagDto tag : e.getTags()) {
                    activityIds.add(tag.getActivityId());
                }
            }
        });
        logger.info("\u6240\u67e5\u8be2\u6d3b\u52a8ID:{}", (Object)activityIds);
        if (CollectionUtils.isNotEmpty((Collection)activityIds) && CollectionUtils.isNotEmpty((Collection)(activityRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds(activityIds.stream().collect(Collectors.toList())))))) {
            Map<Long, ActivityRespDto> activityRespDtoMap = activityRespDtos.stream().collect(Collectors.toMap(ActivityRespDto::getId, e -> e, (e1, e2) -> e1));
            List activityLogList = activityRespDtoMap.values().stream().map(e -> {
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("activityId", e.getId());
                map.put("templateId", e.getActivityTemplateId());
                return map;
            }).collect(Collectors.toList());
            logger.info("\u6d3b\u52a8ID\u4e0e\u6d3b\u52a8\u6a21\u677fID\u5bf9\u5e94\u5173\u7cfb:{}", activityLogList);
            for (ItemSkuInfoDto itemSkuInfoDto : list) {
                if (CollectionUtils.isEmpty((Collection)itemSkuInfoDto.getTags())) continue;
                HashSet activityTypeNameSet = Sets.newHashSet();
                for (ItemActivityTagDto tag : itemSkuInfoDto.getTags()) {
                    ActivityRespDto activityRespDto;
                    ActivityTypeTobEnum activityTypeTobEnum;
                    if (!activityRespDtoMap.containsKey(tag.getActivityId()) || (activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)(activityRespDto = activityRespDtoMap.get(tag.getActivityId())).getActivityTemplateId())) == null) continue;
                    activityTypeNameSet.add(activityTypeTobEnum.getTradeDesc());
                }
                itemSkuInfoDto.setActivityTypeNameList(new ArrayList(activityTypeNameSet));
            }
        }
    }

    public PageInfo<ItemInfoRespDto> queryItemPageForHomepage(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        PageInfo itemSkuInfoDtoPageInfo = this.bitemService.queryItemPageForHomepage(itemDepthReqDto, pageNum, pageSize);
        return itemSkuInfoDtoPageInfo;
    }

    public Long queryVirStorage(Long shopId, Long skuId) {
        ItemStorageQueryReqDto itemStorageQueryReqDto = new ItemStorageQueryReqDto();
        itemStorageQueryReqDto.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        itemStorageQueryReqDto.setTenantId(this.context.tenantId());
        itemStorageQueryReqDto.setInstanceId(this.context.instanceId());
        itemStorageQueryReqDto.setShopId(shopId);
        String filters = ObjectHelper.bean2Json((Object)itemStorageQueryReqDto);
        List virStorageList = (List)this.itemStorageQueryApi.queryItemStorage(filters).getData();
        if (CollectionUtils.isEmpty((Collection)virStorageList)) {
            return 0L;
        }
        Long storage = ((ItemStorageQueryRespDto)virStorageList.get(0)).getAvaNum();
        logger.info("\u67e5\u8be2\u865a\u62df\u5e93\u5b58shopId={}, skuId = {},storage={}", new Object[]{shopId, skuId, storage});
        return storage;
    }

    private ItemSkuListRespDto buildItemSkuListRespDto(ItemOnShelfRespDto itemOnShelfRespDto) {
        ItemSkuListRespDto itemSkuListRespDto = new ItemSkuListRespDto();
        BeanUtils.copyProperties((Object)itemOnShelfRespDto, (Object)itemSkuListRespDto);
        itemSkuListRespDto.setId(null);
        return itemSkuListRespDto;
    }

    public CommonImportRespDto importBatchOrder(String url, Long shopId) {
        if (shopId == null) {
            throw new BizException("\u5e97\u94faid\u5fc5\u4f20");
        }
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setNeedVerfiy(false);
        ArrayList exportOrderVos = ListUtil.toList((Object[])new BatchExportOrderVo[0]);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)URLUtil.getStream((URL)URLUtil.url((String)url)), BatchImportOrderVo.class, (ImportParams)importParams);
            if (CollectionUtils.isEmpty((Collection)result.getList())) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
            CubeBeanUtils.copyCollection((Collection)exportOrderVos, (Collection)result.getList(), BatchExportOrderVo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList itemCodeList = ListUtil.toList((Object[])new String[0]);
        for (BatchExportOrderVo vo : exportOrderVos) {
            if (!StringUtils.isNotBlank((String)vo.getItemCode())) continue;
            itemCodeList.add(StringUtils.trimToEmpty((String)vo.getItemCode()));
        }
        if (CollectionUtils.isEmpty((Collection)itemCodeList)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u5217\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemSkuRelRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.iItemQueryApi.queryItemSkuRelByCodes((List)itemCodeList));
        List<ItemStorageQueryDto> itemStorageQueryDtos = this.listStorage(itemSkuRelRespDtoList, shopId);
        logger.info("\u5546\u54c1\u6570\u636e\u548c\u5e93\u5b58\u6570\u636e\uff1ashopId = {}, exportOrderVos = {} , itemSkuRelRespDtoList = {} , itemStorageQueryDtos = {}", new Object[]{shopId, JSONObject.toJSONString((Object)exportOrderVos), JSONObject.toJSONString((Object)itemSkuRelRespDtoList), JSONObject.toJSONString(itemStorageQueryDtos)});
        StringBuffer errorMsg = null;
        ItemSkuRelRespDto itemSkuRel = null;
        ShoppingCartItemReqDto reqDto = null;
        boolean sellerDelivery = this.deliveryRuleUtils.isSellerDelivery(Lists.newArrayList((Object[])new Long[]{shopId}));
        boolean error = false;
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList cartItemReqDtos = ListUtil.toList((Object[])new ShoppingCartItemReqDto[0]);
        for (int i = 0; i < exportOrderVos.size(); ++i) {
            boolean stocked;
            BatchExportOrderVo vo = (BatchExportOrderVo)exportOrderVos.get(i);
            if (ObjectUtil.isEmpty((Object)vo.getItemNum())) continue;
            errorMsg = new StringBuffer();
            if (StringUtils.isBlank((String)vo.getItemCode())) {
                errorMsg.append("\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff1b");
            } else {
                itemSkuRel = this.validateItemCodeExits(StringUtils.trimToEmpty((String)vo.getItemCode()), itemSkuRelRespDtoList);
                if (itemSkuRel == null) {
                    errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                }
            }
            if (!NumberFormatUtils.isPositiveInteger(vo.getItemNum())) {
                errorMsg.append("\u8d2d\u4e70\u6570\u91cf\u4ec5\u652f\u6301\u5927\u4e8e0\u7684\u6b63\u6574\u6570\uff1b");
            } else if (sellerDelivery && !(stocked = this.validateStorage(itemStorageQueryDtos, itemSkuRel.getSkuId(), Long.valueOf(vo.getItemNum()), cartItemReqDtos))) {
                errorMsg.append("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff1b");
            }
            if (StringUtils.isNotBlank((String)errorMsg.toString())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c" + errorMsg.toString() + "\r\n");
                vo.setErrorMsg(errorMsg.toString());
                error = true;
                continue;
            }
            reqDto = new ShoppingCartItemReqDto();
            reqDto.setItemId(itemSkuRel.getItemId());
            if (StringUtils.isEmpty((String)vo.getItemName())) {
                reqDto.setItemName(itemSkuRel.getItemName());
            } else {
                reqDto.setItemName(vo.getItemName());
            }
            reqDto.setItemNum(Integer.valueOf(vo.getItemNum()));
            reqDto.setShopId(shopId);
            reqDto.setSkuId(itemSkuRel.getSkuId());
            this.handShoppingCartItemList(cartItemReqDtos, reqDto);
        }
        CommonImportRespDto importRespDto = new CommonImportRespDto();
        if (error) {
            importRespDto.setFlag(Boolean.valueOf(false));
            importRespDto.setMsg(Arrays.asList("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e"));
            importRespDto.setMsg(msg);
            importRespDto.setUrl(this.exportBatchOrderResult(exportOrderVos));
            return importRespDto;
        }
        logger.info("\u5bfc\u5165\u8ba2\u5355\uff1ashopId = {}, cartItemReqDtos = {}", (Object)shopId, (Object)JSONObject.toJSONString((Object)cartItemReqDtos));
        CartItemBatchReqDto cartItemBatchReqDto = new CartItemBatchReqDto();
        cartItemBatchReqDto.setCartItemList((List)cartItemReqDtos);
        this.shoppingCart.addItemImport(cartItemBatchReqDto, shopId);
        importRespDto.setFlag(Boolean.valueOf(true));
        return importRespDto;
    }

    private boolean validateStorage(List<ItemStorageQueryDto> itemStorageQueryDtos, Long skuId, Long itemNum, List<ShoppingCartItemReqDto> cartItemReqDtos) {
        for (ShoppingCartItemReqDto cartItem : cartItemReqDtos) {
            if (!Objects.equals(cartItem.getSkuId(), skuId)) continue;
            itemNum = itemNum + (long)cartItem.getItemNum().intValue();
        }
        for (ItemStorageQueryDto storage : itemStorageQueryDtos) {
            if (!Objects.equals(storage.getSkuId(), skuId)) continue;
            if (storage.getAvaNum() == null) {
                return true;
            }
            if (storage.getAvaNum() < itemNum) continue;
            return true;
        }
        return false;
    }

    private List<ItemStorageQueryDto> listStorage(List<ItemSkuRelRespDto> itemSkuRelRespDtoList, Long shopId) {
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>(1);
        for (ItemSkuRelRespDto sku : itemSkuRelRespDtoList) {
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(sku.getSkuId());
            itemStorageQueryDto.setShopId(shopId);
            itemStorageQueryDto.setCargoCode(sku.getLongCode());
            itemStorageList.add(itemStorageQueryDto);
        }
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        return itemStorageQueryDtos;
    }

    private void handShoppingCartItemList(List<ShoppingCartItemReqDto> cartItemReqDtos, ShoppingCartItemReqDto reqDto) {
        boolean isExits = false;
        for (ShoppingCartItemReqDto cartItem : cartItemReqDtos) {
            if (!Objects.equals(cartItem.getSkuId(), reqDto.getSkuId())) continue;
            cartItem.setItemNum(Integer.valueOf(cartItem.getItemNum() + reqDto.getItemNum()));
            isExits = true;
        }
        if (!isExits) {
            cartItemReqDtos.add(reqDto);
        }
    }

    private ItemSkuRelRespDto validateItemCodeExits(String itemCode, List<ItemSkuRelRespDto> itemSkuRelRespDtoList) {
        if (CollectionUtils.isEmpty(itemSkuRelRespDtoList)) {
            return null;
        }
        for (ItemSkuRelRespDto isr : itemSkuRelRespDtoList) {
            if (!Objects.equals(isr.getCode(), itemCode)) continue;
            return isr;
        }
        return null;
    }

    public CommonImportRespDto importBatchOrderHis(String url, Long shopId) {
        CommonImportRespDto importRespDto = new CommonImportRespDto();
        boolean flag = true;
        ArrayList<String> msg = new ArrayList<String>();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setNeedVerfiy(false);
        HashMap itemMap = MapUtil.newHashMap();
        List importOrderVos = ListUtil.toList((Object[])new BatchImportOrderVo[0]);
        ArrayList exportOrderVos = ListUtil.toList((Object[])new BatchExportOrderVo[0]);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)URLUtil.getStream((URL)URLUtil.url((String)url)), BatchImportOrderVo.class, (ImportParams)importParams);
            importOrderVos = result.getList();
            if (CollectionUtils.isEmpty((Collection)importOrderVos)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
            CubeBeanUtils.copyCollection((Collection)exportOrderVos, (Collection)importOrderVos, BatchExportOrderVo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        CartItemBatchReqDto cartItemBatchReqDto = new CartItemBatchReqDto();
        ArrayList cartItemReqDtos = ListUtil.toList((Object[])new ShoppingCartItemReqDto[0]);
        for (int i = 0; i < importOrderVos.size(); ++i) {
            BatchImportOrderVo orderVo = (BatchImportOrderVo)importOrderVos.get(i);
            BatchExportOrderVo exportOrderVo = (BatchExportOrderVo)exportOrderVos.get(i);
            ItemRespDto itemRespDto = null;
            ItemDetailRespDto itemDetailRespDto = null;
            StringBuffer errorMsg = new StringBuffer();
            if (ObjectUtil.isEmpty((Object)orderVo.getItemCode())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff1b");
                errorMsg.append("\u5546\u54c1\u7f16\u7801\u672a\u586b\u5199\uff1b");
                flag = false;
            } else if (!itemMap.containsKey(orderVo.getItemCode())) {
                itemRespDto = (ItemRespDto)RestResponseHelper.extractData((RestResponse)this.iItemQueryApi.queryByItemCode(orderVo.getItemCode()));
                if (ObjectUtil.isEmpty((Object)itemRespDto.getId())) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                    errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                    flag = false;
                } else {
                    itemDetailRespDto = (ItemDetailRespDto)RestResponseHelper.extractData((RestResponse)this.iItemQueryApi.queryItemDetail(itemRespDto.getId(), "sku,medias", null));
                    if (ObjectUtil.isEmpty((Object)itemDetailRespDto)) {
                        msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                        errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                        flag = false;
                    } else if (CollUtil.isEmpty((Collection)itemDetailRespDto.getItemSkuList())) {
                        msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                        errorMsg.append("\u5546\u54c1\u4e0d\u5b58\u5728\uff1b");
                        flag = false;
                    }
                }
            }
            if (ObjectUtil.isEmpty((Object)orderVo.getItemNum())) continue;
            if (Integer.valueOf(orderVo.getItemNum()) <= 0) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8d2d\u4e70\u6570\u91cf\u4ec5\u652f\u6301\u6b63\u6574\u6570\uff1b");
                errorMsg.append("\u8d2d\u4e70\u6570\u91cf\u4ec5\u652f\u6301\u6b63\u6574\u6570\uff1b");
                flag = false;
            }
            exportOrderVo.setErrorMsg(errorMsg.toString());
            if (!flag) continue;
            ShoppingCartItemReqDto reqDto = new ShoppingCartItemReqDto();
            reqDto.setItemId(itemRespDto.getId());
            reqDto.setItemName(itemRespDto.getName());
            reqDto.setItemNum(Integer.valueOf(orderVo.getItemNum()));
            reqDto.setShopId(shopId);
            reqDto.setSkuId(((ItemSkuRespDto)itemDetailRespDto.getItemSkuList().get(0)).getId());
            cartItemReqDtos.add(reqDto);
        }
        if (!flag) {
            importRespDto.setFlag(Boolean.valueOf(false));
            importRespDto.setMsg(msg);
            importRespDto.setUrl(this.exportBatchOrderResult(exportOrderVos));
            return importRespDto;
        }
        cartItemBatchReqDto.setCartItemList((List)cartItemReqDtos);
        this.shoppingCart.addItemBatch(cartItemBatchReqDto);
        importRespDto.setFlag(Boolean.valueOf(true));
        if (CollectionUtil.isNotEmpty(msg)) {
            importRespDto.setMsg(msg);
        }
        return importRespDto;
    }

    public String exportBatchOrderTemplate(Long shopId) {
        PageInfo<ItemInfoRespDto> info;
        String fileName = "\u6279\u91cf\u5bfc\u5165\u4e0b\u5355V1.0.0_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
        BatchImportOrderTemplateExport export = new BatchImportOrderTemplateExport(fileName, "", this.objectStorageService, this.context, shopId);
        logger.info("\u67e5\u8be2\u4e0b\u5355\u5bfc\u5165\u6a21\u677f\u7684\u5e97\u94faid\u4e3a[{}]", (Object)shopId);
        ItemDepthQueryReqDto itemDepthReqDto = new ItemDepthQueryReqDto();
        itemDepthReqDto.setShopId(shopId);
        logger.info("\u67e5\u8be2\u4e0b\u5355\u5bfc\u5165\u6a21\u677f\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)JSON.toJSONString((Object)itemDepthReqDto));
        ArrayList orderVoList = ListUtil.toList((Object[])new BatchExportOrderVo[0]);
        int maxPageSize = 10000;
        int pageNum = 1;
        do {
            logger.info("\u67e5\u8be2\u4e0b\u5355\u5bfc\u5165\u6a21\u677f\u7684\u5206\u9875\u53c2\u6570\u4e3apageNum=[{}]maxPageSize=[{}]", (Object)pageNum, (Object)maxPageSize);
            info = this.queryItemPageDepth(itemDepthReqDto, pageNum, maxPageSize);
            logger.info("\u67e5\u8be2\u4e0b\u5355\u5bfc\u5165\u6a21\u677f\u7684\u54cd\u5e94\u7ed3\u679c=[{}]", (Object)JSON.toJSONString(info));
            ++pageNum;
            List dtos = info.getList();
            if (!CollUtil.isNotEmpty((Collection)dtos)) continue;
            logger.info("\u67e5\u8be2\u4e0b\u5355\u5bfc\u5165\u6a21\u677f\u7684\u5728\u552e\u5546\u54c1\u6570\u91cf\u4e3a[{}]", (Object)dtos.size());
            for (ItemInfoRespDto itemInfoRespDto : dtos) {
                BatchExportOrderVo orderVo = new BatchExportOrderVo();
                orderVo.setItemCode(itemInfoRespDto.getCode());
                orderVo.setItemName(itemInfoRespDto.getName());
                orderVoList.add(orderVo);
            }
        } while (CollUtil.isNotEmpty((Collection)info.getList()));
        logger.info("\u67e5\u8be2\u4e0b\u5355\u5bfc\u5165\u6a21\u677f\u7684\u6700\u7ec8\u7ed3\u679c\u5927\u5c0f=[{}]", (Object)orderVoList.size());
        ((AbstractDataExport)export).setDataList(orderVoList);
        return ((AbstractDataExport)export).getExportUrl();
    }

    private String exportBatchOrderResult(List<BatchExportOrderVo> list) {
        String fileName = "\u6279\u91cf\u5bfc\u5165\u4e0b\u5355\u9519\u8bef\u53cd\u9988V1.0.0_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
        BatchImportOrderTemplateExport export = new BatchImportOrderTemplateExport(fileName, "", this.objectStorageService, this.context, null);
        ((AbstractDataExport)export).setDataList(list);
        return ((AbstractDataExport)export).getExportUrl();
    }

    public ImportItemRespDto queryImportItem(OrderItemImportReqDto orderItemImportReqDto) {
        this.validateParam(orderItemImportReqDto);
        List importItemInfoDtos = null;
        try {
            InputStream is = this.getInputStream(orderItemImportReqDto.getUrl());
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, ImportItemInfoDto.class);
            importItemInfoDtos = objectExcelImportResult.getList();
            logger.info("\u5bfc\u5165\u4fe1\u606f\uff1a{}", (Object)importItemInfoDtos);
            if (CollectionUtils.isEmpty((Collection)importItemInfoDtos)) {
                logger.info("\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a");
                return null;
            }
        }
        catch (Exception e3) {
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u7f16\u7801\u5217\u8868\u89e3\u6790\u5931\u8d25\uff1a" + e3.getMessage());
        }
        Integer totalImportNum = importItemInfoDtos.size();
        if (totalImportNum > 1000) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u5927\u4e8e1000\u6761");
        }
        HashSet itemCodes = Sets.newHashSet();
        HashMap map = Maps.newHashMap();
        for (ImportItemInfoDto importItemInfoDto : importItemInfoDtos) {
            itemCodes.add(importItemInfoDto.getCode());
            map.put(importItemInfoDto.getCode(), importItemInfoDto.getNum());
        }
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.queryByCodes(new ArrayList(itemCodes)));
        logger.info("\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)itemRespDtos);
        List itemIds = itemRespDtos.stream().map(ItemRespDto::getId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemIds)) {
            ArrayList failMsgRespDtos = Lists.newArrayList();
            for (ImportItemInfoDto importItemInfoDto : importItemInfoDtos) {
                ImportItemFailMsgRespDto failMsgRespDto = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)failMsgRespDto, (Object)importItemInfoDto, (String[])new String[0]);
                failMsgRespDto.setFailMsg("\u5546\u54c1\u7f16\u7801\u9519\u8bef\u6216\u672a\u4e0a\u67b6\u6216\u672a\u6388\u6743\u6216\u672a\u542f\u552e");
                failMsgRespDtos.add(failMsgRespDto);
            }
            return this.buildImportItemRespDto(totalImportNum, Lists.newArrayList(), failMsgRespDtos, 0, 0, 0);
        }
        ItemDepthQueryReqDto itemDepthQueryReqDto = new ItemDepthQueryReqDto();
        itemDepthQueryReqDto.setCustomerId(orderItemImportReqDto.getCustomerId());
        itemDepthQueryReqDto.setShopId(orderItemImportReqDto.getShopId());
        itemDepthQueryReqDto.setItemIds(StringUtils.join(itemIds, (String)","));
        ArrayList itemInfoImportRespDtoList = Lists.newArrayList();
        PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo = this.queryItemPageDepth(itemDepthQueryReqDto, 0, 1000);
        if (itemInfoRespDtoPageInfo == null || CollectionUtils.isEmpty((Collection)itemInfoRespDtoPageInfo.getList())) {
            ArrayList failMsgRespDtos = Lists.newArrayList();
            for (ImportItemInfoDto importItemInfoDto : importItemInfoDtos) {
                ImportItemFailMsgRespDto failMsgRespDto = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)failMsgRespDto, (Object)importItemInfoDto, (String[])new String[0]);
                failMsgRespDto.setFailMsg("\u5546\u54c1\u7f16\u7801\u9519\u8bef\u6216\u672a\u4e0a\u67b6\u6216\u672a\u6388\u6743\u6216\u672a\u542f\u552e");
                failMsgRespDtos.add(failMsgRespDto);
            }
            return this.buildImportItemRespDto(totalImportNum, itemInfoImportRespDtoList, failMsgRespDtos, 0, 0, 0);
        }
        Map<String, ItemInfoRespDto> itemInfoRespDtoMap = itemInfoRespDtoPageInfo.getList().stream().collect(Collectors.toMap(ItemInfoRespDto::getCode, e -> e, (e1, e2) -> e1));
        HashMap importItemRespDtoMap = Maps.newHashMap();
        ArrayList failMsgRespDtos = Lists.newArrayList();
        Integer productNum = 0;
        Integer giftNum = 0;
        Integer materielNum = 0;
        for (ImportItemInfoDto importItemInfoDto : importItemInfoDtos) {
            ImportItemFailMsgRespDto importItemFailMsgRespDto;
            ImportItemFailMsgRespDto importItemFailMsgRespDto2;
            if (StringUtils.isBlank((String)importItemInfoDto.getCode())) {
                importItemFailMsgRespDto2 = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)importItemFailMsgRespDto2, (Object)importItemInfoDto, (String[])new String[0]);
                importItemFailMsgRespDto2.setFailMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                failMsgRespDtos.add(importItemFailMsgRespDto2);
                continue;
            }
            if (importItemInfoDto.getNum() == null) {
                importItemFailMsgRespDto2 = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)importItemFailMsgRespDto2, (Object)importItemInfoDto, (String[])new String[0]);
                importItemFailMsgRespDto2.setFailMsg("\u5bfc\u5165\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                failMsgRespDtos.add(importItemFailMsgRespDto2);
                continue;
            }
            ItemInfoRespDto itemInfoRespDto = itemInfoRespDtoMap.get(importItemInfoDto.getCode());
            if (itemInfoRespDto == null) {
                importItemFailMsgRespDto = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)importItemFailMsgRespDto, (Object)importItemInfoDto, (String[])new String[0]);
                importItemFailMsgRespDto.setFailMsg("\u5546\u54c1\u7f16\u7801\u9519\u8bef\u6216\u672a\u4e0a\u67b6\u6216\u672a\u6388\u6743\u6216\u672a\u542f\u552e");
                failMsgRespDtos.add(importItemFailMsgRespDto);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)itemInfoRespDto.getItemSkuList()) || ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).getBalance() <= 0L) {
                importItemFailMsgRespDto = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)importItemFailMsgRespDto, (Object)importItemInfoDto, (String[])new String[0]);
                importItemFailMsgRespDto.setFailMsg("\u5546\u54c1\u65e0\u5e93\u5b58");
                failMsgRespDtos.add(importItemFailMsgRespDto);
                continue;
            }
            if (itemInfoRespDto.getMinPrice() == null || itemInfoRespDto.getMinPrice().compareTo(BigDecimal.ZERO) < 0) {
                importItemFailMsgRespDto = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)importItemFailMsgRespDto, (Object)importItemInfoDto, (String[])new String[0]);
                importItemFailMsgRespDto.setFailMsg("\u5546\u54c1\u6682\u65e0\u62a5\u4ef7");
                failMsgRespDtos.add(importItemFailMsgRespDto);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)itemInfoRespDto.getActivityPriceList()) && ((ItemActivityPriceRespDto)itemInfoRespDto.getActivityPriceList().get(0)).getActivityPrice() == null) {
                importItemFailMsgRespDto = new ImportItemFailMsgRespDto();
                CubeBeanUtils.copyProperties((Object)importItemFailMsgRespDto, (Object)importItemInfoDto, (String[])new String[0]);
                importItemFailMsgRespDto.setFailMsg("\u5546\u54c1\u6682\u65e0\u62a5\u4ef7");
                failMsgRespDtos.add(importItemFailMsgRespDto);
                continue;
            }
            ItemInfoImportRespDto itemInfoImportRespDto = (ItemInfoImportRespDto)importItemRespDtoMap.get(importItemInfoDto.getCode());
            if (itemInfoImportRespDto == null) {
                Integer n;
                Integer n2;
                if (SubTypeEnum.PRODUCT.getType().equals(itemInfoRespDto.getSubType())) {
                    n2 = productNum;
                    n = productNum = Integer.valueOf(productNum + 1);
                } else if (SubTypeEnum.GIFT.getType().equals(itemInfoRespDto.getSubType())) {
                    n2 = giftNum;
                    n = giftNum = Integer.valueOf(giftNum + 1);
                } else if (SubTypeEnum.MATERIEL.getType().equals(itemInfoRespDto.getSubType())) {
                    n2 = materielNum;
                    n = materielNum = Integer.valueOf(materielNum + 1);
                }
                itemInfoImportRespDto = new ItemInfoImportRespDto();
                CubeBeanUtils.copyProperties((Object)itemInfoImportRespDto, (Object)itemInfoRespDto, (String[])new String[0]);
                itemInfoImportRespDto.setImportNum(importItemInfoDto.getNum());
                importItemRespDtoMap.put(importItemInfoDto.getCode(), itemInfoImportRespDto);
                continue;
            }
            itemInfoImportRespDto.setImportNum(Integer.valueOf(itemInfoImportRespDto.getImportNum() + importItemInfoDto.getNum()));
        }
        if (CollectionUtils.isNotEmpty(importItemRespDtoMap.values())) {
            itemInfoImportRespDtoList.addAll(importItemRespDtoMap.values());
        }
        return this.buildImportItemRespDto(totalImportNum, itemInfoImportRespDtoList, failMsgRespDtos, productNum, giftNum, materielNum);
    }

    private ImportItemRespDto buildImportItemRespDto(Integer totalImportNum, List<ItemInfoImportRespDto> itemInfoImportRespDtoList, List<ImportItemFailMsgRespDto> failMsgRespDtos, Integer productNum, Integer giftNum, Integer materielNum) {
        Integer failNum = failMsgRespDtos.size();
        String failMsgFileUrl = "";
        if (CollectionUtils.isNotEmpty(failMsgRespDtos)) {
            failMsgFileUrl = EasyPoiExportUtil.getExportUrl(failMsgRespDtos, ImportItemFailMsgRespDto.class, null, "\u4ee3\u5ba2\u4e0b\u5355-\u5bfc\u5165\u5546\u54c1\u5931\u8d25\u6587\u4ef6" + DateFormatUtils.format((Date)new Date(), (String)"yyMMddHHmmss"), "xls");
        }
        ImportItemRespDto importItemRespDto = new ImportItemRespDto();
        importItemRespDto.setItemInfoImportRespDtoList(itemInfoImportRespDtoList);
        importItemRespDto.setTotalImportNum(totalImportNum);
        importItemRespDto.setSuccNum(Integer.valueOf(totalImportNum - failNum));
        importItemRespDto.setFailNum(failNum);
        importItemRespDto.setProductNum(productNum);
        importItemRespDto.setGiftNum(giftNum);
        importItemRespDto.setMaterielNum(materielNum);
        importItemRespDto.setFailFileUrl(failMsgFileUrl);
        return importItemRespDto;
    }

    private void validateParam(OrderItemImportReqDto orderItemImportReqDto) {
        if (orderItemImportReqDto.getShopId() == null) {
            throw new BizException("\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderItemImportReqDto.getCustomerId() == null) {
            throw new BizException("\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)orderItemImportReqDto.getUrl())) {
            throw new BizException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    public void setItemToInventory(ItemDepthQueryReqDto itemDepthReqDto, List<ItemInfoRespDto> list) {
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerApi.queryCustomerRespDto(Collections.singletonList(itemDepthReqDto.getShopId())));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u6839\u636e\u5e97\u94faid[{}]\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f", (Object)itemDepthReqDto.getShopId());
            return;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        logger.info("\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerRespDto));
        if (null == customerRespDto.getId()) {
            logger.info("\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u6839\u636e\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f");
            return;
        }
        List<Long> itemIdList = list.stream().map(ItemInfoRespDto::getItemId).collect(Collectors.toList());
        logger.info("\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7==>itemIdList={}", (Object)JSON.toJSONString(itemIdList));
        Map<Long, Long> itemToInventoryMap = this.checkControlRule(itemIdList, customerRespDto.getId());
        if (itemToInventoryMap.isEmpty()) {
            logger.info("\u6839\u636e\u5ba2\u6237\u4fe1\u606f\u548c\u5546\u54c1\u4fe1\u606f\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u7ba1\u63a7\u4fe1\u606f");
            return;
        }
        list.forEach(itemInfoRespDto -> {
            Long inventory = (Long)itemToInventoryMap.get(itemInfoRespDto.getItemId());
            logger.info("\u5546\u54c1id[{}],\u5e93\u5b58\u6570[{}]", (Object)itemInfoRespDto.getItemId(), (Object)inventory);
            if (null == inventory) {
                return;
            }
            long balance = ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).getBalance() - inventory;
            balance = balance < 0L ? 0L : balance;
            ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).setBalance(Long.valueOf(balance));
        });
    }
}

