/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.OrganizationInfoExtTemporaryDto;
import com.dtyunxi.tcbj.api.query.IUserExtV2QueryApi;
import com.dtyunxi.tcbj.center.openapi.api.IErpOrderApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.UnauditReqDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ErpAuditOrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerRelationQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IMqMessageApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.adjust.ITcbjAdjustApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.delivery.ITcbjDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDetailDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOtherFieldDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustUpReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAuditToBReqDto;
import com.dtyunxi.yundt.module.trade.biz.util.ApiNoticeConfig;
import com.dtyunxi.yundt.module.trade.biz.util.DingdingSender;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderInformMqService {
    private static final Logger logger = LoggerFactory.getLogger(OrderInformMqService.class);
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ITcbjDeliveryApi tcbjDeliveryApi;
    @Resource
    private IMqMessageApi mqMessageApi;
    @Resource
    private ITcbjReciptApi tcbjReciptApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private ITcbjAdjustApi tcbjAdjustApi;
    @Resource
    private IContext context;
    @Resource
    private ICsReceiveNoticeOrderApi createReceiveOrderProcess;
    @Resource
    private ApiNoticeConfig apiNoticeConfig;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ICustomerRelationQueryApi customerRelationQueryApi;
    @Resource
    private IErpOrderApi erpOrderApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IUserExtV2QueryApi userExtV2QueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    public void sendDeliveryInform(String orderNo, OrderDetailRespDto orderDto) {
        if (orderDto == null) {
            ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
            attrs.add(OrderQueryEnum.ADDRESS);
            attrs.add(OrderQueryEnum.ITEM);
            RestResponse orderDetailResponse = this.orderBizQueryApi.getOrderDetail(orderNo, StringUtils.join(attrs, (String)","));
            orderDto = (OrderDetailRespDto)orderDetailResponse.getData();
        }
        logger.info("\u66f4\u65b0\u53d1\u8d27\u5355\u72b6\u6001\uff0c\u5e76\u53d1\u9001\u81f3\u8425\u9500\u4e91\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)orderDto));
        String orgCode = this.getOrgCode(orderDto.getOrganizationId());
        CustomerRespDto customerRespDto = this.getCustomerDetail(orderDto.getCustomerId());
        OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
        if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
            orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
        }
        this.updateInformOrder(orderDto.getOrderNo(), OrderStatus.DELIVERY_OUT_ING.toString());
        MqContentOrderDto mqContentOrderDto = new MqContentOrderDto();
        mqContentOrderDto.setOrgId(orgCode);
        mqContentOrderDto.setApplyerId(customerRespDto.getThirdPartyId());
        mqContentOrderDto.setApplyerName(customerRespDto.getName());
        mqContentOrderDto.setApproverId(this.getCustomerCode(orderDto.getOrganizationId()));
        mqContentOrderDto.setNo(orderDto.getOrderNo());
        mqContentOrderDto.setDt(orderDto.getPlaceTime());
        mqContentOrderDto.setShippingAddress(orderDelivery.getAddress());
        mqContentOrderDto.setPhone(orderDelivery.getDeliveryMobile());
        mqContentOrderDto.setContacts(orderDelivery.getDeliveryName());
        mqContentOrderDto.setRemark(orderDto.getBuyerRemark());
        mqContentOrderDto.setTotalMoney(Double.valueOf(orderDto.getTotalAmount().doubleValue()));
        mqContentOrderDto.setOrderApplyItems(this.splitItemDetailByBatch(orderDto.getOrderItems()));
        CustomerRelationRespDto subTenantData = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(Long.valueOf(orderDto.getCustomerId())));
        if (subTenantData != null) {
            mqContentOrderDto.setBizType(ErpAuditOrderBizTypeEnum.SECOND_IN_PURCHASE.getCode());
            mqContentOrderDto.setSubTenantId(subTenantData.getParentThirdCode());
        }
        this.getOrganizationInfo(mqContentOrderDto, customerRespDto.getOrgInfoId());
        logger.info("------------>\u751f\u6210\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)mqContentOrderDto));
        this.mqMessageApi.sendDeliverOrderInform(mqContentOrderDto);
    }

    private void getOrganizationInfo(MqContentOrderDto mqContentOrderDto, Long orgId) {
        List orginfoRespDtoList = null;
        try {
            RestResponse orginfoResp = this.userExtV2QueryApi.queryOrgInfoByOrgId((List)Lists.newArrayList((Object[])new Long[]{orgId}));
            logger.info("------------>\u83b7\u53d6\u79df\u6237\u7ec4\u7ec7\u548c\u516c\u53f8\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)orginfoResp));
            orginfoRespDtoList = (List)orginfoResp.getData();
            boolean isSendError = false;
            if (CollectionUtil.isNotEmpty((Collection)orginfoRespDtoList)) {
                OrganizationInfoExtTemporaryDto respDto = (OrganizationInfoExtTemporaryDto)orginfoRespDtoList.get(0);
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{respDto.getCreditCode()})) {
                    mqContentOrderDto.setFullApplyerName(respDto.getOrgName());
                    mqContentOrderDto.setUscc(respDto.getCreditCode());
                } else {
                    mqContentOrderDto.setFullApplyerName("");
                    mqContentOrderDto.setUscc("");
                    isSendError = true;
                }
            } else {
                isSendError = true;
            }
            if (isSendError) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.apiNoticeConfig.getCommonList());
                msgReqDto.setRemindType(1);
                String str = "\u53d1\u9001\u9500\u552e\u8ba2\u5355\u7ed9\u4e0b\u6e38\u8fdb\u9500\u5b58\u5f02\u5e38,\u5c0fB\u672a\u771f\u5b9e\u6027\u6821\u9a8c:MQ\u53c2\u6570\u6570\u636e\u3010" + JSON.toJSONString((Object)mqContentOrderDto) + "\u3011,\u5ba2\u6237\u53c2\u6570\u6570\u636e:\u3010" + JSON.toJSONString((Object)orginfoRespDtoList) + "\u3011";
                msgReqDto.setSendMessage(str);
                this.dingdingSender.sendMessage(msgReqDto);
            }
        }
        catch (Exception e) {
            logger.warn("\u53d1\u9001\u9500\u552e\u8ba2\u5355\u7ed9\u4e0b\u6e38\u8fdb\u9500\u5b58\u5f02\u5e38,\u5c0fB\u672a\u771f\u5b9e\u6027\u6821\u9a8c:MQ\u53c2\u6570\u6570\u636e\u3010" + JSON.toJSONString((Object)mqContentOrderDto) + "\u3011,\u5ba2\u6237\u53c2\u6570\u6570\u636e:\u3010" + JSON.toJSONString(orginfoRespDtoList) + "\u3011");
        }
    }

    public void createReciptInform(String returnNo) {
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(returnNo, "");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)returnDetailRespDtoRestResponse.getData();
        TcbjNotiGenReqDto tcbjNotiGenReqDto = new TcbjNotiGenReqDto();
        tcbjNotiGenReqDto.setPreNo(returnDetailRespDto.getReturnNo());
        tcbjNotiGenReqDto.setPlanTime(returnDetailRespDto.getCreateTime().toString());
        if (StringUtils.isNotEmpty((CharSequence)returnDetailRespDto.getReturnDesc())) {
            JSONObject jsonObject = JSONObject.parseObject((String)returnDetailRespDto.getReturnDesc());
            tcbjNotiGenReqDto.setReciveName(jsonObject.getString("deliveryName"));
            tcbjNotiGenReqDto.setRecivePhone(jsonObject.getString("deliveryMobile"));
            tcbjNotiGenReqDto.setAddress(jsonObject.getString("deliveryAddress"));
        }
        tcbjNotiGenReqDto.setWarehouseCode(returnDetailRespDto.getWarehouseCode());
        tcbjNotiGenReqDto.setType(Integer.valueOf(204));
        this.tcbjReciptApi.send(tcbjNotiGenReqDto);
    }

    public void sendReciptInform(String returnNo) {
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(returnNo, "");
        logger.info("------------>\u83b7\u53d6\u552e\u540e\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)returnDetailRespDtoRestResponse));
        if (ObjectUtil.isEmpty((Object)returnDetailRespDtoRestResponse.getData())) {
            logger.info("------------>\u83b7\u53d6\u552e\u540e\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)returnNo);
            return;
        }
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)returnDetailRespDtoRestResponse.getData();
        String orgCode = this.getOrgCode(returnDetailRespDto.getOrganizationId());
        CustomerRespDto customerRespDto = this.getCustomerDetail(returnDetailRespDto.getCustomerId());
        this.createReceiveOrder(returnDetailRespDto);
        MqContentOrderDto mqContentOrderDto = new MqContentOrderDto();
        mqContentOrderDto.setOrgId(orgCode);
        mqContentOrderDto.setApplyerId(customerRespDto.getThirdPartyId());
        mqContentOrderDto.setApplyerName(customerRespDto.getName());
        mqContentOrderDto.setNo(returnDetailRespDto.getReturnNo());
        mqContentOrderDto.setDt(returnDetailRespDto.getCreateTime());
        mqContentOrderDto.setShippingAddress(null);
        mqContentOrderDto.setPhone(null);
        mqContentOrderDto.setContacts(null);
        mqContentOrderDto.setApproverId(this.getCurrentCustomer());
        mqContentOrderDto.setRemark(returnDetailRespDto.getRemark());
        Map extFields = returnDetailRespDto.getExtFields();
        String placeUserId = extFields.get("placeUserId") + "";
        UserDto userInfo = this.findUserInfo(StringUtils.isBlank((CharSequence)placeUserId) || "null".equals(placeUserId) ? null : Long.valueOf(placeUserId));
        mqContentOrderDto.setOrderPersonName(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfo.getNickName()}) ? userInfo.getNickName() : userInfo.getUserName());
        mqContentOrderDto.setTotalMoney(Double.valueOf(returnDetailRespDto.getRefundAmount().doubleValue()));
        ArrayList<MqContentOrderDetailDto> detailList = new ArrayList<MqContentOrderDetailDto>();
        for (ApplyReturnItemRespDto item : returnDetailRespDto.getApplyReturnItemRespDtoList()) {
            MqContentOrderDetailDto detailDto = new MqContentOrderDetailDto();
            detailDto.setEasNo(item.getCargoSerial());
            detailDto.setActQuantity(item.getReturnNum());
            detailDto.setQuantity(item.getReturnNum());
            detailDto.setRemark(item.getRemark());
            detailDto.setBatchNum(null);
            detailDto.setPrice(Double.valueOf(item.getItemPrice().doubleValue()));
            detailDto.setActPrice(Double.valueOf(item.getItemPrice().doubleValue()));
            detailDto.setMoney(Double.valueOf(item.getItemAmount().doubleValue()));
            MqContentOtherFieldDto mqContentOtherFieldDto = new MqContentOtherFieldDto();
            mqContentOtherFieldDto.setTradeOrderItemId(item.getTradeItemId());
            detailDto.setOtherField1(JSONObject.toJSONString((Object)mqContentOtherFieldDto));
            detailList.add(detailDto);
        }
        mqContentOrderDto.setOrderApplyItems(detailList);
        this.getOrganizationInfo(mqContentOrderDto, customerRespDto.getOrgInfoId());
        CustomerRelationRespDto subTenantData = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(Long.valueOf(returnDetailRespDto.getCustomerId())));
        if (subTenantData != null && StringUtils.isNotBlank((CharSequence)returnDetailRespDto.getExtlReturnSerial())) {
            mqContentOrderDto.setBizType(ErpAuditOrderBizTypeEnum.SECOND_SUB_SALE_RTN_OUT.getCode());
            mqContentOrderDto.setSubTenantId(subTenantData.getParentThirdCode());
            mqContentOrderDto.setSecondSaleReturnOrder(returnDetailRespDto.getExtlReturnSerial());
        }
        logger.info("------------>\u751f\u6210\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString((Object)mqContentOrderDto));
        this.mqMessageApi.sendReceiveOrderInformMq(mqContentOrderDto);
    }

    public void subTenantrejectRetrun(OrderAuditToBReqDto orderAuditToBReqDto) {
        ReturnDetailRespDto returnData = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)this.afterSalesQueryApi.queryReturnDetail(orderAuditToBReqDto.getReturnNo(), ""));
        if (StringUtils.isNotBlank((CharSequence)returnData.getExtlReturnSerial())) {
            CustomerRelationRespDto subTenantData = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(Long.valueOf(returnData.getCustomerId())));
            logger.info("\u4e2db\u79df\u6237\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)subTenantData));
            if (subTenantData != null) {
                UnauditReqDto unauditReqDto = new UnauditReqDto();
                unauditReqDto.setTenantId(subTenantData.getParentThirdCode());
                unauditReqDto.setNumber(returnData.getReturnNo());
                RestResponseHelper.extractData((RestResponse)this.erpOrderApi.subrtnOrderUnaudit(unauditReqDto));
            }
        }
    }

    private void createReceiveOrder(ReturnDetailRespDto returnDetailRespDto) {
        JSONObject jsonObject;
        CsReceiveNoticeOrderAddReqDto tcbjNotiGenReqDto = new CsReceiveNoticeOrderAddReqDto();
        ContactDto contactDto = new ContactDto();
        if (StringUtils.isNotEmpty((CharSequence)returnDetailRespDto.getBuyerAddrInfo()) && (jsonObject = JSONObject.parseObject((String)returnDetailRespDto.getBuyerAddrInfo())) != null) {
            contactDto.setReciveName(jsonObject.getString("contact"));
            contactDto.setRecivePhone(jsonObject.getString("phone"));
            contactDto.setAddress(jsonObject.getString("address"));
            logger.info("\u4e0a\u95e8\u53d6\u8d27\u5730\u5740id{}", (Object)jsonObject.getString("id"));
        }
        tcbjNotiGenReqDto.setExternalOrderNo(returnDetailRespDto.getExtlReturnSerial());
        tcbjNotiGenReqDto.setShopId(Long.valueOf(returnDetailRespDto.getShopId()));
        tcbjNotiGenReqDto.setRemark(returnDetailRespDto.getRemark());
        tcbjNotiGenReqDto.setContactDto(contactDto);
        tcbjNotiGenReqDto.setPreOrderNo(returnDetailRespDto.getReturnNo());
        tcbjNotiGenReqDto.setWarehouseCode(returnDetailRespDto.getWarehouseCode());
        ArrayList notiGenItemReqDtos = Lists.newArrayList();
        for (ApplyReturnItemRespDto item : returnDetailRespDto.getApplyReturnItemRespDtoList()) {
            CsReceiveNoticeOrderDetailAddReqDto dto = new CsReceiveNoticeOrderDetailAddReqDto();
            dto.setCargoCode(item.getCargoSerial());
            dto.setPlanQuantity(new BigDecimal(item.getReturnNum()));
            notiGenItemReqDtos.add(dto);
        }
        tcbjNotiGenReqDto.setReceiveNoticeOrderDetailAddReqDtoList((List)notiGenItemReqDtos);
        tcbjNotiGenReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_EXCHANGE_IN.getCode());
        logger.info("\u751f\u6210\u901a\u77e5\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)tcbjNotiGenReqDto));
        RestResponse receiveOrderProcess = this.createReceiveOrderProcess.createReceiveOrderProcess(tcbjNotiGenReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)receiveOrderProcess);
    }

    private String getOrgCode(Long orgId) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryById(orgId, "");
        logger.info("------------>\u83b7\u53d6\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (ObjectUtil.isNotEmpty((Object)organizationDtoRestResponse.getData())) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getCode();
        }
        return "";
    }

    private CustomerRespDto getCustomerDetail(String customerId) {
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            Long id = Long.valueOf(customerId);
            RestResponse customerRespDtoRestResponse = this.customerQueryApi.queryById(id);
            logger.info("------------>\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespDtoRestResponse));
            if (ObjectUtil.isNotEmpty((Object)customerRespDtoRestResponse.getData())) {
                return (CustomerRespDto)customerRespDtoRestResponse.getData();
            }
        }
        return new CustomerRespDto();
    }

    private String getCurrentCustomer() {
        RestResponse orgRest = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryById((Long)orgRest.getData(), "");
        if (ObjectUtil.isNotEmpty((Object)organizationDtoRestResponse.getData()) && ObjectUtil.isNotEmpty((Object)((OrganizationDto)organizationDtoRestResponse.getData()).getCode())) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getCode();
        }
        return "";
    }

    private String getCustomerCode(Long orgId) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryById(orgId, "");
        if (ObjectUtil.isNotEmpty((Object)organizationDtoRestResponse.getData()) && ObjectUtil.isNotEmpty((Object)((OrganizationDto)organizationDtoRestResponse.getData()).getCode())) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getCode();
        }
        return "";
    }

    private List<ItemRespDto> getItemList(String itemsCode) {
        RestResponse listRestResponse = this.itemQueryApi.queryByItemIds(itemsCode);
        logger.info("------------>\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)listRestResponse));
        if (CollectionUtil.isNotEmpty((Collection)((Collection)listRestResponse.getData()))) {
            return (List)listRestResponse.getData();
        }
        return new ArrayList<ItemRespDto>();
    }

    private void updateInformOrder(String proNo, String status) {
        logger.info("------------>\u66f4\u65b0\u901a\u77e5\u5355\u72b6\u6001\uff1a{}:{}", (Object)proNo, (Object)status);
        TcbjAdjustUpReqDto tcbjAdjustUpReqDto = new TcbjAdjustUpReqDto();
        tcbjAdjustUpReqDto.setPreNo(proNo);
        tcbjAdjustUpReqDto.setStatus(status);
        this.tcbjAdjustApi.updateNoti(tcbjAdjustUpReqDto);
    }

    private List<MqContentOrderDetailDto> splitItemDetailByBatch(List<TradeItemRespDto> itemList) {
        ArrayList<MqContentOrderDetailDto> detailList = new ArrayList<MqContentOrderDetailDto>();
        for (TradeItemRespDto item : itemList) {
            MqContentOtherFieldDto fieldDto = new MqContentOtherFieldDto();
            fieldDto.setTradeOrderItemId(item.getId());
            if (StringUtils.isNotEmpty((CharSequence)item.getBatchNo())) {
                try {
                    String[] batchArray;
                    for (String batch : batchArray = item.getBatchNo().split(",")) {
                        String[] content = batch.split("#");
                        String batchNum = content[0];
                        Integer count = Integer.valueOf(content[1]);
                        MqContentOrderDetailDto detailDto = new MqContentOrderDetailDto();
                        detailDto.setEasNo(item.getSkuCode());
                        detailDto.setActQuantity(count);
                        detailDto.setQuantity(count);
                        if (item.getIfExchange() != null && item.getIfExchange() == 1) {
                            detailDto.setRemark("\u6362\u8d2d");
                        } else {
                            detailDto.setRemark(item.getRemark());
                        }
                        detailDto.setBatchNum(batchNum);
                        detailDto.setPrice(Double.valueOf(item.getItemPrice().doubleValue()));
                        detailDto.setActPrice(Double.valueOf(item.getItemPrice().doubleValue()));
                        detailDto.setMoney(Double.valueOf(item.getItemPrice().multiply(new BigDecimal(count)).doubleValue()));
                        detailDto.setOtherField1(JSON.toJSONString((Object)fieldDto));
                        detailList.add(detailDto);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info("\u53d1\u9001\u53d1\u8d27\u7ed3\u679c\u5355\u5f02\u5e38\uff0c\u6839\u636e\u6279\u6b21\u53f7\u62c6\u5206\u5546\u54c1\u660e\u7ec6\uff1a{}", (Object)JSONObject.toJSONString((Object)item));
                    continue;
                }
            }
            MqContentOrderDetailDto detailDto = new MqContentOrderDetailDto();
            detailDto.setEasNo(item.getSkuCode());
            detailDto.setActQuantity(item.getItemNum());
            detailDto.setQuantity(item.getItemNum());
            detailDto.setRemark(item.getRemark());
            detailDto.setBatchNum(item.getBatchNo());
            detailDto.setPrice(Double.valueOf(item.getItemPrice().doubleValue()));
            detailDto.setActPrice(Double.valueOf(item.getItemPrice().doubleValue()));
            detailDto.setMoney(Double.valueOf(item.getPayTotalAmount().doubleValue()));
            detailDto.setOtherField1(JSON.toJSONString((Object)fieldDto));
            detailList.add(detailDto);
        }
        return detailList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDto findUserInfo(Long userId) {
        UserDto userDto = new UserDto();
        if (userId == null) {
            return userDto;
        }
        try {
            RestResponse userDtoRestResponse = this.userQueryApi.queryById(userId, "{}");
            if (userDtoRestResponse != null) {
                if (userDtoRestResponse.getData() != null) {
                    userDto = (UserDto)userDtoRestResponse.getData();
                    return userDto;
                }
            }
        }
        catch (Exception e) {
            logger.info("BizType\u8f6cInteger\u5931\u8d25,BizType:" + userId);
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        finally {
            return userDto;
        }
    }
}

