/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderItemService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderItemServiceImpl
implements IOrderItemService {
    private static final Logger logger = LoggerFactory.getLogger(OrderItemServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;

    public Long queryVirStorage(Long shopId, Long itemId, Long skuId) {
        ItemStorageQueryReqDto itemStorageQueryReqDto = new ItemStorageQueryReqDto();
        itemStorageQueryReqDto.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        itemStorageQueryReqDto.setTenantId(this.context.tenantId());
        itemStorageQueryReqDto.setInstanceId(this.context.instanceId());
        itemStorageQueryReqDto.setShopId(shopId);
        String filters = ObjectHelper.bean2Json((Object)itemStorageQueryReqDto);
        List virStorageList = (List)this.itemStorageQueryApi.queryItemStorage(filters).getData();
        if (CollectionUtils.isEmpty((Collection)virStorageList)) {
            return 0L;
        }
        Long storage = ((ItemStorageQueryRespDto)virStorageList.get(0)).getAvaNum();
        logger.info("\u67e5\u8be2\u865a\u62df\u5e93\u5b58shopId={}, skuId = {},storage={}", new Object[]{shopId, skuId, storage});
        return storage;
    }

    public Boolean isOnshelf(Long shopId, Long itemId, Long skuId) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemId);
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setSkuId(skuId);
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData();
        return null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }
}

