/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CompanySimpleInfoDto;
import com.dtyunxi.tcbj.api.query.IUserExtV2QueryApi;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditNodeApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OrderNodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.order.delivery.ITcbjDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IStorageOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.delivery.resp.TcbjDeliveryResDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAuditApi;
import com.dtyunxi.yundt.cube.center.trade.api.IPayApi;
import com.dtyunxi.yundt.cube.center.trade.api.IPayTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.ReturnOrderCreateModeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.GiftAccountReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnConfirmRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.ReturnOrderStatusCountRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ApplyReturnItemBatchRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IPayQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IRefundQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.IOptLogApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.query.IAttachementQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IReturnOrderService;
import com.dtyunxi.yundt.module.trade.api.constant.TradeConstant;
import com.dtyunxi.yundt.module.trade.api.dto.CustomAddressDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemExtDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.BasePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.NullifyOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAddressReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAuditToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReFundOrderReceiveSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReFundOrderReceiveSaveToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderItemSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderPageSearchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderUpdateReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ReturnItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemReceiveRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveredRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderReceiveDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReceiveDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.RefundRecordRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnLogisticsRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderPayRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.OrderReturnBizTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PayMethodEnum;
import com.dtyunxi.yundt.module.trade.api.enums.RefundOrderStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ReturnDeliveryStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ReturnStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.mq.MqProducer;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import com.dtyunxi.yundt.module.trade.biz.pay.PayFactory;
import com.dtyunxi.yundt.module.trade.biz.util.ReturnOrderUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.constants.ItemInterceptConfigEnum;
import com.yx.tcbj.center.api.constants.YesOrNoEnum;
import com.yx.tcbj.center.api.dto.request.ItemInterceptConfigReqDto;
import com.yx.tcbj.center.api.dto.request.ItemInterceptDetailReqDto;
import com.yx.tcbj.center.api.dto.response.ItemInterceptConfigRespDto;
import com.yx.tcbj.center.api.query.IItemInterceptConfigQueryApi;
import com.yx.tcbj.center.api.query.IItemInterceptDetailQueryApi;
import com.yx.tcbj.center.trade.api.constant.RefundChannelTypeEnum;
import com.yx.tcbj.center.trade.api.dto.response.RefundDisposeConfigRespDto;
import com.yx.tcbj.center.trade.api.query.IRefundDisposeConfigQueryApi;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReturnOrderServiceImpl
implements IReturnOrderService {
    private static final Logger logger = LoggerFactory.getLogger(ReturnOrderServiceImpl.class);
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private PayFactory payFactory;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Autowired
    private IReturnOrderService returnOrderService;
    @Autowired
    private IOrderService orderService;
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private IAfterSalesApi iAfterSalesApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IPayApi iPayApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IOrderService iOrderService;
    @Resource
    IPayQueryApi iPayQueryApi;
    @Resource
    private IAttachementQueryApi attachementQueryApi;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private IRefundQueryApi refundQueryApi;
    @Resource
    private IStorageOrderQueryApi iStorageOrderQueryApi;
    @Resource
    private IOptLogApi optLogApi;
    @Resource
    private ICreditNodeApi creditNodeApi;
    @Resource
    private IAfterSalesTobApi afterSalesTobApi;
    @Resource
    private IPayTobApi payTobApi;
    @Resource
    private IAuditApi auditApi;
    @Resource
    private MqProducer mqProducer;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ITcbjReciptApi tcbjReciptApi;
    @Resource
    private ITcbjDeliveryApi tcbjDeliveryApi;
    @Resource
    private IActivityExtQueryApi activityExtQueryApi;
    @Resource
    private ICsReceiveResultOrderQueryApi receiveResultOrderQueryApi;
    @Resource
    private IRefundDisposeConfigQueryApi refundDisposeConfigQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IUserExtV2QueryApi userExtV2QueryApi;
    @Resource
    private IItemInterceptDetailQueryApi itemInterceptDetailQueryApi;
    @Resource
    private IItemInterceptConfigQueryApi itemInterceptConfigQueryApi;
    @Resource
    private ICustomerExtQueryApi iCustomerQueryApi;

    public static String dateToString(Date date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = formatter.format(date);
            return dateString;
        }
        catch (Exception e) {
            logger.info("\u8f6c\u5316\u5931\u8d25,data----:" + JSON.toJSONString((Object)date));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            return "";
        }
    }

    public RestResponse<ReturnOrderStatusCountRespDto> countReturnOrder(ReturnOrderPageSearchReqDto addressQueryReqDto) {
        ReturnQueryReqDto returnQueryReqDto = new ReturnQueryReqDto();
        PageInfo paramPageInfo = this.buildCommonQueryParam(returnQueryReqDto, addressQueryReqDto);
        if (paramPageInfo == null) {
            return this.afterSalesQueryApi.countReturnOrder(returnQueryReqDto);
        }
        return new RestResponse((Object)new ReturnOrderStatusCountRespDto());
    }

    public PageInfo<ReturnOrderRespDto> pageReturnOrder(ReturnOrderPageSearchReqDto addressQueryReqDto, Integer pageNum, Integer pageSize) {
        ReturnQueryReqDto returnQueryReqDto = new ReturnQueryReqDto();
        PageInfo paramPageInfo = this.buildCommonQueryParam(returnQueryReqDto, addressQueryReqDto);
        if (paramPageInfo != null) {
            return paramPageInfo;
        }
        returnQueryReqDto.setPageNum(pageNum);
        returnQueryReqDto.setPageSize(pageSize);
        RestResponse pageInfoRestResponse = this.afterSalesQueryApi.queryPostReturnByPage(JSON.toJSONString((Object)returnQueryReqDto));
        PageInfo pageInfoRestResponse1 = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo page = new PageInfo();
        HashMap<String, String> selllerNameMap = new HashMap<String, String>();
        HashMap<String, ShopDto> shopDtoMap = new HashMap<String, ShopDto>();
        HashMap<String, CustomerNameSimpleRespDto> custDtoMap = new HashMap<String, CustomerNameSimpleRespDto>();
        HashMap<String, RefundDisposeConfigRespDto> disposeConfigRespDtoMap = new HashMap<String, RefundDisposeConfigRespDto>();
        if (pageInfoRestResponse1 != null && pageInfoRestResponse1.getList() != null && pageInfoRestResponse1.getList().size() > 0) {
            List list = pageInfoRestResponse1.getList();
            List refundRecordRespDto = list.stream().map(this::buildRefundRecordRespDto).collect(Collectors.toList());
            this.initSellerNameMap(selllerNameMap, list.stream().map(e -> e.getSellerId()).collect(Collectors.toList()));
            this.initShopNameMap(shopDtoMap, list.stream().map(e -> e.getShopId()).collect(Collectors.toList()));
            this.initCustNameMap(custDtoMap, refundRecordRespDto.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerId())).map(e -> e.getCustomerId()).collect(Collectors.toList()));
            this.initDisposeConfigRespDtoMap(disposeConfigRespDtoMap, list.stream().map(e -> e.getReturnNo()).collect(Collectors.toList()));
            Map companyMap = (Map)RestResponseHelper.extractData((RestResponse)this.userExtV2QueryApi.queryCompanyNameByCusId(refundRecordRespDto.stream().map(e -> Long.parseLong(e.getCustomerId())).collect(Collectors.toList())));
            CompanySimpleInfoDto simpleInfoDto = null;
            for (ReturnOrderRespDto returnOrderRespDto : refundRecordRespDto) {
                RefundDisposeConfigRespDto configRespDto;
                returnOrderRespDto.setSellerName((String)selllerNameMap.get(returnOrderRespDto.getSellerId()));
                ShopDto shopDto = (ShopDto)shopDtoMap.get(returnOrderRespDto.getShopId());
                CustomerNameSimpleRespDto custDto = (CustomerNameSimpleRespDto)custDtoMap.get(returnOrderRespDto.getCustomerId());
                if (shopDto != null) {
                    returnOrderRespDto.setShopName(shopDto.getName());
                    returnOrderRespDto.setShopType(String.valueOf(shopDto.getType()));
                }
                if (custDto != null) {
                    returnOrderRespDto.setCustomerName(custDto.getName());
                }
                if (ObjectUtils.isNotEmpty((Object)(configRespDto = (RefundDisposeConfigRespDto)disposeConfigRespDtoMap.get(returnOrderRespDto.getReturnNo())))) {
                    returnOrderRespDto.setRefundChannelType(configRespDto.getRefundChannelType());
                    returnOrderRespDto.setRefundChannelTypeName(RefundChannelTypeEnum.formDisplay((Integer)configRespDto.getRefundChannelType()));
                }
                simpleInfoDto = (CompanySimpleInfoDto)companyMap.get(Long.parseLong(returnOrderRespDto.getCustomerId()));
                if (returnOrderRespDto.getCustomerId() == null || simpleInfoDto == null) continue;
                returnOrderRespDto.setCustomerOrgName(simpleInfoDto.getOrgName());
            }
            page.setList(refundRecordRespDto);
            CubeBeanUtils.copyProperties((Object)page, (Object)pageInfoRestResponse1, (String[])new String[]{"list", "navigatepageNums"});
        }
        return page;
    }

    private PageInfo buildCommonQueryParam(ReturnQueryReqDto returnQueryReqDto, ReturnOrderPageSearchReqDto addressQueryReqDto) {
        RestResponse returnNoListResp;
        List returnNoList;
        Collection customerIds;
        Integer adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", this.context.userId() + "", Integer.class);
        if (adminFlag == null) {
            customerIds = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.getCurrentUserOrOrgCustomer(this.context.userId(), null));
            if (CollectionUtils.isEmpty((Collection)customerIds)) {
                return new PageInfo();
            }
            returnQueryReqDto.setCustomerIds(StringUtils.join((Iterable)customerIds, (String)","));
        }
        if (StringUtils.isNotBlank((CharSequence)addressQueryReqDto.getCustomerInfo())) {
            customerIds = this.orderService.getCustomerIdsByCustomerInfo(addressQueryReqDto.getCustomerInfo());
            if (CollectionUtils.isEmpty((Collection)customerIds)) {
                return new PageInfo();
            }
            returnQueryReqDto.setCustomerIds(StringUtils.join((Iterable)customerIds, (String)","));
        }
        returnQueryReqDto.setReturnNo(addressQueryReqDto.getReturnNo());
        returnQueryReqDto.setOrderTradeNo(addressQueryReqDto.getOrderNo());
        returnQueryReqDto.setReturnTimeEnd(addressQueryReqDto.getEndDay());
        returnQueryReqDto.setReturnTimeStart(addressQueryReqDto.getStartDay());
        returnQueryReqDto.setReturnStatus(addressQueryReqDto.getReFundOrderTradeStatus());
        if ("1".equals(addressQueryReqDto.getBizType())) {
            addressQueryReqDto.setReturnBizType(OrderReturnBizTypeEnum.ONLY_REFUND.getCode());
        } else if ("2".equals(addressQueryReqDto.getBizType())) {
            addressQueryReqDto.setReturnBizType(OrderReturnBizTypeEnum.ONLY_RETURN.getCode());
        } else if ("3".equals(addressQueryReqDto.getBizType())) {
            addressQueryReqDto.setReturnBizType(OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode());
        }
        returnQueryReqDto.setReturnType(addressQueryReqDto.getReturnBizType());
        returnQueryReqDto.setInstanceId(this.context.instanceId());
        returnQueryReqDto.setTenantId(this.context.tenantId());
        List sellIds = this.orderService.getSellIds();
        returnQueryReqDto.setSellerIds(sellIds);
        returnQueryReqDto.setItemCodes(addressQueryReqDto.getItemCodes());
        returnQueryReqDto.setBatchNos(addressQueryReqDto.getBatchNos());
        returnQueryReqDto.setItemName(addressQueryReqDto.getItemName());
        returnQueryReqDto.setItemCode(addressQueryReqDto.getItemCode());
        returnQueryReqDto.setBatchNo(addressQueryReqDto.getBatchNo());
        if (StringUtils.isNotBlank((CharSequence)addressQueryReqDto.getPlaceUserName())) {
            RestResponse idResp = this.userExtV2QueryApi.queryUserByName(addressQueryReqDto.getPlaceUserName());
            List userIds = (List)RestResponseHelper.extractData((RestResponse)idResp);
            logger.info("\u901a\u8fc7\u7528\u6237\u540d\u67e5\u8be2\u5230\u7684\u7528\u6237id\u4fe1\u606f\u4e3a:{}", (Object)userIds.toString());
            if (CollectionUtils.isNotEmpty((Collection)userIds)) {
                returnQueryReqDto.setPlaceUserIds(userIds);
            } else {
                logger.info("\u4e0d\u5b58\u5728\u4e0b\u5355\u4eba\u7528\u6237\uff0c\u8ba2\u5355\u8fd4\u56de\u7a7a");
                return new PageInfo();
            }
        }
        if (ObjectUtils.isNotEmpty((Object)addressQueryReqDto.getRefundChannelType()) && CollectionUtils.isNotEmpty((Collection)(returnNoList = (List)RestResponseHelper.extractData((RestResponse)(returnNoListResp = this.refundDisposeConfigQueryApi.queryByChannelType(addressQueryReqDto.getRefundChannelType())))))) {
            if (StringUtils.isNotBlank((CharSequence)returnQueryReqDto.getReturnNoList())) {
                returnNoList.addAll(Arrays.asList(StringUtils.split((String)returnQueryReqDto.getReturnNoList(), (String)",")));
            }
            returnQueryReqDto.setReturnNoList(StringUtils.join((Iterable)returnNoList, (String)","));
        }
        returnQueryReqDto.setRemark(addressQueryReqDto.getReturnOrderRemark());
        return null;
    }

    private void initDisposeConfigRespDtoMap(Map<String, RefundDisposeConfigRespDto> disposeConfigRespDtoMap, List<String> returnNos) {
        if (CollectionUtils.isEmpty(returnNos)) {
            return;
        }
        List res = (List)this.refundDisposeConfigQueryApi.queryByRefundNoList(returnNos).getData();
        res.forEach(e -> disposeConfigRespDtoMap.put(e.getOrderNo(), (RefundDisposeConfigRespDto)e));
    }

    private void initCustNameMap(Map<String, CustomerNameSimpleRespDto> custDtoMap, List<String> customerIds) {
        if (CollectionUtils.isEmpty(customerIds)) {
            return;
        }
        List custIdList = customerIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
        List res = (List)this.customerQueryApi.queryListByIds(custIdList).getData();
        res.forEach(e -> custDtoMap.put(String.valueOf(e.getId()), (CustomerNameSimpleRespDto)e));
    }

    private void initShopNameMap(Map<String, ShopDto> shopDtoMap, List<String> shopIds) {
        if (CollectionUtils.isEmpty(shopIds)) {
            return;
        }
        HashSet shopIdSet = new HashSet(shopIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList()));
        List res = (List)this.shopQueryApi.queryByIds(shopIdSet).getData();
        res.forEach(e -> shopDtoMap.put(String.valueOf(e.getId()), (ShopDto)e));
    }

    private void initSellerNameMap(Map<String, String> selllerNameMap, List<String> sellerIds) {
        if (CollectionUtils.isEmpty(sellerIds)) {
            return;
        }
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        HashSet sellerIdSet = new HashSet(sellerIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList()));
        sellerQueryReqDto.setIdList(new ArrayList(sellerIdSet));
        List sellerList = (List)this.sellerQueryApi.queryList(sellerQueryReqDto).getData();
        sellerList.forEach(e -> selllerNameMap.put(String.valueOf(e.getId()), e.getName()));
    }

    public void addReturnOrder(ReturnOrderSaveReqDto returnOrderItemSaveReqDto) {
        List itemList = returnOrderItemSaveReqDto.getItemList();
        List<ReturnOrderItemSaveReqDto> newItemList = this.checkData(itemList);
        List supplierReturnList = newItemList.stream().map(this::buildSupplierReturnItem).collect(Collectors.toList());
        ReturnOrderSaveReqDto.Address address = returnOrderItemSaveReqDto.getAddress();
        ReturnReqDto returnReqDto = new ReturnReqDto();
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setAuditRecordReqDto(null);
        returnReqDto.setBizStatus(null);
        returnReqDto.setBizType(null);
        returnReqDto.setCancelDesc(returnOrderItemSaveReqDto.getRemark());
        returnReqDto.setCancelTime(null);
        returnReqDto.setCancelType(DeliveryCancelTypeEnum.SELLER_CANCLE.getType());
        returnReqDto.setExtlReturnSerial(null);
        returnReqDto.setExtlReturnSrc(null);
        returnReqDto.setFlowCode(null);
        returnReqDto.setInventoryEffectiveDate(null);
        returnReqDto.setOrderProofReturnList(null);
        returnReqDto.setOrderTradeNo(returnOrderItemSaveReqDto.getOrderNo());
        returnReqDto.setPayRecords(null);
        returnReqDto.setRefundAmount(returnOrderItemSaveReqDto.getRefundAmount());
        returnReqDto.setReqReason(returnOrderItemSaveReqDto.getRemark());
        returnReqDto.setReturnExpressCompany(null);
        returnReqDto.setReturnExpressDetail(null);
        returnReqDto.setReturnExpressSerial(null);
        returnReqDto.setReturnIntegral(null);
        returnReqDto.setReturnNo(null);
        returnReqDto.setReturnPointCoupon(null);
        returnReqDto.setReturnStatus(null);
        returnReqDto.setReturnType(StringUtils.isBlank((CharSequence)returnOrderItemSaveReqDto.getOrderReturnBizType()) ? OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode() : returnOrderItemSaveReqDto.getOrderReturnBizType());
        returnReqDto.setSellerRefundAmount(null);
        returnReqDto.setTradeNo(returnOrderItemSaveReqDto.getOrderNo());
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("refundStatus", RefundStatusEnum.INIT.getName());
        addrExtFields.put("totalAmount", returnOrderItemSaveReqDto.getRefundAmount());
        addrExtFields.put("placeUserId", returnOrderItemSaveReqDto.getPlaceUserId());
        addrExtFields.put("placeTime", returnOrderItemSaveReqDto.getPlaceTime());
        addrExtFields.put("remark", returnOrderItemSaveReqDto.getRemark());
        addrExtFields.put("customerId", returnOrderItemSaveReqDto.getCustomerId());
        addrExtFields.put("attachements", returnOrderItemSaveReqDto.getAttachmentList());
        if (Objects.nonNull(address) && StringUtils.isNotEmpty((CharSequence)address.getWarehouseCode())) {
            addrExtFields.put("warehouseCode", address.getWarehouseCode());
            returnReqDto.setWarehouseCode(address.getWarehouseCode());
        } else {
            RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(returnOrderItemSaveReqDto.getOrderNo());
            OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            addrExtFields.put("warehouseCode", orderDetailRespDto.getWarehouseCode());
            returnReqDto.setWarehouseCode(orderDetailRespDto.getWarehouseCode());
        }
        OrderReceiveDetailRespDto orderReceiveDetailRespDto = new OrderReceiveDetailRespDto();
        orderReceiveDetailRespDto.setCustomerName(returnOrderItemSaveReqDto.getCustomerName());
        orderReceiveDetailRespDto.setDeliveryAddress(address.getAddress());
        orderReceiveDetailRespDto.setDeliveryMobile(address.getDeliveryMobile());
        orderReceiveDetailRespDto.setDeliveryName(address.getDeliveryName());
        addrExtFields.put("returnDesc", JSON.toJSONString((Object)orderReceiveDetailRespDto));
        returnReqDto.setExtFields(addrExtFields);
        returnReqDto.setDeviceType("PC");
        returnReqDto.setDeliveryNo(returnOrderItemSaveReqDto.getDeliveryNo());
        returnReqDto.setCustomerId(returnOrderItemSaveReqDto.getCustomerId());
        RestResponse mapRestResponse = this.iAfterSalesApi.addAfterSale(returnReqDto);
        RestResponseHelper.extractData((RestResponse)mapRestResponse);
    }

    private List<ReturnOrderItemSaveReqDto> checkData(List<ReturnOrderItemSaveReqDto> itemList) {
        ArrayList<ReturnOrderItemSaveReqDto> list = new ArrayList<ReturnOrderItemSaveReqDto>();
        for (ReturnOrderItemSaveReqDto returnOrderItemSaveReqDto : itemList) {
            if (returnOrderItemSaveReqDto.getNum() == null) continue;
            list.add(returnOrderItemSaveReqDto);
        }
        return list;
    }

    public void updateReturnOrder(ReturnOrderUpdateReqDto returnOrderItemSaveReqDto) {
        if (!ReturnStatusToBEnum.WAIT_AUDIT.getCode().equals(returnOrderItemSaveReqDto.getOrderTradeStatus())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.RETURN_NOT_ALLOW_MODIFY);
        }
        List itemList = returnOrderItemSaveReqDto.getItemList();
        List supplierReturnList = itemList.stream().map(this::buildSupplierReturnItem).collect(Collectors.toList());
        ReturnOrderUpdateReqDto.Address address = returnOrderItemSaveReqDto.getReceiveDetail();
        ReturnModTobReqDto returnReqDto = new ReturnModTobReqDto();
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setCancelDesc(returnOrderItemSaveReqDto.getRemark());
        returnReqDto.setCancelType(DeliveryCancelTypeEnum.SELLER_CANCLE.getType());
        returnReqDto.setOrderTradeNo(returnOrderItemSaveReqDto.getOrderNo());
        returnReqDto.setRefundAmount(returnOrderItemSaveReqDto.getRefundAmount());
        returnReqDto.setReqReason(returnOrderItemSaveReqDto.getRemark());
        returnReqDto.setTradeNo(returnOrderItemSaveReqDto.getReturnNo());
        returnReqDto.setReturnNo(returnOrderItemSaveReqDto.getReturnNo());
        returnReqDto.setTotalAmount(returnOrderItemSaveReqDto.getRefundAmount());
        returnReqDto.setPlaceUserId(returnOrderItemSaveReqDto.getPlaceUserId());
        returnReqDto.setPlaceTime(returnOrderItemSaveReqDto.getPlaceTime());
        returnReqDto.setRemark(returnOrderItemSaveReqDto.getRemark());
        returnReqDto.setAttachements(returnOrderItemSaveReqDto.getAttachmentList());
        if (Objects.nonNull(address)) {
            OrderReceiveDetailRespDto orderReceiveDetailRespDto = new OrderReceiveDetailRespDto();
            orderReceiveDetailRespDto.setCustomerName(address.getCustomerName());
            orderReceiveDetailRespDto.setDeliveryAddress(address.getDeliveryAddress());
            orderReceiveDetailRespDto.setDeliveryMobile(address.getDeliveryMobile());
            orderReceiveDetailRespDto.setDeliveryName(address.getDeliveryName());
            returnReqDto.setReturnDesc(JSON.toJSONString((Object)orderReceiveDetailRespDto));
            if (StringUtils.isNotEmpty((CharSequence)address.getWarehouseCode())) {
                returnReqDto.setWarehouseCode(address.getWarehouseCode());
            }
        }
        returnReqDto.setUpdateFlag(TradeConstant.YES);
        RestResponse voidRestResponse = this.afterSalesTobApi.modifyReturnInfo(returnReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
    }

    public void cancelByReturn(NullifyOrderReqDto nullifyOrderReqDto) {
        CancelReqDto cancelOrderReqDto = new CancelReqDto();
        cancelOrderReqDto.setTradeNo(cancelOrderReqDto.getTradeNo());
        cancelOrderReqDto.setCancelDesc(nullifyOrderReqDto.getNullifyDesc());
        cancelOrderReqDto.setCancelType(nullifyOrderReqDto.getNullifyType());
        cancelOrderReqDto.setTradeNo(nullifyOrderReqDto.getTradeNo());
        String s = nullifyOrderReqDto.getOrderNo();
        RestResponse voidRestResponse = this.iAfterSalesApi.cancelByReturn(s, cancelOrderReqDto);
        RestResponseHelper.extractData((RestResponse)voidRestResponse);
    }

    public ReFundOrderDetailRespDto queryById(String returnNo) {
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(returnNo, "{}");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)returnDetailRespDtoRestResponse);
        logger.info("\u9000\u8ba2\u5355\u8be6\u60c5:{}", (Object)JacksonUtil.toJson((Object)returnDetailRespDto));
        String refundType = "1";
        String tradeNo = null;
        if (StringUtils.isNotEmpty((CharSequence)returnDetailRespDto.getDeliveryNo())) {
            refundType = "2";
            tradeNo = returnDetailRespDto.getDeliveryNo();
        } else {
            refundType = "APP".equals(returnDetailRespDto.getDeviceType()) ? "3" : "1";
            tradeNo = returnDetailRespDto.getOrderTradeNo();
        }
        String finalRefundType = refundType;
        ArrayList itemDetails = Lists.newArrayList();
        BigDecimal payAmount = BigDecimal.ZERO;
        List itemIds = returnDetailRespDto.getReturnOmniItemRespDtoList().stream().filter(Objects::nonNull).distinct().map(ReturnOmniItemRespDto::getItemId).collect(Collectors.toList());
        ArrayList respDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            respDtos.addAll((Collection)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIdsOnPost(itemIds)));
        }
        Map<String, ItemRespDto> itemRespDtoMap = respDtos.stream().collect(Collectors.toMap(e -> String.valueOf(e.getId()), e -> e, (e1, e2) -> e1));
        BigDecimal refundAmount = new BigDecimal(0);
        HashMap<String, Integer> itemRefundMap = new HashMap<String, Integer>();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.iCustomerQueryApi.queryCurrentUserOrgId());
        List<Object> interceptList = Lists.newArrayList();
        ItemInterceptConfigEnum itemInterceptConfigEnum = null;
        ItemInterceptConfigReqDto itemInterceptConfigReqDto = new ItemInterceptConfigReqDto();
        itemInterceptConfigReqDto.setOrganizationId(orgId);
        itemInterceptConfigReqDto.setStatus(YesOrNoEnum.YES.getCode());
        PageInfo itemInterceptConfigRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemInterceptConfigQueryApi.queryByPage(JSON.toJSONString((Object)itemInterceptConfigReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (CollectionUtils.isNotEmpty((Collection)itemInterceptConfigRespDtoPageInfo.getList())) {
            ItemInterceptConfigRespDto itemInterceptConfigRespDto = (ItemInterceptConfigRespDto)itemInterceptConfigRespDtoPageInfo.getList().stream().findFirst().get();
            itemInterceptConfigEnum = ItemInterceptConfigEnum.enumOfCode((Integer)itemInterceptConfigRespDto.getInterceptType());
            ItemInterceptDetailReqDto itemInterceptDetailReqDto = new ItemInterceptDetailReqDto();
            itemInterceptDetailReqDto.setOrganizationId(itemInterceptConfigRespDto.getOrganizationId());
            PageInfo itemInterceptDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemInterceptDetailQueryApi.queryByPage(JSON.toJSONString((Object)itemInterceptDetailReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            interceptList = itemInterceptDetailRespDtoPageInfo.getList().stream().map(c -> Long.valueOf(c.getInterceptContent())).collect(Collectors.toList());
        }
        for (ReturnOmniItemRespDto omniItemRespDto : returnDetailRespDto.getReturnOmniItemRespDtoList()) {
            ReFundOrderDetailRespDto.ItemDetail itemDetail = this.buildItemDetail(omniItemRespDto, itemRefundMap, finalRefundType, itemRespDtoMap, itemInterceptConfigEnum, interceptList);
            Integer isAllowReturn = omniItemRespDto.getIsAllowReturn();
            if (isAllowReturn == 1) {
                payAmount = payAmount.add(itemDetail.getSubTotal());
                refundAmount = refundAmount.add(itemDetail.getSubTotal());
            }
            itemDetails.add(itemDetail);
        }
        returnDetailRespDto.setRefundAmount(refundAmount);
        this.buildUtilMessageByIds(itemDetails);
        ReFundOrderDetailRespDto reFundOrderDetailRespDto = new ReFundOrderDetailRespDto();
        reFundOrderDetailRespDto.setReturnExpressCompany(returnDetailRespDto.getReturnExpressCompany());
        reFundOrderDetailRespDto.setReturnExpressCompanyName(returnDetailRespDto.getReturnExpressCompanyName());
        reFundOrderDetailRespDto.setReturnExpressSerial(returnDetailRespDto.getReturnExpressSerial());
        reFundOrderDetailRespDto.setReturnExpressDetail(returnDetailRespDto.getReturnExpressDetail());
        if ("3".equals(refundType)) {
            reFundOrderDetailRespDto.setReturnItemDetail((List)itemDetails);
        } else {
            reFundOrderDetailRespDto.setReturnItemDetail((List)itemDetails);
        }
        Map extFields = returnDetailRespDto.getExtFields();
        String returnDesc = extFields.get("returnDesc") + "";
        this.buildAddress(reFundOrderDetailRespDto, returnDesc);
        ReFundOrderDetailRespDto.BuildOrderDetail buildOrderDetail = new ReFundOrderDetailRespDto.BuildOrderDetail();
        String refundStatus = extFields.get("refundStatus") + "";
        String placeUserId = extFields.get("placeUserId") + "";
        String remark = extFields.get("remark") + "";
        RefundOrderStatusToBEnum refundOrderStatusToBEnum = ReturnOrderUtil.convertRefundStatus(refundStatus);
        reFundOrderDetailRespDto.setOrderRefundStatus(refundOrderStatusToBEnum.getCode());
        reFundOrderDetailRespDto.setOrderRefundStatusName(refundOrderStatusToBEnum.getName());
        reFundOrderDetailRespDto.setOrderTradeStatus(ReturnStatusToBEnum.toCode((String)returnDetailRespDto.getReturnStatus()));
        reFundOrderDetailRespDto.setOrderTradeStatusName(ReturnStatusToBEnum.toName((String)returnDetailRespDto.getReturnStatus()));
        reFundOrderDetailRespDto.setOrderId(null);
        reFundOrderDetailRespDto.setOrderNo(returnDetailRespDto.getOrderTradeNo());
        reFundOrderDetailRespDto.setPayAmount(payAmount);
        reFundOrderDetailRespDto.setAmount(returnDetailRespDto.getRefundAmount());
        reFundOrderDetailRespDto.setPlaceType("\u4ee3\u5ba2\u4e0b\u5355");
        reFundOrderDetailRespDto.setRefundId(null);
        reFundOrderDetailRespDto.setReturnedAmount(null);
        reFundOrderDetailRespDto.setBizType(returnDetailRespDto.getReturnType());
        reFundOrderDetailRespDto.setBizTypeName(OrderReturnBizTypeEnum.toName((String)returnDetailRespDto.getReturnType()));
        reFundOrderDetailRespDto.setReturnNo(returnDetailRespDto.getReturnNo());
        reFundOrderDetailRespDto.setReturnOrderRemark(remark);
        UserDto userInfo = this.findUserInfo(StringUtils.isBlank((CharSequence)placeUserId) || "null".equals(placeUserId) ? null : Long.valueOf(placeUserId));
        Long customerId = Long.valueOf(extFields.get("customerId") + "");
        CustomerRespDto customerInfo = this.findCustomerInfo(customerId);
        reFundOrderDetailRespDto.setCustomerId(extFields.get("customerId") + "");
        reFundOrderDetailRespDto.setCustomerName(customerInfo.getName());
        UserDto salesmanInfo = this.findUserInfo(customerInfo.getSalesmanId());
        reFundOrderDetailRespDto.setSalesmanName(StringUtils.isNotEmpty((CharSequence)salesmanInfo.getNickName()) ? salesmanInfo.getNickName() : salesmanInfo.getUserName());
        buildOrderDetail.setBuildPerson(userInfo.getUserName());
        buildOrderDetail.setCreateTime(ReturnOrderServiceImpl.dateToString(returnDetailRespDto.getCreateTime()));
        reFundOrderDetailRespDto.setBuildOrderDetail(buildOrderDetail);
        reFundOrderDetailRespDto.setShopId(returnDetailRespDto.getShopId());
        reFundOrderDetailRespDto.setSellerId(returnDetailRespDto.getSellerId());
        reFundOrderDetailRespDto.setReturnReason(returnDetailRespDto.getReturnReason());
        this.fillDetailSellerInfo(reFundOrderDetailRespDto);
        if (CollectionUtils.isNotEmpty((Collection)returnDetailRespDto.getApplyReturnItemRespDtoList())) {
            this.setApplyReturnItemBatchNoInfo(returnDetailRespDto.getApplyReturnItemRespDtoList());
        }
        RestResponse attachementRestResp = this.attachementQueryApi.queryByNoAndType(reFundOrderDetailRespDto.getReturnNo(), "RETURN");
        List attachementReqDtoList = (List)RestResponseHelper.extractData((RestResponse)attachementRestResp);
        reFundOrderDetailRespDto.setAttachmentList(attachementReqDtoList);
        reFundOrderDetailRespDto.setReturnRebate(returnDetailRespDto.getReturnRebate());
        reFundOrderDetailRespDto.setWarehouseCode(Objects.nonNull(extFields.get("warehouseCode")) ? extFields.get("warehouseCode") + "" : null);
        reFundOrderDetailRespDto.setExtension(returnDetailRespDto.getExtension());
        reFundOrderDetailRespDto.setApplyReturnItemRespDtoList(returnDetailRespDto.getApplyReturnItemRespDtoList());
        reFundOrderDetailRespDto.setApplyReturnQty(returnDetailRespDto.getApplyReturnQty());
        reFundOrderDetailRespDto.setCreateMode(returnDetailRespDto.getCreateMode());
        CustomAddressDto customAddressDto = (CustomAddressDto)JSON.parseObject((String)returnDetailRespDto.getBuyerAddrInfo(), CustomAddressDto.class);
        reFundOrderDetailRespDto.setBuyerAddrInfo(customAddressDto);
        reFundOrderDetailRespDto.setReturnOrderRemark(returnDetailRespDto.getRemark());
        this.setApplyReturnItemInfo(reFundOrderDetailRespDto, itemRefundMap);
        this.setActivityCode(reFundOrderDetailRespDto);
        if (CollectionUtils.isNotEmpty((Collection)reFundOrderDetailRespDto.getReturnItemDetail())) {
            JSONObject jsonObjectReturnRespDto = new JSONObject();
            jsonObjectReturnRespDto.put("returnNo", (Object)returnNo);
            jsonObjectReturnRespDto.put("instanceId", (Object)this.context.instanceId());
            jsonObjectReturnRespDto.put("tenantId", (Object)this.context.tenantId());
            RestResponse pageInfoRestResponse1 = this.refundQueryApi.queryByPage(jsonObjectReturnRespDto.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            BigDecimal returnedPayAmount = new BigDecimal("0");
            if (pageInfoRestResponse1 != null && ((PageInfo)pageInfoRestResponse1.getData()).getList() != null && ((PageInfo)pageInfoRestResponse1.getData()).getList().size() > 0) {
                List list = ((PageInfo)pageInfoRestResponse1.getData()).getList();
                returnedPayAmount = this.countAlreadyPayAmount(list);
            }
            reFundOrderDetailRespDto.setAmount(returnedPayAmount);
        }
        try {
            ArrayList<Long> customerIdList = new ArrayList<Long>(Arrays.asList(customerId));
            Map companyMap = (Map)RestResponseHelper.extractData((RestResponse)this.userExtV2QueryApi.queryCompanyNameByCusId(customerIdList));
            if (MapUtil.isNotEmpty((Map)companyMap) && returnDetailRespDto.getCustomerId() != null && companyMap.get(customerId) != null) {
                reFundOrderDetailRespDto.setOrganizationName(((CompanySimpleInfoDto)companyMap.get(customerId)).getOrgName());
                reFundOrderDetailRespDto.setCustomerOrgName(((CompanySimpleInfoDto)companyMap.get(customerId)).getOrgName());
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return reFundOrderDetailRespDto;
    }

    private void setActivityCode(ReFundOrderDetailRespDto reFundOrderDetailRespDto) {
        logger.info("\u9000\u8d27\u5355\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)reFundOrderDetailRespDto));
        Set<Object> activityIdSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)reFundOrderDetailRespDto.getApplyReturnItemRespDtoList())) {
            activityIdSet = reFundOrderDetailRespDto.getApplyReturnItemRespDtoList().stream().map(ApplyReturnItemRespDto::getCombinedPackageActivityId).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollectionUtils.isNotEmpty((Collection)reFundOrderDetailRespDto.getReturnItemDetail())) {
            activityIdSet.addAll(reFundOrderDetailRespDto.getReturnItemDetail().stream().map(ReFundOrderDetailRespDto.ItemDetail::getCombinedPackageActivityId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty((Collection)activityIdSet)) {
            List activityRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds(new ArrayList(activityIdSet)));
            logger.info("\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)activityRespDtoList));
            Map<Long, ActivityRespDto> activityMap = activityRespDtoList.stream().collect(Collectors.toMap(ActivityRespDto::getId, act -> act, (e1, e2) -> e1));
            if (CollectionUtils.isNotEmpty((Collection)reFundOrderDetailRespDto.getApplyReturnItemRespDtoList())) {
                reFundOrderDetailRespDto.getApplyReturnItemRespDtoList().stream().filter(e -> CombinationEnum.YES.getType().equals(e.getIsCombinedPackage()) && e.getCombinedPackageActivityId() != null && activityMap.containsKey(e.getCombinedPackageActivityId())).forEach(e -> {
                    ActivityRespDto activityRespDto = (ActivityRespDto)activityMap.get(e.getCombinedPackageActivityId());
                    e.setActivityCode(activityRespDto.getActivityCode());
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)reFundOrderDetailRespDto.getReturnItemDetail())) {
                reFundOrderDetailRespDto.getReturnItemDetail().stream().filter(e -> CombinationEnum.YES.getType().equals(e.getIsCombinedPackage()) && e.getCombinedPackageActivityId() != null && activityMap.containsKey(e.getCombinedPackageActivityId())).forEach(e -> {
                    ActivityRespDto activityRespDto = (ActivityRespDto)activityMap.get(e.getCombinedPackageActivityId());
                    e.setActivityCode(activityRespDto.getActivityCode());
                });
            }
        }
    }

    private void setApplyReturnItemBatchNoInfo(List<ApplyReturnItemRespDto> applyReturnItemRespDtoList) {
        HashSet batchNoSet = Sets.newHashSet();
        ArrayList all = Lists.newArrayList();
        for (ApplyReturnItemRespDto applyReturnItemRespDto : applyReturnItemRespDtoList) {
            String[] batchNumArr;
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)applyReturnItemRespDto.getSrcBatchNo())) {
                ArrayList srcTradeItemBatchDtos = Lists.newArrayList();
                for (String batchNo : split = applyReturnItemRespDto.getSrcBatchNo().split(",")) {
                    batchNumArr = batchNo.split("#");
                    ApplyReturnItemBatchRespDto srcBatchNo = new ApplyReturnItemBatchRespDto();
                    srcBatchNo.setBatchNo(batchNumArr[0]);
                    srcBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                    batchNoSet.add(batchNumArr[0]);
                    srcTradeItemBatchDtos.add(srcBatchNo);
                    all.add(srcBatchNo);
                }
                applyReturnItemRespDto.setSrcTradeItemBatchNoDtos((List)srcTradeItemBatchDtos);
            }
            if (!StringUtils.isNotBlank((CharSequence)applyReturnItemRespDto.getBatchNo())) continue;
            ArrayList itemBatchNoList = Lists.newArrayList();
            for (String batchNo : split = applyReturnItemRespDto.getBatchNo().split(",")) {
                batchNumArr = batchNo.split("#");
                ApplyReturnItemBatchRespDto applyBatchNo = new ApplyReturnItemBatchRespDto();
                applyBatchNo.setBatchNo(batchNumArr[0]);
                if (batchNumArr.length > 1) {
                    applyBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                }
                batchNoSet.add(batchNumArr[0]);
                itemBatchNoList.add(applyBatchNo);
                all.add(applyBatchNo);
            }
            applyReturnItemRespDto.setApplyItemBatchNoDtos((List)itemBatchNoList);
        }
    }

    private void setApplyReturnItemInfo(ReFundOrderDetailRespDto reFundOrderDetailRespDto, Map<String, Integer> itemRefundMap) {
        if (itemRefundMap == null || itemRefundMap.isEmpty()) {
            itemRefundMap = new HashMap<String, Integer>();
        }
        if (ReturnOrderCreateModeEnum.FROM_ORDER.getType().equalsIgnoreCase(reFundOrderDetailRespDto.getCreateMode())) {
            for (ApplyReturnItemRespDto itemRespDto : reFundOrderDetailRespDto.getApplyReturnItemRespDtoList()) {
                Integer returnedNum = itemRefundMap.get(itemRespDto.getCargoSerial()) == null ? Integer.valueOf(0) : itemRefundMap.get(itemRespDto.getCargoSerial());
                Integer canReturnNum = itemRespDto.getItemNum() - returnedNum;
                itemRespDto.setCanReturnedNum(canReturnNum);
            }
        }
    }

    private void fillDetailSellerInfo(ReFundOrderDetailRespDto reFundOrderDetailRespDto) {
        if (StringUtils.isEmpty((CharSequence)reFundOrderDetailRespDto.getShopId())) {
            return;
        }
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(Long.valueOf(reFundOrderDetailRespDto.getShopId()).longValue(), new String[0]).getData();
        reFundOrderDetailRespDto.setShopName(shopDto.getName());
        reFundOrderDetailRespDto.setSellerName(shopDto.getSellerName());
    }

    @NotNull
    private OrderDetailRespDto buildCustomerMessage(ReFundOrderDetailRespDto reFundOrderDetailRespDto) {
        RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(reFundOrderDetailRespDto.getOrderNo());
        OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (!orderData.getExtFields().isEmpty()) {
            Map orderExtFields = orderData.getExtFields();
            Long customerId = Long.valueOf(orderExtFields.get("customerId") + "");
            CustomerRespDto customerInfo = this.findCustomerInfo(customerId);
            UserDto salesmanInfo = this.findUserInfo(customerInfo.getSalesmanId());
            reFundOrderDetailRespDto.setSalesmanName(StringUtils.isNotEmpty((CharSequence)salesmanInfo.getNickName()) ? salesmanInfo.getNickName() : salesmanInfo.getUserName());
        }
        return orderData;
    }

    private void buildAddress(ReFundOrderDetailRespDto reFundOrderDetailRespDto, String returnDesc) {
        try {
            OrderReceiveDetailRespDto orderReceiveDetailRespDto = (OrderReceiveDetailRespDto)JSONObject.parseObject((String)returnDesc, OrderReceiveDetailRespDto.class);
            OrderReceiveDetailRespDto receiveDetail = new OrderReceiveDetailRespDto();
            receiveDetail.setCustomerName(orderReceiveDetailRespDto.getCustomerName());
            receiveDetail.setDeliveryAddress(orderReceiveDetailRespDto.getDeliveryAddress());
            receiveDetail.setDeliveryMobile(orderReceiveDetailRespDto.getDeliveryMobile());
            receiveDetail.setDeliveryName(orderReceiveDetailRespDto.getDeliveryName());
            reFundOrderDetailRespDto.setReceiveDetail(receiveDetail);
        }
        catch (Exception e) {
            logger.info("\u5730\u5740\u89e3\u6790\u5f02\u5e38,data----:" + JSON.toJSONString((Object)returnDesc));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
    }

    private void buildUtilMessageByIds(List<ReFundOrderDetailRespDto.ItemDetail> itemDetails) {
        if (CollectionUtils.isNotEmpty(itemDetails)) {
            HashSet<Long> unitIds = new HashSet<Long>(itemDetails.size());
            for (ReFundOrderDetailRespDto.ItemDetail itemDetail : itemDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)itemDetail.getUnit())) continue;
                try {
                    Long unitId = Long.parseLong(itemDetail.getUnit());
                    unitIds.add(unitId);
                }
                catch (NumberFormatException e) {
                    logger.info("\u9000\u8ba2\u5355\u8be6\u60c5\u8fd4\u56de\u5355\u4f4d\u8f6c\u6362\u51fa\u9519>>>{}", (Object)(itemDetail.getUnit() + itemDetail.getItemId()));
                }
            }
            if (CollectionUtils.isNotEmpty(unitIds)) {
                List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
                Map<String, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(unitResp -> unitResp.getId().toString(), UnitRespDto::getName, (e1, e2) -> e1));
                for (ReFundOrderDetailRespDto.ItemDetail itemDetail : itemDetails) {
                    if (!StringUtils.isNotEmpty((CharSequence)itemDetail.getUnit())) continue;
                    String unitName = unitNameMap.get(itemDetail.getUnit());
                    itemDetail.setUnitName(unitName);
                }
            }
        }
    }

    private ReFundOrderDetailRespDto.ItemDetail buildItemDetail(ReturnOmniItemRespDto returnOmniItemRespDto, Map<String, Integer> itemRefundMap, String refundType, Map<String, ItemRespDto> itemMap, ItemInterceptConfigEnum itemInterceptConfigEnum, List<Long> interceptList) {
        ReFundOrderDetailRespDto.ItemDetail itemDetail = new ReFundOrderDetailRespDto.ItemDetail();
        itemDetail.setIndex(Integer.valueOf(1));
        Map extFields = returnOmniItemRespDto.getExtFields();
        String unit = extFields.get("unit") + "";
        String returnedNum = extFields.get("returnedNum") + "";
        String returnNUm = extFields.get("returnNum") + "";
        String itemAmount = extFields.get("itemAmount") + "";
        String refundAmount = extFields.get("refundAmount") + "";
        String returnRebate = extFields.get("returnRebate") + "";
        itemDetail.setItemId(Long.valueOf(returnOmniItemRespDto.getItemId()));
        itemDetail.setItemCode(returnOmniItemRespDto.getItemCode());
        itemDetail.setItemName(returnOmniItemRespDto.getItemName());
        itemDetail.setCargoSerial(returnOmniItemRespDto.getCargoSerial());
        itemDetail.setItemNum(Integer.valueOf(returnOmniItemRespDto.getItemNum() == null ? 0 : returnOmniItemRespDto.getItemNum()));
        itemDetail.setNum(Integer.valueOf(StringUtils.isBlank((CharSequence)returnNUm) || "null".equals(returnNUm) ? 0 : Integer.parseInt(returnNUm)));
        itemDetail.setGift(returnOmniItemRespDto.getGift());
        itemDetail.setTradeItemNo(returnOmniItemRespDto.getTradeItemNo());
        itemDetail.setEachShareAmount(returnOmniItemRespDto.getEachShareAmount());
        if (returnOmniItemRespDto.getReturnNum() != null) {
            itemDetail.setReturnedNum(returnOmniItemRespDto.getReturnNum());
            itemRefundMap.put(returnOmniItemRespDto.getTradeItemId() + "_" + returnOmniItemRespDto.getCargoSerial(), returnOmniItemRespDto.getReturnNum());
        }
        if (itemDetail.getGift() == 0) {
            itemDetail.setCanReturnedNum(Integer.valueOf(itemDetail.getItemNum() - itemDetail.getReturnedNum()));
        } else {
            Integer deliveredNum = returnOmniItemRespDto.getDeliveredNum() == null ? 0 : returnOmniItemRespDto.getDeliveredNum();
            itemDetail.setCanReturnedNum(Integer.valueOf(deliveredNum - itemDetail.getReturnedNum()));
        }
        itemDetail.setThisStorageNum(Integer.valueOf(StringUtils.isBlank((CharSequence)returnNUm) || "null".equals(returnNUm) ? 0 : Integer.parseInt(returnNUm)));
        itemDetail.setItemPrice(returnOmniItemRespDto.getItemPrice());
        itemDetail.setId(returnOmniItemRespDto.getId());
        itemDetail.setRetailPrice(returnOmniItemRespDto.getItemMarketPrice());
        itemDetail.setPromotionPrice(returnOmniItemRespDto.getPromotionPrice());
        BigDecimal adjustPrice = returnOmniItemRespDto.getItemPrice();
        if (returnOmniItemRespDto.getAdjustNum() != null) {
            adjustPrice = adjustPrice.add(returnOmniItemRespDto.getAdjustNum());
        }
        itemDetail.setSubTotal(adjustPrice.multiply(new BigDecimal(itemDetail.getNum())));
        itemDetail.setSubTotalReturnAmount(StringUtils.isBlank((CharSequence)refundAmount) || "null".equals(refundAmount) ? BigDecimal.ZERO : new BigDecimal(refundAmount));
        itemDetail.setRemark(returnOmniItemRespDto.getRemark());
        itemDetail.setSkuName(returnOmniItemRespDto.getSkuDesc());
        itemDetail.setSkuId(Long.valueOf(returnOmniItemRespDto.getSkuSerial()));
        itemDetail.setItemId(Long.valueOf(returnOmniItemRespDto.getItemId()));
        itemDetail.setAdjustNum(returnOmniItemRespDto.getAdjustNum());
        itemDetail.setUnit(unit);
        itemDetail.setCargoSerial(returnOmniItemRespDto.getCargoSerial());
        itemDetail.setAdjustNum(returnOmniItemRespDto.getAdjustNum());
        if (StringUtils.isNotBlank((CharSequence)returnOmniItemRespDto.getExtension())) {
            OrderItemExtDto jsonObject = (OrderItemExtDto)JSONObject.parseObject((String)returnOmniItemRespDto.getExtension(), OrderItemExtDto.class);
            itemDetail.setPath(jsonObject.getImgPath());
        }
        itemDetail.setTradeNo(returnOmniItemRespDto.getTradeNo());
        itemDetail.setDiscountAmount(returnOmniItemRespDto.getDiscountAmount());
        itemDetail.setEachDiscountAmount(returnOmniItemRespDto.getEachDiscountAmount());
        itemDetail.setGiftDeduction(returnOmniItemRespDto.getGiftDeductionAmount());
        itemDetail.setEachGiftDeductionAmount(returnOmniItemRespDto.getEachGiftDeductionAmount());
        itemDetail.setBatchNo(returnOmniItemRespDto.getBatchNo());
        itemDetail.setIsAllowReturn(returnOmniItemRespDto.getIsAllowReturn());
        if (itemMap.containsKey(returnOmniItemRespDto.getItemId())) {
            ItemRespDto itemRespDto = itemMap.get(returnOmniItemRespDto.getItemId());
            itemDetail.setItemTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemRespDto.getSubType()));
            if (CollectionUtils.isNotEmpty(interceptList)) {
                Integer flag = null == itemInterceptConfigEnum ? YesOrNoEnum.YES.getCode() : (itemInterceptConfigEnum.equals((Object)ItemInterceptConfigEnum.BRAND) ? (!interceptList.contains(itemRespDto.getBrandId()) ? YesOrNoEnum.YES.getCode() : YesOrNoEnum.NO.getCode()) : (!interceptList.contains(itemRespDto.getItemId()) ? YesOrNoEnum.YES.getCode() : YesOrNoEnum.NO.getCode()));
                itemDetail.setIsAllowReturn(flag);
                itemDetail.setIsAllowEditReturn(flag);
            }
        }
        itemDetail.setIfExchange(returnOmniItemRespDto.getIfExchange());
        itemDetail.setIsCombinedPackage(returnOmniItemRespDto.getIsCombinedPackage());
        itemDetail.setCombinedPackageActivityId(returnOmniItemRespDto.getCombinedPackageActivityId());
        if (StringUtils.isNotBlank((CharSequence)returnOmniItemRespDto.getBatchNo())) {
            String[] split;
            ArrayList itemBatchNoList = Lists.newArrayList();
            for (String batchNo : split = returnOmniItemRespDto.getBatchNo().split(",")) {
                String[] batchNumArr = batchNo.split("#");
                ApplyReturnItemBatchRespDto applyBatchNo = new ApplyReturnItemBatchRespDto();
                applyBatchNo.setBatchNo(batchNumArr[0]);
                applyBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                itemBatchNoList.add(applyBatchNo);
            }
            itemDetail.setApplyItemBatchNoDtos((List)itemBatchNoList);
        }
        return itemDetail;
    }

    public void auditOrder(OrderAuditToBReqDto orderAuditToBReqDto) {
        ReturnAuditReqDto returnAuditReqDto = new ReturnAuditReqDto();
        returnAuditReqDto.setAuditDesc(orderAuditToBReqDto.getAuditDesc());
        returnAuditReqDto.setAuditor(orderAuditToBReqDto.getAuditor());
        returnAuditReqDto.setAuditStatus(1 == orderAuditToBReqDto.getAuditResult() ? "pass" : "reject");
        returnAuditReqDto.setAuditTime(new Date());
        returnAuditReqDto.setAuditType(orderAuditToBReqDto.getAuditType() + "");
        returnAuditReqDto.setReturnNo(orderAuditToBReqDto.getOrderNo());
        RestResponse stringRestResponse = this.afterSalesTobApi.auditReturnRefactor(orderAuditToBReqDto.getOrderNo(), returnAuditReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
        OptLogReqDto optLogDto = new OptLogReqDto();
        optLogDto.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogDto.setBizNo(returnAuditReqDto.getReturnNo());
        optLogDto.setOptTime(new Date());
        optLogDto.setOptPerson(this.context.userName());
        optLogDto.setOptType("RETURN_AUDIT");
        StringBuilder description = new StringBuilder();
        if ("3".equals(returnAuditReqDto.getAuditType())) {
            if ("reject".equals(returnAuditReqDto.getAuditStatus())) {
                description.append("\u552e\u540e\u7533\u8bf7\u5ba1\u6838\u4e0d\u901a\u8fc7");
                description.append("\uff0c\u539f\u56e0\uff1a");
                description.append(returnAuditReqDto.getAuditDesc());
            } else {
                description.append("\u552e\u540e\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7");
            }
        } else if ("reject".equals(returnAuditReqDto.getAuditStatus())) {
            description.append("\u9000\u8ba2\u5355\u9000\u6b3e\u5ba1\u6838\u4e0d\u901a\u8fc7");
            description.append("\uff0c\u539f\u56e0\uff1a");
            description.append(returnAuditReqDto.getAuditDesc());
        } else {
            description.append("\u9000\u8ba2\u5355\u9000\u6b3e\u5ba1\u6838\u901a\u8fc7");
        }
        optLogDto.setDescription(description.toString());
        RestResponse response = this.optLogApi.addBoOptLog(optLogDto);
        RestResponseHelper.extractData((RestResponse)response);
    }

    public ReceiveDetailRespDto findReceiveDetailById(String returnNo) {
        RestResponse position;
        String warehouseCode;
        ReFundOrderDetailRespDto detail = this.returnOrderService.queryById(returnNo);
        ReceiveDetailRespDto orderDeliveryToBRespDto = new ReceiveDetailRespDto();
        orderDeliveryToBRespDto.setReturnNo(returnNo);
        List itemList = detail.getReturnItemDetail();
        Map<String, List<StorageOrderDetailRespDto>> storageDetailMap = this.getItemOutNum(returnNo);
        List Items = itemList.stream().map(data -> this.buildWaitOutboundItemDto((ReFundOrderDetailRespDto.ItemDetail)data, storageDetailMap)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(Items)) {
            HashSet itemIds = Sets.newHashSet();
            HashSet<Long> unitIds = new HashSet<Long>(Items.size());
            for (ItemReceiveRespDto itemReceiveResp : Items) {
                itemIds.add(itemReceiveResp.getItemId());
                if (!StringUtils.isNotEmpty((CharSequence)itemReceiveResp.getUnit())) continue;
                try {
                    Long unitId = Long.parseLong(itemReceiveResp.getUnit());
                    unitIds.add(unitId);
                }
                catch (NumberFormatException e3) {
                    logger.info("\u9000\u8d27\u5165\u5e93\u4fe1\u606f\u8be6\u60c5\u8fd4\u56de\u5355\u4f4d\u8f6c\u6362\u51fa\u9519>>>{}", (Object)(itemReceiveResp.getUnit() + itemReceiveResp.getItemId()));
                }
            }
            Map<Object, Object> itemRespDtoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemIds)) {
                List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(StringUtils.join((Iterable)itemIds, (String)",")));
                itemRespDtoMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, e -> e, (e1, e2) -> e2));
            }
            if (CollectionUtils.isNotEmpty(unitIds)) {
                List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
                Map<String, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(unitResp -> unitResp.getId().toString(), UnitRespDto::getName, (e1, e2) -> e1));
                for (ItemReceiveRespDto itemReceiveResp : Items) {
                    if (itemRespDtoMap.containsKey(itemReceiveResp.getItemId())) {
                        ItemRespDto itemRespDto = (ItemRespDto)itemRespDtoMap.get(itemReceiveResp.getItemId());
                        itemReceiveResp.setItemType(itemRespDto.getType());
                        itemReceiveResp.setSubType(itemRespDto.getSubType());
                        itemReceiveResp.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemRespDto.getSubType()));
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)itemReceiveResp.getUnit())) continue;
                    String unitName = unitNameMap.get(itemReceiveResp.getUnit());
                    itemReceiveResp.setUnitName(unitName);
                }
            }
        }
        orderDeliveryToBRespDto.setItemList(Items);
        OrderReceiveDetailRespDto receiveDetail = detail.getReceiveDetail();
        OrderAddressReqDto orderAddressReqDto = new OrderAddressReqDto();
        if (null != receiveDetail) {
            orderAddressReqDto.setDeliveryName(receiveDetail.getDeliveryName());
            orderAddressReqDto.setAddress(receiveDetail.getDeliveryAddress());
            orderAddressReqDto.setDeliveryPhone(receiveDetail.getDeliveryMobile());
            orderAddressReqDto.setDeliveryMobile(receiveDetail.getDeliveryMobile());
            orderAddressReqDto.setAreaName(receiveDetail.getDeliveryAddress());
            orderDeliveryToBRespDto.setCustomerName(receiveDetail.getCustomerName());
        }
        orderAddressReqDto.setProvinceName("");
        orderAddressReqDto.setCityName("");
        orderAddressReqDto.setDetailed("");
        orderDeliveryToBRespDto.setAddress(orderAddressReqDto);
        orderDeliveryToBRespDto.setOrderNo(detail.getOrderNo());
        orderDeliveryToBRespDto.setOrderTradeStatus(detail.getOrderTradeStatus());
        orderDeliveryToBRespDto.setOrderTradeStatusName(detail.getOrderTradeStatusName());
        orderDeliveryToBRespDto.setPlaceType(detail.getPlaceType());
        orderDeliveryToBRespDto.setOrderRefundStatus(detail.getOrderRefundStatus());
        orderDeliveryToBRespDto.setOrderRefundStatusName(detail.getOrderRefundStatusName());
        orderDeliveryToBRespDto.setOrderTradeStatus(detail.getOrderTradeStatus());
        orderDeliveryToBRespDto.setOrderTradeStatusName(detail.getOrderTradeStatusName());
        orderDeliveryToBRespDto.setCustomerName(detail.getCustomerName());
        orderDeliveryToBRespDto.setBuyerAddrInfo(detail.getBuyerAddrInfo());
        orderDeliveryToBRespDto.setCreateMode(detail.getCreateMode());
        orderDeliveryToBRespDto.setReturnExpressCompany(detail.getReturnExpressCompany());
        orderDeliveryToBRespDto.setReturnExpressCompanyName(detail.getReturnExpressCompanyName());
        orderDeliveryToBRespDto.setReturnExpressSerial(detail.getReturnExpressSerial());
        orderDeliveryToBRespDto.setReturnExpressDetail(detail.getReturnExpressDetail());
        orderDeliveryToBRespDto.setReturnLogisticsRespDto((ReturnLogisticsRespDto)JSONObject.parseObject((String)detail.getExtension(), ReturnLogisticsRespDto.class));
        TcbjReciptResReqDto tcbjReciptResReqDto = new TcbjReciptResReqDto();
        tcbjReciptResReqDto.setPreNo(returnNo);
        tcbjReciptResReqDto.setPageNum(Integer.valueOf(1));
        tcbjReciptResReqDto.setPageSize(Integer.valueOf(10));
        CsReceiveResultOrderQueryDto receiveResultOrderQueryDto = new CsReceiveResultOrderQueryDto();
        receiveResultOrderQueryDto.setPreOrderNo(returnNo);
        receiveResultOrderQueryDto.setPageNum(Integer.valueOf(1));
        receiveResultOrderQueryDto.setPageSize(Integer.valueOf(10));
        RestResponse pageInfoRestResponse = this.receiveResultOrderQueryApi.queryByPage(receiveResultOrderQueryDto);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u6536\u8d27\u7ed3\u679c\u5355:{}", (Object)pageInfoRestResponse);
        PageInfo resultOrderRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.nonNull(resultOrderRespDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)resultOrderRespDtoPageInfo.getList())) {
            CsReceiveResultOrderRespDto dto = (CsReceiveResultOrderRespDto)resultOrderRespDtoPageInfo.getList().get(0);
            orderDeliveryToBRespDto.setReceiptResultNo(dto.getDocumentNo());
            orderDeliveryToBRespDto.setReceiveTime(dto.getCreateTime());
            orderDeliveryToBRespDto.setReceiveStatusName(CsOrderStatusEnum.getDescByCode((String)dto.getOrderStatus()));
            if (dto.getTotalQuantity() != null) {
                orderDeliveryToBRespDto.setTotalReceiveNum(Integer.valueOf(dto.getTotalQuantity().intValue()));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(warehouseCode = detail.getWarehouseCode())) && (position = this.warehouseQueryApi.queryWarehouseByCode(detail.getWarehouseCode(), "{\"instanceId\":" + this.context.instanceId() + ",\"tenantId\":" + this.context.instanceId() + "}")) != null && position.getData() != null) {
            WarehouseRespDto data2 = (WarehouseRespDto)position.getData();
            orderDeliveryToBRespDto.setWarehouseId(data2.getId());
            orderDeliveryToBRespDto.setWarehouseCode(data2.getCode());
            orderDeliveryToBRespDto.setWarehouseName(data2.getName());
        }
        return orderDeliveryToBRespDto;
    }

    private Map<String, List<StorageOrderDetailRespDto>> getItemOutNum(String returnNo) {
        Map<String, List<Object>> group = new HashMap<String, List<StorageOrderDetailRespDto>>();
        JSONObject sjon = new JSONObject();
        sjon.put("category", (Object)"CATEGORY_IN");
        sjon.put("groupId", (Object)"");
        sjon.put("businessId", (Object)returnNo);
        sjon.put("instanceId", (Object)this.context.instanceId());
        sjon.put("tenantId", (Object)this.context.tenantId());
        RestResponse pageInfoRestResponse = this.iStorageOrderQueryApi.queryFilterByPage(sjon.toJSONString(), Integer.valueOf(1), Integer.valueOf(1000));
        PageInfo storageOrderPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (Objects.nonNull(storageOrderPageInfo) && CollectionUtils.isNotEmpty((Collection)storageOrderPageInfo.getList())) {
            List list = storageOrderPageInfo.getList();
            ArrayList detailRespDtoList = Lists.newArrayList();
            for (StorageOrderCombineRespDto combineRespDto : list) {
                detailRespDtoList.addAll(combineRespDto.getDetailRespDtoList());
            }
            StorageOrderDetailRespDto storageOrderDetailRespDto = (StorageOrderDetailRespDto)detailRespDtoList.get(0);
            if (StringUtils.isNotEmpty((CharSequence)storageOrderDetailRespDto.getExtension())) {
                group = detailRespDtoList.stream().collect(Collectors.groupingBy(StorageOrderDetailRespDto::getExtension, Collectors.toList()));
            }
        }
        return group;
    }

    public void addReFundOrderReceive(ReFundOrderReceiveSaveReqDto dto) {
        ReturnItemConfirmReqDto returnItemConfirmReqDto = new ReturnItemConfirmReqDto();
        if (dto == null || CollectionUtils.isEmpty((Collection)dto.getItemReceiveSaveReqDto())) {
            throw new BizException("\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemReceiveSaveReqDto = dto.getItemReceiveSaveReqDto();
        Iterator iterator = itemReceiveSaveReqDto.iterator();
        while (iterator.hasNext()) {
            ReFundOrderReceiveSaveReqDto.ItemReceiveSaveReqDto receiveSaveReqDto;
            receiveSaveReqDto.setNum((receiveSaveReqDto = (ReFundOrderReceiveSaveReqDto.ItemReceiveSaveReqDto)iterator.next()).getNum() == null ? receiveSaveReqDto.getBuyNum() : receiveSaveReqDto.getNum());
            Long num = null != receiveSaveReqDto.getNum() ? receiveSaveReqDto.getNum() : 0L;
            Long receivedNum = null != receiveSaveReqDto.getReceivedNum() ? receiveSaveReqDto.getReceivedNum() : 0L;
            Long currentNum = null != receiveSaveReqDto.getCurrentNum() ? receiveSaveReqDto.getCurrentNum() : 0L;
            if (num - receivedNum >= currentNum) continue;
            throw new BizException("\u5f53\u524d\u9000\u8d27\u6570\u91cf:" + receiveSaveReqDto.getCurrentNum() + ".\u8d85\u8fc7\u5408\u7406\u9000\u8d27\u6570\u91cf");
        }
        List supplierReturnList = dto.getItemReceiveSaveReqDto().stream().map(this::buildReturnItemConfirmDetailReqDto).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(supplierReturnList)) {
            HashSet<String> cargoCodes = new HashSet<String>(supplierReturnList.size());
            for (ReturnItemConfirmDetailReqDto reqDto : supplierReturnList) {
                if (!StringUtils.isNotEmpty((CharSequence)reqDto.getCargoSerial())) continue;
                cargoCodes.add(reqDto.getCargoSerial());
            }
            if (CollectionUtils.isNotEmpty(cargoCodes)) {
                List cargoRespDtos = new ArrayList();
                try {
                    cargoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.cargoQueryApi.listByCodes((List)Lists.newArrayList(cargoCodes)));
                }
                catch (Exception e) {
                    logger.info("\u6839\u636e\u8d27\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u8d27\u54c1\u4fe1\u606f\u8f6c\u5316\u5931\u8d25,cargoCodes----:" + JSON.toJSONString(cargoCodes));
                    logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
                    throw new BizException("\u5546\u54c1\u7f3a\u5931cargoCodes,\u65e0\u6cd5\u51fa\u5e93");
                }
                Map<String, String> cargoIdMap = cargoRespDtos.stream().collect(Collectors.toMap(CargoRespDto::getCode, resp -> resp.getId().toString(), (e1, e2) -> e1));
                for (ReturnItemConfirmDetailReqDto reqDto : supplierReturnList) {
                    if (cargoIdMap.isEmpty() || reqDto == null || !StringUtils.isNotEmpty((CharSequence)reqDto.getCargoSerial())) continue;
                    String cargoId = cargoIdMap.get(reqDto.getCargoSerial());
                    reqDto.setCargoSerial(cargoId);
                }
            }
        }
        returnItemConfirmReqDto.setReturnItemConfirmDetailReqDtos(supplierReturnList);
        returnItemConfirmReqDto.setReturnNo(dto.getReturnNo());
        returnItemConfirmReqDto.setWarehouseId(dto.getWarehouseId());
        returnItemConfirmReqDto.setTenantId(this.context.tenantId());
        returnItemConfirmReqDto.setInstanceId(this.context.instanceId());
        RestResponse stringRestResponse = this.afterSalesTobApi.confirmReturnItem(returnItemConfirmReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
    }

    public ReturnOrderPayRespDto getMgmtPayRecord(String returnNo) {
        ReturnOrderPayRespDto detail = new ReturnOrderPayRespDto();
        ReFundOrderDetailRespDto reFundOrderDetailRespDto1 = this.returnOrderService.queryById(returnNo);
        JSONObject jsonObjectReturnRespDto = new JSONObject();
        jsonObjectReturnRespDto.put("returnNo", (Object)returnNo);
        jsonObjectReturnRespDto.put("instanceId", (Object)this.context.instanceId());
        jsonObjectReturnRespDto.put("tenantId", (Object)this.context.tenantId());
        RestResponse pageInfoRestResponse1 = this.refundQueryApi.queryByPage(jsonObjectReturnRespDto.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        BigDecimal returnedPayAmount = BigDecimal.ZERO;
        RefundDisposeConfigRespDto refundDisposeConfig = new RefundDisposeConfigRespDto();
        try {
            refundDisposeConfig = (RefundDisposeConfigRespDto)RestResponseHelper.extractData((RestResponse)this.refundDisposeConfigQueryApi.queryByNo(returnNo));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u83b7\u53d6\u91d1\u989d\u5904\u7406\u914d\u7f6e\u5931\u8d25,\u5355\u53f7\u4e3a:{}", (Object)returnNo);
        }
        logger.info("\u5904\u7406\u590d\u6838\u91d1\u989d\uff1a{}", (Object)JSON.toJSONString((Object)refundDisposeConfig));
        if (pageInfoRestResponse1 != null && ((PageInfo)pageInfoRestResponse1.getData()).getList() != null && ((PageInfo)pageInfoRestResponse1.getData()).getList().size() > 0) {
            List list = ((PageInfo)pageInfoRestResponse1.getData()).getList();
            ArrayList collect = Lists.newArrayList();
            for (RefundRespDto refundRespDto : list) {
                Map extFields = refundRespDto.getExtFields();
                String confirmTimeStr = extFields.get("confirmTime") + "";
                Date confirmTime = this.changeDateTime(confirmTimeStr);
                RefundStatusEnum byName = RefundStatusEnum.getByName((String)refundRespDto.getRefundStatus());
                List refundDetailRespDtos = refundRespDto.getRefundDetailRespDtos();
                for (RefundDetailRespDto refundDetailRespDto : refundDetailRespDtos) {
                    RefundRecordRespDto refundRecordRespDto = new RefundRecordRespDto();
                    refundRecordRespDto.setConfirmTime(confirmTime);
                    refundRecordRespDto.setCreateTime(refundRespDto.getCreateTime());
                    refundRecordRespDto.setRefundItemAmount(refundDetailRespDto.getRefundAmount());
                    refundRecordRespDto.setRefundNo(refundRespDto.getRefundNo());
                    refundRecordRespDto.setRefundReason(extFields.get("remark") + "");
                    refundRecordRespDto.setRefundStatus(refundRespDto.getRefundStatus());
                    if (null != byName) {
                        refundRecordRespDto.setRefundStatusName(byName.getMsg());
                    }
                    if (RefundChannelTypeEnum.OFFLINE.getCode().equals(refundDisposeConfig.getRefundChannelType())) {
                        refundRecordRespDto.setRefundWay(RefundChannelTypeEnum.OFFLINE.getDesc());
                    } else {
                        refundRecordRespDto.setRefundWay(PayMethodEnum.toName((String)refundDetailRespDto.getPayMethod()));
                    }
                    refundRecordRespDto.setPayMethod(refundDetailRespDto.getPayMethod());
                    refundRecordRespDto.setId(refundDetailRespDto.getId());
                    collect.add(refundRecordRespDto);
                }
            }
            detail.setRefundRecordList((List)collect);
            returnedPayAmount = this.countAlreadyPayAmount(list);
        }
        detail.setAlreadyReturnAmount(null == returnedPayAmount ? BigDecimal.ZERO : returnedPayAmount);
        detail.setOrderNo(reFundOrderDetailRespDto1.getOrderNo());
        detail.setOrderRefundStatusName(reFundOrderDetailRespDto1.getOrderRefundStatusName());
        detail.setOrderRefundStatus(reFundOrderDetailRespDto1.getOrderRefundStatus());
        detail.setOrderTradeStatus(reFundOrderDetailRespDto1.getOrderTradeStatus());
        detail.setOrderTradeStatusName(reFundOrderDetailRespDto1.getOrderTradeStatusName());
        detail.setPayAmount(reFundOrderDetailRespDto1.getAmount());
        detail.setPlaceType(reFundOrderDetailRespDto1.getPlaceType());
        detail.setReturnNo(returnNo);
        detail.setWaitReturnAmount(null == detail.getPayAmount() ? null : detail.getPayAmount().subtract(detail.getAlreadyReturnAmount()));
        return detail;
    }

    public void abandonPayRecord(String payNo) {
        this.payTobApi.abandonPayRecord(payNo);
    }

    public PageInfo<OrderDeliveredRespDto> getMgmtReceivedRecordPage(String keyword, String returnNo, Integer pageNum, Integer pageSize) {
        JSONObject sjon = new JSONObject();
        sjon.put("category", (Object)"CATEGORY_IN");
        sjon.put("groupId", (Object)"");
        sjon.put("businessId", (Object)returnNo);
        sjon.put("instanceId", (Object)this.context.instanceId());
        sjon.put("tenantId", (Object)this.context.tenantId());
        TcbjReciptResReqDto queryDto = new TcbjReciptResReqDto();
        queryDto.setNo(returnNo);
        queryDto.setPageNum(pageNum);
        queryDto.setPageSize(pageSize);
        RestResponse pageInfoRestResponse = this.tcbjReciptApi.resPage(queryDto);
        PageInfo storageOrderCombineRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        ArrayList respDtoList = CollectionUtils.isEmpty((Collection)storageOrderCombineRespDtoPageInfo.getList()) ? new ArrayList() : storageOrderCombineRespDtoPageInfo.getList().stream().map(e -> {
            OrderDeliveredRespDto orderDeliveredRespDto = new OrderDeliveredRespDto();
            orderDeliveredRespDto.setOrderNo(e.getPreNo());
            orderDeliveredRespDto.setDeliveryNo(e.getNo());
            orderDeliveredRespDto.setWarehouseCode(e.getWarehouseCode());
            orderDeliveredRespDto.setWarehouseId(Long.valueOf(e.getWarehouseId()));
            orderDeliveredRespDto.setWarehouseName(e.getWarehouseName());
            orderDeliveredRespDto.setTotalItemNum(new BigDecimal(e.getNum()));
            orderDeliveredRespDto.setDeliveryStatus(e.getStrStatus());
            return orderDeliveredRespDto;
        }).collect(Collectors.toList());
        PageInfo page = new PageInfo();
        CubeBeanUtils.copyProperties((Object)page, (Object)pageInfoRestResponse.getData(), (String[])new String[]{"list", "navigatepageNums"});
        page.setList(respDtoList);
        return page;
    }

    public void confirmRefund(ReFundOrderReceiveSaveToBReqDto confirmRefundReqDto) {
        if (StringUtils.isEmpty((CharSequence)confirmRefundReqDto.getReturnNo()) || CollectionUtils.isEmpty((Collection)confirmRefundReqDto.getRefundNos())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.RETURN_NO_REFUND_NO_NOT_EMPTY);
        }
        RestResponse restResponse = this.afterSalesTobApi.confirmRefund((ReturnConfirmRefundReqDto)confirmRefundReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        String orderNo = confirmRefundReqDto.getOrderNo();
        RestResponse orderDetail = this.orderBizQueryApi.getOrderDetail(orderNo);
        OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)orderDetail);
        logger.info("confirmRefund\u65e5\u5fd7\u8f93\u51fa[{}]", (Object)JSON.toJSONString((Object)orderData));
        PayRecordRespDto pay = this.getValidRecord(orderData);
        ReturnOrderPayRespDto returnOrderPayRespDto = this.returnOrderService.getMgmtPayRecord(confirmRefundReqDto.getReturnNo());
        List refundRecordList = returnOrderPayRespDto.getRefundRecordList();
        Map groupRefundNoAndData = refundRecordList.stream().collect(Collectors.groupingBy(RefundRecordRespDto::getRefundNo, Collectors.toList()));
        for (String refundNo : confirmRefundReqDto.getRefundNos()) {
            List refundRecordRespDtos = groupRefundNoAndData.get(refundNo);
            logger.info("\u83b7\u53d6\u6240\u6709\u9000\u6b3e\u8bb0\u5f55:{}", (Object)JSON.toJSONString(refundRecordRespDtos));
            if (CollectionUtils.isEmpty(refundRecordRespDtos)) continue;
            RefundRecordRespDto orderDeliveryRespDto = (RefundRecordRespDto)refundRecordRespDtos.get(0);
            if (PayMethodEnum.WECHAT_PAY_101.getCode().equals(orderDeliveryRespDto.getPayMethod())) {
                orderDeliveryRespDto.setPayMethod(PayMethodEnum.WECHAT_PAY.getCode());
            }
            if (PayMethodEnum.SETTLEMENT_WALLET.getCode().equals(orderDeliveryRespDto.getPayMethod()) || PayMethodEnum.SETTLEMENT_ZFB.getCode().equals(orderDeliveryRespDto.getPayMethod()) || PayMethodEnum.SETTLEMENT_WECHAT_PAY.getCode().equals(orderDeliveryRespDto.getPayMethod())) {
                orderDeliveryRespDto.setPayMethod(PayMethodEnum.OFFLINE_AMOUNT_PAY.getCode());
            }
            AbstractPayHelp abstractPayHelp = this.payFactory.create(orderDeliveryRespDto.getPayMethod());
            logger.info("\u83b7\u53d6\u9000\u6b3e\u65b9\u5f0f:{}", (Object)JSON.toJSONString((Object)abstractPayHelp));
            BasePayReqDto basePayReqDto = new BasePayReqDto();
            String customerId = (String)orderData.getExtFields().get("customerId");
            basePayReqDto.setCustomerId(customerId);
            basePayReqDto.setOrderNo(confirmRefundReqDto.getOrderNo());
            SimplePayReqDto simplePayReqDto = abstractPayHelp.initParam(orderData, orderDeliveryRespDto, pay, basePayReqDto);
            simplePayReqDto.setRefundNo(orderDeliveryRespDto.getRefundNo());
            simplePayReqDto.setRefundAmount(orderDeliveryRespDto.getRefundItemAmount());
            simplePayReqDto.setNodeCode(OrderNodeEnum.REFUND.getType());
            abstractPayHelp.customerConfirmRefund(simplePayReqDto);
        }
    }

    private PayRecordRespDto getValidRecord(OrderDetailRespDto orderData) {
        JSONObject json = new JSONObject();
        json.put("instanceId", (Object)this.context.instanceId());
        json.put("tenantId", (Object)this.context.tenantId());
        json.put("orderNo", (Object)orderData.getOrderNo());
        RestResponse payRecordRespDtoRestResponse = this.iPayQueryApi.queryByPage(json.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo orderDeliveryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)payRecordRespDtoRestResponse);
        List list = orderDeliveryRespDtoPageInfo.getList();
        for (PayRecordRespDto pay : list) {
            if (!"SUCCESS".equals(pay.getPayStatus())) continue;
            return pay;
        }
        return null;
    }

    public void removeRefund(ReturnConfirmRefundReqDto confirmRefundReqDto) {
        if (StringUtils.isEmpty((CharSequence)confirmRefundReqDto.getReturnNo()) || CollectionUtils.isEmpty((Collection)confirmRefundReqDto.getRefundNos())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.RETURN_NO_REFUND_NO_NOT_EMPTY);
        }
        RestResponse restResponse = this.afterSalesTobApi.removeRefund(confirmRefundReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public void aduit(AuditReqDto auditReqDto) {
        Long result = (Long)this.auditApi.addAudit(auditReqDto).getData();
        logger.info("[{}]\u7ec4\u5408\u652f\u4ed8\u5ba1\u6838\u7ed3\u679c[{}]", (Object)JSON.toJSONString((Object)auditReqDto), (Object)(result > 0L ? 1 : 0));
        if ("0".equals(auditReqDto.getStatus())) {
            ReFundOrderReceiveSaveToBReqDto confirmRefundReqDto = new ReFundOrderReceiveSaveToBReqDto();
            confirmRefundReqDto.setReturnNo(auditReqDto.getReturnNo());
            ArrayList<String> refundNos = new ArrayList<String>(1);
            refundNos.add(auditReqDto.getRefundNo());
            confirmRefundReqDto.setRefundNos(refundNos);
            this.confirmRefund(confirmRefundReqDto);
        }
    }

    public void modifyItemOrigPriceById(Long id, BigDecimal itemOrigPrice) {
        this.iAfterSalesApi.modifyItemOrigPriceById(id, itemOrigPrice);
    }

    public RestResponse<PageInfo<ReturnItemRespDto>> queryReturnItemByPage(ReturnQueryReqDto returnQueryReqDto, Integer pageNum, Integer pageSize) {
        if (StringUtils.isBlank((CharSequence)returnQueryReqDto.getReturnNo())) {
            throw new BizException("\u9000\u8d27\u6d41\u6c34\u53f7\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.afterSalesQueryApi.queryReturnItemByPage(JSON.toJSONString((Object)returnQueryReqDto), pageNum, pageSize));
        Set itemIds = respDtoPageInfo.getList().stream().map(ReturnOmniItemRespDto::getItemId).collect(Collectors.toSet());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list"});
        Map<Object, Object> itemMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(StringUtils.join(itemIds, (String)",")));
            itemMap = itemRespDtos.stream().collect(Collectors.toMap(e -> String.valueOf(e.getId()), e -> e, (e1, e2) -> e1));
        }
        HashMap orderCargoMap = Maps.newHashMap();
        SimpleRequestDto dto = new SimpleRequestDto();
        dto.setNo(returnQueryReqDto.getReturnNo());
        SimpleRequestDto queryDto = new SimpleRequestDto();
        queryDto.setPreNo(returnQueryReqDto.getReturnNo());
        queryDto.setCategory("202");
        queryDto.setNotThrowException(true);
        TcbjDeliveryResDetailRespDto tcbjDeliveryResDetailRespDto = (TcbjDeliveryResDetailRespDto)RestResponseHelper.extractData((RestResponse)this.tcbjDeliveryApi.queryDetailByPreNo(queryDto));
        logger.info("\u6536\u8d27\u7ed3\u679c\u5355\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)tcbjDeliveryResDetailRespDto));
        Map<Object, Object> tcbjResDetailCargoRespDtoMap = Maps.newHashMap();
        if (tcbjDeliveryResDetailRespDto != null && CollectionUtils.isNotEmpty((Collection)tcbjDeliveryResDetailRespDto.getCargos())) {
            tcbjResDetailCargoRespDtoMap = tcbjDeliveryResDetailRespDto.getCargos().stream().collect(Collectors.groupingBy(TcbjResDetailCargoRespDto::getCargoCode));
        }
        ArrayList list = Lists.newArrayList();
        for (ReturnOmniItemRespDto returnOmniItemRespDto : respDtoPageInfo.getList()) {
            ReturnItemRespDto returnItemRespDto = new ReturnItemRespDto();
            CubeBeanUtils.copyProperties((Object)returnItemRespDto, (Object)returnOmniItemRespDto, (String[])new String[0]);
            if (Integer.valueOf(1).equals(returnOmniItemRespDto.getIsAllowReturn())) {
                returnItemRespDto.setDeliveredNum(returnOmniItemRespDto.getReturnNum());
            }
            if (tcbjResDetailCargoRespDtoMap.containsKey(returnOmniItemRespDto.getCargoSerial())) {
                StringBuilder batchNo = new StringBuilder();
                ((List)tcbjResDetailCargoRespDtoMap.get(returnOmniItemRespDto.getCargoSerial())).stream().forEach(e -> {
                    if (batchNo.length() > 0) {
                        batchNo.append("\u3001");
                    }
                    batchNo.append(e.getBatch());
                });
                returnItemRespDto.setBatchNo(batchNo.toString());
            }
            if (itemMap.containsKey(returnOmniItemRespDto.getItemId())) {
                ItemRespDto itemRespDto = (ItemRespDto)itemMap.get(returnOmniItemRespDto.getItemId());
                returnItemRespDto.setItemType(itemRespDto.getSubType());
                returnItemRespDto.setItemTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemRespDto.getSubType()));
            }
            list.add(returnItemRespDto);
        }
        pageInfo.setList((List)list);
        return new RestResponse((Object)pageInfo);
    }

    private OrderDeliveredRespDto buildOrderDeliveredRespDto(StorageOrderCombineRespDto orderDeliveryRespDto) {
        OrderDeliveredRespDto orderDeliveredRespDto = new OrderDeliveredRespDto();
        orderDeliveredRespDto.setDeliveryNo(orderDeliveryRespDto.getStorageOrderRespDto().getId() + "");
        orderDeliveredRespDto.setSrcNo(orderDeliveryRespDto.getStorageOrderRespDto().getOrderNo() + "");
        orderDeliveredRespDto.setDeliveryStatus(orderDeliveryRespDto.getStorageOrderRespDto().getStatus() + "");
        orderDeliveredRespDto.setDeliveryStatusName(ReturnDeliveryStatusEnum.toName((Integer)orderDeliveryRespDto.getStorageOrderRespDto().getStatus()));
        orderDeliveredRespDto.setWarehouseId(orderDeliveryRespDto.getStorageOrderRespDto().getWarehouseId());
        orderDeliveredRespDto.setWarehouseName(orderDeliveryRespDto.getStorageOrderRespDto().getWarehouseName());
        orderDeliveredRespDto.setDeliveryTime(orderDeliveryRespDto.getStorageOrderRespDto().getCreateTime());
        orderDeliveredRespDto.setOrderNo(orderDeliveryRespDto.getStorageOrderRespDto().getOrderNo());
        if (orderDeliveryRespDto.getDetailRespDtoList() != null) {
            BigDecimal totalNum = orderDeliveryRespDto.getDetailRespDtoList().stream().filter(e -> e.getNum() != null).map(e -> new BigDecimal(e.getNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderDeliveredRespDto.setTotalItemNum(totalNum);
        }
        return orderDeliveredRespDto;
    }

    private BigDecimal countAlreadyPayAmount(List<RefundRespDto> list) {
        BigDecimal alreadyPayAmount = null;
        try {
            alreadyPayAmount = list.stream().filter(data -> "SUCCESS".equals(data.getRefundStatus())).map(RefundRespDto::getRefundTotalAmount).reduce(BigDecimal::add).get();
            logger.info("countAlreadyPayAmount.alreadyPayAmount={}", (Object)alreadyPayAmount);
            alreadyPayAmount = alreadyPayAmount.setScale(2, 1);
        }
        catch (Exception e) {
            logger.info("\u7d2f\u52a0\u5df2\u652f\u4ed8\u91d1\u989d\u5931\u8d25,data----:" + JSON.toJSONString(list));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        return alreadyPayAmount;
    }

    private RefundRecordRespDto buildRefundRecord(RefundRespDto returnRespDto) {
        RefundRecordRespDto refundRecordRespDto = new RefundRecordRespDto();
        Map extFields = returnRespDto.getExtFields();
        String confirmTime = extFields.get("confirmTime") + "";
        refundRecordRespDto.setConfirmTime(this.changeDateTime(confirmTime));
        refundRecordRespDto.setCreateTime(returnRespDto.getCreateTime());
        refundRecordRespDto.setRefundItemAmount(returnRespDto.getRefundItemAmount());
        refundRecordRespDto.setRefundNo(returnRespDto.getRefundNo());
        refundRecordRespDto.setRefundReason(extFields.get("remark") + "");
        refundRecordRespDto.setRefundStatus(returnRespDto.getRefundStatus());
        RefundStatusEnum byName = RefundStatusEnum.getByName((String)returnRespDto.getRefundStatus());
        if (null != byName) {
            refundRecordRespDto.setRefundStatusName(byName.getMsg());
        }
        refundRecordRespDto.setRefundWay(PayMethodEnum.toName((String)returnRespDto.getPayMethod()));
        return refundRecordRespDto;
    }

    private Date changeDateTime(String confirmTime) {
        Date time = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = simpleDateFormat.parse(confirmTime);
        }
        catch (Exception e) {
            logger.info("\u8f6c\u5316confirmTime\u5931\u8d25,data----:" + JSON.toJSONString((Object)confirmTime));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            return time;
        }
        return time;
    }

    private ReturnItemConfirmDetailReqDto buildReturnItemConfirmDetailReqDto(ReFundOrderReceiveSaveReqDto.ItemReceiveSaveReqDto itemReceiveSaveReqDto) {
        Long currentNum = null == itemReceiveSaveReqDto.getCurrentNum() ? 0L : itemReceiveSaveReqDto.getCurrentNum();
        ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto = new ReturnItemConfirmDetailReqDto();
        returnItemConfirmDetailReqDto.setBuyNum(itemReceiveSaveReqDto.getNum());
        returnItemConfirmDetailReqDto.setCargoSerial(itemReceiveSaveReqDto.getCargoSerial());
        returnItemConfirmDetailReqDto.setCurrentNum(currentNum);
        returnItemConfirmDetailReqDto.setItemCode(itemReceiveSaveReqDto.getItemCode());
        returnItemConfirmDetailReqDto.setItemId(itemReceiveSaveReqDto.getItemId());
        returnItemConfirmDetailReqDto.setItemName(itemReceiveSaveReqDto.getItemName());
        returnItemConfirmDetailReqDto.setReceivedNum(itemReceiveSaveReqDto.getReceivedNum());
        returnItemConfirmDetailReqDto.setSkuSerial(Objects.nonNull(itemReceiveSaveReqDto.getSkuId()) ? itemReceiveSaveReqDto.getSkuId().toString() : null);
        returnItemConfirmDetailReqDto.setGift(itemReceiveSaveReqDto.getGift());
        return returnItemConfirmDetailReqDto;
    }

    private ItemReceiveRespDto buildWaitOutboundItemDto(ReFundOrderDetailRespDto.ItemDetail itemRespDto, Map<String, List<StorageOrderDetailRespDto>> storageDetailMap) {
        ItemReceiveRespDto waitOutboundItemDto = new ItemReceiveRespDto();
        waitOutboundItemDto.setItemId(itemRespDto.getItemId());
        waitOutboundItemDto.setItemCode(itemRespDto.getItemCode());
        waitOutboundItemDto.setItemName(itemRespDto.getItemName());
        waitOutboundItemDto.setCargoSerial(itemRespDto.getCargoSerial());
        waitOutboundItemDto.setSkuId(itemRespDto.getSkuId());
        waitOutboundItemDto.setGift(itemRespDto.getGift());
        waitOutboundItemDto.setNum(itemRespDto.getNum());
        waitOutboundItemDto.setItemNum(itemRespDto.getItemNum());
        waitOutboundItemDto.setCurrentNum(Integer.valueOf(0));
        waitOutboundItemDto.setReceiveNum(itemRespDto.getNum());
        waitOutboundItemDto.setBuyNum(itemRespDto.getItemNum());
        waitOutboundItemDto.setSkuName(itemRespDto.getSkuName());
        waitOutboundItemDto.setUnit(itemRespDto.getUnit());
        if (StringUtils.isNotBlank((CharSequence)itemRespDto.getBatchNo())) {
            String[] split;
            ArrayList itemBatchNoList = Lists.newArrayList();
            for (String batchNo : split = itemRespDto.getBatchNo().split(",")) {
                String[] batchNumArr = batchNo.split("#");
                if (batchNumArr.length < 2) continue;
                ApplyReturnItemBatchRespDto applyBatchNo = new ApplyReturnItemBatchRespDto();
                applyBatchNo.setBatchNo(batchNumArr[0]);
                applyBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                itemBatchNoList.add(applyBatchNo);
            }
            waitOutboundItemDto.setApplyItemBatchNoDtos((List)itemBatchNoList);
        }
        return waitOutboundItemDto;
    }

    private AfterSalesItemReqDto buildSupplierReturnItem(ReturnOrderItemSaveReqDto attachmentReqDto) {
        AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("returnedNum", attachmentReqDto.getReturnedNum() + attachmentReqDto.getNum());
        addrExtFields.put("returnNum", attachmentReqDto.getNum());
        addrExtFields.put("originNum", attachmentReqDto.getThisStorageNum());
        addrExtFields.put("unit", attachmentReqDto.getUnit());
        addrExtFields.put("itemAmount", attachmentReqDto.getItemPrice());
        addrExtFields.put("remark", attachmentReqDto.getRemark());
        addrExtFields.put("refundAmount", BigDecimal.valueOf(attachmentReqDto.getNum().intValue()).multiply(attachmentReqDto.getItemPrice()) + "");
        afterSalesItemReqDto.setItemPrice(attachmentReqDto.getItemPrice());
        afterSalesItemReqDto.setId(attachmentReqDto.getId());
        afterSalesItemReqDto.setTradeItemNo(attachmentReqDto.getTradeItemNo());
        afterSalesItemReqDto.setExtFields(addrExtFields);
        afterSalesItemReqDto.setSkuSerial(Objects.nonNull(attachmentReqDto.getSkuId()) ? attachmentReqDto.getSkuId().toString() : null);
        afterSalesItemReqDto.setItemCode(attachmentReqDto.getItemCode());
        afterSalesItemReqDto.setGift(attachmentReqDto.getGift());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(attachmentReqDto.getPath());
        orderItemExtDto.setShelfType(attachmentReqDto.getShelfType());
        afterSalesItemReqDto.setExtension(JSON.toJSONString((Object)orderItemExtDto));
        afterSalesItemReqDto.setItemSerial(Objects.nonNull(attachmentReqDto.getItemId()) ? attachmentReqDto.getItemId().toString() : null);
        return afterSalesItemReqDto;
    }

    private ReturnOrderRespDto buildRefundRecordRespDto(ReturnRespDto returnRespDto) {
        ReturnOrderRespDto refundRecordRespDto = new ReturnOrderRespDto();
        Map extFields = returnRespDto.getExtFields();
        String refundStatus = extFields.get("refundStatus") + "";
        String placeUserId = extFields.get("placeUserId") + "";
        String customerId = extFields.get("customerId") + "";
        refundRecordRespDto.setBizType(returnRespDto.getReturnType());
        refundRecordRespDto.setBizTypeName(OrderReturnBizTypeEnum.toName((String)returnRespDto.getReturnType()));
        refundRecordRespDto.setCustomerId(returnRespDto.getCustomerId());
        refundRecordRespDto.setId(returnRespDto.getId());
        refundRecordRespDto.setReturnNo(returnRespDto.getReturnNo());
        refundRecordRespDto.setOrderNo(returnRespDto.getOrderTradeNo());
        refundRecordRespDto.setOrderCreateTime(ReturnOrderServiceImpl.dateToString(returnRespDto.getCreateTime()));
        RefundOrderStatusToBEnum refundOrderStatusToBEnum = ReturnOrderUtil.convertRefundStatus(refundStatus);
        refundRecordRespDto.setOrderRefundStatus(refundOrderStatusToBEnum.getCode());
        refundRecordRespDto.setOrderRefundStatusName(refundOrderStatusToBEnum.getName());
        refundRecordRespDto.setOrderTradeStatus(ReturnStatusToBEnum.toCode((String)returnRespDto.getReturnStatus()));
        refundRecordRespDto.setOrderTradeStatusName(ReturnStatusToBEnum.toName((String)returnRespDto.getReturnStatus()));
        UserDto userInfo = this.findUserInfo(StringUtils.isBlank((CharSequence)placeUserId) || "null".equals(placeUserId) ? null : Long.valueOf(placeUserId));
        refundRecordRespDto.setPlaceUserName(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfo.getNickName()}) ? userInfo.getNickName() : userInfo.getUserName());
        refundRecordRespDto.setRefundAmount(returnRespDto.getRefundAmount());
        refundRecordRespDto.setReturnNo(returnRespDto.getReturnNo());
        refundRecordRespDto.setApplyReturnQty(returnRespDto.getApplyReturnQty());
        refundRecordRespDto.setCreateMode(returnRespDto.getCreateMode());
        refundRecordRespDto.setShopId(String.valueOf(returnRespDto.getShopId()));
        refundRecordRespDto.setSellerId(String.valueOf(returnRespDto.getSellerId()));
        refundRecordRespDto.setApplyReturnItemRespDtoList(returnRespDto.getApplyReturnItemRespDtoList());
        refundRecordRespDto.setReturnOrderRemark(returnRespDto.getRemark());
        String returnDesc = returnRespDto.getExtFields().get("returnDesc") + "";
        try {
            OrderReceiveDetailRespDto orderReceiveDetailRespDto = (OrderReceiveDetailRespDto)JSONObject.parseObject((String)returnDesc, OrderReceiveDetailRespDto.class);
            refundRecordRespDto.setCustomerName(orderReceiveDetailRespDto.getCustomerName());
        }
        catch (Exception e) {
            logger.info("\u5206\u9875\u83b7\u53d6\u4fe1\u606f\u5931\u8d25,\u5ba2\u6237\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38,data----:" + JSON.toJSONString((Object)returnDesc));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        return refundRecordRespDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDto findUserInfo(Long userId) {
        UserDto userDto = new UserDto();
        if (userId == null) {
            return userDto;
        }
        try {
            RestResponse userDtoRestResponse = this.userQueryApi.queryById(userId, "{}");
            if (userDtoRestResponse != null) {
                if (userDtoRestResponse.getData() != null) {
                    userDto = (UserDto)userDtoRestResponse.getData();
                    return userDto;
                }
            }
        }
        catch (Exception e) {
            logger.info("BizType\u8f6cInteger\u5931\u8d25,BizType:" + userId);
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        finally {
            return userDto;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomerRespDto findCustomerInfo(Long customerId) {
        CustomerRespDto customerRespDto = new CustomerRespDto();
        if (customerId == null) {
            return customerRespDto;
        }
        try {
            RestResponse customerRespDtoRestResponse = this.customerQueryApi.queryById(customerId);
            if (customerRespDtoRestResponse != null) {
                if (customerRespDtoRestResponse.getData() != null) {
                    customerRespDto = (CustomerRespDto)customerRespDtoRestResponse.getData();
                    return customerRespDto;
                }
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25,customerId:" + customerId);
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        finally {
            return customerRespDto;
        }
    }

    public BigDecimal giftRefund(GiftAccountReqDto dto) {
        RestResponse bigDecimalRestResponse = this.afterSalesTobApi.giftRefund(dto);
        if (!Objects.equals("0", bigDecimalRestResponse.getResultCode())) {
            throw new BizException(bigDecimalRestResponse.getResultMsg());
        }
        return (BigDecimal)bigDecimalRestResponse.getData();
    }
}

