/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.service;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.trade.api.dto.ItemInterceptReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.constants.ItemInterceptConfigEnum;
import com.yx.tcbj.center.api.dto.request.ItemInterceptConfigReqDto;
import com.yx.tcbj.center.api.dto.request.ItemInterceptDetailReqDto;
import com.yx.tcbj.center.api.dto.response.ItemInterceptConfigRespDto;
import com.yx.tcbj.center.api.query.IItemInterceptConfigQueryApi;
import com.yx.tcbj.center.api.query.IItemInterceptDetailQueryApi;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ItemInterceptHandlerService {
    private static final Logger log = LoggerFactory.getLogger(ItemInterceptHandlerService.class);
    @Resource
    private ICustomerExtQueryApi iCustomerQueryApi;
    @Resource
    private IItemInterceptDetailQueryApi itemInterceptDetailQueryApi;
    @Resource
    private IItemInterceptConfigQueryApi itemInterceptConfigQueryApi;

    public void verifyItemProcess(ItemInterceptReqDto itemInterceptReqDto) {
        log.info("verify item process params is {} .", (Object)JSON.toJSONString((Object)itemInterceptReqDto));
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.iCustomerQueryApi.queryOneByOrgId(itemInterceptReqDto.getOrganizationId()));
        ItemInterceptConfigReqDto itemInterceptConfigReqDto = new ItemInterceptConfigReqDto();
        itemInterceptConfigReqDto.setOrganizationId(customerRespDto.getMerchantId());
        itemInterceptConfigReqDto.setStatus(YesOrNoEnum.YES.getCode());
        PageInfo itemInterceptConfigRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemInterceptConfigQueryApi.queryByPage(JSON.toJSONString((Object)itemInterceptConfigReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (CollectionUtils.isNotEmpty((Collection)itemInterceptConfigRespDtoPageInfo.getList())) {
            List itemCodes;
            Map<String, List<ItemInterceptReqDto.ItemDetail>> itemGroupMap;
            ItemInterceptConfigRespDto itemInterceptConfigRespDto = (ItemInterceptConfigRespDto)itemInterceptConfigRespDtoPageInfo.getList().stream().findFirst().get();
            log.info("\u5f53\u524d\u7ec4\u7ec7\u5546\u54c1\u62e6\u622a\u914d\u7f6e\u660e\u7ec6 result is {} .", (Object)JSON.toJSONString((Object)itemInterceptConfigRespDto));
            ItemInterceptDetailReqDto itemInterceptDetailReqDto = new ItemInterceptDetailReqDto();
            itemInterceptDetailReqDto.setOrganizationId(itemInterceptConfigRespDto.getOrganizationId());
            PageInfo itemInterceptDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemInterceptDetailQueryApi.queryByPage(JSON.toJSONString((Object)itemInterceptDetailReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            List interceptContentList = itemInterceptDetailRespDtoPageInfo.getList().stream().map(c -> c.getInterceptContent()).collect(Collectors.toList());
            if (itemInterceptConfigRespDto.getInterceptType().equals(ItemInterceptConfigEnum.BRAND.getCode())) {
                itemGroupMap = itemInterceptReqDto.getItemDetailList().stream().collect(Collectors.groupingBy(c -> c.getBrandSerial().isEmpty() ? c.getBrandId().toString() : c.getBrandSerial()));
                itemCodes = interceptContentList.stream().map(c -> itemGroupMap.getOrDefault(c, Lists.newArrayList())).flatMap(Collection::stream).map(c -> c.getItemCode()).distinct().collect(Collectors.toList());
                AssertUtils.isTrue((boolean)CollectionUtils.isEmpty(itemCodes), (String)("\u5f53\u524d\u5546\u54c1\u4e0b\u67b6" + JSON.toJSONString(itemCodes) + "\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1\uff01"));
            }
            if (itemInterceptConfigRespDto.getInterceptType().equals(ItemInterceptConfigEnum.ITEM.getCode())) {
                itemGroupMap = itemInterceptReqDto.getItemDetailList().stream().collect(Collectors.groupingBy(c -> c.getItemSerial().isEmpty() ? c.getItemId().toString() : c.getItemSerial()));
                itemCodes = interceptContentList.stream().map(c -> itemGroupMap.getOrDefault(c, Lists.newArrayList())).flatMap(Collection::stream).map(c -> c.getItemCode()).distinct().collect(Collectors.toList());
                AssertUtils.isTrue((boolean)CollectionUtils.isEmpty(itemCodes), (String)("\u5f53\u524d\u5546\u54c1\u4e0b\u67b6" + JSON.toJSONString(itemCodes) + "\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1\uff01"));
            }
        }
    }
}

