/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigQueryApi;
import com.dtyunxi.yundt.module.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.PreviewOrderRespDto;
import com.dtyunxi.yundt.module.trade.biz.IHelpService;
import com.dtyunxi.yundt.module.trade.biz.impl.action.ActionContext;
import com.dtyunxi.yundt.module.trade.biz.impl.action.TemplateList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="helpService")
public class HelpServiceImpl
implements IHelpService {
    @Resource
    private IGiftBalanceQueryApi giftBalanceQueryApi;
    @Resource
    private IGiftConfigQueryApi giftConfigQueryApi;

    @Override
    public GiftInfoRespDto doAction(PreviewOrderRespDto orderInfoDto) {
        if (Objects.isNull(orderInfoDto.getCustomerId())) {
            throw new BizException("\u5ba2\u6237id\u4e3a\u7a7a");
        }
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId(orderInfoDto.getCustomerId());
        BalanceDetailRespDto balanceDetailRespDto = (BalanceDetailRespDto)RestResponseHelper.extractData((RestResponse)this.giftBalanceQueryApi.queryByCustomerId(balanceQueryReqDto));
        if (Objects.isNull(balanceDetailRespDto)) {
            throw new BizException("\u5ba2\u6237" + orderInfoDto.getCustomerId() + "\u989d\u5ea6\u8d26\u6237id\u4e0d\u5b58\u5728");
        }
        GiftConfigBaseRespDto giftConfigBaseRespDto = (GiftConfigBaseRespDto)RestResponseHelper.extractData((RestResponse)this.giftConfigQueryApi.queryBase());
        if (Objects.isNull(giftConfigBaseRespDto)) {
            throw new BizException("\u8d60\u54c1\u8d26\u6237\u4e0d\u5b58\u5728" + orderInfoDto.getCustomerId());
        }
        List itemList = orderInfoDto.getItemList();
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            throw new BizException("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        ActionContext context = new ActionContext();
        context.addContentData("item", itemList);
        context.addContentData("account", balanceDetailRespDto);
        context.addContentData("base", giftConfigBaseRespDto);
        context.addContentData("info", new GiftInfoRespDto());
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getShopList())) {
            context.addContentData("shop", orderInfoDto.getShopList().get(0));
        }
        TemplateList.PREVIEW.forEach(x -> x.doAction(context));
        return context.getContentData("info", GiftInfoRespDto.class);
    }
}

