/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.account.ICrAccountOrderApi;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.thrid.dto.AccountPeriodCreateReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineResult;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.trade.api.dto.request.AccountPeriodReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AddPayRecordReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.AccountPeriodRespDto;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import javax.annotation.Resource;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="accountPeriodPayHelp")
public class AccountPeriodPayHelp
extends AbstractPayHelp<AccountPeriodRespDto> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EngineResult engineResult;
    @Resource
    private ICrAccountOrderApi iCrAccountOrderApi;
    @Resource
    private IShopQueryApi shopQueryApi;

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto simplePayReqDto = new SimplePayReqDto();
        AccountPeriodReqDto AccountPeriodReqDto2 = new AccountPeriodReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)AccountPeriodReqDto2);
        }
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)simplePayReqDto);
        }
        if (Strings.isEmpty((CharSequence)AccountPeriodReqDto2.getShopName()) && Strings.isNotEmpty((CharSequence)AccountPeriodReqDto2.getShopId())) {
            ShopBaseDto shopBaseDto = (ShopBaseDto)this.shopQueryApi.queryBaseById(Long.valueOf(Long.parseLong(AccountPeriodReqDto2.getShopId()))).getData();
            AccountPeriodReqDto2.setShopName(shopBaseDto.getName());
        }
        simplePayReqDto.setAccountPeriodReqDto(AccountPeriodReqDto2);
        return simplePayReqDto;
    }

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    protected void error(Exception e) {
        throw new BizException("\u8d26\u671f\u652f\u4ed8\u53c2\u6570\u5f02\u5e38");
    }

    @Override
    public void customerCheck(SimplePayReqDto simplePayReqDto) {
    }

    @Override
    public void errorCallBack(SimplePayReqDto request) {
    }

    @Override
    public void buildOrderRecord(SimplePayReqDto simplePayReqDto, AddPayRecordReqDto addPayRecordReqDto) {
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        AccountPeriodReqDto accountPeriodReqDto = simplePayReqDto.getAccountPeriodReqDto();
        AccountPeriodCreateReq accountPeriodCreateReq = new AccountPeriodCreateReq();
        accountPeriodCreateReq.setBillAmount(accountPeriodReqDto.getAccountPeriodPayAmount());
        accountPeriodCreateReq.setShopId(accountPeriodReqDto.getShopId());
        accountPeriodCreateReq.setShop(accountPeriodReqDto.getShopName());
        accountPeriodCreateReq.setTotalAmount(simplePayReqDto.getPayAmount());
        accountPeriodCreateReq.setOrderNo(simplePayReqDto.getOrderNo());
        accountPeriodCreateReq.setCustomerId(Long.valueOf(simplePayReqDto.getCustomerId()));
        RestResponse accountOrder = this.iCrAccountOrderApi.createAccountOrder(accountPeriodCreateReq);
        Void unused = (Void)RestResponseHelper.extractData((RestResponse)accountOrder);
        simplePayReqDto.setPayAmount(accountPeriodReqDto.getAccountPeriodPayAmount());
        this.addOrderPayRecord(simplePayReqDto);
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return true;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return true;
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
    }
}

