/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AddPayRecordReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.BasePayRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.PayMethodEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractPayHelp<R extends BasePayRespDto> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    IOrderService orderService;
    @Resource
    private ICommonsMqService commonsMqService;

    public abstract SimplePayReqDto initParam(Object ... var1);

    public SimplePayReqDto prePay(SimplePayReqDto simplePayReqDto) {
        this.baseCheck(simplePayReqDto);
        try {
            this.customerCheck(simplePayReqDto);
            this.toPrePay(simplePayReqDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u4fe1\u7528\u652f\u4ed8\u5931\u8d25:" + e.getMessage());
        }
        return this.buildResult(simplePayReqDto);
    }

    public SimplePayReqDto prePay(Map<String, Object> request) throws Exception {
        return this.prePay(this.map2Bean(request));
    }

    protected abstract SimplePayReqDto buildResult(SimplePayReqDto var1);

    protected void error(Exception e) {
    }

    protected String addOrderPayRecord(SimplePayReqDto req) {
        AddPayRecordReqDto addPayRecordReqDto = new AddPayRecordReqDto();
        addPayRecordReqDto.setDeviceType(req.getDeviceType());
        addPayRecordReqDto.setOrderNo(req.getOrderNo());
        addPayRecordReqDto.setPayAmount(req.getPayAmount());
        addPayRecordReqDto.setSrcType(req.getSrcType());
        addPayRecordReqDto.setPayType(req.getPayType());
        addPayRecordReqDto.setPayDate(new Date());
        PayMethodEnum payMethodTobEnum = PayMethodEnum.fromCode((String)req.getPayMethod());
        Assert.notNull((Object)payMethodTobEnum, (String)" \u652f\u4ed8\u7c7b\u578b\u5f02\u5e38");
        addPayRecordReqDto.setPayMethod(payMethodTobEnum.getNum() + "");
        addPayRecordReqDto.setRemark(payMethodTobEnum.getName());
        addPayRecordReqDto.setStorePayAmount(BigDecimal.valueOf(0L));
        this.buildOrderRecord(req, addPayRecordReqDto);
        String payRequest = null;
        try {
            payRequest = this.orderService.orderPay(addPayRecordReqDto);
            this.logger.info("\u8ba2\u5355[{}]\u6dfb\u52a0\u8bb0\u5f55/\u83b7\u53d6\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570\u83b7\u53d6\u8fd4\u56de:[{}]", (Object)req.getOrderNo(), (Object)payRequest);
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355[{}]\u521b\u5efa\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25,\u539f\u56e0:[{}]", (Object)req.getOrderNo(), (Object)e.getMessage());
            e.printStackTrace();
            throw new BizException("\u8ba2\u5355[" + req.getOrderNo() + "]\u521b\u5efa\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25,\u539f\u56e0 " + e.getMessage());
        }
        return payRequest;
    }

    public void buildOrderRecord(SimplePayReqDto simplePayReqDto, AddPayRecordReqDto addPayRecordReqDto) {
    }

    public SimplePayReqDto map2Bean(Map<String, Object> request) {
        SimplePayReqDto simplePayReqDto = new SimplePayReqDto();
        return simplePayReqDto;
    }

    protected void baseCheck(SimplePayReqDto request) {
        if (request.getPayAmount() == null) {
            throw new BizException("\u652f\u4ed8\u91d1\u989dPayAmount\u5fc5\u586b");
        }
        if (StringUtils.isEmpty((CharSequence)request.getPayMethod())) {
            throw new BizException("\u652f\u4ed8\u65b9\u5f0fPayMethod\u5fc5\u586b");
        }
    }

    public void customerCheck(SimplePayReqDto simplePayReqDto) {
    }

    public void toPrePay(SimplePayReqDto simplePayReqDto) {
    }

    public abstract void errorCallBack(SimplePayReqDto var1);

    public void successCallBack(SimplePayReqDto simplePayReqDto) {
        this.successCallBackDefine(simplePayReqDto);
    }

    public abstract void successCallBackDefine(SimplePayReqDto var1);

    public abstract boolean allowSubmitOrder(SimplePayReqDto var1);

    public abstract boolean isPrePayed(SimplePayReqDto var1);

    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
    }
}

