/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.module.trade.biz.impl.action.ActionContext;
import com.dtyunxi.yundt.module.trade.biz.impl.action.GiftAction;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements GiftAction<ActionContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAction.class);

    @Override
    public boolean judge(ActionContext actionContext) {
        return true;
    }

    @Override
    public void doAction(ActionContext actionContext) {
        LOGGER.info("\u6a21\u677f\u57fa\u7840\u7b56\u7565" + this.getClass().getSimpleName() + JSON.toJSONString((Object)actionContext));
        this.start(actionContext);
    }

    protected abstract void start(ActionContext var1);

    protected GiftConfigBaseRespDto getConfigBase(ActionContext context) {
        GiftConfigBaseRespDto configBase = context.getContentData("base", GiftConfigBaseRespDto.class);
        this.assertObject(configBase);
        return configBase;
    }

    protected List<OrderItemInfoDto> getItem(ActionContext context) {
        List<OrderItemInfoDto> itemList = context.getContentDataList("item", OrderItemInfoDto.class);
        this.assertObject(itemList);
        return itemList;
    }

    protected BigDecimal getTotalPrice(OrderItemInfoDto f) {
        return f.getSellPrice().multiply(BigDecimal.valueOf(f.getItemNum().intValue())).setScale(2, 5).subtract(Optional.ofNullable(f.getDiscountTotalAmount()).orElse(BigDecimal.ZERO));
    }

    protected BalanceDetailRespDto getAccount(ActionContext actionContext) {
        BalanceDetailRespDto account = actionContext.getContentData("account", BalanceDetailRespDto.class);
        this.assertObject(account);
        return account;
    }

    protected GiftInfoRespDto getInfo(ActionContext actionContext) {
        GiftInfoRespDto info = actionContext.getContentData("info", GiftInfoRespDto.class);
        this.assertObject(info);
        return info;
    }

    private void assertObject(Object obj) {
        if (Objects.isNull(obj)) {
            throw new NullPointerException("\u6a21\u677f\u914d\u7f6e\u5931\u6548");
        }
    }
}

