/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditNodeApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.AccountOccupyInfo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.AccountQuotaRecordUpdateReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineResult;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.OrderSkuInfo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.ReverseOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.BooleanEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageRecordType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OrderNodeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.ThreadPoolUtil;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.request.CreditPayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AddPayRecordReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.CreditPayRespDto;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="creditPayPayHelp")
public class CreditPayPayHelp
extends AbstractPayHelp<CreditPayRespDto> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICreditNodeApi creditNodeApi;
    @Resource
    private IContext context;

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto simplePayReqDto = new SimplePayReqDto();
        CreditPayReqDto creditPayReqDto = new CreditPayReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)creditPayReqDto);
        }
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)simplePayReqDto);
        }
        simplePayReqDto.setCreditPayReqDto(creditPayReqDto);
        this.logger.info("\u652f\u4ed8\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)simplePayReqDto));
        return simplePayReqDto;
    }

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    protected void error(Exception e) {
        throw new BizException("\u4fe1\u7528\u652f\u4ed8\u53c2\u6570\u5f02\u5e38");
    }

    @Override
    public void customerCheck(SimplePayReqDto request) {
        if (request.getCreditPayReqDto().getCreditAccountId() == null) {
            throw new BizException("\u4fe1\u7528\u8d26\u53f7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void toPrePay(SimplePayReqDto request) {
        EngineOrderReq engineOrderReq = new EngineOrderReq();
        CreditPayReqDto creditPayReqDto = request.getCreditPayReqDto();
        engineOrderReq.setCreditAccountId(creditPayReqDto.getCreditAccountId());
        engineOrderReq.setCustomerId(Long.valueOf(request.getCustomerId()));
        engineOrderReq.setIsPassOverdueStrategyRemind(creditPayReqDto.getIsPassOverdueStrategyRemind());
        engineOrderReq.setIsPassQuotaStrategyRemind(creditPayReqDto.getIsPassQuotaStrategyRemind());
        engineOrderReq.setOrderNode(OrderNodeEnum.SUBMIT_ORDER.getType());
        engineOrderReq.setOrderNo("");
        engineOrderReq.setOrgId(request.getMerchantId());
        ArrayList<OrderSkuInfo> list = new ArrayList<OrderSkuInfo>();
        for (TradeItemReqDto orderItem : creditPayReqDto.getOrderItems()) {
            OrderSkuInfo orderSkuInfo = new OrderSkuInfo();
            orderSkuInfo.setDirId(null);
            orderSkuInfo.setIsFreight(Integer.valueOf(1));
            orderSkuInfo.setName(orderItem.getSkuName());
            orderSkuInfo.setNum(orderItem.getItemNum());
            orderSkuInfo.setOrganizationId("");
            orderSkuInfo.setPayAmount(orderItem.getItemPrice());
            orderSkuInfo.setPrice(orderItem.getPayTotalAmount());
            orderSkuInfo.setSkuCode(orderItem.getSkuCode());
            list.add(orderSkuInfo);
        }
        engineOrderReq.setOrderInfoList(list);
        engineOrderReq.setTotalAmount(creditPayReqDto.getCreditPayAmount().compareTo(BigDecimal.ZERO) == 0 ? request.getPayAmount() : creditPayReqDto.getCreditPayAmount());
        engineOrderReq.setCombinationPay(Integer.valueOf(creditPayReqDto.getCreditPayAmount().compareTo(request.getPayAmount()) == 0 ? 2 : 1));
        this.logger.info("\u989d\u5ea6\u5360\u7528,\u989d\u5ea6\u6821\u9a8c\u5e94\u7528\u4e2d\u5fc3\u5165\u53e3----:" + JSONObject.toJSONString((Object)engineOrderReq));
        RestResponse restResponse = this.creditNodeApi.doAction(engineOrderReq);
        EngineResult engineResult = (EngineResult)RestResponseHelper.extractData((RestResponse)restResponse);
        CreditPayRespDto creditPayRespDto = new CreditPayRespDto();
        BeanUtils.copyProperties((Object)engineResult, (Object)creditPayRespDto);
        creditPayReqDto.setCreditPayRespDto(creditPayRespDto);
        this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u524d\u7f00,\u67e5\u8be2\u4fe1\u7528\u4e2d\u5fc3:" + JSONObject.toJSONString((Object)engineResult));
        request.setPayMsg(engineResult.getDesc());
    }

    @Override
    public void errorCallBack(SimplePayReqDto request) {
        if (this.isPrePayed(request)) {
            CreditPayReqDto creditPayReqDto = request.getCreditPayReqDto();
            AccountQuotaRecordUpdateReq accountQuotaRecordUpdateReq = new AccountQuotaRecordUpdateReq();
            BeanUtils.copyProperties((Object)creditPayReqDto.getCreditPayRespDto(), (Object)accountQuotaRecordUpdateReq);
            accountQuotaRecordUpdateReq.setSubmitState(Integer.valueOf(2));
            accountQuotaRecordUpdateReq.setOrderNo(request.getOrderNo());
            accountQuotaRecordUpdateReq.setRemark(creditPayReqDto.getRemark());
            ThreadPoolUtil.executorService.submit(() -> this.creditNodeApi.updateQuotaRecord(accountQuotaRecordUpdateReq));
        }
    }

    @Override
    public void buildOrderRecord(SimplePayReqDto simplePayReqDto, AddPayRecordReqDto addPayRecordReqDto) {
        CreditPayReqDto creditPayReqDto = simplePayReqDto.getCreditPayReqDto();
        if (!CollectionUtils.isEmpty((Collection)creditPayReqDto.getCreditPayRespDto().getAccountOccupyInfoList())) {
            addPayRecordReqDto.setAccount(((AccountOccupyInfo)creditPayReqDto.getCreditPayRespDto().getAccountOccupyInfoList().get(0)).getAccountCode());
        }
        addPayRecordReqDto.setCreditPayAmount(simplePayReqDto.getCreditPayReqDto().getCreditPayAmount());
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        if (this.isPrePayed(simplePayReqDto)) {
            simplePayReqDto.setPayAmount(simplePayReqDto.getCreditPayReqDto().getCreditPayAmount());
            this.addOrderPayRecord(simplePayReqDto);
            CreditPayRespDto creditPayRespDto = simplePayReqDto.getCreditPayReqDto().getCreditPayRespDto();
            AccountQuotaRecordUpdateReq accountQuotaRecordUpdateReq = new AccountQuotaRecordUpdateReq();
            BeanUtils.copyProperties((Object)creditPayRespDto, (Object)accountQuotaRecordUpdateReq);
            BeanUtils.copyProperties((Object)simplePayReqDto, (Object)accountQuotaRecordUpdateReq);
            accountQuotaRecordUpdateReq.setSubmitState(Integer.valueOf(1));
            accountQuotaRecordUpdateReq.setOrderNo(simplePayReqDto.getOrderNo());
            accountQuotaRecordUpdateReq.setRemark(CreditUsageRecordType.SUBMIT_ORDER.getDesc());
            accountQuotaRecordUpdateReq.setInstanceId(this.context.instanceId());
            accountQuotaRecordUpdateReq.setTenantId(this.context.tenantId());
            accountQuotaRecordUpdateReq.setUserId(this.context.userId());
            ThreadPoolUtil.executorService.submit(() -> {
                RestResponse voidRestResponse = this.creditNodeApi.updateQuotaRecord(accountQuotaRecordUpdateReq);
                RestResponseHelper.extractData((RestResponse)voidRestResponse);
            });
        }
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        CreditPayRespDto creditPayRespDto = request.getCreditPayReqDto().getCreditPayRespDto();
        return BooleanEnum.YES.getCode().equals(creditPayRespDto.getThisOrderSubmitState());
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        CreditPayRespDto creditPayRespDto = simplePayReqDto.getCreditPayReqDto().getCreditPayRespDto();
        return creditPayRespDto != null && BooleanEnum.YES.getCode().equals(creditPayRespDto.getThisCreditQuotaState());
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        if (simplePayReqDto.getRefundAmount() == null || simplePayReqDto.getRefundAmount().compareTo(BigDecimal.ZERO) <= 0) {
            this.logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27\u9000\u5360\u7528\u989d\u5ea6,\u91d1\u989d\u4e3a\u7a7a,\u9000\u51fa{}", (Object)JSON.toJSONString((Object)simplePayReqDto.getRefundAmount()));
            return;
        }
        ReverseOrderReq reverseOrderReq = new ReverseOrderReq();
        reverseOrderReq.setRemark(CreditUsageRecordType.RELEASE_REFUND.getDesc());
        reverseOrderReq.setIsRefund(Integer.valueOf(1));
        reverseOrderReq.setOrderNo(simplePayReqDto.getOrderNo());
        reverseOrderReq.setNodeCode(simplePayReqDto.getNodeCode());
        reverseOrderReq.setReceiveType(Integer.valueOf(2));
        reverseOrderReq.setReceivedAmount(simplePayReqDto.getRefundAmount());
        this.logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27\u9000\u5360\u7528\u989d\u5ea6,\u7ec4\u88c5\u6570\u636e\u5b8c\u6bd5[{}],\u5f00\u59cb\u8c03\u7528\u63a5\u53e3", (Object)JSON.toJSONString((Object)reverseOrderReq));
        RestResponse restResponse = this.creditNodeApi.doReleaseAction(reverseOrderReq);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        this.logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27\u9000\u5360\u7528\u989d\u5ea6,\u5b8c\u6210\u8c03\u7528\u63a5\u53e3,\u6210\u529f");
    }
}

