/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.module.context.biz.ServiceContextUtil;
import com.dtyunxi.yundt.module.context.common.dto.RequestApp;
import com.dtyunxi.yundt.module.context.common.utils.ContextCommonUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpMethod;

@ConditionalOnClass(value={RequestInterceptor.class})
public class FeignClientContextFilter
implements RequestInterceptor {
    public void apply(RequestTemplate template) {
        RequestApp requestApp;
        String referer;
        String xrealHostName;
        if (template.url().contains("/instance/one-time") && template.method().equalsIgnoreCase(HttpMethod.GET.name()) || template.url().contains("/instance?hostname=") && template.method().equalsIgnoreCase(HttpMethod.GET.name())) {
            return;
        }
        String applicationKey = ServiceContextUtil.getApplicationKey();
        if (applicationKey != null) {
            this.setHeader(template, "Application-Key", applicationKey);
        }
        if ((xrealHostName = ServiceContextUtil.getXrealHostName()) != null) {
            this.setHeader(template, "X-Real-Hostname", xrealHostName);
        }
        if ((referer = ServiceContextUtil.getReferer()) != null) {
            this.setHeader(template, "Referer", referer);
        }
        if ((requestApp = ServiceContextUtil.getAppInstance(ContextCommonUtils.getLocalIp(), template.url(), applicationKey, xrealHostName, referer, template.url())) != null) {
            this.setHeader(template, "yes.req.applicationId", requestApp.getReqAppId());
            this.setHeader(template, "yes.req.instanceId", requestApp.getReqInstanceId());
            this.setHeader(template, "yes.req.tenantId", requestApp.getReqTenantId());
        } else {
            Long requestApplicationId = ServiceContext.getContext().getRequestApplicationId();
            this.setHeader(template, "yes.req.applicationId", requestApplicationId);
            Long requestInstanceId = ServiceContext.getContext().getRequestInstanceId();
            this.setHeader(template, "yes.req.instanceId", requestInstanceId);
            Long requestTenantId = ServiceContext.getContext().getRequestTenantId();
            this.setHeader(template, "yes.req.tenantId", requestTenantId);
        }
        String accessToken = ServiceContextUtil.getAccessToken();
        this.setHeader(template, "Access-Token", accessToken);
        String userId = ServiceContext.getContext().getAttachment("yes.req.userId");
        String userCode = ServiceContext.getContext().getAttachment("yes.req.userCode");
        this.setHeader(template, "yes.req.userId", userId);
        this.setHeader(template, "yes.req.userCode", userCode);
    }

    private <T> void setHeader(RequestTemplate template, String header, T value) {
        if (value != null) {
            template.header(header, new String[]{value.toString()});
        }
    }
}

