/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.config;

import com.dtyunxi.yundt.module.context.biz.impl.AccessTokenInterceptor;
import com.dtyunxi.yundt.module.context.biz.impl.ContextInterceptor;
import com.dtyunxi.yundt.module.context.common.config.ContextConfig;
import com.dtyunxi.yundt.module.context.common.impl.RequestPreProcessService;
import com.dtyunxi.yundt.module.context.common.impl.TokenVerificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class ContextInterceptorConfig
implements WebMvcConfigurer {
    private ContextConfig contextConfigProperties;
    private String tokenSecretKey;
    private RequestPreProcessService requestPreProcessService;

    @Autowired
    public void setContextConfigProperties(ContextConfig contextConfigProperties) {
        this.contextConfigProperties = contextConfigProperties;
    }

    @Value(value="${token.secretKey:}")
    public void setTokenSecretKey(String tokenSecretKey) {
        this.tokenSecretKey = tokenSecretKey;
    }

    @Autowired
    public void setRequestPreProcessService(RequestPreProcessService requestPreProcessService) {
        this.requestPreProcessService = requestPreProcessService;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        AccessTokenInterceptor accessTokenInterceptor = new AccessTokenInterceptor();
        accessTokenInterceptor.setTokenVerificationService(TokenVerificationService.initTokenService((ContextConfig)this.contextConfigProperties, (String)this.tokenSecretKey));
        accessTokenInterceptor.setRequestPreProcessService(this.requestPreProcessService);
        accessTokenInterceptor.setContextConfig(this.contextConfigProperties);
        registry.addInterceptor((HandlerInterceptor)accessTokenInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.contextConfigProperties.getWhiteList());
        registry.addInterceptor((HandlerInterceptor)new ContextInterceptor().enableTrustHeaderApp().fillRequestPreProcessService(this.requestPreProcessService)).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.contextConfigProperties.getContextWhiteList());
    }
}

