/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.context.common.callback.IAccessTokenCallBack;
import com.dtyunxi.yundt.module.context.common.config.ContextConfig;
import com.dtyunxi.yundt.module.context.common.impl.RequestPreProcessService;
import com.dtyunxi.yundt.module.context.common.impl.TokenVerificationService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AccessTokenInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenInterceptor.class);
    private TokenVerificationService tokenVerificationService;
    private RequestPreProcessService requestPreProcessService;
    private ContextConfig contextConfigProperties;

    public boolean preHandle(final HttpServletRequest request, final HttpServletResponse response, Object handler) throws Exception {
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        if (this.contextConfigProperties == null || !this.contextConfigProperties.getValidateAccessToken().booleanValue()) {
            logger.debug("token\u9a8c\u8bc1\u672a\u6253\u5f00");
            return true;
        }
        if (this.requestPreProcessService.serviceCallWhiteList(request.getRemoteHost())) {
            return true;
        }
        IAccessTokenCallBack accessTokenCallBack = new IAccessTokenCallBack(){

            public String getAccessToken() {
                return request.getHeader("Access-Token");
            }

            public String getRequestURI() {
                return request.getRequestURI();
            }

            public void writeOut() throws IOException {
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.append(TokenVerificationService.getRespResult());
            }

            public boolean isValidRemote(String accessToken) {
                return AccessTokenInterceptor.this.getContextBean(request).isValid(accessToken);
            }
        };
        return this.tokenVerificationService.verify(accessTokenCallBack);
    }

    public void setTokenVerificationService(TokenVerificationService tokenVerificationService) {
        this.tokenVerificationService = tokenVerificationService;
    }

    public void setRequestPreProcessService(RequestPreProcessService requestPreProcessService) {
        this.requestPreProcessService = requestPreProcessService;
    }

    public void setContextConfig(ContextConfig contextConfigProperties) {
        this.contextConfigProperties = contextConfigProperties;
    }

    private IContext getContextBean(HttpServletRequest request) {
        IContext context = null;
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        if (null != webApplicationContext) {
            context = (IContext)webApplicationContext.getBean(IContext.class);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            super.afterCompletion(request, response, handler, ex);
        }
        finally {
            ServiceContext.getContext().removeAttachmentContext();
            ServiceContext.removeContext();
        }
    }
}

