/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.TokenUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.ApplicationBatchQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.context.bo.ContextInfo;
import com.dtyunxi.yundt.module.context.bo.Token;
import com.dtyunxi.yundt.module.context.common.dto.RequestApp;
import com.dtyunxi.yundt.module.context.common.impl.RequestPreProcessService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ContextImpl
implements IContext {
    private static final Logger logger = LoggerFactory.getLogger(ContextImpl.class);
    private static final Map<String, Object> contextInstanceMap = new HashMap<String, Object>();
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Autowired
    private RequestPreProcessService requestPreProcessService;

    public Long applicationId() {
        Long applicationId = null;
        ServiceContext context = ServiceContext.getContext();
        applicationId = context.getRequestApplicationId();
        if (applicationId == null) {
            AppInstanceDto appInstance = this.getAppInstance();
            if (null != appInstance) {
                applicationId = appInstance.getApplicationId();
                context.setAttachment("yes.req.applicationId", Long.toString(applicationId));
            } else {
                context.setAttachment("yes.req.applicationId", Long.toString(-1L));
            }
        }
        logger.info("-------------\u5f53\u524d\u5e94\u7528ID:{}---------------", (Object)applicationId);
        return applicationId;
    }

    public Long instanceId() {
        ServiceContext context = ServiceContext.getContext();
        Long instanceId = context.getRequestInstanceId();
        if (instanceId == null) {
            AppInstanceDto appInstance = this.getAppInstance();
            if (null != appInstance) {
                instanceId = appInstance.getId();
                context.setAttachment("yes.req.instanceId", Long.toString(instanceId));
            } else {
                context.setAttachment("yes.req.instanceId", Long.toString(-1L));
            }
        }
        logger.info("-------------\u5f53\u524d\u5b9e\u4f8bID:{}---------------", (Object)instanceId);
        return instanceId;
    }

    public Long tenantId() {
        ServiceContext context = ServiceContext.getContext();
        Long tenantId = context.getRequestTenantId();
        if (tenantId == null) {
            AppInstanceDto appInstance = this.getAppInstance();
            if (null != appInstance) {
                tenantId = appInstance.getTenantId();
                context.setAttachment("yes.req.tenantId", Long.toString(tenantId));
            } else {
                context.setAttachment("yes.req.tenantId", Long.toString(-1L));
            }
        }
        logger.info("-------------\u5f53\u524d\u79df\u6237ID:{}---------------", (Object)tenantId);
        return tenantId;
    }

    public Long userId() {
        ServiceContext context = ServiceContext.getContext();
        Long userId = context.getRequestUserId();
        return userId;
    }

    public String userName() {
        ServiceContext context = ServiceContext.getContext();
        String userName = context.getAttachment("yes.req.userCode");
        return userName;
    }

    public Integer userType() {
        Long userId = this.userId();
        UserDto userDto = (UserDto)this.userQueryApi.queryById(userId, null).getData();
        return userDto.getUserType();
    }

    private AppInstanceDto getAppInstance() {
        ServiceContext context = ServiceContext.getContext();
        String applicationKey = context.getAttachment("Application-Key");
        String hostName = context.getAttachment("X-Real-Hostname");
        logger.info("-------------getAppInstance, applicationKey:{}, X-Real-Hostname:{} ---------------", (Object)applicationKey, (Object)hostName);
        int getType = 1;
        AppInstanceDto appInstanceDto = null;
        if (StringUtils.isNotBlank((CharSequence)applicationKey)) {
            appInstanceDto = this.getByInstanceKey(applicationKey);
        }
        if (null == appInstanceDto && StringUtils.isNotBlank((CharSequence)hostName)) {
            getType = 2;
            appInstanceDto = this.getByInstanceKey(hostName);
        }
        if (null != appInstanceDto) {
            logger.info("-------------\u6839\u636e{}\u83b7\u53d6\u5b9e\u4f8b---------------", (Object)(getType == 1 ? "Application-Key" : "X-Real-Hostname"));
            contextInstanceMap.put(getType == 1 ? applicationKey : hostName, appInstanceDto);
        }
        return appInstanceDto;
    }

    private AppInstanceDto getByInstanceKey(String instanceKey) {
        AppInstanceDto appInstance = null;
        if (StringUtils.isBlank((CharSequence)instanceKey)) {
            return appInstance;
        }
        appInstance = (AppInstanceDto)contextInstanceMap.get(instanceKey);
        if (null == appInstance) {
            ApplicationBatchQueryDto applicationBatchQueryDto = new ApplicationBatchQueryDto();
            appInstance = (AppInstanceDto)this.applicationQueryApi.findByHostnameInOneTime(applicationBatchQueryDto).getData();
        }
        return appInstance;
    }

    public ContextInfo getByHostName(String hostName) {
        ContextInfo contextInfo = null;
        AppInstanceDto appInstance = this.getByInstanceKey(hostName);
        if (null != appInstance) {
            contextInfo = this.getContextInfo(appInstance);
        }
        logger.info("hostName:{}, contextInfo:{}", (Object)hostName, (Object)contextInfo);
        return contextInfo;
    }

    public ContextInfo getByAppKey(String applicationKey) {
        ContextInfo contextInfo = null;
        AppInstanceDto appInstance = this.getByInstanceKey(applicationKey);
        if (null != appInstance) {
            contextInfo = this.getContextInfo(appInstance);
        }
        logger.info("applicationKey:{}, contextInfo:{}", (Object)applicationKey, (Object)contextInfo);
        return contextInfo;
    }

    private ContextInfo getContextInfo(AppInstanceDto appInstanceDto) {
        ContextInfo contextInfo = new ContextInfo();
        contextInfo.setInstanceId(appInstanceDto.getId());
        contextInfo.setTenantId(appInstanceDto.getTenantId());
        contextInfo.setApplicationId(appInstanceDto.getApplicationId());
        return contextInfo;
    }

    public Boolean isValid(String accessToken) {
        Map checkResult = null;
        RestResponse restResponse = this.tokenApi.checkToken(accessToken);
        if (ExceptionCode.SUCCESS.getCode().equals(restResponse.getResultCode())) {
            checkResult = (Map)restResponse.getData();
        }
        return checkResult != null;
    }

    public Token parse(String accessToken) {
        Token token = null;
        Map parseMap = TokenUtil.parse((String)accessToken);
        if (null != parseMap) {
            token = new Token();
            ObjectHelper.mapToBean((Map)parseMap, (Object)token);
            Long userId = (Long)parseMap.get("id");
            Integer expireTime = (Integer)parseMap.get("exp");
            token.setUserId(userId);
            token.setExpireTime(Long.valueOf(expireTime.longValue()));
        }
        return token;
    }

    public UserAccessVo findUserAccess() {
        Long userId = this.userId();
        try {
            RestResponse response;
            AppInstanceDto appInstanceDto = this.getAppInstance();
            if (null != appInstanceDto && null != (response = this.accessQueryApi.queryUserAccess(appInstanceDto.getId(), userId, "{}")) && "0".equals(response.getResultCode())) {
                return (UserAccessVo)response.getData();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }

    public void setApplicationKey(String applicationKey) {
        applicationKey = applicationKey + "";
        ServiceContext.getContext().setAttachment("Application-Key", applicationKey);
    }

    public void removeApplicationKey() {
    }

    public void applicationId(Long id) {
        ServiceContext.getContext().setAttachment("yes.req.applicationId", id.toString());
    }

    public void instanceId(Long id) {
        ServiceContext.getContext().setAttachment("yes.req.instanceId", id.toString());
    }

    public void tenantId(Long id) {
        ServiceContext.getContext().setAttachment("yes.req.tenantId", id.toString());
    }

    public void userId(Long id) {
        ServiceContext.getContext().setAttachment("yes.req.userId", id.toString());
    }

    public void userName(String name) {
        ServiceContext.getContext().setAttachment("yes.req.userCode", name);
    }

    public RequestApp recognizeApp(String remoteIp, String requestUrl, String applicationKey, String xRealHostname, String referer, String apiPath) {
        RequestApp requestApp = this.requestPreProcessService.recognizeRequestApp(remoteIp, requestUrl, applicationKey, xRealHostname, referer, apiPath);
        if (requestApp != null) {
            ServiceContext.getContext().set("REQUEST_APP", (Object)requestApp);
        }
        return requestApp;
    }
}

