/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.module.context.biz.ServiceContextUtil;
import com.dtyunxi.yundt.module.context.common.dto.RequestApp;
import com.dtyunxi.yundt.module.context.common.impl.RequestPreProcessService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ContextInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ContextInterceptor.class);
    private boolean trustHeaderApp = false;
    private RequestPreProcessService requestPreProcessService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (HttpMethod.OPTIONS.name().equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        HashMap<String, String> packingHeaderValues = new HashMap<String, String>();
        for (String packingHeader : ServiceContextUtil.PACKING_HEADERS) {
            packingHeaderValues.put(packingHeader, request.getHeader(packingHeader));
        }
        ContextInterceptor.fillContextByHeader(request.getRequestURL().toString(), packingHeaderValues, this.trustHeaderApp);
        return true;
    }

    public static void fillContextByHeader(String requestUrl, Map<String, String> headerMap, boolean trustHeaderApp) {
        ServiceContext context = ServiceContext.getContext();
        context.getAttachments().clear();
        String applicationKey = headerMap.get("Application-Key");
        String xRealHostname = headerMap.get("X-Real-Hostname");
        String referer = headerMap.get("Referer");
        logger.info("url={}, X-Real-Hostname={}, Application-Key={},referer={}", new Object[]{requestUrl, xRealHostname, applicationKey, referer});
        if (xRealHostname == null) {
            xRealHostname = requestUrl;
        }
        ServiceContext.getContext().setAttachment("X-Real-Hostname", xRealHostname);
        if (applicationKey == null) {
            applicationKey = "";
        }
        ServiceContext.getContext().setAttachment("Application-Key", applicationKey);
        if (referer != null) {
            ServiceContext.getContext().setAttachment("Referer", referer);
        }
        if (trustHeaderApp) {
            ContextInterceptor.fillContextMap(headerMap);
        }
    }

    public static void fillContextMap(Map<String, String> headerMap) {
        String reqAppId = headerMap.get("yes.req.applicationId");
        String reqInstanceId = headerMap.get("yes.req.instanceId");
        String reqTenantId = headerMap.get("yes.req.tenantId");
        ServiceContext context = ServiceContext.getContext();
        context.setAttachment("yes.req.applicationId", reqAppId);
        context.setAttachment("yes.req.tenantId", reqTenantId);
        context.setAttachment("yes.req.instanceId", reqInstanceId);
        String userId = ServiceContext.getContext().getAttachment("yes.req.userId");
        String userCode = ServiceContext.getContext().getAttachment("yes.req.userCode");
        if (userId == null && (userId = headerMap.get("yes.req.userId")) != null) {
            ServiceContext.getContext().setAttachment("yes.req.userId", userId);
        }
        if (userCode == null && (userCode = headerMap.get("yes.req.userCode")) != null) {
            ServiceContext.getContext().setAttachment("yes.req.userCode", userCode);
        }
        logger.info("\u4f7f\u7528header\u900f\u4f20\u7684instance\u4fe1\u606f: tenantId={},instanceId={},applicationId={},userId:{},userCode:{}", new Object[]{reqTenantId, reqInstanceId, reqAppId, userId, userCode});
        if (reqAppId != null && reqInstanceId != null && reqTenantId != null) {
            RequestApp requestApp = new RequestApp();
            try {
                requestApp.setReqTenantId(Long.valueOf(Long.parseLong(reqTenantId)));
                requestApp.setReqInstanceId(Long.valueOf(Long.parseLong(reqInstanceId)));
                requestApp.setReqAppId(Long.valueOf(Long.parseLong(reqAppId)));
            }
            catch (Exception e) {
                logger.warn("\u5e94\u7528\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38\uff1a{}-{}-{}", new Object[]{reqAppId, reqTenantId, reqInstanceId, e});
            }
            ServiceContext.getContext().set("REQUEST_APP", (Object)requestApp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            super.afterCompletion(request, response, handler, ex);
        }
        finally {
            ServiceContext.getContext().removeAttachmentContext();
            ServiceContext.removeContext();
        }
    }

    public ContextInterceptor enableTrustHeaderApp() {
        this.trustHeaderApp = true;
        return this;
    }

    public ContextInterceptor fillRequestPreProcessService(RequestPreProcessService requestPreProcessService) {
        this.requestPreProcessService = requestPreProcessService;
        return this;
    }
}

