/*
 * *
 *  * @(#)ModifyPasswordReqDto.java 2.0.0 2/27/20, 1:34 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.module.customer.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 用户名修改密码参数
 * 
 * @author wu.sheng
 * @time 2019年8月1日 下午3:18:21
 */
@ApiModel(value = "ModifyPasswordReqDto", description = "通过用户名修改密码参数")
public class ModifyPasswordReqDto {

	@ApiModelProperty(name = "userName", value = "用户名", required = true)
	@NotNull
	private String userName;

	@ApiModelProperty(name = "password", value = "旧密码", required = true)
	@NotNull
	private String password;

	@ApiModelProperty(name = "newPassword", value = "新密码", required = true)
	@NotNull
	private String newPassword;

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getNewPassword() {
		return newPassword;
	}

	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}

}
