package com.dtyunxi.yundt.module.customer.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerImportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerBlacklistRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;

import java.util.List;

/**
 * 人员关联客户服务实现类
 * @Author: xiuji
 * @Date: 2022/1/20 10:00 AM
 */
public interface IEmployeeCustomerService {

    /**
     * 查询人员所属客户
     * @param queryReqDto
     * @return
     */
    RestResponse<List<EmployeeCustomerRespDto>> queryEmployeeCustomerList(EmployeeCustomerQueryReqDto queryReqDto);


    /**
     * 客户导入
     * 返回客户信息集合，成功数，失败数，失败文档
     */
    RestResponse<EmployeeCustomerImportRespDto> customerImport(EmployeeCustomerImportReqDto importReqDto);



    /**
     * 查询人员-客户黑名单
     * @param queryReqDto
     * @return
     */
    RestResponse<List<EmployeeCustomerBlacklistRespDto>> queryEmployeeCustomerBlackList(EmployeeCustomerBlacklistQueryReqDto queryReqDto);

}
