/**
 * @(#)IWeixinService.java 1.0 2020/2/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.yundt.module.customer.api.user.dto.response.WxUserInfoDto;

import java.util.HashMap;

/**
 * 微信
 *
 * @author wu.sheng
 * @date 2020/2/28 9:19
 */
public interface IWeixinService {

    /**
     * 获取JSSKD配置信息
     *
     * @param url
     * @return
     * @author wu.sheng
     * @date 2020/2/28 9:20
     */
    HashMap<String, String> jsSdkSign(String url);

    /**
     * 获取调用接口access_token
     * @param isMini 是否为小程序
     * @return
     * @author wu.sheng
     * @date 2020/2/28 9:26
     */
    String getAccessToken(boolean isMini);

    /**
     * 获取jsapiticket
     *
     * @return
     * @author wu.sheng
     * @date 2020/2/28 9:27
     */
    String getJsApiTicket();


    /**
     * 获取微信获取授权code地址
     *
     * @return
     * @author wu.sheng
     * @date 2020/2/28 15:50
     */
    String getCodeUri(String redirectUri);

    /**
     * 获取网页授权access_token
     *
     * @param code
     * @author wu.sheng
     * @date 2020/2/28 16:08
     */
    String getOpenId(String code);


    /**
     * 获取微信用户信息
     *
     * @param accessToken 网页授权access_token
     * @return
     */
    WxUserInfoDto getUserInfo(String accessToken, String openId);

    /**
     * 生成小程序二维码，并上传到oss上
     * @param path 路径
     * @param width 宽度
     * @return oss上的文件路径
     */
    String getWxaCode(String path, int width);
}
