package com.dtyunxi.yundt.module.customer.api.dto.response;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


@ApiModel(value = "CustomerDetailRespDto", description = "客户详细信息响应Dto")
public class CustomerDetailRespDto extends CustomerRespDto {

    /**
     * 营业执照URL
     */
    @ApiModelProperty(value = "营业执照URL，选填")
    private String bussinessLicenseUrl;

    /**
     *  业务员名称
     */
    @ApiModelProperty(name="salesmanName",value = "业务员名称")
    private String salesmanName;

    /**
     * 用户名/登录名/登录账号
     */
    @ApiModelProperty(value = "用户名/登录名/登录账号")
    private String userName;

    /**
     *  区域
     */
    @ApiModelProperty(name="region",value = "区域")
    private String region;


    @ApiModelProperty(name = "externalCode", value = "外部编码")
    private String externalCode;

    /**
     *  联系人信息
     */
    @ApiModelProperty(name="contactsInfoDto",value = "联系人信息")
    private ContactsInfoDto contactsInfoDto;
    /**
     *  开票信息
     */
    @ApiModelProperty(name="billInfoDto",value = "开票信息")
    private BillInfoDto billInfoDto;
    /**
     * 地址信息列表
     */
    @ApiModelProperty(name="addressDtoList",value = "地址信息列表")
    private List<AddressDto> addressDtoList;

    /**
     *  联系人信息集合
     */
    @ApiModelProperty(name="contactsInfoList",value = "联系人信息集合")
    private List<ContactsInfoDto> contactsInfoList;

    /**
     *  开票信息集合
     */
    @ApiModelProperty(name="billInfoList",value = "开票信息集合")
    private List<BillInfoDto> billInfoList;

    @ApiModelProperty(name = "regionNameList",value = "区域编码集合")
    private List<String> regionNameList;

    /**
     * 客户级别id
     */
    @ApiModelProperty(name = "levelId", value = "客户级别id")
    private Long levelId;

    /**
     * 客户级别名称
     */
    @ApiModelProperty(name = "levelName", value = "客户级别名称")
    private String levelName;

    @Override
    public Long getLevelId() {
        return levelId;
    }

    @Override
    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    @Override
    public String getLevelName() {
        return levelName;
    }

    @Override
    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public List<String> getRegionNameList() {
        return regionNameList;
    }

    public void setRegionNameList(List<String> regionNameList) {
        this.regionNameList = regionNameList;
    }

    public List<ContactsInfoDto> getContactsInfoList() {
        return contactsInfoList;
    }

    public void setContactsInfoList(List<ContactsInfoDto> contactsInfoList) {
        this.contactsInfoList = contactsInfoList;
    }

    public List<BillInfoDto> getBillInfoList() {
        return billInfoList;
    }

    public void setBillInfoList(List<BillInfoDto> billInfoList) {
        this.billInfoList = billInfoList;
    }

    public String getBussinessLicenseUrl() {
        return bussinessLicenseUrl;
    }

    public void setBussinessLicenseUrl(String bussinessLicenseUrl) {
        this.bussinessLicenseUrl = bussinessLicenseUrl;
    }

    public String getSalesmanName() {
        return salesmanName;
    }

    public void setSalesmanName(String salesmanName) {
        this.salesmanName = salesmanName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public ContactsInfoDto getContactsInfoDto() {
        return contactsInfoDto;
    }

    public void setContactsInfoDto(ContactsInfoDto contactsInfoDto) {
        this.contactsInfoDto = contactsInfoDto;
    }

    public BillInfoDto getBillInfoDto() {
        return billInfoDto;
    }

    public void setBillInfoDto(BillInfoDto billInfoDto) {
        this.billInfoDto = billInfoDto;
    }

    public List<AddressDto> getAddressDtoList() {
        return addressDtoList;
    }

    public void setAddressDtoList(List<AddressDto> addressDtoList) {
        this.addressDtoList = addressDtoList;
    }

    public String getExternalCode() {
        return externalCode;
    }

    public void setExternalCode(String externalCode) {
        this.externalCode = externalCode;
    }
}