package com.dtyunxi.yundt.module.customer.api.dto.request;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


@ApiModel(value = "CustomerDetailReqDto", description = "客户详细信息请求Dto")
public class CustomerDetailReqDto extends CustomerReqDto {

    /**
     * 营业执照URL
     */
    @ApiModelProperty(value = "营业执照URL，选填")
    private String bussinessLicenseUrl;

    /**
     *  用户账号信息
     */
    @ApiModelProperty(name="userAccountReqDto",value = "用户账号信息")
    private UserAccountReqDto userAccountReqDto;
    /**
     *  联系人信息
     */
    @ApiModelProperty(name="contactsInfoDto",value = "联系人信息")
    private ContactsInfoDto contactsInfoDto;
    /**
     *  联系人信息集合
     */
    @ApiModelProperty(name="contactsInfoList",value = "联系人信息集合")
    private List<ContactsInfoDto> contactsInfoList;
    /**
     *  开票信息
     */
    @ApiModelProperty(name="billInfoDto",value = "开票信息")
    private BillInfoDto billInfoDto;
    /**
     *  联系人信息集合
     */
    @ApiModelProperty(name="billInfoList",value = "联系人信息集合")
    private List<BillInfoDto> billInfoList;
    /**
     * 地址信息
     */
    @ApiModelProperty(name="addressDto",value = "地址信息")
    private AddressDto addressDto;

    public List<ContactsInfoDto> getContactsInfoList() {
        return contactsInfoList;
    }

    public void setContactsInfoList(List<ContactsInfoDto> contactsInfoList) {
        this.contactsInfoList = contactsInfoList;
    }

    public List<BillInfoDto> getBillInfoList() {
        return billInfoList;
    }

    public void setBillInfoList(List<BillInfoDto> billInfoList) {
        this.billInfoList = billInfoList;
    }

    public String getBussinessLicenseUrl() {
        return bussinessLicenseUrl;
    }

    public void setBussinessLicenseUrl(String bussinessLicenseUrl) {
        this.bussinessLicenseUrl = bussinessLicenseUrl;
    }

    public UserAccountReqDto getUserAccountReqDto() {
        return userAccountReqDto;
    }

    public void setUserAccountReqDto(UserAccountReqDto userAccountReqDto) {
        this.userAccountReqDto = userAccountReqDto;
    }

    public ContactsInfoDto getContactsInfoDto() {
        return contactsInfoDto;
    }

    public void setContactsInfoDto(ContactsInfoDto contactsInfoDto) {
        this.contactsInfoDto = contactsInfoDto;
    }

    public BillInfoDto getBillInfoDto() {
        return billInfoDto;
    }

    public void setBillInfoDto(BillInfoDto billInfoDto) {
        this.billInfoDto = billInfoDto;
    }

    public AddressDto getAddressDto() {
        return addressDto;
    }

    public void setAddressDto(AddressDto addressDto) {
        this.addressDto = addressDto;
    }
}