package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * 人员导入管理类型枚举
 * @author jiejun
 */
public enum EmpGovernTypeEnum {
    //管理区域、管理客户、管理黑名单
    AREA(1, "管理区域"),
    CUS(2, "管理客户"),
    BLA(3, "管理黑名单"),
    ;

    private final Integer code;
    private final String name;

    EmpGovernTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static EmpGovernTypeEnum fromCode(Integer code) {
        for (EmpGovernTypeEnum typeEnum : EmpGovernTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static EmpGovernTypeEnum fromName(String name) {
        for (EmpGovernTypeEnum typeEnum : EmpGovernTypeEnum.values()) {
            if (typeEnum.getName().equals(name)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        EmpGovernTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        EmpGovernTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
