/**
 * @(#)TokenInfo.java 1.0 2019/9/27
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "TokenInfo", description = "用户登录返回信息")
public class TokenInfo {


    @ApiModelProperty(name = "userId", value = "用户ID")
    private Long userId;

    @ApiModelProperty(name = "token", value = "登录令牌token")
    private String token;

    @ApiModelProperty(name = "userType", value = "用户类型： 1 运营用户；  2  商户方；  3  C 端用户")
    private Integer userType;

    @ApiModelProperty(name = "phone", value = "手机号码")
    private String phone;

    @ApiModelProperty(name = "instanceId", value = "实例id")
    private Long instanceId;

    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;

    @ApiModelProperty( name = "isFirstLogin",value = "是否是首次登录，0:否；1:是")
    private Integer isFirstLogin;

    @ApiModelProperty(name = "orgInfoId", value = "组织id")
    private Long orgInfoId;

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public Integer getIsFirstLogin() {
        return isFirstLogin;
    }

    public void setIsFirstLogin(Integer isFirstLogin) {
        this.isFirstLogin = isFirstLogin;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
}
