package com.dtyunxi.yundt.module.customer.rest.user;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.query.IPostQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.UserInfoRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IUserService;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.OrganizationPackageDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 用户组件:用户相关服务
 *
 * @author sumo
 * @date 2020/9/29 0029
 */
@Api(tags = {"用户组件：用户相关服务"})
@RestController("userRestV1")
@RequestMapping("/v1/user")
public class UserRest {


    @Autowired
    private IUserQueryApi iUserQueryApi;
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Autowired
    private IUserService userService;

    @Resource
    private IPostQueryApi postQueryApi;

    @Resource
    private IEmployeeQueryApi employeeQueryApi;

    @Resource
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;

    @Value("${icommerceb.post.postCode}")
    private String sysPostCode;


    @GetMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "获取业务员分页", notes = "获取业务员分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "int", paramType = "query", required = true)})
    RestResponse<PageInfo<UserDto>> pageUser(
            @RequestParam(value = "account", required = false) String account,
            @RequestParam(value = "userName", required = false) String userName,
            @RequestParam(value = "phone", required = false) String phone,
            @RequestParam(value = "email", required = false) String email,
            @RequestParam("pageNum") Integer pageNum,
            @RequestParam("pageSize") Integer pageSize) {
        Long tenantId = context.tenantId();
        return new RestResponse<>(iUserQueryApi.queryUser(tenantId, account, userName, phone, email, pageNum, pageSize).getData());

    }

    @GetMapping(value = "/list", produces = "application/json")
    @ApiOperation(value = "获取业务员全部列表", notes = "获取业务员全部列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postCode", value = "岗位编码", dataType = "String", paramType = "query")
    })
    RestResponse<List<UserDto>> queryUser(@RequestParam(value = "postCode", required = false) String postCode) {

        if (StringUtils.isEmpty(postCode)){
            postCode = sysPostCode;
        }
        RestResponse<List<EmployeePagerRespDto>> listRestResponse = postQueryApi.employeeList(postCode);
        List<EmployeePagerRespDto> employDtoList = RestResponseHelper.extractData(listRestResponse);
        List<Long> userIdList = Lists.newArrayList();
        //todo 当前用户中心没有根据员工id集合查询员工信息的接口，只能调单个接口，可能存在性能问题，后续优化
        for (EmployeePagerRespDto employeePagerRespDto : employDtoList) {
            RestResponse<EmployeeRespDto> employeeRestResp = employeeQueryApi.queryById(employeePagerRespDto.getId());
            EmployeeRespDto employeeRespDto = RestResponseHelper.extractData(employeeRestResp);
            if (Objects.nonNull(employeeRespDto.getUserId())) {
                userIdList.add(employeeRespDto.getUserId());
            }
        }
        List<UserDto> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userIdList)){
            RestResponse<List<UserDto>> userRestResp = iUserQueryApi.queryByIdList(StringUtils.join(userIdList, ","), "{}");
            list = RestResponseHelper.extractData(userRestResp);
        }

        return new RestResponse<List<UserDto>>(list);

    }

    @GetMapping(value = "/salesman/list", produces = "application/json")
    @ApiOperation(value = "查询业务员列表", notes = "查询业务员列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "useType", value = "使用类型，1-客户列表相关(默认值)，2-业务员列表", dataType = "int", paramType = "query",required = true),
            @ApiImplicitParam(name = "type", value = "客户类型（2：经销商，3：零售商）", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "channel", value = "渠道类型（1：品牌方运营端，2：大B卖家端）", dataType = "int", paramType = "query",required = true),
            @ApiImplicitParam(name = "superiorOrgId", value = "上游组织ID", dataType = "Long", paramType = "query")})
    RestResponse<List<UserRespDto>> querySalesmanList(@RequestParam("type") Integer type,
                                                  @RequestParam(name = "useType", required = true, defaultValue = "1") Integer useType,
                                                  @RequestParam("channel") Integer channel,
                                                  @RequestParam(name = "superiorOrgId", required = false) Long superiorOrgId) {

        Assert.isTrue(null != type,"客户类型不能为空");
        Assert.isTrue(null != channel,"渠道类型不能为空");
        if (CustomerTypeEnum.BRAND.getCode().equals(channel) && CustomerTypeEnum.RETAILER.getCode().equals(type)) {
            Assert.isTrue(null != superiorOrgId,"上游组织ID不能为空");
        }
        if (Objects.isNull(superiorOrgId)){
            superiorOrgId = userService.getCurrentUserOrgId(context.userId());
        }
        // 优先查询业务员列表(不限制状态)
        if (Objects.equals(1, useType) ){
            CustomerSalesmanReqDto customerSalesmanReqDto = new CustomerSalesmanReqDto();
            customerSalesmanReqDto.setOrgInfoId(superiorOrgId);
            PageInfo<CustomerSalesmanRespDto> salesmanRespDtoPageInfo = RestResponseHelper.extractData(customerSalesmanQueryApi.queryByPage(customerSalesmanReqDto, 1, 1000));
            if (Objects.nonNull(salesmanRespDtoPageInfo) && CollUtil.isNotEmpty(salesmanRespDtoPageInfo.getList())){
                List<UserRespDto> userRespList = salesmanRespDtoPageInfo.getList().stream().map(item -> {
                    UserRespDto userRespDto = new UserRespDto();
                    userRespDto.setAccount(item.getName());
                    userRespDto.setUserName(item.getName());
                    userRespDto.setId(item.getUserId());
                    userRespDto.setCreateTime(item.getCreateTime());
                    userRespDto.setPhone(item.getMobileNumber());
                    userRespDto.setEmail(item.getEmail());
                    return userRespDto;
                }).collect(Collectors.toList());
                return new RestResponse<>(userRespList);
            }
        }
        //根据上游组织ID查询该组织下绑定的user
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(superiorOrgId);
        RestResponse<PageInfo<UserRespDto>> pageInfoRestResponse = organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, 1, Integer.MAX_VALUE);
        PageInfo<UserRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
        List<UserRespDto> list = Lists.newArrayList();
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty(pageInfo.getList())){
            list = pageInfo.getList();
        }

        return new RestResponse<List<UserRespDto>>(list);

    }

    @GetMapping({"/all/subordinate"})
    @ApiOperation("查询用户本身及下级组织列表")
    RestResponse<List<OrganizationDto>> queryAllSubordinateOrgIds() {
        List<OrganizationDto> res;
        List<Long> orgIds = RestResponseHelper.extractData(organizationQueryApi.queryAllSubordinateOrgIds());
        if (CollectionUtils.isEmpty(orgIds)) {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(0L);
            organizationDto.setName("默认组织");
            res = Lists.newArrayList(organizationDto);
        }
        else {
            res = orgIds.stream().map(id -> organizationQueryApi.queryById(id, "{}").getData()).collect(Collectors.toList());
        }
        return new RestResponse(res);
    }

    @GetMapping({"/all/self"})
    @ApiOperation("查询查询用户本身组织列表")
    RestResponse<List<OrganizationDto>> queryUserOrgList() {
        List<OrganizationDto> orgs = RestResponseHelper.extractData(organizationQueryApi.queryUserOrgList());
        if (CollectionUtils.isEmpty(orgs)) {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(0L);
            organizationDto.setName("默认组织");
            orgs = Lists.newArrayList(organizationDto);
        }
        return new RestResponse(orgs);
    }

    @GetMapping({"/all/superior"})
    @ApiOperation("查询查询用户本身及上级组织列表")
    RestResponse<List<OrganizationDto>> queryAllSuperiorOrgIdList() {
        List<OrganizationDto> res;
        List<Long> orgIds = RestResponseHelper.extractData(organizationQueryApi.queryAllSuperiorOrgIdList());
        if (CollectionUtils.isEmpty(orgIds)) {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(0L);
            organizationDto.setName("默认组织");
            res = Lists.newArrayList(organizationDto);
        }
        res = orgIds.stream().map(id -> organizationQueryApi.queryById(id, "{}").getData()).collect(Collectors.toList());
        return new RestResponse(res);
    }

    @ApiOperation("查询用户的个人信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", dataType = "Long", paramType = "query", value = "用户id，非必填"),
            @ApiImplicitParam(name = "srcType", dataType = "Int", paramType = "query", value = "来源类型（1:经销商小程序端，2:PC管理端，3:业务员小程序端）")
    })
    @GetMapping("/user-info")
    public RestResponse<UserInfoRespDto> queryUserInfo(@RequestParam(value = "userId", required = false) Long userId,
                                                       @RequestParam(value = "srcType", required = false) Integer srcType) {

        return new RestResponse<>(userService.queryUserInfo(userId,srcType));
    }

    @GetMapping({"/org/show"})
    @ApiOperation("查询用于新增和回显的用户组织id集合")
    RestResponse<OrganizationPackageDto> showOrgs(@RequestParam(value = "organizationId", required = false)  Long orgId) {
        return new RestResponse<>(userService.showOrgIds(orgId));
    }
}
