/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="removeHandler")
public class RemoveHandler
implements IServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoveHandler.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;

    public Object handle(ServiceEvent<?> serviceEvent) {
        logger.info("======>\u5220\u9664\u5546\u54c1");
        Long id = (Long)serviceEvent.getData();
        if (null == id) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.CHANGE_RECORD_ID_NOT_NULL);
        }
        this.itemApi.removeItem(String.valueOf(id));
        ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(id, "sku", null).getData();
        Integer itemStatus = Optional.ofNullable(itemDetailRespDto).map(ItemDetailRespDto::getItem).map(ItemRespDto::getStatus).orElseGet(() -> null);
        if (ItemStatus.ITEM_ONSHELF.getStatus().equals(itemStatus)) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.ON_SHELF_ITEM_NOT_REMOVE);
        }
        RestResponse itemResponse = this.itemApi.removeItem(String.valueOf(id));
        RestResponseHelper.checkOrThrow((RestResponse)itemResponse);
        return null;
    }
}

