/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemChangeApplyApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemChangeApplyStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPublishReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemRelationSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRelationSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderConfigInfoRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query.ICommanderInfoQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.IBrand;
import com.dtyunxi.yundt.module.item.api.IItem;
import com.dtyunxi.yundt.module.item.api.IItemLibService;
import com.dtyunxi.yundt.module.item.api.constants.ItemConstant;
import com.dtyunxi.yundt.module.item.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.item.api.dto.JXCDto;
import com.dtyunxi.yundt.module.item.api.dto.JXCItemDto;
import com.dtyunxi.yundt.module.item.api.enums.ItemLibTypeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.impl.JxcService;
import com.dtyunxi.yundt.module.item.bo.Brand;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemLibService")
public class ItemLibServiceImpl
implements IItemLibService {
    private static Logger logger = LoggerFactory.getLogger(ItemLibServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IItemChangeApplyApi iItemChangeApplyApi;
    @Resource
    private IItem iItem;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private IItem item;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Autowired
    ICommonsMqService commonsMqService;
    @Resource
    private ICommanderInfoQueryApi iCommanderInfoQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemAuthApi itemAuthApi;
    @Resource
    private IBrand brandImpl;
    @Resource
    private JxcService jxcService;
    @Resource
    private ICacheService cacheService;
    private final Integer defalutAddPriceMax = 20;
    private final Integer defalutAddPriceMin = 10;

    @Transactional(rollbackFor={Exception.class})
    public Long createItemLib(ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        logger.info("\u5f00\u59cb\u521b\u5efa\u5546\u54c1\u5e93,\u5165\u53c2ItemChangeApplyDetailDto:{}", (Object)JSON.toJSONString((Object)itemChangeApplyDetailDto));
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Long userId = this.context.userId();
        if (Objects.isNull(itemChangeApplyDetailDto.getOrganizationId())) {
            Long currentUserOrgId = this.iItem.getCurrentUserOrgId(userId);
            logger.info("\u524d\u7aef\u672a\u4f20\u7ec4\u7ec7id\uff0c\u5f53\u524d\u767b\u5f55\u4eba\u7ec4\u7ec7id\uff1a{}", (Object)currentUserOrgId);
            itemChangeApplyDetailDto.setOrganizationId(currentUserOrgId);
        }
        if (StringUtils.isBlank((String)itemChangeApplyDetailDto.getItemCode())) {
            String itemCode = this.getItemCode();
            logger.info("\u524d\u7aef\u672a\u4f20\u5546\u54c1\u5e93\u5546\u54c1\u7f16\u7801\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u53f7\uff1a{}", (Object)itemCode);
            itemChangeApplyDetailDto.setItemCode(itemCode);
        }
        if (StringUtils.isBlank((String)itemChangeApplyDetailDto.getDisplayName())) {
            itemChangeApplyDetailDto.setDisplayName(itemChangeApplyDetailDto.getItemName());
        }
        if (itemChangeApplyDetailDto.getType() == null) {
            itemChangeApplyDetailDto.setType(ItemLibTypeEnum.GENERAL_ITEM.getType());
        } else if (itemChangeApplyDetailDto.getType().equals(ItemTypeEnum.VIRTUAL.getType())) {
            itemChangeApplyDetailDto.setVirtual(Boolean.valueOf(true));
        }
        ItemChangeApplyReqDto itemChangeApplyReqDto = new ItemChangeApplyReqDto();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyReqDto, (Object)itemChangeApplyDetailDto, (String[])new String[0]);
        itemChangeApplyReqDto.setSellerId(ItemConstant.ITEM_LIB_SELLER_ID);
        itemChangeApplyReqDto.setInstanceId(instanceId);
        itemChangeApplyReqDto.setTenantId(tenantId);
        itemChangeApplyReqDto.setOwnerId(userId);
        itemChangeApplyReqDto.setStatus(ItemChangeApplyStatus.DRAFT.getStatus());
        itemChangeApplyReqDto.setItemChangeApplyDto((ItemChangeApplyDto)itemChangeApplyDetailDto);
        if (ItemLibTypeEnum.MULTIPLE_ITEM.getType().intValue() != itemChangeApplyDetailDto.getType().intValue()) {
            this.checkCargoCode(itemChangeApplyReqDto.getItemChangeApplyDto());
        } else {
            itemChangeApplyDetailDto.getSkus().forEach(itemBundleReqDto -> {
                if (!CollectionUtils.isNotEmpty((Collection)itemBundleReqDto.getBundleItemDtos())) {
                    throw new BizException("\u8bf7\u9009\u62e9\u5546\u54c1\u8fdb\u884c\u7ec4\u5408");
                }
                itemBundleReqDto.getBundleItemDtos().forEach(bundleItemReqDto -> {
                    if (bundleItemReqDto.getNum() == null || bundleItemReqDto.getNum() <= 0) {
                        throw new BizException("\u7ec4\u5408\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            });
        }
        List shopList = (List)this.shopQueryApi.queryByIds((Set)Sets.newHashSet((Object[])new Long[]{itemChangeApplyDetailDto.getShopId()})).getData();
        if (CollectionUtils.isEmpty((Collection)shopList)) {
            throw new BizException("\u5e97\u94fa\u4e0d\u5b58\u5728");
        }
        logger.info("\u65b0\u589e\u5546\u54c1\u5e93\u53d8\u66f4\u7533\u8bf7...\uff0c\u5165\u53c2ItemChangeApplyReqDto\uff1a{}", (Object)JSON.toJSONString((Object)itemChangeApplyReqDto));
        RestResponse addResponse = this.iItemChangeApplyApi.add(itemChangeApplyReqDto);
        Long applyId = (Long)RestResponseHelper.extractData((RestResponse)addResponse);
        logger.info("\u63d0\u4ea4\u5546\u54c1\u5e93\u53d8\u66f4\u7533\u8bf7...");
        RestResponse commitResponse = this.iItemChangeApplyApi.commit(applyId);
        RestResponseHelper.extractData((RestResponse)commitResponse);
        logger.info("\u81ea\u52a8\u901a\u8fc7\u5ba1\u6838\u53d8\u66f4\u5546\u54c1\u5e93\u7533\u8bf7\uff0c\u5546\u54c1\u5e93\u5546\u54c1\u4fe1\u606f\u5165\u5e93...");
        ChangeApplyAuditReqDto changeApplyAuditReqDto = new ChangeApplyAuditReqDto();
        changeApplyAuditReqDto.setChangeApplyId(applyId);
        changeApplyAuditReqDto.setStatus(ItemChangeApplyStatus.AUDIT_SUCCESS.getStatus());
        changeApplyAuditReqDto.setInstanceId(instanceId);
        changeApplyAuditReqDto.setTenantId(tenantId);
        RestResponse auditResultResponse = this.iItemChangeApplyApi.audit(changeApplyAuditReqDto);
        AuditResultRespDto auditResultRespDto = (AuditResultRespDto)RestResponseHelper.extractData((RestResponse)auditResultResponse);
        logger.info("\u66f4\u65b0\u5546\u54c1\u5e93\u5b58...");
        this.iItem.modifyItemVirStorage(auditResultRespDto.getItemId(), null, null);
        logger.info("\u67e5\u8be2\u7248\u672c\u4fe1\u606f");
        Long itemId = auditResultRespDto.getItemId();
        List itemRespDtos = (List)this.itemQueryApi.queryByItemIds(String.valueOf(itemId)).getData();
        if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            logger.error("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\uff0citemId\uff1a{}", (Object)itemId);
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.ITEM_NOT_EXIST);
        }
        ItemPublishReqDto itemPublishReqDto = new ItemPublishReqDto();
        itemPublishReqDto.setItemId(itemId);
        logger.info("\u53d1\u5e03\u5546\u54c1\u5e93\u5546\u54c1...");
        RestResponse restResponse = this.itemApi.publish(itemPublishReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        logger.info("\u4e0d\u9700\u8981\u5ba1\u6838\uff0c\u76f4\u63a5\u5ba1\u6838\u901a\u8fc7\u53d1\u5e03\u5546\u54c1\u5e93\u5546\u54c1...");
        ItemAuditReqDto itemAuditReqDto = new ItemAuditReqDto();
        itemAuditReqDto.setItemId(itemId);
        itemAuditReqDto.setInstanceId(instanceId);
        itemAuditReqDto.setTenantId(tenantId);
        itemAuditReqDto.setStatus(ItemStatus.ITEM_AUDIT_SUCCESS.getStatus());
        RestResponse auditResponse = this.itemApi.audit(itemAuditReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)auditResponse);
        logger.info("\u53d1\u5e03\u5546\u54c1\u5e93\u5546\u54c1\u5b8c\u6bd5, itemId:{}", (Object)itemId);
        this.addItemAuthShelf(itemChangeApplyDetailDto, instanceId, tenantId, auditResultRespDto, ((ShopDto)shopList.get(0)).getSellerId());
        try {
            logger.info("\u53d1\u9001\u65b0\u589e\u5546\u54c1\u540c\u6b65\u4e0a\u67b6\u5230\u5206\u9500\u5458\u5e97\u94fa\u6d88\u606f\uff1a{}", (Object)itemId);
            MessageVo messageVo = new MessageVo();
            HashMap mqMap = Maps.newHashMap();
            mqMap.put("itemId", itemId);
            mqMap.put("userId", userId);
            mqMap.put("instanceId", ServiceContext.getContext().get("yes.req.instanceId"));
            mqMap.put("tenantId", ServiceContext.getContext().get("yes.req.tenantId"));
            messageVo.setData((Object)mqMap);
            this.commonsMqService.sendSingleMessage("CREATE_ITEM_ONSHELF", (Object)messageVo);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u65b0\u589e\u5546\u54c1\u540c\u6b65\u4e0a\u67b6\u5230\u5206\u9500\u5458\u5e97\u94fa\u6d88\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        return itemId;
    }

    private boolean synBindTenantMaterial(ItemChangeApplyDetailDto itemChangeApplyDetailDto, String extTenantId) {
        List brands = this.brandImpl.getList();
        String brandCode = "";
        if (CollectionUtils.isNotEmpty((Collection)brands)) {
            for (Brand brand : brands) {
                if (!Objects.equals(brand.getId(), itemChangeApplyDetailDto.getBrandId())) continue;
                brandCode = brand.getCode();
            }
        }
        JXCDto jxcDto = new JXCDto();
        jxcDto.setExtTenantId(extTenantId);
        ArrayList itemList = Lists.newArrayList();
        JXCItemDto jxcItemDto = new JXCItemDto();
        jxcItemDto.setMaterialNo(itemChangeApplyDetailDto.getLongCode());
        jxcItemDto.setHelpCode(itemChangeApplyDetailDto.getItemCode());
        jxcItemDto.setName(itemChangeApplyDetailDto.getItemName());
        jxcItemDto.setType(SubTypeEnum.MATERIEL.name());
        jxcItemDto.setModel(itemChangeApplyDetailDto.getDosageForm());
        jxcItemDto.setBrandCode(brandCode);
        jxcItemDto.setExtMaterialNo(itemChangeApplyDetailDto.getExternalCode());
        itemList.add(jxcItemDto);
        jxcDto.setItemList((List)itemList);
        this.jxcService.synBindTenantMaterial(jxcDto);
        return true;
    }

    private void addItemAuthShelf(ItemChangeApplyDetailDto itemChangeApplyDetailDto, Long instanceId, Long tenantId, AuditResultRespDto auditResultRespDto, Long sellerId) {
        if (itemChangeApplyDetailDto.getItemId() == null) {
            ItemSkuRespDto sku = (ItemSkuRespDto)((List)this.iItemSkuQueryApi.queryByItemId(auditResultRespDto.getItemId()).getData()).get(0);
            logger.info("\u65b0\u589e\u6388\u6743\u5546\u54c1\u6388\u6743\uff1aitemId={}, skuId={}, shopId={} ", new Object[]{auditResultRespDto.getItemId(), sku.getId(), itemChangeApplyDetailDto.getShopId()});
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setInstanceId(instanceId);
            itemAuthReqDto.setTenantId(tenantId);
            itemAuthReqDto.setBusinessId(sku.getId());
            itemAuthReqDto.setTargetId(itemChangeApplyDetailDto.getShopId());
            itemAuthReqDto.setBusinessType("SKU");
            itemAuthReqDto.setTargetType(Integer.valueOf(2));
            itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
            this.itemAuthApi.addItemAuth(itemAuthReqDto);
            ItemOnShelfReqListDto itemOnShelfReqListDto = new ItemOnShelfReqListDto();
            ArrayList itemShelfReqDtoList = Lists.newArrayList();
            ItemShelfReqDto itemShelfReqDto = new ItemShelfReqDto();
            itemShelfReqDto.setItemId(auditResultRespDto.getItemId());
            itemShelfReqDto.setShopId(itemChangeApplyDetailDto.getShopId());
            itemShelfReqDto.setSkuId(sku.getId());
            itemShelfReqDto.setSellerId(sellerId);
            itemShelfReqDto.setDirId(itemChangeApplyDetailDto.getDirId());
            itemShelfReqDto.setType(Integer.valueOf(1));
            itemShelfReqDto.setBusType(Integer.valueOf(0));
            itemShelfReqDto.setStorage(Long.valueOf(0L));
            itemShelfReqDto.setPrice(new BigDecimal("0"));
            itemShelfReqDto.setCashAmount(new BigDecimal("0"));
            itemShelfReqDto.setStockDisplay(itemChangeApplyDetailDto.getStockDisplay());
            itemShelfReqDto.setLimitMin(itemChangeApplyDetailDto.getLimitMin());
            itemShelfReqDto.setLimitMinMode(itemChangeApplyDetailDto.getLimitMinMode());
            itemShelfReqDto.setMultipleStatus(itemChangeApplyDetailDto.getMultipleStatus());
            itemShelfReqDto.setHomePageDisplay(itemChangeApplyDetailDto.getHomePageDisplay());
            itemShelfReqDtoList.add(itemShelfReqDto);
            itemOnShelfReqListDto.setItemShelfReqDtos((List)itemShelfReqDtoList);
            this.itemApi.onShelfItem(itemOnShelfReqListDto);
        }
    }

    private void validate(List<ItemBundleReqDto> skuList) {
        if (CollectionUtils.isEmpty(skuList)) {
            throw new BizException("\u5546\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        skuList.forEach(sku -> {
            if (null == sku.getCostPrice()) {
                throw new BizException("\u5546\u54c1\u6210\u672c\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List prices = sku.getPrices();
            if (CollectionUtils.isEmpty((Collection)prices)) {
                throw new BizException("\u5546\u54c1\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Map priceMap = prices.stream().filter(price -> StringUtils.isNotBlank((String)price.getPriceType())).collect(Collectors.toMap(ItemPriceReqDto::getPriceType, Function.identity(), (v1, v2) -> v1));
            ItemPriceReqDto priceReqDto = (ItemPriceReqDto)priceMap.get("RETAIL_PRICE");
            if (null == priceReqDto) {
                throw new BizException("\u5546\u54c1\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal salesPrice = priceReqDto.getPrice();
            if (null == salesPrice) {
                throw new BizException("\u5546\u54c1\u552e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            CommanderConfigInfoRespDto commanderConfigInfoRespDto = (CommanderConfigInfoRespDto)RestResponseHelper.extractData((RestResponse)this.iCommanderInfoQueryApi.queryCommanderConfig(this.context.userId()));
            logger.info("\u56e2\u957f\u914d\u7f6e\u4fe1\u606fcommanderConfigInfoRespDto={}", (Object)JSON.toJSONString((Object)commanderConfigInfoRespDto));
            BigDecimal costPrice = sku.getCostPrice();
            logger.info("\u521b\u5efa\u6d3b\u52a8\u7684\u6210\u672c\u4ef7costPrice={}", (Object)costPrice);
            BigDecimal groupPrice = salesPrice;
            logger.info("\u521b\u5efa\u6d3b\u52a8\u7684\u62fc\u56e2\u4ef7groupPrice={}", (Object)groupPrice);
            if (Objects.nonNull(commanderConfigInfoRespDto) && commanderConfigInfoRespDto.getDistribType() != null && 2 == commanderConfigInfoRespDto.getDistribType() && 1 == commanderConfigInfoRespDto.getIsPriceDistribution()) {
                BigDecimal limitPriceTop;
                BigDecimal limitPriceBottom = StringUtils.isBlank((String)sku.getAddPriceMin()) ? BigDecimal.ZERO : new BigDecimal(sku.getAddPriceMin());
                BigDecimal bigDecimal = limitPriceTop = StringUtils.isBlank((String)sku.getAddPriceMax()) ? BigDecimal.ZERO : new BigDecimal(sku.getAddPriceMax());
                if (2 == sku.getAddPriceMode()) {
                    int compareTo;
                    BigDecimal divideGroupPrice;
                    if (Objects.nonNull(limitPriceBottom)) {
                        divideGroupPrice = costPrice.add(limitPriceBottom);
                        compareTo = groupPrice.compareTo(divideGroupPrice);
                        logger.info("compareTo={}", (Object)compareTo);
                        if (compareTo < 0) {
                            throw new BizException("\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u56fa\u5b9a\u503c\u9650\u5236\u7684\u52a0\u4ef7\u4e0b\u9650");
                        }
                    }
                    if (Objects.nonNull(limitPriceTop)) {
                        divideGroupPrice = costPrice.add(limitPriceTop);
                        compareTo = groupPrice.compareTo(divideGroupPrice);
                        logger.info("compareTo={}", (Object)compareTo);
                        if (compareTo > 1) {
                            throw new BizException("\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u56fa\u5b9a\u503c\u9650\u5236\u7684\u52a0\u4ef7\u4e0a\u9650");
                        }
                    }
                } else {
                    BigDecimal limitPrice;
                    if (Objects.nonNull(limitPriceBottom) && groupPrice.compareTo(limitPrice = costPrice.add(costPrice.multiply(limitPriceBottom.multiply(new BigDecimal(0.01))))) < 0) {
                        throw new BizException("\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u6309\u6bd4\u4f8b\u9650\u5236\u7684\u52a0\u4ef7\u4e0b\u9650");
                    }
                    if (Objects.nonNull(limitPriceTop) && groupPrice.compareTo(limitPrice = costPrice.add(costPrice.multiply(limitPriceTop.multiply(new BigDecimal(0.01))))) > 1) {
                        throw new BizException("\u6d3b\u52a8\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u6309\u6bd4\u4f8b\u9650\u5236\u7684\u52a0\u4ef7\u4e0a\u9650");
                    }
                }
            }
        });
    }

    private void checkCargoCode(ItemChangeApplyDto itemChangeApplyDto) {
        List skus = itemChangeApplyDto.getSkus();
        if (CollectionUtils.isEmpty((Collection)skus)) {
            throw new ItemBusinessRuntimeException("sku\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList cargoCodes = new ArrayList();
        skus.stream().forEach(sku -> {
            String cargoCode = sku.getCargoCode();
            if (StringUtils.isNotEmpty((String)cargoCode)) {
                cargoCodes.add(cargoCode);
            }
        });
        if (CollectionUtils.isEmpty(cargoCodes)) {
            return;
        }
        List cargos = (List)this.cargoQueryApi.listByCodes(cargoCodes).getData();
        if (CollectionUtils.isEmpty((Collection)cargos)) {
            throw new ItemBusinessRuntimeException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d27\u54c1\u4fe1\u606f\uff01");
        }
        HashMap cargoMap = new HashMap();
        cargos.stream().forEach(cargoRespDto -> cargoMap.put(cargoRespDto.getCode(), cargoRespDto));
        skus.stream().forEach(sku -> {
            String cargoCode = sku.getCargoCode();
            if (StringUtils.isNotEmpty((String)cargoCode)) {
                CargoRespDto cargoRespDto = (CargoRespDto)cargoMap.get(cargoCode);
                if (null == cargoRespDto) {
                    throw new ItemBusinessRuntimeException("\u627e\u4e0d\u5230\u8d27\u54c1\u7f16\u53f7\uff1a" + cargoCode + "\u5bf9\u5e94\u7684\u4fe1\u606f\uff01");
                }
                sku.setOutterCode(cargoRespDto.getId().toString());
            }
        });
    }

    public Long updateItemLib(ItemChangeApplyDetailDto changApply) {
        logger.info("\u5f00\u59cb\u66f4\u65b0\u5546\u54c1\u5e93,\u5165\u53c2ItemChangeApplyDetailDto:{}", (Object)JSON.toJSONString((Object)changApply));
        Long itemId = changApply.getItemId();
        RestResponse itemDetailRespDtoRestResponse = this.itemQueryApi.queryItemDetail(itemId, "sku", null);
        ItemDetailRespDto oldItemDetail = (ItemDetailRespDto)RestResponseHelper.extractData((RestResponse)itemDetailRespDtoRestResponse);
        Long userId = oldItemDetail.getItem().getOwnerId();
        Long instanceId = oldItemDetail.getItem().getInstanceId();
        Long tenantId = oldItemDetail.getItem().getTenantId();
        ItemChangeApplyReqDto itemChangeApplyReqDto = new ItemChangeApplyReqDto();
        if (StringUtils.isBlank((String)changApply.getDisplayName())) {
            changApply.setDisplayName(changApply.getItemName());
        }
        CubeBeanUtils.copyProperties((Object)itemChangeApplyReqDto, (Object)changApply, (String[])new String[0]);
        itemChangeApplyReqDto.setItemId(itemId);
        itemChangeApplyReqDto.setType(changApply.getType());
        itemChangeApplyReqDto.setTenantId(tenantId);
        itemChangeApplyReqDto.setInstanceId(instanceId);
        itemChangeApplyReqDto.setSellerId(ItemConstant.ITEM_LIB_SELLER_ID);
        itemChangeApplyReqDto.setOwnerId(userId);
        itemChangeApplyReqDto.setStatus(ItemChangeApplyStatus.DRAFT.getStatus());
        itemChangeApplyReqDto.setItemChangeApplyDto((ItemChangeApplyDto)changApply);
        this.checkCargoCode(itemChangeApplyReqDto.getItemChangeApplyDto());
        logger.info("\u65b0\u589e\u5546\u54c1\u5e93\u5546\u54c1\u53d8\u66f4\u7533\u8bf7...");
        RestResponse addResponse = this.iItemChangeApplyApi.add(itemChangeApplyReqDto);
        Long applyId = (Long)RestResponseHelper.extractData((RestResponse)addResponse);
        logger.info("\u63d0\u4ea4\u5546\u54c1\u5e93\u5546\u54c1\u53d8\u66f4\u7533\u8bf7...");
        RestResponse commitResponse = this.iItemChangeApplyApi.commit(applyId);
        RestResponseHelper.extractData((RestResponse)commitResponse);
        logger.info("\u5ba1\u6838\u5546\u54c1\u5e93\u5546\u54c1\u53d8\u66f4\u7533\u8bf7...");
        ChangeApplyAuditReqDto changeApplyAuditReqDto = new ChangeApplyAuditReqDto();
        changeApplyAuditReqDto.setChangeApplyId(applyId);
        changeApplyAuditReqDto.setStatus(ItemChangeApplyStatus.AUDIT_SUCCESS.getStatus());
        changeApplyAuditReqDto.setInstanceId(this.context.instanceId());
        changeApplyAuditReqDto.setTenantId(this.context.tenantId());
        RestResponse auditResponse = this.iItemChangeApplyApi.audit(changeApplyAuditReqDto);
        AuditResultRespDto auditResultRespDto = (AuditResultRespDto)RestResponseHelper.extractData((RestResponse)auditResponse);
        logger.info("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u8be6\u60c5...");
        ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(Long.valueOf(auditResultRespDto.getItemId()), "sku", null).getData();
        logger.info("\u66f4\u65b0\u5546\u54c1\u5e93\u5b58...");
        this.iItem.modifyItemVirStorage(auditResultRespDto.getItemId(), oldItemDetail, itemDetailRespDto);
        List skus = changApply.getSkus();
        for (ItemBundleReqDto itemBundleReqDto : skus) {
            ItemSkuReqDto itemSkuReqDto = new ItemSkuReqDto();
            itemSkuReqDto.setId(itemBundleReqDto.getId());
            itemSkuReqDto.setAddPriceMode(itemBundleReqDto.getAddPriceMode());
            itemSkuReqDto.setAddPriceMin(itemBundleReqDto.getAddPriceMin());
            itemSkuReqDto.setAddPriceMax(itemBundleReqDto.getAddPriceMax());
            itemSkuReqDto.setCostPrice(itemBundleReqDto.getCostPrice());
            this.iItemSkuQueryApi.updateCostPrice(itemSkuReqDto);
        }
        return itemId;
    }

    public ItemChangeApplyDetailDto getItemLibDetail(Long itemId) {
        String orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        Long shopId = null;
        if (StringUtils.isNotBlank((String)orgIdStr)) {
            List shopDtos;
            ShopQueryDto queryCondition = new ShopQueryDto();
            queryCondition.setOrganizationId(Long.valueOf(orgIdStr));
            RestResponse shopResp = this.shopQueryApi.queryShopList(queryCondition);
            if (shopResp != null && CollectionUtils.isNotEmpty((Collection)(shopDtos = (List)shopResp.getData()))) {
                ShopDto shopDto = (ShopDto)shopDtos.get(0);
                shopId = shopDto.getId();
            }
        }
        ItemChangeApplyDetailDto detail = this.item.getDetailByItemId(shopId, itemId, null);
        return detail;
    }

    public PageInfo<ItemRelationSkuRespDto> queryItemRelationSku(ItemRelationSkuReqDto itemRelationSkuReqDto, Integer pageNum, Integer pageSize) {
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.iItemSkuQueryApi.queryItemRelationSku(itemRelationSkuReqDto, pageNum, pageSize));
    }

    public String getDefalutPrice() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("defalutAddPriceMax", (Object)this.defalutAddPriceMax);
        jsonObject.put("defalutAddPriceMin", (Object)this.defalutAddPriceMin);
        return jsonObject.toJSONString();
    }

    private String getItemCode() {
        String itemCode = "";
        ItemRespDto itemRespDto = null;
        while (Objects.nonNull(itemRespDto = (ItemRespDto)this.itemQueryApi.queryByItemCode(itemCode = this.generateNo()).getData()) && Objects.nonNull(itemRespDto.getId())) {
        }
        return itemCode;
    }

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(String key, Date expireTime) {
        boolean exists = this.cacheService.exists(key);
        if (exists) {
            return this.cacheService.incr(key);
        }
        int expireSecond = DateUtil.getDifferMinute((Date)new Date(), (Date)expireTime) * 60;
        return this.cacheService.incr(key, (long)expireSecond);
    }

    public String generateNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = ItemLibServiceImpl.getOrderIdPrefix(now, "yyyyMMdd");
        String orderId = "MA" + orderIdPrefix + String.format("%1$03d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return orderId;
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static Long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }
}

