/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl.serializa;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponDynamicDateDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.module.item.api.IDeserializationDynamicDateExtItem;
import com.dtyunxi.yundt.module.item.api.dto.response.marketing.CouponTemplate;
import com.dtyunxi.yundt.module.item.biz.impl.serializa.DeserializationFixDateExtItem;
import com.dtyunxi.yundt.module.item.biz.impl.serializa.DeserializationForeverExtItem;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SerializeCouPonUseTimeValueDistributeExtItem
implements ApplicationListener<ApplicationStartedEvent> {
    private static Map<Integer, IDeserializationDynamicDateExtItem> DESERIALIZATION_MAP = new HashMap<Integer, IDeserializationDynamicDateExtItem>();
    private static DeserializationFixDateExtItem deserializationFixDate = new DeserializationFixDateExtItem();
    private static DeserializationForeverExtItem deserializationForever = new DeserializationForeverExtItem();

    public static void deserialization(CouponTemplate couponTemplate) {
        if (couponTemplate.getValidityType() == CouponValidityTypeEnum.FIXED_DATE.getType()) {
            deserializationFixDate.deserialization(couponTemplate, null);
        } else if (couponTemplate.getValidityType() == CouponValidityTypeEnum.DYNAMIC_DATE.getType()) {
            CouponDynamicDateDto dynamicDate = (CouponDynamicDateDto)JSONObject.parseObject((String)couponTemplate.getDynamicDate(), CouponDynamicDateDto.class);
            if (dynamicDate.getForever() != null && dynamicDate.getForever() == 1) {
                deserializationForever.deserialization(couponTemplate, dynamicDate);
            } else {
                IDeserializationDynamicDateExtItem deserializationDynamicDate = DESERIALIZATION_MAP.get(dynamicDate.getAfterDate());
                deserializationDynamicDate.deserialization(couponTemplate, dynamicDate);
            }
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent applicationStartedEvent) {
        ConfigurableApplicationContext context = applicationStartedEvent.getApplicationContext();
        Map smap = context.getBeansOfType(IDeserializationDynamicDateExtItem.class);
        smap.keySet().stream().forEach(k -> {
            IDeserializationDynamicDateExtItem impl = (IDeserializationDynamicDateExtItem)smap.get(k);
            DESERIALIZATION_MAP.put(impl.getSupportAfterDay(), impl);
        });
    }
}

