/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.module.bo.ConfigItem;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemChangeApplyApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemChangeApplyStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.IItem;
import com.dtyunxi.yundt.module.item.api.IItemService;
import com.dtyunxi.yundt.module.item.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.item.api.enums.ItemAddTypeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemEventCodeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemLibTypeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.extension.itempublishchannel.IItemPublishChannel;
import com.dtyunxi.yundt.module.item.biz.service.IItemCommonService;
import java.util.Date;
import java.util.Random;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="createHandler")
public class CreateHandler
implements IServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateHandler.class);
    @Resource
    private IContext context;
    @Resource
    private IItemChangeApplyApi iItemChangeApplyApi;
    @Resource
    private IItemCommonService itemCommonService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItem iItem;
    @Resource(name="yundt.module.item")
    private IConfig config;
    @Resource
    private IItemService itemService;
    private static final String ITEM_CONFIG_GROUP = "yundt.module.item.group";
    private static final String ITEM_CONFIG_HAS_PRODUCT = "com.dtyunxi.yundt.module.item.biz.handler.CreateHandler.spu";

    public Object handle(ServiceEvent<?> serviceEvent) {
        IItemPublishChannel iItemPublishChannel;
        logger.info("======>\u521b\u5efa\u5546\u54c1");
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne(ITEM_CONFIG_GROUP, ITEM_CONFIG_HAS_PRODUCT);
        }
        catch (Exception e) {
            configItem = new ConfigItem();
            configItem.setValue("false");
            logger.error("\u83b7\u53d6\u914d\u7f6e\u9879\u51fa\u9519,\u539f\u56e0\uff1a{}\u3002\u91c7\u7528\u9ed8\u8ba4\u914d\u7f6e\uff1a\u53ef\u4ee5\u5355\u72ec\u5efa\u7acb\u5546\u54c1", (Object)e.getMessage());
        }
        ItemChangeApplyDetailDto changeApply = (ItemChangeApplyDetailDto)serviceEvent.getData();
        if (null != configItem && !StringUtils.isEmpty((Object)configItem.getValue()) && configItem.getValue().equals("true") && (null == changeApply.getSpuid() || 0L == changeApply.getSpuid())) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.NO_PRODUCT);
        }
        if (null == (iItemPublishChannel = this.itemCommonService.getItemPublishChannel(JSON.parseObject((String)changeApply.getAttrs()).getString("publishChannel")))) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.INVALID_ITEM_PUBLISH_CHANNEL);
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)changeApply.getItemCode())) {
            String itemCode = this.getItemCode();
            changeApply.setItemCode(itemCode);
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)changeApply.getDisplayName())) {
            changeApply.setDisplayName(changeApply.getItemName());
        }
        if (changeApply.getType() == null) {
            changeApply.setType(ItemLibTypeEnum.GENERAL_ITEM.getType());
        }
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Long userId = this.context.userId();
        Long sellerId = this.itemCommonService.getSellerId();
        ItemChangeApplyReqDto itemChangeApplyReqDto = new ItemChangeApplyReqDto();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyReqDto, (Object)changeApply, (String[])new String[0]);
        itemChangeApplyReqDto.setInstanceId(instanceId);
        itemChangeApplyReqDto.setTenantId(tenantId);
        itemChangeApplyReqDto.setSellerId(sellerId);
        itemChangeApplyReqDto.setOwnerId(userId);
        itemChangeApplyReqDto.setStatus(ItemChangeApplyStatus.DRAFT.getStatus());
        if (ItemLibTypeEnum.VIRTUAL_ITEM.getType().equals(itemChangeApplyReqDto.getType())) {
            changeApply.setVirtual(Boolean.valueOf(true));
        } else {
            changeApply.setVirtual(Boolean.valueOf(false));
        }
        itemChangeApplyReqDto.setItemChangeApplyDto((ItemChangeApplyDto)changeApply);
        RestResponse addResponse = this.iItemChangeApplyApi.add(itemChangeApplyReqDto);
        Long applyId = (Long)RestResponseHelper.extractData((RestResponse)addResponse);
        RestResponse commitResponse = this.iItemChangeApplyApi.commit(applyId);
        RestResponseHelper.extractData((RestResponse)commitResponse);
        ChangeApplyAuditReqDto changeApplyAuditReqDto = new ChangeApplyAuditReqDto();
        changeApplyAuditReqDto.setChangeApplyId(applyId);
        changeApplyAuditReqDto.setStatus(ItemChangeApplyStatus.AUDIT_SUCCESS.getStatus());
        changeApplyAuditReqDto.setTenantId(this.context.tenantId());
        changeApplyAuditReqDto.setInstanceId(this.context.instanceId());
        RestResponse auditResponse = this.iItemChangeApplyApi.audit(changeApplyAuditReqDto);
        AuditResultRespDto auditResultRespDto = (AuditResultRespDto)RestResponseHelper.extractData((RestResponse)auditResponse);
        if (ItemAddTypeEnum.PUBLISH.getCode().equals(changeApply.getAddType())) {
            ServiceEvent publishServiceEvent = new ServiceEvent(ItemEventCodeEnum.PUBLISH.getCode(), ItemEventCodeEnum.PUBLISH.getName(), (Object)auditResultRespDto.getItemId());
            this.itemService.doService(publishServiceEvent);
        }
        return applyId;
    }

    private String getItemCode() {
        String timeStr = DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long threadId = Thread.currentThread().getId();
        Random random = new Random();
        Integer number = random.nextInt(10);
        String code = String.format("%s%s%s", timeStr, threadId, number);
        return code;
    }
}

