/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOffShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.item.biz.service.IItemValidateRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="offShelfHandler")
public class OffShelfHandler
implements IServiceHandler,
IItemValidateRule {
    private static final Logger logger = LoggerFactory.getLogger(OffShelfHandler.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;

    public Object handle(ServiceEvent<?> serviceEvent) {
        logger.info("======>\u5546\u54c1\u4e0b\u67b6\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(serviceEvent));
        List itemOffShelfReqDtos = (List)serviceEvent.getData();
        ArrayList offItemReqDtos = new ArrayList();
        itemOffShelfReqDtos.forEach(itemOffShelfReqDto -> {
            OffItemReqDto offItemReqDto = new OffItemReqDto();
            if (itemOffShelfReqDto.getBusType() == null) {
                offItemReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
            } else {
                offItemReqDto.setBusType(itemOffShelfReqDto.getBusType());
            }
            if (ItemBusTypeEnum.INTEGRAL.getType().equals(itemOffShelfReqDto.getItemType())) {
                offItemReqDto.setBusType(ItemBusTypeEnum.INTEGRAL.getType());
                offItemReqDto.setItemType(null);
            }
            offItemReqDto.setItemId(itemOffShelfReqDto.getItemId());
            offItemReqDto.setSkuId(itemOffShelfReqDto.getSkuId());
            offItemReqDto.setShopId(itemOffShelfReqDto.getShopId());
            offItemReqDtos.add(offItemReqDto);
        });
        ItemOffShelfReqListDto itemOffShelfReqListDto = new ItemOffShelfReqListDto();
        itemOffShelfReqListDto.setOffItemReqDtos(offItemReqDtos);
        RestResponse restResponse = this.itemApi.offShelfItem(itemOffShelfReqListDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        return null;
    }
}

