/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPublishReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.service.IItemCommonService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="publishHandler")
public class PublishHandler
implements IServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(PublishHandler.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;
    @Resource
    private IItemCommonService itemCommonService;
    @Resource
    private IContext context;

    public Object handle(ServiceEvent<?> serviceEvent) {
        logger.info("======>\u53d1\u5e03\u5546\u54c1");
        Long itemId = (Long)serviceEvent.getData();
        List itemRespDtos = (List)this.itemQueryApi.queryByItemIds(String.valueOf(itemId)).getData();
        if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.ITEM_NOT_EXIST);
        }
        ItemPublishReqDto itemPublishReqDto = new ItemPublishReqDto();
        itemPublishReqDto.setItemId(itemId);
        RestResponse restResponse = this.itemApi.publish(itemPublishReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        Boolean needAudit = this.itemCommonService.needAudit();
        if (!needAudit.booleanValue()) {
            ItemAuditReqDto itemAuditReqDto = new ItemAuditReqDto();
            itemAuditReqDto.setItemId(itemId);
            Long instanceId = this.context.instanceId();
            Long tenantId = this.context.tenantId();
            itemAuditReqDto.setInstanceId(instanceId);
            itemAuditReqDto.setTenantId(tenantId);
            itemAuditReqDto.setStatus(ItemStatus.ITEM_AUDIT_SUCCESS.getStatus());
            RestResponse auditResponse = this.itemApi.audit(itemAuditReqDto);
            RestResponseHelper.checkOrThrow((RestResponse)auditResponse);
        }
        return null;
    }
}

