/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BundleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="removeShopHandler")
public class RemoveShopHandler
implements IServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoveShopHandler.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;

    public Object handle(ServiceEvent<?> serviceEvent) {
        Map paramMap = (Map)serviceEvent.getData();
        Long shopId = (Long)paramMap.get("shopId");
        Long id = (Long)paramMap.get("id");
        logger.info("======>\u5220\u9664\u5546\u54c1shopId={},id={}", (Object)shopId, (Object)id);
        if (shopId == null || id == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.CHANGE_RECORD_ID_NOT_NULL);
        }
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(id);
        shelfReqDto.setShopId(shopId);
        String filter = JSON.toJSONString((Object)shelfReqDto);
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(filter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        ItemShelfRespDto itemShelfRespDto = null;
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            itemShelfRespDto = (ItemShelfRespDto)pageInfo.getList().get(0);
        }
        if (itemShelfRespDto != null) {
            if (ItemBusTypeEnum.GIFT.getType().intValue() != itemShelfRespDto.getBusType().intValue() && ItemStatus.ITEM_ONSHELF.getStatus().intValue() == itemShelfRespDto.getStatus().intValue()) {
                BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.ON_SHELF_ITEM_NOT_REMOVE);
            }
            if (ItemTypeEnum.BUNDLE.getType().intValue() != itemShelfRespDto.getType().intValue()) {
                BundleItemReqDto bundleItemReqDto = new BundleItemReqDto();
                bundleItemReqDto.setSubItemId(itemShelfRespDto.getItemId());
                List bundleItemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryBundleItemList(bundleItemReqDto));
                if (CollectionUtils.isNotEmpty((Collection)bundleItemRespDtoList)) {
                    List itemIdList = bundleItemRespDtoList.stream().map(BundleItemRespDto::getItemId).distinct().collect(Collectors.toList());
                    ShelfQueryReqDto shelfQueryReqDto = new ShelfQueryReqDto();
                    shelfQueryReqDto.setShopId(shopId);
                    shelfQueryReqDto.setItemIds(itemIdList);
                    List shelfQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryShelfList(shelfQueryReqDto));
                    if (CollectionUtils.isNotEmpty((Collection)shelfQueryRespDtoList)) {
                        BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.EXIST_BUNDLE_ITEM_INCLUDE_SUB_ITEM);
                    }
                }
            }
        }
        shelfReqDto.setStatus(null);
        filter = JSON.toJSONString((Object)shelfReqDto);
        pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(filter, Integer.valueOf(1), Integer.valueOf(50)).getData();
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            this.remove((PageInfo<ItemShelfRespDto>)pageInfo);
            for (int pageNum = 2; pageNum <= pageInfo.getPages(); ++pageNum) {
                pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(filter, Integer.valueOf(pageNum), Integer.valueOf(50)).getData();
                this.remove((PageInfo<ItemShelfRespDto>)pageInfo);
            }
        }
        return null;
    }

    private void remove(PageInfo<ItemShelfRespDto> pageInfo) {
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            List ids = pageInfo.getList().stream().map(ItemShelfRespDto::getId).collect(Collectors.toList());
            String idsStr = StringUtils.join(ids, (String)",");
            this.itemApi.removeItemShelf(idsStr);
        }
    }
}

