/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.handler;

import com.dtyunxi.dto.BaseDto;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.BeanMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SqlParameterAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ThreadLocal<UUID> requestId = new ThreadLocal();

    @Pointcut(value="execution(public * com.dtyunxi.pearlriver.*.ds.*.query*(..))")
    private void pointCut() {
    }

    @Around(value="pointCut()")
    public Object process(ProceedingJoinPoint joinPoint) throws Throwable {
        this.requestId.set(UUID.randomUUID());
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            this.judgement(args[i]);
        }
        return joinPoint.proceed();
    }

    @AfterReturning(returning="result", pointcut="pointCut()")
    public void doAfterReturning(Object result) {
    }

    @AfterThrowing(throwing="e", pointcut="pointCut()")
    public void doAfterException(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("requestId:").append(this.requestId.get()).append(" exception:").append(e.getMessage());
        this.logger.error(sb.toString());
    }

    Object judgement(Object obj) {
        if (obj instanceof String) {
            this.checkStr(obj);
        } else if (obj instanceof Map && ((Map)obj).size() > 0) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                ((Map)obj).put(entry.getKey(), this.checkStr(entry.getValue()));
            }
        } else {
            if (obj instanceof BaseDto) {
                BeanMap map = new BeanMap((Object)obj);
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    map.put(entry.getKey(), this.checkStr(entry.getValue()));
                }
                return map.getBean();
            }
            if (obj instanceof List) {
                if (((List)obj).size() > 0) {
                    Object[] values = ((List)obj).toArray();
                    this.checkArray(values);
                    for (int i = 0; i < values.length; ++i) {
                        ((List)obj).set(i, values[i]);
                    }
                }
            } else if (obj != null && obj.getClass().isArray()) {
                obj = this.checkArray(obj);
            } else {
                this.logger.warn("requestId:{} \u5176\u4ed6\u7c7b\u578b\u53c2\u6570\uff01parameter:{}", (Object)this.requestId.get(), (Object)obj);
            }
        }
        return obj;
    }

    Object[] checkArray(Object[] values) {
        if (values[0] instanceof String) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.checkStr(values[i]);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.judgement(values[i]);
            }
        }
        return values;
    }

    Object checkStr(Object obj) {
        String objStr = obj.toString();
        if (objStr.indexOf("'") > -1) {
            objStr = objStr.replaceAll("'", "''");
            this.logger.warn("requestId:{} \u53c2\u6570\u4e2d\u5305\u542b\u975e\u6cd5\u5173\u952e\u5b57\uff0c\u53ef\u80fd\u5b58\u5728\u98ce\u9669\uff01parameter:{},\u66ff\u6362\u540eparameter:{}", new Object[]{this.requestId.get(), obj, objStr});
        }
        return objStr;
    }

    public static void main(String[] s) {
    }
}

